package io.qt.network.auth;

import io.qt.*;


/**
 * <p>Implementation of the Authorization Code Grant flow</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qoauth2authorizationcodeflow.html">QOAuth2AuthorizationCodeFlow</a></code></p>
 */
public class QOAuth2AuthorizationCodeFlow extends io.qt.network.auth.QAbstractOAuth2
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QOAuth2AuthorizationCodeFlow.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth2authorizationcodeflow.html#accessTokenUrl-prop">QOAuth2AuthorizationCodeFlow::<wbr>accessTokenUrlChanged(QUrl)</a></code></p>
     */
    @QtPropertyNotify(name="accessTokenUrl")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> accessTokenUrlChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QOAuth2AuthorizationCodeFlow(io.qt.network.QNetworkAccessManager, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth2AuthorizationCodeFlow(io.qt.network.@Nullable QNetworkAccessManager manager) {
        this(manager, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth2authorizationcodeflow.html#QOAuth2AuthorizationCodeFlow-1">QOAuth2AuthorizationCodeFlow::<wbr>QOAuth2AuthorizationCodeFlow(QNetworkAccessManager*,<wbr>QObject*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth2AuthorizationCodeFlow(io.qt.network.@Nullable QNetworkAccessManager manager, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, manager, parent);
    }
    
    private native static void initialize_native(QOAuth2AuthorizationCodeFlow instance, io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QOAuth2AuthorizationCodeFlow(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QOAuth2AuthorizationCodeFlow() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth2authorizationcodeflow.html#QOAuth2AuthorizationCodeFlow">QOAuth2AuthorizationCodeFlow::<wbr>QOAuth2AuthorizationCodeFlow(QObject*)</a></code></p>
     */
    public QOAuth2AuthorizationCodeFlow(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QOAuth2AuthorizationCodeFlow instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QOAuth2AuthorizationCodeFlow(java.lang.String, io.qt.network.QNetworkAccessManager, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth2AuthorizationCodeFlow(java.lang.@NonNull String clientIdentifier, io.qt.network.@Nullable QNetworkAccessManager manager) {
        this(clientIdentifier, manager, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth2authorizationcodeflow.html#QOAuth2AuthorizationCodeFlow-2">QOAuth2AuthorizationCodeFlow::<wbr>QOAuth2AuthorizationCodeFlow(QString,<wbr>QNetworkAccessManager*,<wbr>QObject*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth2AuthorizationCodeFlow(java.lang.@NonNull String clientIdentifier, io.qt.network.@Nullable QNetworkAccessManager manager, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, clientIdentifier, manager, parent);
    }
    
    private native static void initialize_native(QOAuth2AuthorizationCodeFlow instance, java.lang.String clientIdentifier, io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QOAuth2AuthorizationCodeFlow(java.lang.String, io.qt.core.QUrl, io.qt.core.QUrl, io.qt.network.QNetworkAccessManager, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth2AuthorizationCodeFlow(java.lang.@NonNull String clientIdentifier, io.qt.core.@NonNull QUrl authorizationUrl, io.qt.core.@NonNull QUrl accessTokenUrl, io.qt.network.@Nullable QNetworkAccessManager manager) {
        this(clientIdentifier, authorizationUrl, accessTokenUrl, manager, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth2authorizationcodeflow.html#QOAuth2AuthorizationCodeFlow-4">QOAuth2AuthorizationCodeFlow::<wbr>QOAuth2AuthorizationCodeFlow(QString,<wbr>QUrl,<wbr>QUrl,<wbr>QNetworkAccessManager*,<wbr>QObject*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth2AuthorizationCodeFlow(java.lang.@NonNull String clientIdentifier, io.qt.core.@NonNull QUrl authorizationUrl, io.qt.core.@NonNull QUrl accessTokenUrl, io.qt.network.@Nullable QNetworkAccessManager manager, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, clientIdentifier, authorizationUrl, accessTokenUrl, manager, parent);
    }
    
    private native static void initialize_native(QOAuth2AuthorizationCodeFlow instance, java.lang.String clientIdentifier, io.qt.core.QUrl authorizationUrl, io.qt.core.QUrl accessTokenUrl, io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QOAuth2AuthorizationCodeFlow(io.qt.core.QUrl, io.qt.core.QUrl, io.qt.network.QNetworkAccessManager, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth2AuthorizationCodeFlow(io.qt.core.@NonNull QUrl authorizationUrl, io.qt.core.@NonNull QUrl accessTokenUrl, io.qt.network.@Nullable QNetworkAccessManager manager) {
        this(authorizationUrl, accessTokenUrl, manager, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth2authorizationcodeflow.html#QOAuth2AuthorizationCodeFlow-3">QOAuth2AuthorizationCodeFlow::<wbr>QOAuth2AuthorizationCodeFlow(QUrl,<wbr>QUrl,<wbr>QNetworkAccessManager*,<wbr>QObject*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth2AuthorizationCodeFlow(io.qt.core.@NonNull QUrl authorizationUrl, io.qt.core.@NonNull QUrl accessTokenUrl, io.qt.network.@Nullable QNetworkAccessManager manager, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, authorizationUrl, accessTokenUrl, manager, parent);
    }
    
    private native static void initialize_native(QOAuth2AuthorizationCodeFlow instance, io.qt.core.QUrl authorizationUrl, io.qt.core.QUrl accessTokenUrl, io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #accessTokenUrl()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getAccessTokenUrl() {
        return accessTokenUrl();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth2authorizationcodeflow.html#accessTokenUrl">QOAuth2AuthorizationCodeFlow::<wbr>accessTokenUrl()const</a></code></p>
     */
    @QtPropertyReader(name="accessTokenUrl")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl accessTokenUrl(){
        return accessTokenUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl accessTokenUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #buildAuthenticateUrl(java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @QtUninvokable
    protected final io.qt.core.@NonNull QUrl buildAuthenticateUrl() {
        return buildAuthenticateUrl(java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth2authorizationcodeflow.html#buildAuthenticateUrl">QOAuth2AuthorizationCodeFlow::<wbr>buildAuthenticateUrl(QMultiMap&lt;QString,<wbr>QVariant&gt;)</a></code></p>
     */
    @QtUninvokable
    protected final io.qt.core.@NonNull QUrl buildAuthenticateUrl(java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.util.List<? extends java.lang.Object>> parameters){
        return buildAuthenticateUrl_native_cref_QMultiMap(QtJambi_LibraryUtilities.internal.nativeId(this), parameters);
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl buildAuthenticateUrl_native_cref_QMultiMap(long __this__nativeId, java.util.Map<java.lang.String, ? extends java.util.List<? extends java.lang.Object>> parameters);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth2authorizationcodeflow.html#refreshAccessToken">QOAuth2AuthorizationCodeFlow::<wbr>refreshAccessToken()</a></code></p>
     */
    public final void refreshAccessToken(){
        refreshAccessToken_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void refreshAccessToken_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth2authorizationcodeflow.html#requestAccessToken">QOAuth2AuthorizationCodeFlow::<wbr>requestAccessToken(QString)</a></code></p>
     */
    @QtUninvokable
    protected final void requestAccessToken(java.lang.@NonNull String code){
        requestAccessToken_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), code);
    }
    
    @QtUninvokable
    private native void requestAccessToken_native_cref_QString(long __this__nativeId, java.lang.String code);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth2authorizationcodeflow.html#setAccessTokenUrl">QOAuth2AuthorizationCodeFlow::<wbr>setAccessTokenUrl(QUrl)</a></code></p>
     */
    @QtPropertyWriter(name="accessTokenUrl")
    @QtUninvokable
    public final void setAccessTokenUrl(io.qt.core.@NonNull QUrl accessTokenUrl){
        setAccessTokenUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(accessTokenUrl));
    }
    
    @QtUninvokable
    private native void setAccessTokenUrl_native_cref_QUrl(long __this__nativeId, long accessTokenUrl);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#grant">QAbstractOAuth::<wbr>grant()</a></code></p>
     */
    public void grant(){
        grant_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void grant_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#resourceOwnerAuthorization">QAbstractOAuth::<wbr>resourceOwnerAuthorization(QUrl,<wbr>QMultiMap&lt;QString,<wbr>QVariant&gt;)</a></code></p>
     */
    @QtUninvokable
    protected void resourceOwnerAuthorization(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.util.List<? extends java.lang.Object>> parameters){
        resourceOwnerAuthorization_native_cref_QUrl_cref_QMultiMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    @QtUninvokable
    private native void resourceOwnerAuthorization_native_cref_QUrl_cref_QMultiMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.util.List<? extends java.lang.Object>> parameters);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOAuth2AuthorizationCodeFlow(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QOAuth2AuthorizationCodeFlow(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QOAuth2AuthorizationCodeFlow instance, QDeclarativeConstructor constructor);
    
}
