package io.qt.network.auth;


/**
 * <p>Handles replies to OAuth authentication requests</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qabstractoauthreplyhandler.html">QAbstractOAuthReplyHandler</a></p>
 */
public abstract class QAbstractOAuthReplyHandler extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractOAuthReplyHandler.class);
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QAbstractOAuthReplyHandler {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public java.lang.String callback(){
            return callback_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native java.lang.String callback_native_constfct(long __this__nativeId);
        
        
        @Override
        public void networkReplyFinished(io.qt.network.QNetworkReply reply){
            networkReplyFinished_native_QNetworkReply_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(reply));
        }
        private native void networkReplyFinished_native_QNetworkReply_ptr(long __this__nativeId, long reply);
        
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauthreplyhandler.html#callbackDataReceived">QAbstractOAuthReplyHandler::callbackDataReceived(QByteArray)</a></p>
     */
    public final Signal1<io.qt.core.QByteArray> callbackDataReceived = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauthreplyhandler.html#callbackReceived">QAbstractOAuthReplyHandler::callbackReceived(QVariantMap)</a></p>
     */
    public final Signal1<java.util.NavigableMap<java.lang.String, java.lang.Object>> callbackReceived = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauthreplyhandler.html#replyDataReceived">QAbstractOAuthReplyHandler::replyDataReceived(QByteArray)</a></p>
     */
    public final Signal1<io.qt.core.QByteArray> replyDataReceived = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauthreplyhandler.html#tokensReceived">QAbstractOAuthReplyHandler::tokensReceived(QVariantMap)</a></p>
     */
    public final Signal1<java.util.NavigableMap<java.lang.String, java.lang.Object>> tokensReceived = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractOAuthReplyHandler(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAbstractOAuthReplyHandler() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauthreplyhandler.html#QAbstractOAuthReplyHandler">QAbstractOAuthReplyHandler::QAbstractOAuthReplyHandler(QObject*)</a></p>
     */
    public QAbstractOAuthReplyHandler(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAbstractOAuthReplyHandler instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauthreplyhandler.html#callback">QAbstractOAuthReplyHandler::callback()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.lang.String callback();
    
    @io.qt.QtUninvokable
    private native java.lang.String callback_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauthreplyhandler.html#networkReplyFinished">QAbstractOAuthReplyHandler::networkReplyFinished(QNetworkReply*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public abstract void networkReplyFinished(io.qt.network.QNetworkReply reply);
    
    private native void networkReplyFinished_native_QNetworkReply_ptr(long __this__nativeId, long reply);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAbstractOAuthReplyHandler(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QAbstractOAuthReplyHandler(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QAbstractOAuthReplyHandler instance, QDeclarativeConstructor constructor);
    
}
