package io.qt.network.auth;


/**
 * <p>The base of all implementations of OAuth 2 authentication methods</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qabstractoauth2.html">QAbstractOAuth2</a></p>
 */
public abstract class QAbstractOAuth2 extends io.qt.network.auth.QAbstractOAuth
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractOAuth2.class);
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QAbstractOAuth2 {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        public void grant(){
            grant_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native void grant_native(long __this__nativeId);
        
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#authorizationCallbackReceived">QAbstractOAuth2::authorizationCallbackReceived(QVariantMap)</a></p>
     */
    public final Signal1<java.util.NavigableMap<java.lang.String, java.lang.Object>> authorizationCallbackReceived = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#clientIdentifierSharedKey-prop">QAbstractOAuth2::clientIdentifierSharedKeyChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="clientIdentifierSharedKey")
    public final Signal1<java.lang.String> clientIdentifierSharedKeyChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#error">QAbstractOAuth2::error(QString,QString,QUrl)</a></p>
     */
    public final Signal3<java.lang.String, java.lang.String, io.qt.core.QUrl> error = new Signal3<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#expiration-prop">QAbstractOAuth2::expirationAtChanged(QDateTime)</a></p>
     */
    @io.qt.QtPropertyNotify(name="expiration")
    public final Signal1<io.qt.core.QDateTime> expirationAtChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#refreshToken-prop">QAbstractOAuth2::refreshTokenChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="refreshToken")
    public final Signal1<java.lang.String> refreshTokenChanged = new Signal1<>();

    public final Signal1<java.lang.String> responseTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#scope-prop">QAbstractOAuth2::scopeChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="scope")
    public final Signal1<java.lang.String> scopeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#state-prop">QAbstractOAuth2::stateChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="state")
    public final Signal1<java.lang.String> stateChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#userAgent-prop">QAbstractOAuth2::userAgentChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="userAgent")
    public final Signal1<java.lang.String> userAgentChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractOAuth2(io.qt.network.QNetworkAccessManager, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public QAbstractOAuth2(io.qt.network.QNetworkAccessManager manager) {
        this(manager, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#QAbstractOAuth2-1">QAbstractOAuth2::QAbstractOAuth2(QNetworkAccessManager*,QObject*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QAbstractOAuth2(io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, manager, parent);
    }
    
    private native static void initialize_native(QAbstractOAuth2 instance, io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractOAuth2(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAbstractOAuth2() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#QAbstractOAuth2">QAbstractOAuth2::QAbstractOAuth2(QObject*)</a></p>
     */
    public QAbstractOAuth2(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAbstractOAuth2 instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#clientIdentifierSharedKey-prop">QAbstractOAuth2::clientIdentifierSharedKey()const</a></p>
     */
    @io.qt.QtPropertyReader(name="clientIdentifierSharedKey")
    @io.qt.QtUninvokable
    public final java.lang.String clientIdentifierSharedKey(){
        return clientIdentifierSharedKey_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String clientIdentifierSharedKey_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#expiration-prop">QAbstractOAuth2::expirationAt()const</a></p>
     */
    @io.qt.QtPropertyReader(name="expiration")
    @io.qt.QtUninvokable
    public final io.qt.core.QDateTime expirationAt(){
        return expirationAt_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QDateTime expirationAt_native_constfct(long __this__nativeId);
    
    /**
     * <p>Gets the current refresh token</p>
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#refreshToken">QAbstractOAuth2::refreshToken()const</a></p>
     */
    @io.qt.QtPropertyReader(name="refreshToken")
    @io.qt.QtUninvokable
    public final java.lang.String refreshToken(){
        return refreshToken_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String refreshToken_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#responseType">QAbstractOAuth2::responseType()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String responseType(){
        return responseType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String responseType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#scope-prop">QAbstractOAuth2::scope()const</a></p>
     */
    @io.qt.QtPropertyReader(name="scope")
    @io.qt.QtUninvokable
    public final java.lang.String scope(){
        return scope_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String scope_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#clientIdentifierSharedKey-prop">QAbstractOAuth2::setClientIdentifierSharedKey(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="clientIdentifierSharedKey")
    @io.qt.QtUninvokable
    public final void setClientIdentifierSharedKey(java.lang.String clientIdentifierSharedKey){
        setClientIdentifierSharedKey_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), clientIdentifierSharedKey);
    }
    
    @io.qt.QtUninvokable
    private native void setClientIdentifierSharedKey_native_cref_QString(long __this__nativeId, java.lang.String clientIdentifierSharedKey);
    
    /**
     * <p>Sets the new refresh token refreshToken to be used</p>
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#setRefreshToken">QAbstractOAuth2::setRefreshToken(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="refreshToken")
    @io.qt.QtUninvokable
    public final void setRefreshToken(java.lang.String refreshToken){
        setRefreshToken_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), refreshToken);
    }
    
    @io.qt.QtUninvokable
    private native void setRefreshToken_native_cref_QString(long __this__nativeId, java.lang.String refreshToken);
    
    @io.qt.QtUninvokable
    protected final void setResponseType(java.lang.String responseType){
        setResponseType_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), responseType);
    }
    
    @io.qt.QtUninvokable
    private native void setResponseType_native_cref_QString(long __this__nativeId, java.lang.String responseType);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#scope-prop">QAbstractOAuth2::setScope(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="scope")
    @io.qt.QtUninvokable
    public final void setScope(java.lang.String scope){
        setScope_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), scope);
    }
    
    @io.qt.QtUninvokable
    private native void setScope_native_cref_QString(long __this__nativeId, java.lang.String scope);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#state-prop">QAbstractOAuth2::setState(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="state")
    @io.qt.QtUninvokable
    public final void setState(java.lang.String state){
        setState_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), state);
    }
    
    @io.qt.QtUninvokable
    private native void setState_native_cref_QString(long __this__nativeId, java.lang.String state);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#userAgent-prop">QAbstractOAuth2::setUserAgent(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="userAgent")
    @io.qt.QtUninvokable
    public final void setUserAgent(java.lang.String userAgent){
        setUserAgent_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), userAgent);
    }
    
    @io.qt.QtUninvokable
    private native void setUserAgent_native_cref_QString(long __this__nativeId, java.lang.String userAgent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#state-prop">QAbstractOAuth2::state()const</a></p>
     */
    @io.qt.QtPropertyReader(name="state")
    @io.qt.QtUninvokable
    public final java.lang.String state(){
        return state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String state_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#userAgent-prop">QAbstractOAuth2::userAgent()const</a></p>
     */
    @io.qt.QtPropertyReader(name="userAgent")
    @io.qt.QtUninvokable
    public final java.lang.String userAgent(){
        return userAgent_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String userAgent_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #createAuthenticatedUrl(io.qt.core.QUrl, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    public final io.qt.core.QUrl createAuthenticatedUrl(io.qt.core.QUrl url) {
        return createAuthenticatedUrl(url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#createAuthenticatedUrl">QAbstractOAuth2::createAuthenticatedUrl(QUrl,QVariantMap)</a></p>
     */
    public io.qt.core.QUrl createAuthenticatedUrl(io.qt.core.QUrl url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters){
        return createAuthenticatedUrl_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    private native io.qt.core.QUrl createAuthenticatedUrl_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth.html#deleteResource">QAbstractOAuth::deleteResource(QUrl,QVariantMap)</a></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.QNetworkReply deleteResource(io.qt.core.QUrl url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters){
        return deleteResource_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    private native io.qt.network.QNetworkReply deleteResource_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth.html#get">QAbstractOAuth::get(QUrl,QVariantMap)</a></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.QNetworkReply get(io.qt.core.QUrl url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters){
        return get_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    private native io.qt.network.QNetworkReply get_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth.html#head">QAbstractOAuth::head(QUrl,QVariantMap)</a></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.QNetworkReply head(io.qt.core.QUrl url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters){
        return head_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    private native io.qt.network.QNetworkReply head_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#post-2">QAbstractOAuth2::post(QUrl,QHttpMultiPart*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.QNetworkReply post(io.qt.core.QUrl url, io.qt.network.QHttpMultiPart multiPart){
        return post_native_cref_QUrl_QHttpMultiPart_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), QtJambi_LibraryUtilities.internal.checkedNativeId(multiPart));
    }
    
    private native io.qt.network.QNetworkReply post_native_cref_QUrl_QHttpMultiPart_ptr(long __this__nativeId, long url, long multiPart);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#post-1">QAbstractOAuth2::post(QUrl,QByteArray)</a></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.QNetworkReply post(io.qt.core.QUrl url, io.qt.core.QByteArray data){
        return post_native_cref_QUrl_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), QtJambi_LibraryUtilities.internal.checkedNativeId(data));
    }
    
    private native io.qt.network.QNetworkReply post_native_cref_QUrl_cref_QByteArray(long __this__nativeId, long url, long data);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth.html#post">QAbstractOAuth::post(QUrl,QVariantMap)</a></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.QNetworkReply post(io.qt.core.QUrl url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters){
        return post_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    private native io.qt.network.QNetworkReply post_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth.html#prepareRequest">QAbstractOAuth::prepareRequest(QNetworkRequest*,QByteArray,QByteArray)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public void prepareRequest(io.qt.network.QNetworkRequest request, io.qt.core.QByteArray verb, io.qt.core.QByteArray body){
        prepareRequest_native_QNetworkRequest_ptr_cref_QByteArray_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), request, QtJambi_LibraryUtilities.internal.checkedNativeId(verb), QtJambi_LibraryUtilities.internal.checkedNativeId(body));
    }
    
    @io.qt.QtUninvokable
    private native void prepareRequest_native_QNetworkRequest_ptr_cref_QByteArray_cref_QByteArray(long __this__nativeId, io.qt.network.QNetworkRequest request, long verb, long body);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#put-2">QAbstractOAuth2::put(QUrl,QHttpMultiPart*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.QNetworkReply put(io.qt.core.QUrl url, io.qt.network.QHttpMultiPart multiPart){
        return put_native_cref_QUrl_QHttpMultiPart_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), QtJambi_LibraryUtilities.internal.checkedNativeId(multiPart));
    }
    
    private native io.qt.network.QNetworkReply put_native_cref_QUrl_QHttpMultiPart_ptr(long __this__nativeId, long url, long multiPart);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth2.html#put-1">QAbstractOAuth2::put(QUrl,QByteArray)</a></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.QNetworkReply put(io.qt.core.QUrl url, io.qt.core.QByteArray data){
        return put_native_cref_QUrl_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), QtJambi_LibraryUtilities.internal.checkedNativeId(data));
    }
    
    private native io.qt.network.QNetworkReply put_native_cref_QUrl_cref_QByteArray(long __this__nativeId, long url, long data);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractoauth.html#put">QAbstractOAuth::put(QUrl,QVariantMap)</a></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.QNetworkReply put(io.qt.core.QUrl url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters){
        return put_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    private native io.qt.network.QNetworkReply put_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAbstractOAuth2(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QAbstractOAuth2(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QAbstractOAuth2 instance, QDeclarativeConstructor constructor);
    
}
