package io.qt.network.auth;


/**
 * <p>The base of all implementations of OAuth authentication methods</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qabstractoauth.html">QAbstractOAuth</a></p>
 */
public abstract class QAbstractOAuth extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcNetworkAccessManager = null;
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcReplyHandler = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractOAuth.class);
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QAbstractOAuth {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        public io.qt.network.QNetworkReply deleteResource(io.qt.core.QUrl url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters){
            return deleteResource_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
        }
        private native io.qt.network.QNetworkReply deleteResource_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
        
        
        @Override
        public io.qt.network.QNetworkReply get(io.qt.core.QUrl url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters){
            return get_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
        }
        private native io.qt.network.QNetworkReply get_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
        
        
        @Override
        public void grant(){
            grant_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native void grant_native(long __this__nativeId);
        
        
        @Override
        public io.qt.network.QNetworkReply head(io.qt.core.QUrl url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters){
            return head_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
        }
        private native io.qt.network.QNetworkReply head_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
        
        
        @Override
        public io.qt.network.QNetworkReply post(io.qt.core.QUrl url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters){
            return post_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
        }
        private native io.qt.network.QNetworkReply post_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
        
        
        @Override
        public io.qt.network.QNetworkReply put(io.qt.core.QUrl url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters){
            return put_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
        }
        private native io.qt.network.QNetworkReply put_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
        
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qabstractoauth.html#ContentType-enum">QAbstractOAuth::ContentType</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum ContentType implements io.qt.QtEnumerator {
        WwwFormUrlEncoded(0),
        Json(1);

        private ContentType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ContentType resolve(int value) {
            switch (value) {
            case 0: return WwwFormUrlEncoded;
            case 1: return Json;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qabstractoauth.html#Error-enum">QAbstractOAuth::Error</a></p>
     */
    public enum Error implements io.qt.QtEnumerator {
        NoError(0),
        NetworkError(1),
        ServerError(2),
        OAuthTokenNotFoundError(3),
        OAuthTokenSecretNotFoundError(4),
        OAuthCallbackNotVerified(5);

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Error resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return NetworkError;
            case 2: return ServerError;
            case 3: return OAuthTokenNotFoundError;
            case 4: return OAuthTokenSecretNotFoundError;
            case 5: return OAuthCallbackNotVerified;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qabstractoauth.html#Stage-enum">QAbstractOAuth::Stage</a></p>
     */
    public enum Stage implements io.qt.QtEnumerator {
        RequestingTemporaryCredentials(0),
        RequestingAuthorization(1),
        RequestingAccessToken(2),
        RefreshingAccessToken(3);

        private Stage(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Stage resolve(int value) {
            switch (value) {
            case 0: return RequestingTemporaryCredentials;
            case 1: return RequestingAuthorization;
            case 2: return RequestingAccessToken;
            case 3: return RefreshingAccessToken;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qabstractoauth.html#Status-enum">QAbstractOAuth::Status</a></p>
     */
    public enum Status implements io.qt.QtEnumerator {
        NotAuthenticated(0),
        TemporaryCredentialsReceived(1),
        Granted(2),
        RefreshingToken(3);

        private Status(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Status resolve(int value) {
            switch (value) {
            case 0: return NotAuthenticated;
            case 1: return TemporaryCredentialsReceived;
            case 2: return Granted;
            case 3: return RefreshingToken;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Java wrapper for Qt function pointer QAbstractOAuth::ModifyParametersFunction</p>
     */
    @FunctionalInterface
    public interface ModifyParametersFunction extends io.qt.QtObjectInterface, java.util.function.BiConsumer<io.qt.network.auth.QAbstractOAuth.Stage, java.util.Map<java.lang.String, ? extends java.lang.Object>> {

        @Override
        public void accept(io.qt.network.auth.QAbstractOAuth.Stage arg__1, java.util.Map<java.lang.String, ? extends java.lang.Object> arg__2);

        /**
         * <p>Implementor class for interface {@link ModifyParametersFunction}</p>
         */
        public static abstract class Impl extends io.qt.QtObject implements ModifyParametersFunction{
            static {
                QtJambi_LibraryUtilities.initialize();
            }

            public Impl(){
                super((QPrivateConstructor)null);
                initialize_native(this);
            }

            protected Impl(QPrivateConstructor p){
                super(p);
            }

            private static native void initialize_native(ModifyParametersFunction instance);

            @io.qt.NativeAccess
            private final static class ConcreteWrapper extends Impl {
                private ConcreteWrapper(QPrivateConstructor c){
                    super(c);
                }

                @Override
                public native void accept(io.qt.network.auth.QAbstractOAuth.Stage arg__1, java.util.Map<java.lang.String, ? extends java.lang.Object> arg__2);
            }

        }
    }


    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#authorizationUrl-prop">QAbstractOAuth::authorizationUrlChanged(QUrl)</a></p>
     */
    @io.qt.QtPropertyNotify(name="authorizationUrl")
    public final Signal1<io.qt.core.QUrl> authorizationUrlChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#authorizeWithBrowser">QAbstractOAuth::authorizeWithBrowser(QUrl)</a></p>
     */
    public final Signal1<io.qt.core.QUrl> authorizeWithBrowser = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#clientIdentifier-prop">QAbstractOAuth::clientIdentifierChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="clientIdentifier")
    public final Signal1<java.lang.String> clientIdentifierChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#contentType-prop">QAbstractOAuth::contentTypeChanged(QAbstractOAuth::ContentType)</a></p>
     */
    @io.qt.QtPropertyNotify(name="contentType")
    public final Signal1<io.qt.network.auth.QAbstractOAuth.ContentType> contentTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#extraTokens-prop">QAbstractOAuth::extraTokensChanged(QVariantMap)</a></p>
     */
    @io.qt.QtPropertyNotify(name="extraTokens")
    public final Signal1<java.util.NavigableMap<java.lang.String, java.lang.Object>> extraTokensChanged = new Signal1<>();

    @SuppressWarnings({"exports"})
    public final Signal1<io.qt.network.QNetworkReply> finished = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#granted">QAbstractOAuth::granted()</a></p>
     */
    public final Signal0 granted = new Signal0();

    public final Signal1<io.qt.core.QByteArray> replyDataReceived = new Signal1<>();

    public final Signal1<io.qt.network.auth.QAbstractOAuth.Error> requestFailed = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#status-prop">QAbstractOAuth::statusChanged(QAbstractOAuth::Status)</a></p>
     */
    @io.qt.QtPropertyNotify(name="status")
    public final Signal1<io.qt.network.auth.QAbstractOAuth.Status> statusChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#token-prop">QAbstractOAuth::tokenChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="token")
    public final Signal1<java.lang.String> tokenChanged = new Signal1<>();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#authorizationUrl">QAbstractOAuth::authorizationUrl()const</a></p>
     */
    @io.qt.QtPropertyReader(name="authorizationUrl")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl authorizationUrl(){
        return authorizationUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl authorizationUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#callback">QAbstractOAuth::callback()const</a></p>
     */
    @io.qt.QtUninvokable
    protected final java.lang.String callback(){
        return callback_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String callback_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#clientIdentifier">QAbstractOAuth::clientIdentifier()const</a></p>
     */
    @io.qt.QtPropertyReader(name="clientIdentifier")
    @io.qt.QtUninvokable
    public final java.lang.String clientIdentifier(){
        return clientIdentifier_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String clientIdentifier_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#contentType">QAbstractOAuth::contentType()const</a></p>
     */
    @io.qt.QtPropertyReader(name="contentType")
    @io.qt.QtUninvokable
    public final io.qt.network.auth.QAbstractOAuth.ContentType contentType(){
        return io.qt.network.auth.QAbstractOAuth.ContentType.resolve(contentType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int contentType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#extraTokens">QAbstractOAuth::extraTokens()const</a></p>
     */
    @io.qt.QtPropertyReader(name="extraTokens")
    @io.qt.QtUninvokable
    public final io.qt.core.QMap<java.lang.String, java.lang.Object> extraTokens(){
        return extraTokens_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QMap<java.lang.String, java.lang.Object> extraTokens_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#modifyParametersFunction">QAbstractOAuth::modifyParametersFunction()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.network.auth.QAbstractOAuth.ModifyParametersFunction modifyParametersFunction(){
        return modifyParametersFunction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.network.auth.QAbstractOAuth.ModifyParametersFunction modifyParametersFunction_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#networkAccessManager">QAbstractOAuth::networkAccessManager()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.network.QNetworkAccessManager networkAccessManager(){
        return networkAccessManager_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.network.QNetworkAccessManager networkAccessManager_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #prepareRequest(io.qt.network.QNetworkRequest, io.qt.core.QByteArray, io.qt.core.QByteArray)}
     *  with <code>body = new io.qt.core.QByteArray()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void prepareRequest(io.qt.network.QNetworkRequest request, io.qt.core.QByteArray verb) {
        prepareRequest(request, verb, new io.qt.core.QByteArray());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#prepareRequest">QAbstractOAuth::prepareRequest(QNetworkRequest*,QByteArray,QByteArray)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void prepareRequest(io.qt.network.QNetworkRequest request, io.qt.core.QByteArray verb, io.qt.core.QByteArray body){
        prepareRequest_native_QNetworkRequest_ptr_cref_QByteArray_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), request, QtJambi_LibraryUtilities.internal.checkedNativeId(verb), QtJambi_LibraryUtilities.internal.checkedNativeId(body));
    }
    
    @io.qt.QtUninvokable
    private native void prepareRequest_native_QNetworkRequest_ptr_cref_QByteArray_cref_QByteArray(long __this__nativeId, io.qt.network.QNetworkRequest request, long verb, long body);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#replyHandler">QAbstractOAuth::replyHandler()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.network.auth.QAbstractOAuthReplyHandler replyHandler(){
        return replyHandler_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.network.auth.QAbstractOAuthReplyHandler replyHandler_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#setAuthorizationUrl">QAbstractOAuth::setAuthorizationUrl(QUrl)</a></p>
     */
    @io.qt.QtPropertyWriter(name="authorizationUrl")
    @io.qt.QtUninvokable
    public final void setAuthorizationUrl(io.qt.core.QUrl url){
        setAuthorizationUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @io.qt.QtUninvokable
    private native void setAuthorizationUrl_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#setClientIdentifier">QAbstractOAuth::setClientIdentifier(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="clientIdentifier")
    @io.qt.QtUninvokable
    public final void setClientIdentifier(java.lang.String clientIdentifier){
        setClientIdentifier_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), clientIdentifier);
    }
    
    @io.qt.QtUninvokable
    private native void setClientIdentifier_native_cref_QString(long __this__nativeId, java.lang.String clientIdentifier);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#setContentType">QAbstractOAuth::setContentType(QAbstractOAuth::ContentType)</a></p>
     */
    @io.qt.QtPropertyWriter(name="contentType")
    @io.qt.QtUninvokable
    public final void setContentType(io.qt.network.auth.QAbstractOAuth.ContentType contentType){
        setContentType_native_QAbstractOAuth_ContentType(QtJambi_LibraryUtilities.internal.nativeId(this), contentType.value());
    }
    
    @io.qt.QtUninvokable
    private native void setContentType_native_QAbstractOAuth_ContentType(long __this__nativeId, int contentType);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#setModifyParametersFunction">QAbstractOAuth::setModifyParametersFunction(QAbstractOAuth::ModifyParametersFunction)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setModifyParametersFunction(io.qt.network.auth.QAbstractOAuth.ModifyParametersFunction modifyParametersFunction){
        setModifyParametersFunction_native_cref_QAbstractOAuth_ModifyParametersFunction(QtJambi_LibraryUtilities.internal.nativeId(this), modifyParametersFunction);
    }
    
    @io.qt.QtUninvokable
    private native void setModifyParametersFunction_native_cref_QAbstractOAuth_ModifyParametersFunction(long __this__nativeId, io.qt.network.auth.QAbstractOAuth.ModifyParametersFunction modifyParametersFunction);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#setNetworkAccessManager">QAbstractOAuth::setNetworkAccessManager(QNetworkAccessManager*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void setNetworkAccessManager(io.qt.network.QNetworkAccessManager networkAccessManager){
        setNetworkAccessManager_native_QNetworkAccessManager_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(networkAccessManager));
        __rcNetworkAccessManager = networkAccessManager;
    }
    
    @io.qt.QtUninvokable
    private native void setNetworkAccessManager_native_QNetworkAccessManager_ptr(long __this__nativeId, long networkAccessManager);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#setReplyHandler">QAbstractOAuth::setReplyHandler(QAbstractOAuthReplyHandler*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setReplyHandler(io.qt.network.auth.QAbstractOAuthReplyHandler handler){
        setReplyHandler_native_QAbstractOAuthReplyHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(handler));
        __rcReplyHandler = handler;
    }
    
    @io.qt.QtUninvokable
    private native void setReplyHandler_native_QAbstractOAuthReplyHandler_ptr(long __this__nativeId, long handler);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#setStatus">QAbstractOAuth::setStatus(QAbstractOAuth::Status)</a></p>
     */
    @io.qt.QtUninvokable
    protected final void setStatus(io.qt.network.auth.QAbstractOAuth.Status status){
        setStatus_native_QAbstractOAuth_Status(QtJambi_LibraryUtilities.internal.nativeId(this), status.value());
    }
    
    @io.qt.QtUninvokable
    private native void setStatus_native_QAbstractOAuth_Status(long __this__nativeId, int status);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#setToken">QAbstractOAuth::setToken(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="token")
    @io.qt.QtUninvokable
    public final void setToken(java.lang.String token){
        setToken_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), token);
    }
    
    @io.qt.QtUninvokable
    private native void setToken_native_cref_QString(long __this__nativeId, java.lang.String token);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#status">QAbstractOAuth::status()const</a></p>
     */
    @io.qt.QtPropertyReader(name="status")
    @io.qt.QtUninvokable
    public final io.qt.network.auth.QAbstractOAuth.Status status(){
        return io.qt.network.auth.QAbstractOAuth.Status.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#token">QAbstractOAuth::token()const</a></p>
     */
    @io.qt.QtPropertyReader(name="token")
    @io.qt.QtUninvokable
    public final java.lang.String token(){
        return token_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String token_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #deleteResource(io.qt.core.QUrl, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.QNetworkReply deleteResource(io.qt.core.QUrl url) {
        return deleteResource(url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#deleteResource">QAbstractOAuth::deleteResource(QUrl,QVariantMap)</a></p>
     */
    @SuppressWarnings({"exports"})
    public abstract io.qt.network.QNetworkReply deleteResource(io.qt.core.QUrl url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    private native io.qt.network.QNetworkReply deleteResource_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>Overloaded function for {@link #get(io.qt.core.QUrl, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.QNetworkReply get(io.qt.core.QUrl url) {
        return get(url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#get">QAbstractOAuth::get(QUrl,QVariantMap)</a></p>
     */
    @SuppressWarnings({"exports"})
    public abstract io.qt.network.QNetworkReply get(io.qt.core.QUrl url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    private native io.qt.network.QNetworkReply get_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#grant">QAbstractOAuth::grant()</a></p>
     */
    public abstract void grant();
    
    private native void grant_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #head(io.qt.core.QUrl, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.QNetworkReply head(io.qt.core.QUrl url) {
        return head(url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#head">QAbstractOAuth::head(QUrl,QVariantMap)</a></p>
     */
    @SuppressWarnings({"exports"})
    public abstract io.qt.network.QNetworkReply head(io.qt.core.QUrl url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    private native io.qt.network.QNetworkReply head_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>Overloaded function for {@link #post(io.qt.core.QUrl, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.QNetworkReply post(io.qt.core.QUrl url) {
        return post(url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#post">QAbstractOAuth::post(QUrl,QVariantMap)</a></p>
     */
    @SuppressWarnings({"exports"})
    public abstract io.qt.network.QNetworkReply post(io.qt.core.QUrl url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    private native io.qt.network.QNetworkReply post_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>Overloaded function for {@link #put(io.qt.core.QUrl, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.QNetworkReply put(io.qt.core.QUrl url) {
        return put(url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#put">QAbstractOAuth::put(QUrl,QVariantMap)</a></p>
     */
    @SuppressWarnings({"exports"})
    public abstract io.qt.network.QNetworkReply put(io.qt.core.QUrl url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    private native io.qt.network.QNetworkReply put_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#resourceOwnerAuthorization">QAbstractOAuth::resourceOwnerAuthorization(QUrl,QVariantMap)</a></p>
     */
    @io.qt.QtUninvokable
    protected void resourceOwnerAuthorization(io.qt.core.QUrl url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters){
        resourceOwnerAuthorization_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    @io.qt.QtUninvokable
    private native void resourceOwnerAuthorization_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#generateRandomString">QAbstractOAuth::generateRandomString(quint8)</a></p>
     */
    protected native static io.qt.core.QByteArray generateRandomString(byte length);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAbstractOAuth(QPrivateConstructor p) { super(p); } 
    
}
