package io.qt.network.auth;

import io.qt.*;
import static io.qt.QtUtilities.*;

final class QtJambi_LibraryUtilities {

    final static int qtMajorVersion = 5;

    final static int qtMinorVersion = 15;

    final static int qtJambiPatch = 14;

    final static InternalAccess internal;

    static{
        try {
            initializePackage("io.qt.internal");
            loadQtLibrary("DBus", LibraryRequirementMode.ProvideOnly, "macos", "linux");
            loadQtLibrary("Network", LibraryRequirementMode.Mandatory);
            loadQtLibrary("NetworkAuth", LibraryRequirementMode.Mandatory);
            loadQtJambiLibrary("NetworkAuth");
        } catch(Error t) {
            throw t;
        } catch(Throwable t) {
            throw new ExceptionInInitializerError(t);
        }
        internal = internalAccess();
    }
    private static native InternalAccess internalAccess();

    static void initialize() { };

    private QtJambi_LibraryUtilities() throws InstantiationError { throw new InstantiationError("Cannot instantiate QtJambi_LibraryUtilities."); }
}

