package io.qt.network.auth;

import io.qt.*;


/**
 * <p>Implements OAuth 1 signature methods</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qoauth1signature.html">QOAuth1Signature</a></p>
 */
public class QOAuth1Signature extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qoauth1signature.html#HttpRequestMethod-enum">QOAuth1Signature::HttpRequestMethod</a></p>
     */
    public enum HttpRequestMethod implements QtEnumerator {
        Head(1),
        Get(2),
        Put(3),
        Post(4),
        Delete(5),
        Custom(6),
        Unknown(0);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private HttpRequestMethod(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static HttpRequestMethod resolve(int value) {
            switch (value) {
            case 1: return Head;
            case 2: return Get;
            case 3: return Put;
            case 4: return Post;
            case 5: return Delete;
            case 6: return Custom;
            case 0: return Unknown;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#QOAuth1Signature-2">QOAuth1Signature::QOAuth1Signature(QOAuth1Signature)</a></p>
     */
    public QOAuth1Signature(io.qt.network.auth.@NonNull QOAuth1Signature other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QOAuth1Signature instance, io.qt.network.auth.QOAuth1Signature other);
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QUrl, io.qt.network.auth.QOAuth1Signature.HttpRequestMethod, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    public QOAuth1Signature(io.qt.core.@NonNull QUrl url, io.qt.network.auth.QOAuth1Signature.@NonNull HttpRequestMethod method) {
        this(url, method, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QUrl, io.qt.network.auth.QOAuth1Signature.HttpRequestMethod, java.util.Map)}</p>
     * <p>with: </p><ul>
     * <li><code>method = io.qt.network.auth.QOAuth1Signature.HttpRequestMethod.Post</code></li>
     * <li><code>parameters = java.util.Collections.emptyNavigableMap()</code></li>
     * </ul>
     */
    public QOAuth1Signature(io.qt.core.@NonNull QUrl url) {
        this(url, io.qt.network.auth.QOAuth1Signature.HttpRequestMethod.Post, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QUrl, io.qt.network.auth.QOAuth1Signature.HttpRequestMethod, java.util.Map)}</p>
     * <p>with: </p><ul>
     * <li><code>url = new io.qt.core.QUrl()</code></li>
     * <li><code>method = io.qt.network.auth.QOAuth1Signature.HttpRequestMethod.Post</code></li>
     * <li><code>parameters = java.util.Collections.emptyNavigableMap()</code></li>
     * </ul>
     */
    public QOAuth1Signature() {
        this(new io.qt.core.QUrl(), io.qt.network.auth.QOAuth1Signature.HttpRequestMethod.Post, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#QOAuth1Signature">QOAuth1Signature::QOAuth1Signature(QUrl,QOAuth1Signature::HttpRequestMethod,QVariantMap)</a></p>
     */
    public QOAuth1Signature(io.qt.core.@NonNull QUrl url, io.qt.network.auth.QOAuth1Signature.@NonNull HttpRequestMethod method, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        super((QPrivateConstructor)null);
        initialize_native(this, url, method, parameters);
    }
    
    private native static void initialize_native(QOAuth1Signature instance, io.qt.core.QUrl url, io.qt.network.auth.QOAuth1Signature.HttpRequestMethod method, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QUrl, java.lang.String, java.lang.String, io.qt.network.auth.QOAuth1Signature.HttpRequestMethod, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    public QOAuth1Signature(io.qt.core.@NonNull QUrl url, java.lang.@NonNull String clientSharedKey, java.lang.@NonNull String tokenSecret, io.qt.network.auth.QOAuth1Signature.@NonNull HttpRequestMethod method) {
        this(url, clientSharedKey, tokenSecret, method, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QUrl, java.lang.String, java.lang.String, io.qt.network.auth.QOAuth1Signature.HttpRequestMethod, java.util.Map)}</p>
     * <p>with: </p><ul>
     * <li><code>method = io.qt.network.auth.QOAuth1Signature.HttpRequestMethod.Post</code></li>
     * <li><code>parameters = java.util.Collections.emptyNavigableMap()</code></li>
     * </ul>
     */
    public QOAuth1Signature(io.qt.core.@NonNull QUrl url, java.lang.@NonNull String clientSharedKey, java.lang.@NonNull String tokenSecret) {
        this(url, clientSharedKey, tokenSecret, io.qt.network.auth.QOAuth1Signature.HttpRequestMethod.Post, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#QOAuth1Signature-1">QOAuth1Signature::QOAuth1Signature(QUrl,QString,QString,QOAuth1Signature::HttpRequestMethod,QVariantMap)</a></p>
     */
    public QOAuth1Signature(io.qt.core.@NonNull QUrl url, java.lang.@NonNull String clientSharedKey, java.lang.@NonNull String tokenSecret, io.qt.network.auth.QOAuth1Signature.@NonNull HttpRequestMethod method, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        super((QPrivateConstructor)null);
        initialize_native(this, url, clientSharedKey, tokenSecret, method, parameters);
    }
    
    private native static void initialize_native(QOAuth1Signature instance, io.qt.core.QUrl url, java.lang.String clientSharedKey, java.lang.String tokenSecret, io.qt.network.auth.QOAuth1Signature.HttpRequestMethod method, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#addRequestBody">QOAuth1Signature::addRequestBody(QUrlQuery)</a></p>
     */
    @QtUninvokable
    public final void addRequestBody(io.qt.core.@NonNull QUrlQuery body){
        addRequestBody_native_cref_QUrlQuery(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(body));
    }
    
    @QtUninvokable
    private native void addRequestBody_native_cref_QUrlQuery(long __this__nativeId, long body);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#clientSharedKey">QOAuth1Signature::clientSharedKey()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String clientSharedKey(){
        return clientSharedKey_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String clientSharedKey_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#customMethodString">QOAuth1Signature::customMethodString()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray customMethodString(){
        return customMethodString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray customMethodString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#hmacSha1">QOAuth1Signature::hmacSha1()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray hmacSha1(){
        return hmacSha1_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray hmacSha1_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#httpRequestMethod">QOAuth1Signature::httpRequestMethod()const</a></p>
     */
    @QtUninvokable
    public final io.qt.network.auth.QOAuth1Signature.@NonNull HttpRequestMethod httpRequestMethod(){
        return io.qt.network.auth.QOAuth1Signature.HttpRequestMethod.resolve(httpRequestMethod_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int httpRequestMethod_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#insert">QOAuth1Signature::insert(QString,QVariant)</a></p>
     */
    @QtUninvokable
    public final void insert(java.lang.@NonNull String key, java.lang.Object value){
        insert_native_cref_QString_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), key, value);
    }
    
    @QtUninvokable
    private native void insert_native_cref_QString_cref_QVariant(long __this__nativeId, java.lang.String key, java.lang.Object value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#keys">QOAuth1Signature::keys()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@NonNull String> keys(){
        return keys_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.String> keys_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#operator-eq-1">QOAuth1Signature::operator=(QOAuth1Signature)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.network.auth.@NonNull QOAuth1Signature other){
        assign_native_cref_QOAuth1Signature(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QOAuth1Signature(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#parameters">QOAuth1Signature::parameters()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QMap<java.lang.@NonNull String, java.lang.Object> parameters(){
        return parameters_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QMap<java.lang.String, java.lang.Object> parameters_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#plainText">QOAuth1Signature::plainText()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray plainText(){
        return plainText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray plainText_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#rsaSha1">QOAuth1Signature::rsaSha1()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray rsaSha1(){
        return rsaSha1_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray rsaSha1_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#setClientSharedKey">QOAuth1Signature::setClientSharedKey(QString)</a></p>
     */
    @QtUninvokable
    public final void setClientSharedKey(java.lang.@NonNull String secret){
        setClientSharedKey_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), secret);
    }
    
    @QtUninvokable
    private native void setClientSharedKey_native_cref_QString(long __this__nativeId, java.lang.String secret);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#setCustomMethodString">QOAuth1Signature::setCustomMethodString(QByteArray)</a></p>
     */
    @QtUninvokable
    public final void setCustomMethodString(io.qt.core.@NonNull QByteArray verb){
        setCustomMethodString_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(verb));
    }
    
    @QtUninvokable
    private native void setCustomMethodString_native_cref_QByteArray(long __this__nativeId, long verb);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#setHttpRequestMethod">QOAuth1Signature::setHttpRequestMethod(QOAuth1Signature::HttpRequestMethod)</a></p>
     */
    @QtUninvokable
    public final void setHttpRequestMethod(io.qt.network.auth.QOAuth1Signature.@NonNull HttpRequestMethod method){
        setHttpRequestMethod_native_QOAuth1Signature_HttpRequestMethod(QtJambi_LibraryUtilities.internal.nativeId(this), method.value());
    }
    
    @QtUninvokable
    private native void setHttpRequestMethod_native_QOAuth1Signature_HttpRequestMethod(long __this__nativeId, int method);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#setParameters">QOAuth1Signature::setParameters(QVariantMap)</a></p>
     */
    @QtUninvokable
    public final void setParameters(java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        setParameters_native_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), parameters);
    }
    
    @QtUninvokable
    private native void setParameters_native_cref_QMap(long __this__nativeId, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#setTokenSecret">QOAuth1Signature::setTokenSecret(QString)</a></p>
     */
    @QtUninvokable
    public final void setTokenSecret(java.lang.@NonNull String secret){
        setTokenSecret_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), secret);
    }
    
    @QtUninvokable
    private native void setTokenSecret_native_cref_QString(long __this__nativeId, java.lang.String secret);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#setUrl">QOAuth1Signature::setUrl(QUrl)</a></p>
     */
    @QtUninvokable
    public final void setUrl(io.qt.core.@NonNull QUrl url){
        setUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void setUrl_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#swap">QOAuth1Signature::swap(QOAuth1Signature&amp;)</a></p>
     */
    @QtUninvokable
    public final void swap(io.qt.network.auth.@StrictNonNull QOAuth1Signature other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QOAuth1Signature(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QOAuth1Signature(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#take">QOAuth1Signature::take(QString)</a></p>
     */
    @QtUninvokable
    public final java.lang.Object take(java.lang.@NonNull String key){
        return take_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), key);
    }
    
    @QtUninvokable
    private native java.lang.Object take_native_cref_QString(long __this__nativeId, java.lang.String key);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#tokenSecret">QOAuth1Signature::tokenSecret()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String tokenSecret(){
        return tokenSecret_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String tokenSecret_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#url">QOAuth1Signature::url()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl url(){
        return url_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl url_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #value(java.lang.String, java.lang.Object)}
     *  with <code>defaultValue = null</code>.</p>
     */
    @QtUninvokable
    public final java.lang.Object value(java.lang.@NonNull String key) {
        return value(key, (java.lang.Object)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#value">QOAuth1Signature::value(QString,QVariant)const</a></p>
     */
    @QtUninvokable
    public final java.lang.Object value(java.lang.@NonNull String key, java.lang.Object defaultValue){
        return value_native_cref_QString_cref_QVariant_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), key, defaultValue);
    }
    
    @QtUninvokable
    private native java.lang.Object value_native_cref_QString_cref_QVariant_constfct(long __this__nativeId, java.lang.String key, java.lang.Object defaultValue);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1signature.html#plainText-1">QOAuth1Signature::plainText(QString,QString)</a></p>
     */
    public native static io.qt.core.@NonNull QByteArray plainText(java.lang.@NonNull String clientSharedSecret, java.lang.@NonNull String tokenSecret);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QOAuth1Signature(QPrivateConstructor p) { super(p); } 
    
    
    @QtUninvokable
    @Override
    public QOAuth1Signature clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QOAuth1Signature clone_native(long __this_nativeId);
}
