package io.qt.network.auth;

import io.qt.*;


/**
 * <p>The base of all implementations of OAuth 2 authentication methods</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qabstractoauth2.html">QAbstractOAuth2</a></p>
 */
public abstract class QAbstractOAuth2 extends io.qt.network.auth.QAbstractOAuth
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractOAuth2.class);
    
    @NativeAccess
    private static final class ConcreteWrapper extends QAbstractOAuth2 {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        public void grant(){
            grant_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native void grant_native(long __this__nativeId);
        
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#authorizationCallbackReceived">QAbstractOAuth2::authorizationCallbackReceived(QVariantMap)</a></p>
     */
    public final @NonNull Signal1<java.util.@NonNull NavigableMap<java.lang.@NonNull String, java.lang.Object>> authorizationCallbackReceived = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#clientIdentifierSharedKey-prop">QAbstractOAuth2::clientIdentifierSharedKeyChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="clientIdentifierSharedKey")
    public final @NonNull Signal1<java.lang.@NonNull String> clientIdentifierSharedKeyChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#error">QAbstractOAuth2::error(QString,QString,QUrl)</a></p>
     */
    public final @NonNull Signal3<java.lang.@NonNull String, java.lang.@NonNull String, io.qt.core.@NonNull QUrl> error = new Signal3<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#expiration-prop">QAbstractOAuth2::expirationAtChanged(QDateTime)</a></p>
     */
    @QtPropertyNotify(name="expiration")
    public final @NonNull Signal1<io.qt.core.@NonNull QDateTime> expirationAtChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#refreshToken-prop">QAbstractOAuth2::refreshTokenChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="refreshToken")
    public final @NonNull Signal1<java.lang.@NonNull String> refreshTokenChanged = new Signal1<>();

    public final @NonNull Signal1<java.lang.@NonNull String> responseTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#scope-prop">QAbstractOAuth2::scopeChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="scope")
    public final @NonNull Signal1<java.lang.@NonNull String> scopeChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#state-prop">QAbstractOAuth2::stateChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="state")
    public final @NonNull Signal1<java.lang.@NonNull String> stateChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#userAgent-prop">QAbstractOAuth2::userAgentChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="userAgent")
    public final @NonNull Signal1<java.lang.@NonNull String> userAgentChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.network.QNetworkAccessManager, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public QAbstractOAuth2(io.qt.network.@Nullable QNetworkAccessManager manager) {
        this(manager, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#QAbstractOAuth2-1">QAbstractOAuth2::QAbstractOAuth2(QNetworkAccessManager*,QObject*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QAbstractOAuth2(io.qt.network.@Nullable QNetworkAccessManager manager, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, manager, parent);
    }
    
    private native static void initialize_native(QAbstractOAuth2 instance, io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAbstractOAuth2() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#QAbstractOAuth2">QAbstractOAuth2::QAbstractOAuth2(QObject*)</a></p>
     */
    public QAbstractOAuth2(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAbstractOAuth2 instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #clientIdentifierSharedKey()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getClientIdentifierSharedKey() {
        return clientIdentifierSharedKey();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#clientIdentifierSharedKey-prop">QAbstractOAuth2::clientIdentifierSharedKey()const</a></p>
     */
    @QtPropertyReader(name="clientIdentifierSharedKey")
    @QtUninvokable
    public final java.lang.@NonNull String clientIdentifierSharedKey(){
        return clientIdentifierSharedKey_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String clientIdentifierSharedKey_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #expirationAt()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QDateTime getExpiration() {
        return expirationAt();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#expiration-prop">QAbstractOAuth2::expirationAt()const</a></p>
     */
    @QtPropertyReader(name="expiration")
    @QtUninvokable
    public final io.qt.core.@NonNull QDateTime expirationAt(){
        return expirationAt_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QDateTime expirationAt_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #refreshToken()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getRefreshToken() {
        return refreshToken();
    }
    
    /**
     * <p>Gets the current refresh token</p>
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#refreshToken">QAbstractOAuth2::refreshToken()const</a></p>
     */
    @QtPropertyReader(name="refreshToken")
    @QtUninvokable
    public final java.lang.@NonNull String refreshToken(){
        return refreshToken_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String refreshToken_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#responseType">QAbstractOAuth2::responseType()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String responseType(){
        return responseType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String responseType_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #scope()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getScope() {
        return scope();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#scope-prop">QAbstractOAuth2::scope()const</a></p>
     */
    @QtPropertyReader(name="scope")
    @QtUninvokable
    public final java.lang.@NonNull String scope(){
        return scope_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String scope_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#clientIdentifierSharedKey-prop">QAbstractOAuth2::setClientIdentifierSharedKey(QString)</a></p>
     */
    @QtPropertyWriter(name="clientIdentifierSharedKey")
    @QtUninvokable
    public final void setClientIdentifierSharedKey(java.lang.@NonNull String clientIdentifierSharedKey){
        setClientIdentifierSharedKey_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), clientIdentifierSharedKey);
    }
    
    @QtUninvokable
    private native void setClientIdentifierSharedKey_native_cref_QString(long __this__nativeId, java.lang.String clientIdentifierSharedKey);
    
    /**
     * <p>Sets the new refresh token refreshToken to be used</p>
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#setRefreshToken">QAbstractOAuth2::setRefreshToken(QString)</a></p>
     */
    @QtPropertyWriter(name="refreshToken")
    @QtUninvokable
    public final void setRefreshToken(java.lang.@NonNull String refreshToken){
        setRefreshToken_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), refreshToken);
    }
    
    @QtUninvokable
    private native void setRefreshToken_native_cref_QString(long __this__nativeId, java.lang.String refreshToken);
    
    @QtUninvokable
    protected final void setResponseType(java.lang.@NonNull String responseType){
        setResponseType_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), responseType);
    }
    
    @QtUninvokable
    private native void setResponseType_native_cref_QString(long __this__nativeId, java.lang.String responseType);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#scope-prop">QAbstractOAuth2::setScope(QString)</a></p>
     */
    @QtPropertyWriter(name="scope")
    @QtUninvokable
    public final void setScope(java.lang.@NonNull String scope){
        setScope_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), scope);
    }
    
    @QtUninvokable
    private native void setScope_native_cref_QString(long __this__nativeId, java.lang.String scope);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#state-prop">QAbstractOAuth2::setState(QString)</a></p>
     */
    @QtPropertyWriter(name="state")
    @QtUninvokable
    public final void setState(java.lang.@NonNull String state){
        setState_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), state);
    }
    
    @QtUninvokable
    private native void setState_native_cref_QString(long __this__nativeId, java.lang.String state);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#userAgent-prop">QAbstractOAuth2::setUserAgent(QString)</a></p>
     */
    @QtPropertyWriter(name="userAgent")
    @QtUninvokable
    public final void setUserAgent(java.lang.@NonNull String userAgent){
        setUserAgent_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), userAgent);
    }
    
    @QtUninvokable
    private native void setUserAgent_native_cref_QString(long __this__nativeId, java.lang.String userAgent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #state()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getState() {
        return state();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#state-prop">QAbstractOAuth2::state()const</a></p>
     */
    @QtPropertyReader(name="state")
    @QtUninvokable
    public final java.lang.@NonNull String state(){
        return state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String state_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #userAgent()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getUserAgent() {
        return userAgent();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#userAgent-prop">QAbstractOAuth2::userAgent()const</a></p>
     */
    @QtPropertyReader(name="userAgent")
    @QtUninvokable
    public final java.lang.@NonNull String userAgent(){
        return userAgent_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String userAgent_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #createAuthenticatedUrl(io.qt.core.QUrl, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    public final io.qt.core.@NonNull QUrl createAuthenticatedUrl(io.qt.core.@NonNull QUrl url) {
        return createAuthenticatedUrl(url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#createAuthenticatedUrl">QAbstractOAuth2::createAuthenticatedUrl(QUrl,QVariantMap)</a></p>
     */
    public io.qt.core.@NonNull QUrl createAuthenticatedUrl(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        return createAuthenticatedUrl_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    private native io.qt.core.QUrl createAuthenticatedUrl_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#deleteResource">QAbstractOAuth::deleteResource(QUrl,QVariantMap)</a></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.@Nullable QNetworkReply deleteResource(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        return deleteResource_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    private native io.qt.network.QNetworkReply deleteResource_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#get">QAbstractOAuth::get(QUrl,QVariantMap)</a></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.@Nullable QNetworkReply get(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        return get_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    private native io.qt.network.QNetworkReply get_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#head">QAbstractOAuth::head(QUrl,QVariantMap)</a></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.@Nullable QNetworkReply head(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        return head_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    private native io.qt.network.QNetworkReply head_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#post-2">QAbstractOAuth2::post(QUrl,QHttpMultiPart*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.@Nullable QNetworkReply post(io.qt.core.@NonNull QUrl url, io.qt.network.@Nullable QHttpMultiPart multiPart){
        return post_native_cref_QUrl_QHttpMultiPart_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), QtJambi_LibraryUtilities.internal.checkedNativeId(multiPart));
    }
    
    private native io.qt.network.QNetworkReply post_native_cref_QUrl_QHttpMultiPart_ptr(long __this__nativeId, long url, long multiPart);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#post-1">QAbstractOAuth2::post(QUrl,QByteArray)</a></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.@Nullable QNetworkReply post(io.qt.core.@NonNull QUrl url, io.qt.core.@NonNull QByteArray data){
        return post_native_cref_QUrl_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), QtJambi_LibraryUtilities.internal.checkedNativeId(data));
    }
    
    private native io.qt.network.QNetworkReply post_native_cref_QUrl_cref_QByteArray(long __this__nativeId, long url, long data);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#post">QAbstractOAuth::post(QUrl,QVariantMap)</a></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.@Nullable QNetworkReply post(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        return post_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    private native io.qt.network.QNetworkReply post_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#put-2">QAbstractOAuth2::put(QUrl,QHttpMultiPart*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.@Nullable QNetworkReply put(io.qt.core.@NonNull QUrl url, io.qt.network.@Nullable QHttpMultiPart multiPart){
        return put_native_cref_QUrl_QHttpMultiPart_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), QtJambi_LibraryUtilities.internal.checkedNativeId(multiPart));
    }
    
    private native io.qt.network.QNetworkReply put_native_cref_QUrl_QHttpMultiPart_ptr(long __this__nativeId, long url, long multiPart);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth2.html#put-1">QAbstractOAuth2::put(QUrl,QByteArray)</a></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.@Nullable QNetworkReply put(io.qt.core.@NonNull QUrl url, io.qt.core.@NonNull QByteArray data){
        return put_native_cref_QUrl_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), QtJambi_LibraryUtilities.internal.checkedNativeId(data));
    }
    
    private native io.qt.network.QNetworkReply put_native_cref_QUrl_cref_QByteArray(long __this__nativeId, long url, long data);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#put">QAbstractOAuth::put(QUrl,QVariantMap)</a></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.@Nullable QNetworkReply put(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        return put_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    private native io.qt.network.QNetworkReply put_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAbstractOAuth2(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QAbstractOAuth2(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAbstractOAuth2 instance, QDeclarativeConstructor constructor);
    
}
