package io.qt.network.auth;


/**
 * <p>Implementation of the Authorization Code Grant flow</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qoauth2authorizationcodeflow.html">QOAuth2AuthorizationCodeFlow</a></p>
 */
public class QOAuth2AuthorizationCodeFlow extends io.qt.network.auth.QAbstractOAuth2
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QOAuth2AuthorizationCodeFlow.class);
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth2authorizationcodeflow.html#accessTokenUrl-prop">QOAuth2AuthorizationCodeFlow::accessTokenUrlChanged(QUrl)</a></p>
     */
    @io.qt.QtPropertyNotify(name="accessTokenUrl")
    public final Signal1<io.qt.core.QUrl> accessTokenUrlChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QOAuth2AuthorizationCodeFlow(io.qt.network.QNetworkAccessManager, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth2AuthorizationCodeFlow(io.qt.network.QNetworkAccessManager manager) {
        this(manager, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth2authorizationcodeflow.html#QOAuth2AuthorizationCodeFlow-1">QOAuth2AuthorizationCodeFlow::QOAuth2AuthorizationCodeFlow(QNetworkAccessManager*,QObject*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth2AuthorizationCodeFlow(io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, manager, parent);
    }
    
    private native static void initialize_native(QOAuth2AuthorizationCodeFlow instance, io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QOAuth2AuthorizationCodeFlow(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QOAuth2AuthorizationCodeFlow() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth2authorizationcodeflow.html#QOAuth2AuthorizationCodeFlow">QOAuth2AuthorizationCodeFlow::QOAuth2AuthorizationCodeFlow(QObject*)</a></p>
     */
    public QOAuth2AuthorizationCodeFlow(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QOAuth2AuthorizationCodeFlow instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QOAuth2AuthorizationCodeFlow(java.lang.String, io.qt.network.QNetworkAccessManager, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth2AuthorizationCodeFlow(java.lang.String clientIdentifier, io.qt.network.QNetworkAccessManager manager) {
        this(clientIdentifier, manager, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth2authorizationcodeflow.html#QOAuth2AuthorizationCodeFlow-2">QOAuth2AuthorizationCodeFlow::QOAuth2AuthorizationCodeFlow(QString,QNetworkAccessManager*,QObject*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth2AuthorizationCodeFlow(java.lang.String clientIdentifier, io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, clientIdentifier, manager, parent);
    }
    
    private native static void initialize_native(QOAuth2AuthorizationCodeFlow instance, java.lang.String clientIdentifier, io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QOAuth2AuthorizationCodeFlow(java.lang.String, io.qt.core.QUrl, io.qt.core.QUrl, io.qt.network.QNetworkAccessManager, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth2AuthorizationCodeFlow(java.lang.String clientIdentifier, io.qt.core.QUrl authorizationUrl, io.qt.core.QUrl accessTokenUrl, io.qt.network.QNetworkAccessManager manager) {
        this(clientIdentifier, authorizationUrl, accessTokenUrl, manager, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth2authorizationcodeflow.html#QOAuth2AuthorizationCodeFlow-4">QOAuth2AuthorizationCodeFlow::QOAuth2AuthorizationCodeFlow(QString,QUrl,QUrl,QNetworkAccessManager*,QObject*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth2AuthorizationCodeFlow(java.lang.String clientIdentifier, io.qt.core.QUrl authorizationUrl, io.qt.core.QUrl accessTokenUrl, io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, clientIdentifier, authorizationUrl, accessTokenUrl, manager, parent);
    }
    
    private native static void initialize_native(QOAuth2AuthorizationCodeFlow instance, java.lang.String clientIdentifier, io.qt.core.QUrl authorizationUrl, io.qt.core.QUrl accessTokenUrl, io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QOAuth2AuthorizationCodeFlow(io.qt.core.QUrl, io.qt.core.QUrl, io.qt.network.QNetworkAccessManager, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth2AuthorizationCodeFlow(io.qt.core.QUrl authorizationUrl, io.qt.core.QUrl accessTokenUrl, io.qt.network.QNetworkAccessManager manager) {
        this(authorizationUrl, accessTokenUrl, manager, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth2authorizationcodeflow.html#QOAuth2AuthorizationCodeFlow-3">QOAuth2AuthorizationCodeFlow::QOAuth2AuthorizationCodeFlow(QUrl,QUrl,QNetworkAccessManager*,QObject*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth2AuthorizationCodeFlow(io.qt.core.QUrl authorizationUrl, io.qt.core.QUrl accessTokenUrl, io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, authorizationUrl, accessTokenUrl, manager, parent);
    }
    
    private native static void initialize_native(QOAuth2AuthorizationCodeFlow instance, io.qt.core.QUrl authorizationUrl, io.qt.core.QUrl accessTokenUrl, io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth2authorizationcodeflow.html#accessTokenUrl">QOAuth2AuthorizationCodeFlow::accessTokenUrl()const</a></p>
     */
    @io.qt.QtPropertyReader(name="accessTokenUrl")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl accessTokenUrl(){
        return accessTokenUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl accessTokenUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #buildAuthenticateUrl(java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @io.qt.QtUninvokable
    protected final io.qt.core.QUrl buildAuthenticateUrl() {
        return buildAuthenticateUrl(java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth2authorizationcodeflow.html#buildAuthenticateUrl">QOAuth2AuthorizationCodeFlow::buildAuthenticateUrl(QVariantMap)</a></p>
     */
    @io.qt.QtUninvokable
    protected final io.qt.core.QUrl buildAuthenticateUrl(java.util.Map<java.lang.String, java.lang.Object> parameters){
        return buildAuthenticateUrl_native_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), parameters);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl buildAuthenticateUrl_native_cref_QMap(long __this__nativeId, java.util.Map<java.lang.String, java.lang.Object> parameters);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth2authorizationcodeflow.html#refreshAccessToken">QOAuth2AuthorizationCodeFlow::refreshAccessToken()</a></p>
     */
    public final void refreshAccessToken(){
        refreshAccessToken_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void refreshAccessToken_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth2authorizationcodeflow.html#requestAccessToken">QOAuth2AuthorizationCodeFlow::requestAccessToken(QString)</a></p>
     */
    @io.qt.QtUninvokable
    protected final void requestAccessToken(java.lang.String code){
        requestAccessToken_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), code);
    }
    
    @io.qt.QtUninvokable
    private native void requestAccessToken_native_cref_QString(long __this__nativeId, java.lang.String code);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth2authorizationcodeflow.html#setAccessTokenUrl">QOAuth2AuthorizationCodeFlow::setAccessTokenUrl(QUrl)</a></p>
     */
    @io.qt.QtPropertyWriter(name="accessTokenUrl")
    @io.qt.QtUninvokable
    public final void setAccessTokenUrl(io.qt.core.QUrl accessTokenUrl){
        setAccessTokenUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(accessTokenUrl));
    }
    
    @io.qt.QtUninvokable
    private native void setAccessTokenUrl_native_cref_QUrl(long __this__nativeId, long accessTokenUrl);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#grant">QAbstractOAuth::grant()</a></p>
     */
    public void grant(){
        grant_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void grant_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#resourceOwnerAuthorization">QAbstractOAuth::resourceOwnerAuthorization(QUrl,QVariantMap)</a></p>
     */
    @io.qt.QtUninvokable
    protected void resourceOwnerAuthorization(io.qt.core.QUrl url, java.util.Map<java.lang.String, java.lang.Object> parameters){
        resourceOwnerAuthorization_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    @io.qt.QtUninvokable
    private native void resourceOwnerAuthorization_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, java.lang.Object> parameters);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QOAuth2AuthorizationCodeFlow(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QOAuth2AuthorizationCodeFlow(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QOAuth2AuthorizationCodeFlow instance, QDeclarativeConstructor constructor);
    
}
