package io.qt.network.auth;


/**
 * <p>Implementation of the OAuth 1 Protocol</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qoauth1.html">QOAuth1</a></p>
 */
public class QOAuth1 extends io.qt.network.auth.QAbstractOAuth
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QOAuth1.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qoauth1.html#SignatureMethod-enum">QOAuth1::SignatureMethod</a></p>
     */
    public enum SignatureMethod implements io.qt.QtEnumerator {
        Hmac_Sha1(0),
        Rsa_Sha1(1),
        PlainText(2);

        private SignatureMethod(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static SignatureMethod resolve(int value) {
            switch (value) {
            case 0: return Hmac_Sha1;
            case 1: return Rsa_Sha1;
            case 2: return PlainText;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    public final Signal1<java.lang.String> clientSharedSecretChanged = new Signal1<>();

    public final Signal1<io.qt.network.auth.QOAuth1.SignatureMethod> signatureMethodChanged = new Signal1<>();

    public final Signal1<io.qt.core.QUrl> temporaryCredentialsUrlChanged = new Signal1<>();

    public final Signal1<io.qt.core.QUrl> tokenCredentialsUrlChanged = new Signal1<>();

    public final Signal1<java.lang.String> tokenSecretChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QOAuth1(io.qt.network.QNetworkAccessManager, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth1(io.qt.network.QNetworkAccessManager manager) {
        this(manager, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#QOAuth1-1">QOAuth1::QOAuth1(QNetworkAccessManager*,QObject*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth1(io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, manager, parent);
    }
    
    private native static void initialize_native(QOAuth1 instance, io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QOAuth1(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QOAuth1() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#QOAuth1">QOAuth1::QOAuth1(QObject*)</a></p>
     */
    public QOAuth1(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QOAuth1 instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QOAuth1(java.lang.String, java.lang.String, io.qt.network.QNetworkAccessManager, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth1(java.lang.String clientIdentifier, java.lang.String clientSharedSecret, io.qt.network.QNetworkAccessManager manager) {
        this(clientIdentifier, clientSharedSecret, manager, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#QOAuth1-2">QOAuth1::QOAuth1(QString,QString,QNetworkAccessManager*,QObject*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth1(java.lang.String clientIdentifier, java.lang.String clientSharedSecret, io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, clientIdentifier, clientSharedSecret, manager, parent);
    }
    
    private native static void initialize_native(QOAuth1 instance, java.lang.String clientIdentifier, java.lang.String clientSharedSecret, io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#clientCredentials">QOAuth1::clientCredentials()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QPair<java.lang.String, java.lang.String> clientCredentials(){
        return clientCredentials_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QPair<java.lang.String, java.lang.String> clientCredentials_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#clientSharedSecret">QOAuth1::clientSharedSecret()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String clientSharedSecret(){
        return clientSharedSecret_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String clientSharedSecret_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#continueGrantWithVerifier">QOAuth1::continueGrantWithVerifier(QString)</a></p>
     */
    public final void continueGrantWithVerifier(java.lang.String verifier){
        continueGrantWithVerifier_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), verifier);
    }
    
    private native void continueGrantWithVerifier_native_cref_QString(long __this__nativeId, java.lang.String verifier);
    
    /**
     * <p>Overloaded function for {@link #requestTemporaryCredentials(io.qt.network.QNetworkAccessManager.Operation, io.qt.core.QUrl, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @io.qt.QtUninvokable
    protected final io.qt.network.QNetworkReply requestTemporaryCredentials(io.qt.network.QNetworkAccessManager.Operation operation, io.qt.core.QUrl url) {
        return requestTemporaryCredentials(operation, url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#requestTemporaryCredentials">QOAuth1::requestTemporaryCredentials(QNetworkAccessManager::Operation,QUrl,QVariantMap)</a></p>
     */
    @io.qt.QtUninvokable
    protected final io.qt.network.QNetworkReply requestTemporaryCredentials(io.qt.network.QNetworkAccessManager.Operation operation, io.qt.core.QUrl url, java.util.Map<java.lang.String, java.lang.Object> parameters){
        return requestTemporaryCredentials_native_QNetworkAccessManager_Operation_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), operation.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.network.QNetworkReply requestTemporaryCredentials_native_QNetworkAccessManager_Operation_cref_QUrl_cref_QMap(long __this__nativeId, int operation, long url, java.util.Map<java.lang.String, java.lang.Object> parameters);
    
    /**
     * <p>Overloaded function for {@link #requestTokenCredentials(io.qt.network.QNetworkAccessManager.Operation, io.qt.core.QUrl, io.qt.core.QPair, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @io.qt.QtUninvokable
    protected final io.qt.network.QNetworkReply requestTokenCredentials(io.qt.network.QNetworkAccessManager.Operation operation, io.qt.core.QUrl url, io.qt.core.QPair<java.lang.String, java.lang.String> temporaryToken) {
        return requestTokenCredentials(operation, url, temporaryToken, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#requestTokenCredentials">QOAuth1::requestTokenCredentials(QNetworkAccessManager::Operation,QUrl,QPair&lt;QString,QString&gt;,QVariantMap)</a></p>
     */
    @io.qt.QtUninvokable
    protected final io.qt.network.QNetworkReply requestTokenCredentials(io.qt.network.QNetworkAccessManager.Operation operation, io.qt.core.QUrl url, io.qt.core.QPair<java.lang.String, java.lang.String> temporaryToken, java.util.Map<java.lang.String, java.lang.Object> parameters){
        return requestTokenCredentials_native_QNetworkAccessManager_Operation_cref_QUrl_cref_QPair_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), operation.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(url), temporaryToken, parameters);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.network.QNetworkReply requestTokenCredentials_native_QNetworkAccessManager_Operation_cref_QUrl_cref_QPair_cref_QMap(long __this__nativeId, int operation, long url, io.qt.core.QPair<java.lang.String, java.lang.String> temporaryToken, java.util.Map<java.lang.String, java.lang.Object> parameters);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#setClientCredentials">QOAuth1::setClientCredentials(QPair&lt;QString,QString&gt;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setClientCredentials(io.qt.core.QPair<java.lang.String, java.lang.String> clientCredentials){
        setClientCredentials_native_cref_QPair(QtJambi_LibraryUtilities.internal.nativeId(this), clientCredentials);
    }
    
    @io.qt.QtUninvokable
    private native void setClientCredentials_native_cref_QPair(long __this__nativeId, io.qt.core.QPair<java.lang.String, java.lang.String> clientCredentials);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#setClientCredentials-1">QOAuth1::setClientCredentials(QString,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setClientCredentials(java.lang.String clientIdentifier, java.lang.String clientSharedSecret){
        setClientCredentials_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), clientIdentifier, clientSharedSecret);
    }
    
    @io.qt.QtUninvokable
    private native void setClientCredentials_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String clientIdentifier, java.lang.String clientSharedSecret);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#setClientSharedSecret">QOAuth1::setClientSharedSecret(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setClientSharedSecret(java.lang.String clientSharedSecret){
        setClientSharedSecret_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), clientSharedSecret);
    }
    
    @io.qt.QtUninvokable
    private native void setClientSharedSecret_native_cref_QString(long __this__nativeId, java.lang.String clientSharedSecret);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#setSignatureMethod">QOAuth1::setSignatureMethod(QOAuth1::SignatureMethod)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setSignatureMethod(io.qt.network.auth.QOAuth1.SignatureMethod value){
        setSignatureMethod_native_QOAuth1_SignatureMethod(QtJambi_LibraryUtilities.internal.nativeId(this), value.value());
    }
    
    @io.qt.QtUninvokable
    private native void setSignatureMethod_native_QOAuth1_SignatureMethod(long __this__nativeId, int value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#setTemporaryCredentialsUrl">QOAuth1::setTemporaryCredentialsUrl(QUrl)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setTemporaryCredentialsUrl(io.qt.core.QUrl url){
        setTemporaryCredentialsUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @io.qt.QtUninvokable
    private native void setTemporaryCredentialsUrl_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#setTokenCredentials">QOAuth1::setTokenCredentials(QPair&lt;QString,QString&gt;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setTokenCredentials(io.qt.core.QPair<java.lang.String, java.lang.String> tokenCredentials){
        setTokenCredentials_native_cref_QPair(QtJambi_LibraryUtilities.internal.nativeId(this), tokenCredentials);
    }
    
    @io.qt.QtUninvokable
    private native void setTokenCredentials_native_cref_QPair(long __this__nativeId, io.qt.core.QPair<java.lang.String, java.lang.String> tokenCredentials);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#setTokenCredentials-1">QOAuth1::setTokenCredentials(QString,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setTokenCredentials(java.lang.String token, java.lang.String tokenSecret){
        setTokenCredentials_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), token, tokenSecret);
    }
    
    @io.qt.QtUninvokable
    private native void setTokenCredentials_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String token, java.lang.String tokenSecret);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#setTokenCredentialsUrl">QOAuth1::setTokenCredentialsUrl(QUrl)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setTokenCredentialsUrl(io.qt.core.QUrl url){
        setTokenCredentialsUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @io.qt.QtUninvokable
    private native void setTokenCredentialsUrl_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#setTokenSecret">QOAuth1::setTokenSecret(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setTokenSecret(java.lang.String tokenSecret){
        setTokenSecret_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), tokenSecret);
    }
    
    @io.qt.QtUninvokable
    private native void setTokenSecret_native_cref_QString(long __this__nativeId, java.lang.String tokenSecret);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#setup">QOAuth1::setup(QNetworkRequest*,QVariantMap,QNetworkAccessManager::Operation)</a></p>
     */
    @io.qt.QtUninvokable
    protected final void setup(io.qt.network.QNetworkRequest request, java.util.Map<java.lang.String, java.lang.Object> signingParameters, io.qt.network.QNetworkAccessManager.Operation operation){
        setup_native_QNetworkRequest_ptr_cref_QMap_QNetworkAccessManager_Operation(QtJambi_LibraryUtilities.internal.nativeId(this), request, signingParameters, operation.value());
    }
    
    @io.qt.QtUninvokable
    private native void setup_native_QNetworkRequest_ptr_cref_QMap_QNetworkAccessManager_Operation(long __this__nativeId, io.qt.network.QNetworkRequest request, java.util.Map<java.lang.String, java.lang.Object> signingParameters, int operation);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#setup-1">QOAuth1::setup(QNetworkRequest*,QVariantMap,QByteArray)</a></p>
     */
    @io.qt.QtUninvokable
    protected final void setup(io.qt.network.QNetworkRequest request, java.util.Map<java.lang.String, java.lang.Object> signingParameters, io.qt.core.QByteArray operationVerb){
        setup_native_QNetworkRequest_ptr_cref_QMap_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), request, signingParameters, QtJambi_LibraryUtilities.internal.checkedNativeId(operationVerb));
    }
    
    @io.qt.QtUninvokable
    private native void setup_native_QNetworkRequest_ptr_cref_QMap_cref_QByteArray(long __this__nativeId, io.qt.network.QNetworkRequest request, java.util.Map<java.lang.String, java.lang.Object> signingParameters, long operationVerb);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#signatureMethod">QOAuth1::signatureMethod()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.network.auth.QOAuth1.SignatureMethod signatureMethod(){
        return io.qt.network.auth.QOAuth1.SignatureMethod.resolve(signatureMethod_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int signatureMethod_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#temporaryCredentialsUrl">QOAuth1::temporaryCredentialsUrl()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl temporaryCredentialsUrl(){
        return temporaryCredentialsUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl temporaryCredentialsUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#tokenCredentials">QOAuth1::tokenCredentials()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QPair<java.lang.String, java.lang.String> tokenCredentials(){
        return tokenCredentials_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QPair<java.lang.String, java.lang.String> tokenCredentials_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#tokenCredentialsUrl">QOAuth1::tokenCredentialsUrl()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl tokenCredentialsUrl(){
        return tokenCredentialsUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl tokenCredentialsUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#tokenSecret">QOAuth1::tokenSecret()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String tokenSecret(){
        return tokenSecret_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String tokenSecret_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#deleteResource">QAbstractOAuth::deleteResource(QUrl,QVariantMap)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public io.qt.network.QNetworkReply deleteResource(io.qt.core.QUrl url, java.util.Map<java.lang.String, java.lang.Object> parameters){
        return deleteResource_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.network.QNetworkReply deleteResource_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, java.lang.Object> parameters);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#get">QAbstractOAuth::get(QUrl,QVariantMap)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public io.qt.network.QNetworkReply get(io.qt.core.QUrl url, java.util.Map<java.lang.String, java.lang.Object> parameters){
        return get_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.network.QNetworkReply get_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, java.lang.Object> parameters);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#grant">QAbstractOAuth::grant()</a></p>
     */
    public void grant(){
        grant_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void grant_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#head">QAbstractOAuth::head(QUrl,QVariantMap)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public io.qt.network.QNetworkReply head(io.qt.core.QUrl url, java.util.Map<java.lang.String, java.lang.Object> parameters){
        return head_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.network.QNetworkReply head_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, java.lang.Object> parameters);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#post">QAbstractOAuth::post(QUrl,QVariantMap)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public io.qt.network.QNetworkReply post(io.qt.core.QUrl url, java.util.Map<java.lang.String, java.lang.Object> parameters){
        return post_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.network.QNetworkReply post_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, java.lang.Object> parameters);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractoauth.html#put">QAbstractOAuth::put(QUrl,QVariantMap)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public io.qt.network.QNetworkReply put(io.qt.core.QUrl url, java.util.Map<java.lang.String, java.lang.Object> parameters){
        return put_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.network.QNetworkReply put_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, java.lang.Object> parameters);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#generateAuthorizationHeader">QOAuth1::generateAuthorizationHeader(QVariantMap)</a></p>
     */
    protected native static io.qt.core.QByteArray generateAuthorizationHeader(java.util.Map<java.lang.String, java.lang.Object> oauthParams);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qoauth1.html#nonce">QOAuth1::nonce()</a></p>
     */
    protected native static io.qt.core.QByteArray nonce();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QOAuth1(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QOAuth1(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QOAuth1 instance, QDeclarativeConstructor constructor);
    
}
