#include "QRestAccessManager_shell.h"
#include <QtJambi/Cast>

// emitting (writeClassCodeInjections)
auto convertConsumer(JNIEnv* _env, jobject _consumer){
    JObjectWrapper consumer(_env, _consumer);
    return [consumer](QRestReply& reply){
                    if(JniEnvironment env{200}){
                        jobject _reply = qtjambi_cast<jobject>(env, &reply);
                        InvalidateAfterUse inv(env, _reply);
                        Java::Runtime::Consumer::accept(env, consumer.object(), _reply);
                    }
                };
}

QtJambiShell* QRestAccessManager_shell::__shell() const { return *reinterpret_cast<QtJambiShell**>( quintptr(this) + sizeof(QRestAccessManager_shell) ); }

jmethodID QRestAccessManager_oshell::__shell_javaMethod(int pos) const { return QRestAccessManager_shell::__shell()->javaMethod(typeid(QRestAccessManager), pos); }

// emitting (writeShellDestructor)
QRestAccessManager_shell::~QRestAccessManager_shell()
{
    QTJAMBI_IN_DESTRUCTOR_CALL("QRestAccessManager::~QRestAccessManager()", this)
    QRestAccessManager_shell::__shell()->destructed(typeid(QRestAccessManager));
}

// emitting (writeShellConstructor)
QRestAccessManager_shell::QRestAccessManager_shell(QNetworkAccessManager* manager0, QObject* parent1)
    : QRestAccessManager(manager0, parent1)
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QRestAccessManager::QRestAccessManager_shell(QNetworkAccessManager* manager0, QObject* parent1)", this)
    QRestAccessManager_shell::__shell()->constructed(typeid(QRestAccessManager));
}

void QRestAccessManager_shell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QRestAccessManager_shell*>(ptr)->QRestAccessManager_shell::__shell()->tryDeleteShell(typeid(QRestAccessManager));
}

void QRestAccessManager_mshell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QRestAccessManager_mshell*>(ptr)->QRestAccessManager_mshell::__shell()->tryDeleteShell(typeid(QRestAccessManager));
}

void QRestAccessManager_oshell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QRestAccessManager_oshell*>(ptr)->QRestAccessManager_oshell::__shell()->tryDeleteShell(typeid(QRestAccessManager));
}

// emitting (writeQObjectFunctions)
const QMetaObject *QRestAccessManager_mshell::metaObject() const
{
  return QRestAccessManager_shell::__shell()->metaObject();
}

void *QRestAccessManager_mshell::qt_metacast(const char *_clname)
{
    bool ok = false;
    void *rv = QRestAccessManager_shell::__shell()->qt_metacast(_clname, &ok);
    QTJAMBI_INTERNAL_INSTANCE_METHOD_CALL("QRestAccessManager_mshell::qt_metacast(const char *_clname)", this)
    if (!ok)
        rv = QRestAccessManager::qt_metacast(_clname);
    return rv;
}

int QRestAccessManager_mshell::qt_metacall(QMetaObject::Call _c, int _id, void **_a)
{
    QTJAMBI_INTERNAL_INSTANCE_METHOD_CALL("QRestAccessManager_mshell::qt_metacall(QMetaObject::Call _c, int _id, void **_a)", this)
    _id = QRestAccessManager::qt_metacall(_c, _id, _a);
    if (_id >= 0)
        _id = QRestAccessManager_shell::__shell()->qt_metacall(_c, _id, _a);
    return _id;
}

// emitting Virtual overrides (virtualFunctions)
void QRestAccessManager_oshell::childEvent(QChildEvent* event0)
{
    if(jmethodID method_id = __shell_javaMethod(0)){
        if (JniEnvironmentExceptionHandler __jni_env{300}) {
            QTJAMBI_TRY {
                if(jobject __java_this = QRestAccessManager_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_event0 = qtjambi_cast<jobject>(__jni_env, event0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_event0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_event0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QRestAccessManager_shell::__shell()->warnForMethod("QRestAccessManager::childEvent(QChildEvent*)", this);
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QRestAccessManager::childEvent(QChildEvent*)");
            } QTJAMBI_TRY_END
        }else{
            QObject::childEvent(event0);
        }
    }else{
        QObject::childEvent(event0);
    }
}

void QRestAccessManager_oshell::connectNotify(const QMetaMethod& signal0)
{
    if(jmethodID method_id = __shell_javaMethod(1)){
        if (JniEnvironmentExceptionHandler __jni_env{300}) {
            QTJAMBI_TRY {
                if(jobject __java_this = QRestAccessManager_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_signal0 = qtjambi_cast<jobject>(__jni_env, signal0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_signal0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QRestAccessManager_shell::__shell()->warnForMethod("QRestAccessManager::connectNotify(QMetaMethod)", this);
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QRestAccessManager::connectNotify(QMetaMethod)");
            } QTJAMBI_TRY_END
        }else{
            QObject::connectNotify(signal0);
        }
    }else{
        QObject::connectNotify(signal0);
    }
}

void QRestAccessManager_oshell::customEvent(QEvent* event0)
{
    if(jmethodID method_id = __shell_javaMethod(2)){
        if (JniEnvironmentExceptionHandler __jni_env{300}) {
            QTJAMBI_TRY {
                if(jobject __java_this = QRestAccessManager_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_event0 = qtjambi_cast<jobject>(__jni_env, event0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_event0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_event0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QRestAccessManager_shell::__shell()->warnForMethod("QRestAccessManager::customEvent(QEvent*)", this);
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QRestAccessManager::customEvent(QEvent*)");
            } QTJAMBI_TRY_END
        }else{
            QObject::customEvent(event0);
        }
    }else{
        QObject::customEvent(event0);
    }
}

void QRestAccessManager_oshell::disconnectNotify(const QMetaMethod& signal0)
{
    if(jmethodID method_id = __shell_javaMethod(3)){
        if (JniEnvironmentExceptionHandler __jni_env{300}) {
            QTJAMBI_TRY {
                if(jobject __java_this = QRestAccessManager_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_signal0 = qtjambi_cast<jobject>(__jni_env, signal0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_signal0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QRestAccessManager_shell::__shell()->warnForMethod("QRestAccessManager::disconnectNotify(QMetaMethod)", this);
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QRestAccessManager::disconnectNotify(QMetaMethod)");
            } QTJAMBI_TRY_END
        }else{
            QObject::disconnectNotify(signal0);
        }
    }else{
        QObject::disconnectNotify(signal0);
    }
}

bool QRestAccessManager_oshell::event(QEvent* event0)
{
    if(jmethodID method_id = __shell_javaMethod(4)){
        if (JniEnvironmentExceptionHandler __jni_env{300}) {
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QRestAccessManager_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_event0 = qtjambi_cast<jobject>(__jni_env, event0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_event0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_event0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    if(event0->type()==QEvent::DeferredDelete || event0->type()==QEvent::ChildRemoved){
                        __qt_return_value = QObject::event(event0);
                    } else {
                        QRestAccessManager_shell::__shell()->warnForMethod("QRestAccessManager::event(QEvent*)", this);
                    }
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QRestAccessManager::event(QEvent*)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QObject::event(event0);
        }
    }else{
        return QObject::event(event0);
    }
}

bool QRestAccessManager_oshell::eventFilter(QObject* watched0, QEvent* event1)
{
    if(jmethodID method_id = __shell_javaMethod(5)){
        if (JniEnvironmentExceptionInhibitorAndBlocker __jni_env{400}) {
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QRestAccessManager_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_watched0;
                    try{
                        __java_watched0 = qtjambi_cast<jobject>(__jni_env, watched0);
                        if(!__java_watched0 && watched0)
                            return QObject::eventFilter(watched0, event1);
                    }catch(const JavaException&){
                        return QObject::eventFilter(watched0, event1);
                    }
                    jobject __java_event1;
                    try{
                        __java_event1 = qtjambi_cast<jobject>(__jni_env, event1);
                    }catch(const JavaException&){
                        return QObject::eventFilter(watched0, event1);
                    }
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_event1);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_watched0, __java_event1);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    if(event1->type()==QEvent::DeferredDelete || event1->type()==QEvent::ChildRemoved){
                        __qt_return_value = QObject::eventFilter(watched0, event1);
                    } else {
                        QRestAccessManager_shell::__shell()->warnForMethod("QRestAccessManager::eventFilter(QObject*,QEvent*)", this);
                    }
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QRestAccessManager::eventFilter(QObject*,QEvent*)");
            } QTJAMBI_TRY_END
            __jni_env.releaseException();
            return __qt_return_value;
        }else{
            QtJambiExceptionBlocker __qj_exceptionBlocker;
            bool  __qt_return_value = QObject::eventFilter(watched0, event1);
            __qj_exceptionBlocker.release(nullptr);
            return __qt_return_value;
        }
    }else{
        QtJambiExceptionBlocker __qj_exceptionBlocker;
        bool  __qt_return_value = QObject::eventFilter(watched0, event1);
        __qj_exceptionBlocker.release(nullptr);
        return __qt_return_value;
    }
}

void QRestAccessManager_oshell::timerEvent(QTimerEvent* event0)
{
    if(jmethodID method_id = __shell_javaMethod(6)){
        if (JniEnvironmentExceptionHandler __jni_env{300}) {
            QTJAMBI_TRY {
                if(jobject __java_this = QRestAccessManager_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_event0 = qtjambi_cast<jobject>(__jni_env, event0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_event0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_event0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QRestAccessManager_shell::__shell()->warnForMethod("QRestAccessManager::timerEvent(QTimerEvent*)", this);
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QRestAccessManager::timerEvent(QTimerEvent*)");
            } QTJAMBI_TRY_END
        }else{
            QObject::timerEvent(event0);
        }
    }else{
        QObject::timerEvent(event0);
    }
}

// emitting Functions in shell class (nonVirtualShellFunctions)
// emitting Public Override Functions (publicOverrideFunctions)
// emitting Virtual Override Functions (virtualOverrideFunctions)
// emitting (writeConstructors)
// new QRestAccessManager(QNetworkAccessManager*,QObject*)
void __qt_construct_QRestAccessManager_QNetworkAccessManager_ptr(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_has_derivedMetaObject, bool __qtjambi_has_overrides, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRestAccessManager(QNetworkAccessManager*,QObject*)")
    jobject manager0 = __java_arguments[0].l;
    QNetworkAccessManager* __qt_manager0 = qtjambi_cast<QNetworkAccessManager*>(__jni_env, manager0);
    QRestAccessManager *__qt_this;
    if(__qtjambi_has_overrides)
        __qt_this = new(__qtjambi_ptr) QRestAccessManager_oshell(__qt_manager0);
    else if(__qtjambi_has_derivedMetaObject)
        __qt_this = new(__qtjambi_ptr) QRestAccessManager_mshell(__qt_manager0);
    else
        __qt_this = new(__qtjambi_ptr) QRestAccessManager_shell(__qt_manager0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// new QRestAccessManager(QNetworkAccessManager*,QObject*)
void __qt_construct_QRestAccessManager_QNetworkAccessManager_ptr_QObject_ptr(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_has_derivedMetaObject, bool __qtjambi_has_overrides, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRestAccessManager(QNetworkAccessManager*,QObject*)")
    jobject manager0 = __java_arguments[0].l;
    QNetworkAccessManager* __qt_manager0 = qtjambi_cast<QNetworkAccessManager*>(__jni_env, manager0);
    jobject parent1 = __java_arguments[1].l;
    QObject* __qt_parent1 = qtjambi_cast<QObject*>(__jni_env, parent1);
    QtJambiAPI::checkThreadOnParent(__jni_env, __qt_parent1);
    QRestAccessManager *__qt_this;
    if(__qtjambi_has_overrides)
        __qt_this = new(__qtjambi_ptr) QRestAccessManager_oshell(__qt_manager0, __qt_parent1);
    else if(__qtjambi_has_derivedMetaObject)
        __qt_this = new(__qtjambi_ptr) QRestAccessManager_mshell(__qt_manager0, __qt_parent1);
    else
        __qt_this = new(__qtjambi_ptr) QRestAccessManager_shell(__qt_manager0, __qt_parent1);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QRestAccessManager::QRestAccessManager(QNetworkAccessManager*,QObject*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_initialize_1native__Lio_qt_network_QRestAccessManager_2Lio_qt_network_QNetworkAccessManager_2Lio_qt_core_QObject_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject manager0,
 jobject parent1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRestAccessManager::QRestAccessManager(QNetworkAccessManager*,QObject*)")
    QTJAMBI_TRY {
        jvalue arguments[2];
        arguments[0].l = manager0;
        arguments[1].l = parent1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRestAccessManager_QNetworkAccessManager_ptr_QObject_ptr, sizeof(QRestAccessManager_shell), typeid(QRestAccessManager), 0, QRestAccessManager::staticMetaObject, true, false, false, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QRestAccessManager_shell
void __qt_destruct_QRestAccessManager(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QRestAccessManager")
    reinterpret_cast<QRestAccessManager_shell*>(ptr)->~QRestAccessManager_shell();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QRestAccessManager::deleteResource(QNetworkRequest)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_deleteResource_1native_1cref_1QNetworkRequest__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::deleteResource(QNetworkRequest)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        QNetworkReply* __qt_return_value = __qt_this->deleteResource(__qt_request0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::deleteResource<std::function<void(QRestReply&)>,true>(QNetworkRequest,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_deleteResource_1native_1cref_1QNetworkRequest_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJJLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID context1,
 jobject callback2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::deleteResource<std::function<void(QRestReply&)>,true>(QNetworkRequest,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        QObject* __qt_context1 = QtJambiAPI::objectFromNativeId<QObject>(context1);
        auto __qt_callback2 = convertConsumer(__jni_env, callback2);
        QNetworkReply* __qt_return_value = __qt_this->deleteResource(__qt_request0, __qt_context1, std::move(__qt_callback2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::get(QNetworkRequest)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_get_1native_1cref_1QNetworkRequest__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::get(QNetworkRequest)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        QNetworkReply* __qt_return_value = __qt_this->get(__qt_request0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::get(QNetworkRequest,QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_get_1native_1cref_1QNetworkRequest_1cref_1QByteArray__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::get(QNetworkRequest,QByteArray)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QByteArray& __qt_data1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(data1);
        QNetworkReply* __qt_return_value = __qt_this->get(__qt_request0, __qt_data1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::get(QNetworkRequest,QIODevice*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_get_1native_1cref_1QNetworkRequest_1QIODevice_1ptr__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::get(QNetworkRequest,QIODevice*)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        QIODevice* __qt_data1 = QtJambiAPI::objectFromNativeId<QIODevice>(data1);
        QNetworkReply* __qt_return_value = __qt_this->get(__qt_request0, __qt_data1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::get(QNetworkRequest,QJsonDocument)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_get_1native_1cref_1QNetworkRequest_1cref_1QJsonDocument__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::get(QNetworkRequest,QJsonDocument)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QJsonDocument& __qt_data1 = QtJambiAPI::valueReferenceFromNativeId<QJsonDocument>(data1);
        QNetworkReply* __qt_return_value = __qt_this->get(__qt_request0, __qt_data1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::get<std::function<void(QRestReply&)>,true>(QNetworkRequest,QByteArray,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_get_1native_1cref_1QNetworkRequest_1cref_1QByteArray_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJJJLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1,
 QtJambiNativeID context2,
 jobject callback3)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::get<std::function<void(QRestReply&)>,true>(QNetworkRequest,QByteArray,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QByteArray& __qt_data1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(data1);
        QObject* __qt_context2 = QtJambiAPI::objectFromNativeId<QObject>(context2);
        auto __qt_callback3 = convertConsumer(__jni_env, callback3);
        QNetworkReply* __qt_return_value = __qt_this->get(__qt_request0, __qt_data1, __qt_context2, std::move(__qt_callback3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::get<std::function<void(QRestReply&)>,true>(QNetworkRequest,QIODevice*,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_get_1native_1cref_1QNetworkRequest_1QIODevice_1ptr_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJJJLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1,
 QtJambiNativeID context2,
 jobject callback3)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::get<std::function<void(QRestReply&)>,true>(QNetworkRequest,QIODevice*,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        QIODevice* __qt_data1 = QtJambiAPI::objectFromNativeId<QIODevice>(data1);
        QObject* __qt_context2 = QtJambiAPI::objectFromNativeId<QObject>(context2);
        auto __qt_callback3 = convertConsumer(__jni_env, callback3);
        QNetworkReply* __qt_return_value = __qt_this->get(__qt_request0, __qt_data1, __qt_context2, std::move(__qt_callback3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::get<std::function<void(QRestReply&)>,true>(QNetworkRequest,QJsonDocument,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_get_1native_1cref_1QNetworkRequest_1cref_1QJsonDocument_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJJJLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1,
 QtJambiNativeID context2,
 jobject callback3)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::get<std::function<void(QRestReply&)>,true>(QNetworkRequest,QJsonDocument,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QJsonDocument& __qt_data1 = QtJambiAPI::valueReferenceFromNativeId<QJsonDocument>(data1);
        QObject* __qt_context2 = QtJambiAPI::objectFromNativeId<QObject>(context2);
        auto __qt_callback3 = convertConsumer(__jni_env, callback3);
        QNetworkReply* __qt_return_value = __qt_this->get(__qt_request0, __qt_data1, __qt_context2, std::move(__qt_callback3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::get<std::function<void(QRestReply&)>,true>(QNetworkRequest,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_get_1native_1cref_1QNetworkRequest_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJJLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID context1,
 jobject callback2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::get<std::function<void(QRestReply&)>,true>(QNetworkRequest,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        QObject* __qt_context1 = QtJambiAPI::objectFromNativeId<QObject>(context1);
        auto __qt_callback2 = convertConsumer(__jni_env, callback2);
        QNetworkReply* __qt_return_value = __qt_this->get(__qt_request0, __qt_context1, std::move(__qt_callback2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::head(QNetworkRequest)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_head_1native_1cref_1QNetworkRequest__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::head(QNetworkRequest)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        QNetworkReply* __qt_return_value = __qt_this->head(__qt_request0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::head<std::function<void(QRestReply&)>,true>(QNetworkRequest,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_head_1native_1cref_1QNetworkRequest_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJJLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID context1,
 jobject callback2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::head<std::function<void(QRestReply&)>,true>(QNetworkRequest,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        QObject* __qt_context1 = QtJambiAPI::objectFromNativeId<QObject>(context1);
        auto __qt_callback2 = convertConsumer(__jni_env, callback2);
        QNetworkReply* __qt_return_value = __qt_this->head(__qt_request0, __qt_context1, std::move(__qt_callback2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::networkAccessManager()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_networkAccessManager_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::networkAccessManager()const", __this_nativeId)
        QNetworkAccessManager* __qt_return_value = __qt_this->networkAccessManager();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::patch(QNetworkRequest,QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_patch_1native_1cref_1QNetworkRequest_1cref_1QByteArray__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::patch(QNetworkRequest,QByteArray)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QByteArray& __qt_data1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(data1);
        QNetworkReply* __qt_return_value = __qt_this->patch(__qt_request0, __qt_data1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::patch(QNetworkRequest,QIODevice*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_patch_1native_1cref_1QNetworkRequest_1QIODevice_1ptr__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::patch(QNetworkRequest,QIODevice*)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        QIODevice* __qt_data1 = QtJambiAPI::objectFromNativeId<QIODevice>(data1);
        QNetworkReply* __qt_return_value = __qt_this->patch(__qt_request0, __qt_data1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::patch(QNetworkRequest,QJsonDocument)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_patch_1native_1cref_1QNetworkRequest_1cref_1QJsonDocument__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::patch(QNetworkRequest,QJsonDocument)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QJsonDocument& __qt_data1 = QtJambiAPI::valueReferenceFromNativeId<QJsonDocument>(data1);
        QNetworkReply* __qt_return_value = __qt_this->patch(__qt_request0, __qt_data1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::patch(QNetworkRequest,QVariantMap)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_patch_1native_1cref_1QNetworkRequest_1cref_1QMap__JJLjava_util_Map_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 jobject data1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::patch(QNetworkRequest,QVariantMap)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QMap<QString, QVariant>& __qt_data1 = qtjambi_cast<const QMap<QString, QVariant>& >(__jni_env, __qtjambi_scope, data1);
        QNetworkReply* __qt_return_value = __qt_this->patch(__qt_request0, __qt_data1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::patch<std::function<void(QRestReply&)>,true>(QNetworkRequest,QByteArray,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_patch_1native_1cref_1QNetworkRequest_1cref_1QByteArray_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJJJLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1,
 QtJambiNativeID context2,
 jobject callback3)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::patch<std::function<void(QRestReply&)>,true>(QNetworkRequest,QByteArray,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QByteArray& __qt_data1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(data1);
        QObject* __qt_context2 = QtJambiAPI::objectFromNativeId<QObject>(context2);
        auto __qt_callback3 = convertConsumer(__jni_env, callback3);
        QNetworkReply* __qt_return_value = __qt_this->patch(__qt_request0, __qt_data1, __qt_context2, std::move(__qt_callback3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::patch<std::function<void(QRestReply&)>,true>(QNetworkRequest,QIODevice*,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_patch_1native_1cref_1QNetworkRequest_1QIODevice_1ptr_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJJJLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1,
 QtJambiNativeID context2,
 jobject callback3)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::patch<std::function<void(QRestReply&)>,true>(QNetworkRequest,QIODevice*,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        QIODevice* __qt_data1 = QtJambiAPI::objectFromNativeId<QIODevice>(data1);
        QObject* __qt_context2 = QtJambiAPI::objectFromNativeId<QObject>(context2);
        auto __qt_callback3 = convertConsumer(__jni_env, callback3);
        QNetworkReply* __qt_return_value = __qt_this->patch(__qt_request0, __qt_data1, __qt_context2, std::move(__qt_callback3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::patch<std::function<void(QRestReply&)>,true>(QNetworkRequest,QJsonDocument,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_patch_1native_1cref_1QNetworkRequest_1cref_1QJsonDocument_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJJJLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1,
 QtJambiNativeID context2,
 jobject callback3)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::patch<std::function<void(QRestReply&)>,true>(QNetworkRequest,QJsonDocument,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QJsonDocument& __qt_data1 = QtJambiAPI::valueReferenceFromNativeId<QJsonDocument>(data1);
        QObject* __qt_context2 = QtJambiAPI::objectFromNativeId<QObject>(context2);
        auto __qt_callback3 = convertConsumer(__jni_env, callback3);
        QNetworkReply* __qt_return_value = __qt_this->patch(__qt_request0, __qt_data1, __qt_context2, std::move(__qt_callback3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::patch<std::function<void(QRestReply&)>,true>(QNetworkRequest,QMap<QString,QVariant>,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_patch_1native_1cref_1QNetworkRequest_1cref_1QMap_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJLjava_util_Map_2JLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 jobject data1,
 QtJambiNativeID context2,
 jobject callback3)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::patch<std::function<void(QRestReply&)>,true>(QNetworkRequest,QMap<QString,QVariant>,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QMap<QString, QVariant>& __qt_data1 = qtjambi_cast<const QMap<QString, QVariant>& >(__jni_env, __qtjambi_scope, data1);
        QObject* __qt_context2 = QtJambiAPI::objectFromNativeId<QObject>(context2);
        auto __qt_callback3 = convertConsumer(__jni_env, callback3);
        QNetworkReply* __qt_return_value = __qt_this->patch(__qt_request0, __qt_data1, __qt_context2, std::move(__qt_callback3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::post(QNetworkRequest,QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_post_1native_1cref_1QNetworkRequest_1cref_1QByteArray__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::post(QNetworkRequest,QByteArray)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QByteArray& __qt_data1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(data1);
        QNetworkReply* __qt_return_value = __qt_this->post(__qt_request0, __qt_data1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::post(QNetworkRequest,QHttpMultiPart*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_post_1native_1cref_1QNetworkRequest_1QHttpMultiPart_1ptr__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::post(QNetworkRequest,QHttpMultiPart*)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        QHttpMultiPart* __qt_data1 = QtJambiAPI::objectFromNativeId<QHttpMultiPart>(data1);
        QNetworkReply* __qt_return_value = __qt_this->post(__qt_request0, __qt_data1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::post(QNetworkRequest,QIODevice*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_post_1native_1cref_1QNetworkRequest_1QIODevice_1ptr__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::post(QNetworkRequest,QIODevice*)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        QIODevice* __qt_data1 = QtJambiAPI::objectFromNativeId<QIODevice>(data1);
        QNetworkReply* __qt_return_value = __qt_this->post(__qt_request0, __qt_data1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::post(QNetworkRequest,QJsonDocument)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_post_1native_1cref_1QNetworkRequest_1cref_1QJsonDocument__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::post(QNetworkRequest,QJsonDocument)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QJsonDocument& __qt_data1 = QtJambiAPI::valueReferenceFromNativeId<QJsonDocument>(data1);
        QNetworkReply* __qt_return_value = __qt_this->post(__qt_request0, __qt_data1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::post(QNetworkRequest,QVariantMap)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_post_1native_1cref_1QNetworkRequest_1cref_1QMap__JJLjava_util_Map_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 jobject data1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::post(QNetworkRequest,QVariantMap)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QMap<QString, QVariant>& __qt_data1 = qtjambi_cast<const QMap<QString, QVariant>& >(__jni_env, __qtjambi_scope, data1);
        QNetworkReply* __qt_return_value = __qt_this->post(__qt_request0, __qt_data1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::post<std::function<void(QRestReply&)>,true>(QNetworkRequest,QByteArray,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_post_1native_1cref_1QNetworkRequest_1cref_1QByteArray_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJJJLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1,
 QtJambiNativeID context2,
 jobject callback3)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::post<std::function<void(QRestReply&)>,true>(QNetworkRequest,QByteArray,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QByteArray& __qt_data1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(data1);
        QObject* __qt_context2 = QtJambiAPI::objectFromNativeId<QObject>(context2);
        auto __qt_callback3 = convertConsumer(__jni_env, callback3);
        QNetworkReply* __qt_return_value = __qt_this->post(__qt_request0, __qt_data1, __qt_context2, std::move(__qt_callback3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::post<std::function<void(QRestReply&)>,true>(QNetworkRequest,QHttpMultiPart*,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_post_1native_1cref_1QNetworkRequest_1QHttpMultiPart_1ptr_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJJJLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1,
 QtJambiNativeID context2,
 jobject callback3)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::post<std::function<void(QRestReply&)>,true>(QNetworkRequest,QHttpMultiPart*,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        QHttpMultiPart* __qt_data1 = QtJambiAPI::objectFromNativeId<QHttpMultiPart>(data1);
        QObject* __qt_context2 = QtJambiAPI::objectFromNativeId<QObject>(context2);
        auto __qt_callback3 = convertConsumer(__jni_env, callback3);
        QNetworkReply* __qt_return_value = __qt_this->post(__qt_request0, __qt_data1, __qt_context2, std::move(__qt_callback3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::post<std::function<void(QRestReply&)>,true>(QNetworkRequest,QIODevice*,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_post_1native_1cref_1QNetworkRequest_1QIODevice_1ptr_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJJJLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1,
 QtJambiNativeID context2,
 jobject callback3)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::post<std::function<void(QRestReply&)>,true>(QNetworkRequest,QIODevice*,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        QIODevice* __qt_data1 = QtJambiAPI::objectFromNativeId<QIODevice>(data1);
        QObject* __qt_context2 = QtJambiAPI::objectFromNativeId<QObject>(context2);
        auto __qt_callback3 = convertConsumer(__jni_env, callback3);
        QNetworkReply* __qt_return_value = __qt_this->post(__qt_request0, __qt_data1, __qt_context2, std::move(__qt_callback3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::post<std::function<void(QRestReply&)>,true>(QNetworkRequest,QJsonDocument,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_post_1native_1cref_1QNetworkRequest_1cref_1QJsonDocument_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJJJLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1,
 QtJambiNativeID context2,
 jobject callback3)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::post<std::function<void(QRestReply&)>,true>(QNetworkRequest,QJsonDocument,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QJsonDocument& __qt_data1 = QtJambiAPI::valueReferenceFromNativeId<QJsonDocument>(data1);
        QObject* __qt_context2 = QtJambiAPI::objectFromNativeId<QObject>(context2);
        auto __qt_callback3 = convertConsumer(__jni_env, callback3);
        QNetworkReply* __qt_return_value = __qt_this->post(__qt_request0, __qt_data1, __qt_context2, std::move(__qt_callback3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::post<std::function<void(QRestReply&)>,true>(QNetworkRequest,QMap<QString,QVariant>,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_post_1native_1cref_1QNetworkRequest_1cref_1QMap_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJLjava_util_Map_2JLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 jobject data1,
 QtJambiNativeID context2,
 jobject callback3)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::post<std::function<void(QRestReply&)>,true>(QNetworkRequest,QMap<QString,QVariant>,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QMap<QString, QVariant>& __qt_data1 = qtjambi_cast<const QMap<QString, QVariant>& >(__jni_env, __qtjambi_scope, data1);
        QObject* __qt_context2 = QtJambiAPI::objectFromNativeId<QObject>(context2);
        auto __qt_callback3 = convertConsumer(__jni_env, callback3);
        QNetworkReply* __qt_return_value = __qt_this->post(__qt_request0, __qt_data1, __qt_context2, std::move(__qt_callback3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::put(QNetworkRequest,QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_put_1native_1cref_1QNetworkRequest_1cref_1QByteArray__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::put(QNetworkRequest,QByteArray)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QByteArray& __qt_data1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(data1);
        QNetworkReply* __qt_return_value = __qt_this->put(__qt_request0, __qt_data1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::put(QNetworkRequest,QHttpMultiPart*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_put_1native_1cref_1QNetworkRequest_1QHttpMultiPart_1ptr__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::put(QNetworkRequest,QHttpMultiPart*)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        QHttpMultiPart* __qt_data1 = QtJambiAPI::objectFromNativeId<QHttpMultiPart>(data1);
        QNetworkReply* __qt_return_value = __qt_this->put(__qt_request0, __qt_data1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::put(QNetworkRequest,QIODevice*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_put_1native_1cref_1QNetworkRequest_1QIODevice_1ptr__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::put(QNetworkRequest,QIODevice*)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        QIODevice* __qt_data1 = QtJambiAPI::objectFromNativeId<QIODevice>(data1);
        QNetworkReply* __qt_return_value = __qt_this->put(__qt_request0, __qt_data1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::put(QNetworkRequest,QJsonDocument)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_put_1native_1cref_1QNetworkRequest_1cref_1QJsonDocument__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::put(QNetworkRequest,QJsonDocument)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QJsonDocument& __qt_data1 = QtJambiAPI::valueReferenceFromNativeId<QJsonDocument>(data1);
        QNetworkReply* __qt_return_value = __qt_this->put(__qt_request0, __qt_data1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::put(QNetworkRequest,QVariantMap)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_put_1native_1cref_1QNetworkRequest_1cref_1QMap__JJLjava_util_Map_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 jobject data1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::put(QNetworkRequest,QVariantMap)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QMap<QString, QVariant>& __qt_data1 = qtjambi_cast<const QMap<QString, QVariant>& >(__jni_env, __qtjambi_scope, data1);
        QNetworkReply* __qt_return_value = __qt_this->put(__qt_request0, __qt_data1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::put<std::function<void(QRestReply&)>,true>(QNetworkRequest,QByteArray,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_put_1native_1cref_1QNetworkRequest_1cref_1QByteArray_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJJJLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1,
 QtJambiNativeID context2,
 jobject callback3)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::put<std::function<void(QRestReply&)>,true>(QNetworkRequest,QByteArray,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QByteArray& __qt_data1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(data1);
        QObject* __qt_context2 = QtJambiAPI::objectFromNativeId<QObject>(context2);
        auto __qt_callback3 = convertConsumer(__jni_env, callback3);
        QNetworkReply* __qt_return_value = __qt_this->put(__qt_request0, __qt_data1, __qt_context2, std::move(__qt_callback3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::put<std::function<void(QRestReply&)>,true>(QNetworkRequest,QHttpMultiPart*,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_put_1native_1cref_1QNetworkRequest_1QHttpMultiPart_1ptr_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJJJLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1,
 QtJambiNativeID context2,
 jobject callback3)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::put<std::function<void(QRestReply&)>,true>(QNetworkRequest,QHttpMultiPart*,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        QHttpMultiPart* __qt_data1 = QtJambiAPI::objectFromNativeId<QHttpMultiPart>(data1);
        QObject* __qt_context2 = QtJambiAPI::objectFromNativeId<QObject>(context2);
        auto __qt_callback3 = convertConsumer(__jni_env, callback3);
        QNetworkReply* __qt_return_value = __qt_this->put(__qt_request0, __qt_data1, __qt_context2, std::move(__qt_callback3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::put<std::function<void(QRestReply&)>,true>(QNetworkRequest,QIODevice*,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_put_1native_1cref_1QNetworkRequest_1QIODevice_1ptr_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJJJLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1,
 QtJambiNativeID context2,
 jobject callback3)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::put<std::function<void(QRestReply&)>,true>(QNetworkRequest,QIODevice*,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        QIODevice* __qt_data1 = QtJambiAPI::objectFromNativeId<QIODevice>(data1);
        QObject* __qt_context2 = QtJambiAPI::objectFromNativeId<QObject>(context2);
        auto __qt_callback3 = convertConsumer(__jni_env, callback3);
        QNetworkReply* __qt_return_value = __qt_this->put(__qt_request0, __qt_data1, __qt_context2, std::move(__qt_callback3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::put<std::function<void(QRestReply&)>,true>(QNetworkRequest,QJsonDocument,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_put_1native_1cref_1QNetworkRequest_1cref_1QJsonDocument_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJJJLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID data1,
 QtJambiNativeID context2,
 jobject callback3)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::put<std::function<void(QRestReply&)>,true>(QNetworkRequest,QJsonDocument,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QJsonDocument& __qt_data1 = QtJambiAPI::valueReferenceFromNativeId<QJsonDocument>(data1);
        QObject* __qt_context2 = QtJambiAPI::objectFromNativeId<QObject>(context2);
        auto __qt_callback3 = convertConsumer(__jni_env, callback3);
        QNetworkReply* __qt_return_value = __qt_this->put(__qt_request0, __qt_data1, __qt_context2, std::move(__qt_callback3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::put<std::function<void(QRestReply&)>,true>(QNetworkRequest,QMap<QString,QVariant>,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_put_1native_1cref_1QNetworkRequest_1cref_1QMap_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJLjava_util_Map_2JLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 jobject data1,
 QtJambiNativeID context2,
 jobject callback3)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::put<std::function<void(QRestReply&)>,true>(QNetworkRequest,QMap<QString,QVariant>,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QMap<QString, QVariant>& __qt_data1 = qtjambi_cast<const QMap<QString, QVariant>& >(__jni_env, __qtjambi_scope, data1);
        QObject* __qt_context2 = QtJambiAPI::objectFromNativeId<QObject>(context2);
        auto __qt_callback3 = convertConsumer(__jni_env, callback3);
        QNetworkReply* __qt_return_value = __qt_this->put(__qt_request0, __qt_data1, __qt_context2, std::move(__qt_callback3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::sendCustomRequest(QNetworkRequest,QByteArray,QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_sendCustomRequest_1native_1cref_1QNetworkRequest_1cref_1QByteArray_1cref_1QByteArray__JJJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID method1,
 QtJambiNativeID data2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::sendCustomRequest(QNetworkRequest,QByteArray,QByteArray)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QByteArray& __qt_method1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(method1);
        const QByteArray& __qt_data2 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(data2);
        QNetworkReply* __qt_return_value = __qt_this->sendCustomRequest(__qt_request0, __qt_method1, __qt_data2);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::sendCustomRequest(QNetworkRequest,QByteArray,QHttpMultiPart*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_sendCustomRequest_1native_1cref_1QNetworkRequest_1cref_1QByteArray_1QHttpMultiPart_1ptr__JJJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID method1,
 QtJambiNativeID data2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::sendCustomRequest(QNetworkRequest,QByteArray,QHttpMultiPart*)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QByteArray& __qt_method1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(method1);
        QHttpMultiPart* __qt_data2 = QtJambiAPI::objectFromNativeId<QHttpMultiPart>(data2);
        QNetworkReply* __qt_return_value = __qt_this->sendCustomRequest(__qt_request0, __qt_method1, __qt_data2);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::sendCustomRequest(QNetworkRequest,QByteArray,QIODevice*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_sendCustomRequest_1native_1cref_1QNetworkRequest_1cref_1QByteArray_1QIODevice_1ptr__JJJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID method1,
 QtJambiNativeID data2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::sendCustomRequest(QNetworkRequest,QByteArray,QIODevice*)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QByteArray& __qt_method1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(method1);
        QIODevice* __qt_data2 = QtJambiAPI::objectFromNativeId<QIODevice>(data2);
        QNetworkReply* __qt_return_value = __qt_this->sendCustomRequest(__qt_request0, __qt_method1, __qt_data2);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::sendCustomRequest<std::function<void(QRestReply&)>,true>(QNetworkRequest,QByteArray,QByteArray,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_sendCustomRequest_1native_1cref_1QNetworkRequest_1cref_1QByteArray_1cref_1QByteArray_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJJJJLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID method1,
 QtJambiNativeID data2,
 QtJambiNativeID context3,
 jobject callback4)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::sendCustomRequest<std::function<void(QRestReply&)>,true>(QNetworkRequest,QByteArray,QByteArray,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QByteArray& __qt_method1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(method1);
        const QByteArray& __qt_data2 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(data2);
        QObject* __qt_context3 = QtJambiAPI::objectFromNativeId<QObject>(context3);
        auto __qt_callback4 = convertConsumer(__jni_env, callback4);
        QNetworkReply* __qt_return_value = __qt_this->sendCustomRequest(__qt_request0, __qt_method1, __qt_data2, __qt_context3, std::move(__qt_callback4));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::sendCustomRequest<std::function<void(QRestReply&)>,true>(QNetworkRequest,QByteArray,QHttpMultiPart*,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_sendCustomRequest_1native_1cref_1QNetworkRequest_1cref_1QByteArray_1QHttpMultiPart_1ptr_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJJJJLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID method1,
 QtJambiNativeID data2,
 QtJambiNativeID context3,
 jobject callback4)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::sendCustomRequest<std::function<void(QRestReply&)>,true>(QNetworkRequest,QByteArray,QHttpMultiPart*,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QByteArray& __qt_method1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(method1);
        QHttpMultiPart* __qt_data2 = QtJambiAPI::objectFromNativeId<QHttpMultiPart>(data2);
        QObject* __qt_context3 = QtJambiAPI::objectFromNativeId<QObject>(context3);
        auto __qt_callback4 = convertConsumer(__jni_env, callback4);
        QNetworkReply* __qt_return_value = __qt_this->sendCustomRequest(__qt_request0, __qt_method1, __qt_data2, __qt_context3, std::move(__qt_callback4));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRestAccessManager::sendCustomRequest<std::function<void(QRestReply&)>,true>(QNetworkRequest,QByteArray,QIODevice*,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QRestAccessManager_sendCustomRequest_1native_1cref_1QNetworkRequest_1cref_1QByteArray_1QIODevice_1ptr_1const_1QRestAccessManager_1ContextTypeForFunctor_1Functor_1_1ptr_1rval_1QRestAccessManager_1Callback__JJJJJLio_qt_network_QRestAccessManager_00024Callback_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID request0,
 QtJambiNativeID method1,
 QtJambiNativeID data2,
 QtJambiNativeID context3,
 jobject callback4)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRestAccessManager *__qt_this = QtJambiAPI::objectFromNativeId<QRestAccessManager>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRestAccessManager::sendCustomRequest<std::function<void(QRestReply&)>,true>(QNetworkRequest,QByteArray,QIODevice*,const QRestAccessManager::ContextTypeForFunctor<Functor>*,std::function<void(QRestReply&)>&&)", __this_nativeId)
        QtJambiAPI::checkThread(__jni_env, __qt_this);
        const QNetworkRequest& __qt_request0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(request0);
        const QByteArray& __qt_method1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(method1);
        QIODevice* __qt_data2 = QtJambiAPI::objectFromNativeId<QIODevice>(data2);
        QObject* __qt_context3 = QtJambiAPI::objectFromNativeId<QObject>(context3);
        auto __qt_callback4 = convertConsumer(__jni_env, callback4);
        QNetworkReply* __qt_return_value = __qt_this->sendCustomRequest(__qt_request0, __qt_method1, __qt_data2, __qt_context3, std::move(__qt_callback4));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnershipForTopLevelObject(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QRestAccessManager(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerQObjectTypeInfo<QRestAccessManager>("QRestAccessManager", "io/qt/network/QRestAccessManager");
// BEGIN: function table
    registerFunctionInfos(typeId, {
        FunctionInfo(/* 0 */ "childEvent", "(Lio/qt/core/QChildEvent;)V"),
        FunctionInfo(/* 1 */ "connectNotify", "(Lio/qt/core/QMetaMethod;)V"),
        FunctionInfo(/* 2 */ "customEvent", "(Lio/qt/core/QEvent;)V"),
        FunctionInfo(/* 3 */ "disconnectNotify", "(Lio/qt/core/QMetaMethod;)V"),
        FunctionInfo(/* 4 */ "event", "(Lio/qt/core/QEvent;)Z"),
        FunctionInfo(/* 5 */ "eventFilter", "(Lio/qt/core/QObject;Lio/qt/core/QEvent;)Z"),
        FunctionInfo(/* 6 */ "timerEvent", "(Lio/qt/core/QTimerEvent;)V")});
    registerConstructorInfos(typeId, 0, &__qt_destruct_QRestAccessManager, {
        ConstructorInfo(&__qt_construct_QRestAccessManager_QNetworkAccessManager_ptr, "Lio/qt/network/QNetworkAccessManager;")
       ,ConstructorInfo(&__qt_construct_QRestAccessManager_QNetworkAccessManager_ptr_QObject_ptr, "Lio/qt/network/QNetworkAccessManager;Lio/qt/core/QObject;")
    });
// END: function table

    registerMetaObject(typeId, QRestAccessManager::staticMetaObject, false);
// END: signal table

// BEGIN: type registration
    registerSizeOfShell(typeId, sizeof(QRestAccessManager_shell));
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
