#include <QtCore/QtGlobal>
#include <QtNetwork/qhostaddress.h>
#include <QtCore/QVariant>
#include <QtCore/qcontainerfwd.h>
#include <QtCore/qdatastream.h>
#include <QtNetwork/qabstractsocket.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QHostAddress(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QHostAddress")
    QHostAddress *_ptr = reinterpret_cast<QHostAddress *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QHostAddress()
void __qt_construct_QHostAddress(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QHostAddress()")
    Q_UNUSED(__java_arguments)
    QHostAddress *__qt_this = new(__qtjambi_ptr) QHostAddress();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QHostAddress::QHostAddress()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_initialize_1native__Lio_qt_network_QHostAddress_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QHostAddress::QHostAddress()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QHostAddress, sizeof(QHostAddress), typeid(QHostAddress), false, &deleter_QHostAddress, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QHostAddress(QHostAddress)
void __qt_construct_QHostAddress_cref_QHostAddress(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QHostAddress(QHostAddress)")
    jobject copy0 = __java_arguments[0].l;
    const QHostAddress& __qt_copy0 = qtjambi_cast<const QHostAddress& >(__jni_env, copy0);
    QHostAddress *__qt_this = new(__qtjambi_ptr) QHostAddress(__qt_copy0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QHostAddress::QHostAddress(QHostAddress)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_initialize_1native__Lio_qt_network_QHostAddress_2Lio_qt_network_QHostAddress_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject copy0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QHostAddress::QHostAddress(QHostAddress)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = copy0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QHostAddress_cref_QHostAddress, sizeof(QHostAddress), typeid(QHostAddress), false, &deleter_QHostAddress, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QHostAddress(QHostAddress::SpecialAddress)
void __qt_construct_QHostAddress_QHostAddress_SpecialAddress(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QHostAddress(QHostAddress::SpecialAddress)")
    jobject address0 = __java_arguments[0].l;
    QHostAddress::SpecialAddress __qt_address0 = qtjambi_cast<QHostAddress::SpecialAddress>(__jni_env, address0);
    QHostAddress *__qt_this = new(__qtjambi_ptr) QHostAddress(QHostAddress::SpecialAddress(__qt_address0));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QHostAddress::QHostAddress(QHostAddress::SpecialAddress)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_initialize_1native__Lio_qt_network_QHostAddress_2Lio_qt_network_QHostAddress_00024SpecialAddress_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject address0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QHostAddress::QHostAddress(QHostAddress::SpecialAddress)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = address0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QHostAddress_QHostAddress_SpecialAddress, sizeof(QHostAddress), typeid(QHostAddress), false, &deleter_QHostAddress, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QHostAddress(Q_IPV6ADDR)
void __qt_construct_QHostAddress_cref_QIPv6Address(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QHostAddress(Q_IPV6ADDR)")
    jobject ip6Addr0 = __java_arguments[0].l;
    const QIPv6Address& __qt_ip6Addr0 = qtjambi_cast<const QIPv6Address& >(__jni_env, ip6Addr0);
    QHostAddress *__qt_this = new(__qtjambi_ptr) QHostAddress(__qt_ip6Addr0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QHostAddress::QHostAddress(Q_IPV6ADDR)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_initialize_1native__Lio_qt_network_QHostAddress_2Lio_qt_network_QIPv6Address_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject ip6Addr0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QHostAddress::QHostAddress(Q_IPV6ADDR)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = ip6Addr0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QHostAddress_cref_QIPv6Address, sizeof(QHostAddress), typeid(QHostAddress), false, &deleter_QHostAddress, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QHostAddress(QString)
void __qt_construct_QHostAddress_cref_QString(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QHostAddress(QString)")
    jstring address0 = static_cast<jstring>(__java_arguments[0].l);
    QString  __qt_address0 = qtjambi_cast<QString>(__jni_env, address0);
    QHostAddress *__qt_this = new(__qtjambi_ptr) QHostAddress(__qt_address0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QHostAddress::QHostAddress(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_initialize_1native__Lio_qt_network_QHostAddress_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jstring address0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QHostAddress::QHostAddress(QString)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = address0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QHostAddress_cref_QString, sizeof(QHostAddress), typeid(QHostAddress), false, &deleter_QHostAddress, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QHostAddress(quint32)
void __qt_construct_QHostAddress_quint32(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QHostAddress(quint32)")
    jint ip4Addr0 = __java_arguments[0].i;
    Q_UNUSED(ip4Addr0)
    QHostAddress *__qt_this = new(__qtjambi_ptr) QHostAddress(static_cast<quint32>(ip4Addr0));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QHostAddress::QHostAddress(quint32)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_initialize_1native__Lio_qt_network_QHostAddress_2I)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jint ip4Addr0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QHostAddress::QHostAddress(quint32)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.i = ip4Addr0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QHostAddress_quint32, sizeof(QHostAddress), typeid(QHostAddress), false, &deleter_QHostAddress, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QHostAddress
void __qt_destruct_QHostAddress(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QHostAddress")
    reinterpret_cast<QHostAddress*>(ptr)->~QHostAddress();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QHostAddress::clear()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_clear_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::clear()", __qt_this)
        __qt_this->clear();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QHostAddress::isBroadcast()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_isBroadcast_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::isBroadcast()const", __qt_this)
        __java_return_value = __qt_this->isBroadcast();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostAddress::isEqual(QHostAddress,QHostAddress::ConversionMode)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_isEqual_1native_1cref_1QHostAddress_1QHostAddress_1ConversionMode_1constfct__JJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID address0,
 jint mode1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::isEqual(QHostAddress,QHostAddress::ConversionMode)const", __qt_this)
        const QHostAddress& __qt_address0 = QtJambiAPI::valueReferenceFromNativeId<QHostAddress>(address0);
        QHostAddress::ConversionMode __qt_mode1 = qtjambi_cast<QHostAddress::ConversionMode>(__jni_env, mode1);
        __java_return_value = __qt_this->isEqual(__qt_address0, QHostAddress::ConversionMode(__qt_mode1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostAddress::isGlobal()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_isGlobal_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::isGlobal()const", __qt_this)
        __java_return_value = __qt_this->isGlobal();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostAddress::isInSubnet(QHostAddress,int)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_isInSubnet_1native_1cref_1QHostAddress_1int_1constfct__JJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID subnet0,
 jint netmask1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::isInSubnet(QHostAddress,int)const", __qt_this)
        const QHostAddress& __qt_subnet0 = QtJambiAPI::valueReferenceFromNativeId<QHostAddress>(subnet0);
        __java_return_value = __qt_this->isInSubnet(__qt_subnet0, static_cast<int>(netmask1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostAddress::isInSubnet(std::pair<QHostAddress,int>)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_isInSubnet_1native_1cref_1QPair_1constfct__JLio_qt_core_QPair_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject subnet0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::isInSubnet(std::pair<QHostAddress,int>)const", __qt_this)
        const QPair<QHostAddress, int>&  __qt_subnet0 = qtjambi_cast<QPair<QHostAddress, int> >(__jni_env, __qtjambi_scope, subnet0);
        __java_return_value = __qt_this->isInSubnet(__qt_subnet0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostAddress::isLinkLocal()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_isLinkLocal_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::isLinkLocal()const", __qt_this)
        __java_return_value = __qt_this->isLinkLocal();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostAddress::isLoopback()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_isLoopback_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::isLoopback()const", __qt_this)
        __java_return_value = __qt_this->isLoopback();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostAddress::isMulticast()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_isMulticast_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::isMulticast()const", __qt_this)
        __java_return_value = __qt_this->isMulticast();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostAddress::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::isNull()const", __qt_this)
        __java_return_value = __qt_this->isNull();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostAddress::isPrivateUse()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_isPrivateUse_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::isPrivateUse()const", __qt_this)
        __java_return_value = __qt_this->isPrivateUse();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostAddress::isSiteLocal()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_isSiteLocal_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::isSiteLocal()const", __qt_this)
        __java_return_value = __qt_this->isSiteLocal();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostAddress::isUniqueLocalUnicast()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_isUniqueLocalUnicast_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::isUniqueLocalUnicast()const", __qt_this)
        __java_return_value = __qt_this->isUniqueLocalUnicast();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostAddress::operator<<(QDataStream&,QHostAddress)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::operator<<(QDataStream&,QHostAddress)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QHostAddress::operator=(QHostAddress)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_assign_1native_1cref_1QHostAddress__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::operator=(QHostAddress)", __qt_this)
        const QHostAddress& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QHostAddress>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QHostAddress::operator=(QHostAddress::SpecialAddress)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_assign_1native_1QHostAddress_1SpecialAddress__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint address0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::operator=(QHostAddress::SpecialAddress)", __qt_this)
        QHostAddress::SpecialAddress __qt_address0 = qtjambi_cast<QHostAddress::SpecialAddress>(__jni_env, address0);
        (*__qt_this) = QHostAddress::SpecialAddress(__qt_address0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QHostAddress::operator==(QHostAddress)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_equals_1native_1cref_1QHostAddress_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID address0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::operator==(QHostAddress)const", __qt_this)
        const QHostAddress& __qt_address0 = QtJambiAPI::valueReferenceFromNativeId<QHostAddress>(address0);
        __java_return_value = (*__qt_this) == __qt_address0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostAddress::operator==(QHostAddress::SpecialAddress)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_equals_1native_1QHostAddress_1SpecialAddress_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint address0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::operator==(QHostAddress::SpecialAddress)const", __qt_this)
        QHostAddress::SpecialAddress __qt_address0 = qtjambi_cast<QHostAddress::SpecialAddress>(__jni_env, address0);
        __java_return_value = (*__qt_this) == QHostAddress::SpecialAddress(__qt_address0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostAddress::operator>>(QDataStream&,QHostAddress&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::operator>>(QDataStream&,QHostAddress&)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QHostAddress::protocol()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_protocol_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::protocol()const", __qt_this)
        QAbstractSocket::NetworkLayerProtocol __qt_return_value = __qt_this->protocol();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostAddress::scopeId()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_scopeId_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::scopeId()const", __qt_this)
        QString __qt_return_value = __qt_this->scopeId();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostAddress::setAddress(QHostAddress::SpecialAddress)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_setAddress_1native_1QHostAddress_1SpecialAddress__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint address0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::setAddress(QHostAddress::SpecialAddress)", __qt_this)
        QHostAddress::SpecialAddress __qt_address0 = qtjambi_cast<QHostAddress::SpecialAddress>(__jni_env, address0);
        __qt_this->setAddress(QHostAddress::SpecialAddress(__qt_address0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QHostAddress::setAddress(Q_IPV6ADDR)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_setAddress_1native_1cref_1QIPv6Address__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID ip6Addr0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::setAddress(Q_IPV6ADDR)", __qt_this)
        const QIPv6Address& __qt_ip6Addr0 = QtJambiAPI::valueReferenceFromNativeId<QIPv6Address>(ip6Addr0);
        __qt_this->setAddress(__qt_ip6Addr0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QHostAddress::setAddress(QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_setAddress_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring address0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::setAddress(QString)", __qt_this)
        QString  __qt_address0 = qtjambi_cast<QString>(__jni_env, address0);
        __java_return_value = __qt_this->setAddress(__qt_address0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostAddress::setAddress(quint32)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_setAddress_1native_1quint32__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint ip4Addr0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::setAddress(quint32)", __qt_this)
        __qt_this->setAddress(static_cast<quint32>(ip4Addr0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QHostAddress::setScopeId(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_setScopeId_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring id0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::setScopeId(QString)", __qt_this)
        QString  __qt_id0 = qtjambi_cast<QString>(__jni_env, id0);
        __qt_this->setScopeId(__qt_id0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QHostAddress::swap(QHostAddress&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_swap_1native_1ref_1QHostAddress__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::swap(QHostAddress&)", __qt_this)
        QHostAddress& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QHostAddress>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QHostAddress::toIPv6Address()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_toIPv6Address_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::toIPv6Address()const", __qt_this)
        QIPv6Address __qt_return_value = __qt_this->toIPv6Address();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostAddress::toString()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_toString_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostAddress::toString()const", __qt_this)
        QString __qt_return_value = __qt_this->toString();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostAddress::parseSubnet(QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_parseSubnet__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring subnet0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QHostAddress::parseSubnet(QString)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_subnet0 = qtjambi_cast<QString>(__jni_env, subnet0);
        QPair<QHostAddress, int> __qt_return_value = QHostAddress::parseSubnet(__qt_subnet0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostAddress_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QHostAddress *__qt_this = QtJambiAPI::objectFromNativeId<QHostAddress>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QHostAddress(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QHostAddress>("QHostAddress", "io/qt/network/QHostAddress");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QHostAddress, {
        ConstructorInfo(&__qt_construct_QHostAddress, nullptr)
       ,ConstructorInfo(&__qt_construct_QHostAddress_cref_QHostAddress, "Lio/qt/network/QHostAddress;")
       ,ConstructorInfo(&__qt_construct_QHostAddress_QHostAddress_SpecialAddress, "Lio/qt/network/QHostAddress$SpecialAddress;")
       ,ConstructorInfo(&__qt_construct_QHostAddress_cref_QIPv6Address, "Lio/qt/network/QIPv6Address;")
       ,ConstructorInfo(&__qt_construct_QHostAddress_cref_QString, "Ljava/lang/String;")
       ,ConstructorInfo(&__qt_construct_QHostAddress_quint32, "I")
    });
// END: function table

    registerMetaObject(typeId, QHostAddress::staticMetaObject, false);
// END: signal table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QHostAddress);
    registerMetaType<QHostAddress>("QHostAddress");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QHostAddress::ConversionModeFlag>("QHostAddress::ConversionModeFlag", "io/qt/network/QHostAddress$ConversionModeFlag", "QHostAddress::ConversionMode", "QFlags<QHostAddress::ConversionModeFlag>", "io/qt/network/QHostAddress$ConversionMode");
    registerEnumTypeInfo<QHostAddress::SpecialAddress>("QHostAddress::SpecialAddress", "io/qt/network/QHostAddress$SpecialAddress");
// END: enums and flags
}
