#include <QtCore/QtGlobal>
#include <QtNetwork/qnetworkinterface.h>
#include <QtCore/QVariant>
#include <QtCore/qdeadlinetimer.h>
#include <QtNetwork/qhostaddress.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiNetwork/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QNetworkAddressEntry(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QNetworkAddressEntry")
    QNetworkAddressEntry *_ptr = reinterpret_cast<QNetworkAddressEntry *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QNetworkAddressEntry()
void __qt_construct_QNetworkAddressEntry(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QNetworkAddressEntry()")
    Q_UNUSED(__java_arguments)
    QNetworkAddressEntry *__qt_this = new(__qtjambi_ptr) QNetworkAddressEntry();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QNetworkAddressEntry::QNetworkAddressEntry()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_initialize_1native__Lio_qt_network_QNetworkAddressEntry_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QNetworkAddressEntry::QNetworkAddressEntry()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QNetworkAddressEntry, sizeof(QNetworkAddressEntry), typeid(QNetworkAddressEntry), false, &deleter_QNetworkAddressEntry, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QNetworkAddressEntry(QNetworkAddressEntry)
void __qt_construct_QNetworkAddressEntry_cref_QNetworkAddressEntry(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QNetworkAddressEntry(QNetworkAddressEntry)")
    jobject other0 = __java_arguments[0].l;
    const QNetworkAddressEntry& __qt_other0 = qtjambi_cast<const QNetworkAddressEntry& >(__jni_env, other0);
    QNetworkAddressEntry *__qt_this = new(__qtjambi_ptr) QNetworkAddressEntry(__qt_other0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QNetworkAddressEntry::QNetworkAddressEntry(QNetworkAddressEntry)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_initialize_1native__Lio_qt_network_QNetworkAddressEntry_2Lio_qt_network_QNetworkAddressEntry_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QNetworkAddressEntry::QNetworkAddressEntry(QNetworkAddressEntry)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QNetworkAddressEntry_cref_QNetworkAddressEntry, sizeof(QNetworkAddressEntry), typeid(QNetworkAddressEntry), false, &deleter_QNetworkAddressEntry, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QNetworkAddressEntry
void __qt_destruct_QNetworkAddressEntry(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QNetworkAddressEntry")
    reinterpret_cast<QNetworkAddressEntry*>(ptr)->~QNetworkAddressEntry();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QNetworkAddressEntry::broadcast()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_broadcast_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkAddressEntry::broadcast()const", __qt_this)
        QHostAddress __qt_return_value = __qt_this->broadcast();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkAddressEntry::clearAddressLifetime()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_clearAddressLifetime_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkAddressEntry::clearAddressLifetime()", __qt_this)
        __qt_this->clearAddressLifetime();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkAddressEntry::dnsEligibility()const
extern "C" Q_DECL_EXPORT jbyte JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_dnsEligibility_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jbyte __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkAddressEntry::dnsEligibility()const", __qt_this)
        QNetworkAddressEntry::DnsEligibilityStatus __qt_return_value = __qt_this->dnsEligibility();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkAddressEntry::ip()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_ip_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkAddressEntry::ip()const", __qt_this)
        QHostAddress __qt_return_value = __qt_this->ip();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkAddressEntry::isLifetimeKnown()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_isLifetimeKnown_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkAddressEntry::isLifetimeKnown()const", __qt_this)
        __java_return_value = __qt_this->isLifetimeKnown();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkAddressEntry::isPermanent()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_isPermanent_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkAddressEntry::isPermanent()const", __qt_this)
        __java_return_value = __qt_this->isPermanent();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkAddressEntry::isTemporary()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_isTemporary_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkAddressEntry::isTemporary()const", __qt_this)
        __java_return_value = __qt_this->isTemporary();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkAddressEntry::netmask()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_netmask_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkAddressEntry::netmask()const", __qt_this)
        QHostAddress __qt_return_value = __qt_this->netmask();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkAddressEntry::operator=(QNetworkAddressEntry)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_assign_1native_1cref_1QNetworkAddressEntry__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkAddressEntry::operator=(QNetworkAddressEntry)", __qt_this)
        const QNetworkAddressEntry& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkAddressEntry>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkAddressEntry::operator==(QNetworkAddressEntry)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_equals_1native_1cref_1QNetworkAddressEntry_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkAddressEntry::operator==(QNetworkAddressEntry)const", __qt_this)
        const QNetworkAddressEntry& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkAddressEntry>(other0);
        __java_return_value = (*__qt_this) == __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkAddressEntry::preferredLifetime()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_preferredLifetime_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkAddressEntry::preferredLifetime()const", __qt_this)
        QDeadlineTimer __qt_return_value = __qt_this->preferredLifetime();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkAddressEntry::prefixLength()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_prefixLength_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkAddressEntry::prefixLength()const", __qt_this)
        __java_return_value = __qt_this->prefixLength();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkAddressEntry::setAddressLifetime(QDeadlineTimer,QDeadlineTimer)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_setAddressLifetime_1native_1QDeadlineTimer_1QDeadlineTimer__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID preferred0,
 QtJambiNativeID validity1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkAddressEntry::setAddressLifetime(QDeadlineTimer,QDeadlineTimer)", __qt_this)
        QDeadlineTimer __qt_preferred0 = QtJambiAPI::valueReferenceFromNativeId<QDeadlineTimer>(preferred0);
        QDeadlineTimer __qt_validity1 = QtJambiAPI::valueReferenceFromNativeId<QDeadlineTimer>(validity1);
        __qt_this->setAddressLifetime(__qt_preferred0, __qt_validity1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkAddressEntry::setBroadcast(QHostAddress)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_setBroadcast_1native_1cref_1QHostAddress__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID newBroadcast0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkAddressEntry::setBroadcast(QHostAddress)", __qt_this)
        const QHostAddress& __qt_newBroadcast0 = QtJambiAPI::valueReferenceFromNativeId<QHostAddress>(newBroadcast0);
        __qt_this->setBroadcast(__qt_newBroadcast0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkAddressEntry::setDnsEligibility(QNetworkAddressEntry::DnsEligibilityStatus)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_setDnsEligibility_1native_1QNetworkAddressEntry_1DnsEligibilityStatus__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte status0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkAddressEntry::setDnsEligibility(QNetworkAddressEntry::DnsEligibilityStatus)", __qt_this)
        QNetworkAddressEntry::DnsEligibilityStatus __qt_status0 = qtjambi_cast<QNetworkAddressEntry::DnsEligibilityStatus>(__jni_env, status0);
        __qt_this->setDnsEligibility(QNetworkAddressEntry::DnsEligibilityStatus(__qt_status0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkAddressEntry::setIp(QHostAddress)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_setIp_1native_1cref_1QHostAddress__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID newIp0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkAddressEntry::setIp(QHostAddress)", __qt_this)
        const QHostAddress& __qt_newIp0 = QtJambiAPI::valueReferenceFromNativeId<QHostAddress>(newIp0);
        __qt_this->setIp(__qt_newIp0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkAddressEntry::setNetmask(QHostAddress)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_setNetmask_1native_1cref_1QHostAddress__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID newNetmask0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkAddressEntry::setNetmask(QHostAddress)", __qt_this)
        const QHostAddress& __qt_newNetmask0 = QtJambiAPI::valueReferenceFromNativeId<QHostAddress>(newNetmask0);
        __qt_this->setNetmask(__qt_newNetmask0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkAddressEntry::setPrefixLength(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_setPrefixLength_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint length0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkAddressEntry::setPrefixLength(int)", __qt_this)
        __qt_this->setPrefixLength(static_cast<int>(length0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkAddressEntry::swap(QNetworkAddressEntry&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_swap_1native_1ref_1QNetworkAddressEntry__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkAddressEntry::swap(QNetworkAddressEntry&)", __qt_this)
        QNetworkAddressEntry& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QNetworkAddressEntry>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkAddressEntry::validityLifetime()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_validityLifetime_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkAddressEntry::validityLifetime()const", __qt_this)
        QDeadlineTimer __qt_return_value = __qt_this->validityLifetime();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkAddressEntry_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QNetworkAddressEntry *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkAddressEntry>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QNetworkAddressEntry(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QNetworkAddressEntry>("QNetworkAddressEntry", "io/qt/network/QNetworkAddressEntry");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QNetworkAddressEntry, {
        ConstructorInfo(&__qt_construct_QNetworkAddressEntry, nullptr)
       ,ConstructorInfo(&__qt_construct_QNetworkAddressEntry_cref_QNetworkAddressEntry, "Lio/qt/network/QNetworkAddressEntry;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QNetworkAddressEntry);
    registerMetaType<QNetworkAddressEntry>("QNetworkAddressEntry");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QNetworkAddressEntry::DnsEligibilityStatus>("QNetworkAddressEntry::DnsEligibilityStatus", "io/qt/network/QNetworkAddressEntry$DnsEligibilityStatus");
// END: enums and flags
}
