#include <QtCore/QtGlobal>
#include <QtNetwork/qnetworkproxy.h>
#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtNetwork/qnetworkrequest.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiNetwork/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QNetworkProxy(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QNetworkProxy")
    QNetworkProxy *_ptr = reinterpret_cast<QNetworkProxy *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QNetworkProxy()
void __qt_construct_QNetworkProxy_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QNetworkProxy()")
    Q_UNUSED(__java_arguments)
    QNetworkProxy *__qt_this = new(__qtjambi_ptr) QNetworkProxy();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QNetworkProxy(QNetworkProxy)
void __qt_construct_QNetworkProxy_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QNetworkProxy(QNetworkProxy)")
    jobject other0 = __java_arguments[0].l;
    const QNetworkProxy& __qt_other0 = qtjambi_cast<const QNetworkProxy& >(__jni_env, other0);
    QNetworkProxy *__qt_this = new(__qtjambi_ptr) QNetworkProxy(__qt_other0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)
void __qt_construct_QNetworkProxy_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)")
    jobject type0 = __java_arguments[0].l;
    QNetworkProxy::ProxyType __qt_type0 = qtjambi_cast<QNetworkProxy::ProxyType>(__jni_env, type0);
    QNetworkProxy *__qt_this = new(__qtjambi_ptr) QNetworkProxy(QNetworkProxy::ProxyType(__qt_type0));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)
void __qt_construct_QNetworkProxy_3(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)")
    jobject type0 = __java_arguments[0].l;
    QNetworkProxy::ProxyType __qt_type0 = qtjambi_cast<QNetworkProxy::ProxyType>(__jni_env, type0);
    jstring hostName1 = static_cast<jstring>(__java_arguments[1].l);
    QString  __qt_hostName1 = qtjambi_cast<QString>(__jni_env, hostName1);
    QNetworkProxy *__qt_this = new(__qtjambi_ptr) QNetworkProxy(QNetworkProxy::ProxyType(__qt_type0), __qt_hostName1);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)
void __qt_construct_QNetworkProxy_4(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)")
    jobject type0 = __java_arguments[0].l;
    QNetworkProxy::ProxyType __qt_type0 = qtjambi_cast<QNetworkProxy::ProxyType>(__jni_env, type0);
    jstring hostName1 = static_cast<jstring>(__java_arguments[1].l);
    QString  __qt_hostName1 = qtjambi_cast<QString>(__jni_env, hostName1);
    jint port2 = __java_arguments[2].i;
    Q_UNUSED(port2)
    QNetworkProxy *__qt_this = new(__qtjambi_ptr) QNetworkProxy(QNetworkProxy::ProxyType(__qt_type0), __qt_hostName1, static_cast<quint16>(port2));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)
void __qt_construct_QNetworkProxy_5(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)")
    jobject type0 = __java_arguments[0].l;
    QNetworkProxy::ProxyType __qt_type0 = qtjambi_cast<QNetworkProxy::ProxyType>(__jni_env, type0);
    jstring hostName1 = static_cast<jstring>(__java_arguments[1].l);
    QString  __qt_hostName1 = qtjambi_cast<QString>(__jni_env, hostName1);
    jint port2 = __java_arguments[2].i;
    Q_UNUSED(port2)
    jstring user3 = static_cast<jstring>(__java_arguments[3].l);
    QString  __qt_user3 = qtjambi_cast<QString>(__jni_env, user3);
    QNetworkProxy *__qt_this = new(__qtjambi_ptr) QNetworkProxy(QNetworkProxy::ProxyType(__qt_type0), __qt_hostName1, static_cast<quint16>(port2), __qt_user3);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)
void __qt_construct_QNetworkProxy_6(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)")
    jobject type0 = __java_arguments[0].l;
    QNetworkProxy::ProxyType __qt_type0 = qtjambi_cast<QNetworkProxy::ProxyType>(__jni_env, type0);
    jstring hostName1 = static_cast<jstring>(__java_arguments[1].l);
    QString  __qt_hostName1 = qtjambi_cast<QString>(__jni_env, hostName1);
    jint port2 = __java_arguments[2].i;
    Q_UNUSED(port2)
    jstring user3 = static_cast<jstring>(__java_arguments[3].l);
    QString  __qt_user3 = qtjambi_cast<QString>(__jni_env, user3);
    jstring password4 = static_cast<jstring>(__java_arguments[4].l);
    QString  __qt_password4 = qtjambi_cast<QString>(__jni_env, password4);
    QNetworkProxy *__qt_this = new(__qtjambi_ptr) QNetworkProxy(QNetworkProxy::ProxyType(__qt_type0), __qt_hostName1, static_cast<quint16>(port2), __qt_user3, __qt_password4);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QNetworkProxy
void __qt_destruct_QNetworkProxy(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QNetworkProxy")
    reinterpret_cast<QNetworkProxy*>(ptr)->~QNetworkProxy();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QNetworkProxy::QNetworkProxy()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_initialize_1native__Lio_qt_network_QNetworkProxy_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QNetworkProxy::QNetworkProxy()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QNetworkProxy_0, sizeof(QNetworkProxy), typeid(QNetworkProxy), false, &deleter_QNetworkProxy, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkProxy::QNetworkProxy(QNetworkProxy)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_initialize_1native__Lio_qt_network_QNetworkProxy_2Lio_qt_network_QNetworkProxy_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QNetworkProxy::QNetworkProxy(QNetworkProxy)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QNetworkProxy_1, sizeof(QNetworkProxy), typeid(QNetworkProxy), false, &deleter_QNetworkProxy, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkProxy::QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_initialize_1native__Lio_qt_network_QNetworkProxy_2Lio_qt_network_QNetworkProxy_00024ProxyType_2Ljava_lang_String_2ILjava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject type0,
 jstring hostName1,
 jint port2,
 jstring user3,
 jstring password4)
{
    QTJAMBI_NATIVE_METHOD_CALL("QNetworkProxy::QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)")
    QTJAMBI_TRY {
        jvalue arguments[5];
        arguments[0].l = type0;
        arguments[1].l = hostName1;
        arguments[2].i = port2;
        arguments[3].l = user3;
        arguments[4].l = password4;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QNetworkProxy_6, sizeof(QNetworkProxy), typeid(QNetworkProxy), false, &deleter_QNetworkProxy, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkProxy::capabilities()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_capabilities_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::capabilities()const", __qt_this)
        QNetworkProxy::Capabilities __qt_return_value = __qt_this->capabilities();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkProxy::hasRawHeader(QByteArray)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_hasRawHeader_1native_1cref_1QByteArray_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID headerName0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::hasRawHeader(QByteArray)const", __qt_this)
        const QByteArray& __qt_headerName0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(headerName0);
        __java_return_value = __qt_this->hasRawHeader(__qt_headerName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkProxy::header(QNetworkRequest::KnownHeaders)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_header_1native_1QNetworkRequest_1KnownHeaders_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint header0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::header(QNetworkRequest::KnownHeaders)const", __qt_this)
        QNetworkRequest::KnownHeaders __qt_header0 = qtjambi_cast<QNetworkRequest::KnownHeaders>(__jni_env, header0);
        QVariant __qt_return_value = __qt_this->header(QNetworkRequest::KnownHeaders(__qt_header0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkProxy::hostName()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_hostName_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::hostName()const", __qt_this)
        QString __qt_return_value = __qt_this->hostName();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkProxy::isCachingProxy()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_isCachingProxy_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::isCachingProxy()const", __qt_this)
        __java_return_value = __qt_this->isCachingProxy();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkProxy::isTransparentProxy()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_isTransparentProxy_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::isTransparentProxy()const", __qt_this)
        __java_return_value = __qt_this->isTransparentProxy();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkProxy::operator=(QNetworkProxy)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_assign_1native_1cref_1QNetworkProxy__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::operator=(QNetworkProxy)", __qt_this)
        const QNetworkProxy& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkProxy>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkProxy::operator==(QNetworkProxy)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_equals_1native_1cref_1QNetworkProxy_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::operator==(QNetworkProxy)const", __qt_this)
        const QNetworkProxy& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkProxy>(other0);
        __java_return_value = (*__qt_this) == __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkProxy::password()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_password_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::password()const", __qt_this)
        QString __qt_return_value = __qt_this->password();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkProxy::port()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_port_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::port()const", __qt_this)
        quint16 __qt_return_value = __qt_this->port();
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkProxy::rawHeader(QByteArray)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_rawHeader_1native_1cref_1QByteArray_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID headerName0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::rawHeader(QByteArray)const", __qt_this)
        const QByteArray& __qt_headerName0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(headerName0);
        QByteArray __qt_return_value = __qt_this->rawHeader(__qt_headerName0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkProxy::rawHeaderList()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_rawHeaderList_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::rawHeaderList()const", __qt_this)
        QList<QByteArray> __qt_return_value = __qt_this->rawHeaderList();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkProxy::setCapabilities(QNetworkProxy::Capabilities)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_setCapabilities_1native_1QNetworkProxy_1Capabilities__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint capab0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::setCapabilities(QNetworkProxy::Capabilities)", __qt_this)
        QNetworkProxy::Capabilities __qt_capab0 = qtjambi_cast<QNetworkProxy::Capabilities>(__jni_env, capab0);
        __qt_this->setCapabilities(QNetworkProxy::Capabilities(__qt_capab0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkProxy::setHeader(QNetworkRequest::KnownHeaders,QVariant)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_setHeader_1native_1QNetworkRequest_1KnownHeaders_1cref_1QVariant__JILjava_lang_Object_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint header0,
 jobject value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::setHeader(QNetworkRequest::KnownHeaders,QVariant)", __qt_this)
        QNetworkRequest::KnownHeaders __qt_header0 = qtjambi_cast<QNetworkRequest::KnownHeaders>(__jni_env, header0);
        QVariant  __qt_value1 = qtjambi_cast<QVariant >(__jni_env, value1);
        __qt_this->setHeader(QNetworkRequest::KnownHeaders(__qt_header0), __qt_value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkProxy::setHostName(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_setHostName_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring hostName0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::setHostName(QString)", __qt_this)
        QString  __qt_hostName0 = qtjambi_cast<QString>(__jni_env, hostName0);
        __qt_this->setHostName(__qt_hostName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkProxy::setPassword(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_setPassword_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring password0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::setPassword(QString)", __qt_this)
        QString  __qt_password0 = qtjambi_cast<QString>(__jni_env, password0);
        __qt_this->setPassword(__qt_password0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkProxy::setPort(quint16)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_setPort_1native_1quint16__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint port0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::setPort(quint16)", __qt_this)
        __qt_this->setPort(static_cast<quint16>(port0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkProxy::setRawHeader(QByteArray,QByteArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_setRawHeader_1native_1cref_1QByteArray_1cref_1QByteArray__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID headerName0,
 QtJambiNativeID value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::setRawHeader(QByteArray,QByteArray)", __qt_this)
        const QByteArray& __qt_headerName0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(headerName0);
        const QByteArray& __qt_value1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(value1);
        __qt_this->setRawHeader(__qt_headerName0, __qt_value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkProxy::setType(QNetworkProxy::ProxyType)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_setType_1native_1QNetworkProxy_1ProxyType__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint type0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::setType(QNetworkProxy::ProxyType)", __qt_this)
        QNetworkProxy::ProxyType __qt_type0 = qtjambi_cast<QNetworkProxy::ProxyType>(__jni_env, type0);
        __qt_this->setType(QNetworkProxy::ProxyType(__qt_type0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkProxy::setUser(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_setUser_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring userName0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::setUser(QString)", __qt_this)
        QString  __qt_userName0 = qtjambi_cast<QString>(__jni_env, userName0);
        __qt_this->setUser(__qt_userName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkProxy::swap(QNetworkProxy&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_swap_1native_1ref_1QNetworkProxy__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::swap(QNetworkProxy&)", __qt_this)
        QNetworkProxy& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QNetworkProxy>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkProxy::type()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_type_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::type()const", __qt_this)
        QNetworkProxy::ProxyType __qt_return_value = __qt_this->type();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkProxy::user()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_user_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkProxy::user()const", __qt_this)
        QString __qt_return_value = __qt_this->user();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkProxy::applicationProxy()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_applicationProxy__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QNetworkProxy::applicationProxy()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QNetworkProxy __qt_return_value = QNetworkProxy::applicationProxy();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkProxy::setApplicationProxy(QNetworkProxy)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_setApplicationProxy_1native_1cref_1QNetworkProxy__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID proxy0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QNetworkProxy::setApplicationProxy(QNetworkProxy)")
    QTJAMBI_TRY {
        const QNetworkProxy& __qt_proxy0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkProxy>(proxy0);
        QNetworkProxy::setApplicationProxy(__qt_proxy0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkProxy_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QNetworkProxy *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkProxy>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QNetworkProxy(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QNetworkProxy>("QNetworkProxy", "io/qt/network/QNetworkProxy");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QNetworkProxy, {
        ConstructorInfo(&__qt_construct_QNetworkProxy_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QNetworkProxy_1, "Lio/qt/network/QNetworkProxy;")
       ,ConstructorInfo(&__qt_construct_QNetworkProxy_2, "Lio/qt/network/QNetworkProxy$ProxyType;")
       ,ConstructorInfo(&__qt_construct_QNetworkProxy_3, "Lio/qt/network/QNetworkProxy$ProxyType;Ljava/lang/String;")
       ,ConstructorInfo(&__qt_construct_QNetworkProxy_4, "Lio/qt/network/QNetworkProxy$ProxyType;Ljava/lang/String;I")
       ,ConstructorInfo(&__qt_construct_QNetworkProxy_5, "Lio/qt/network/QNetworkProxy$ProxyType;Ljava/lang/String;ILjava/lang/String;")
       ,ConstructorInfo(&__qt_construct_QNetworkProxy_6, "Lio/qt/network/QNetworkProxy$ProxyType;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QNetworkProxy);
    registerMetaType<QNetworkProxy>("QNetworkProxy");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QNetworkProxy::Capability>("QNetworkProxy::Capability", "io/qt/network/QNetworkProxy$Capability", "QNetworkProxy::Capabilities", "QFlags<QNetworkProxy::Capability>", "io/qt/network/QNetworkProxy$Capabilities");
    registerEnumTypeInfo<QNetworkProxy::ProxyType>("QNetworkProxy::ProxyType", "io/qt/network/QNetworkProxy$ProxyType");
// END: enums and flags
}
