#include <QtCore/QtGlobal>
#include <QtNetwork/qnetworkrequest.h>
#include <QtCore/QVariant>
#include <QtCore/qurl.h>
#include <QtCore/qbytearray.h>
#include <QtCore/QList>
#include <QtNetwork/qsslconfiguration.h>
#include <QtCore/qobject.h>
#include <qtnetwork-config.h>
#if QT_CONFIG(http)
#include <QtNetwork/qhttp1configuration.h>
#endif //QT_CONFIG(http)
#if QT_CONFIG(http)
#include <QtNetwork/qhttp2configuration.h>
#endif //QT_CONFIG(http)

#include <QtJambi/QtJambiAPI>
#include <QtJambiNetwork/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QNetworkRequest(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QNetworkRequest")
    QNetworkRequest *_ptr = reinterpret_cast<QNetworkRequest *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QNetworkRequest()
void __qt_construct_QNetworkRequest_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QNetworkRequest()")
    Q_UNUSED(__java_arguments)
    QNetworkRequest *__qt_this = new(__qtjambi_ptr) QNetworkRequest();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QNetworkRequest(QNetworkRequest)
void __qt_construct_QNetworkRequest_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QNetworkRequest(QNetworkRequest)")
    jobject other0 = __java_arguments[0].l;
    const QNetworkRequest& __qt_other0 = qtjambi_cast<const QNetworkRequest& >(__jni_env, other0);
    QNetworkRequest *__qt_this = new(__qtjambi_ptr) QNetworkRequest(__qt_other0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QNetworkRequest(QUrl)
void __qt_construct_QNetworkRequest_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QNetworkRequest(QUrl)")
    jobject url0 = __java_arguments[0].l;
    const QUrl& __qt_url0 = qtjambi_cast<const QUrl& >(__jni_env, url0);
    QNetworkRequest *__qt_this = new(__qtjambi_ptr) QNetworkRequest(__qt_url0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QNetworkRequest
void __qt_destruct_QNetworkRequest(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QNetworkRequest")
    reinterpret_cast<QNetworkRequest*>(ptr)->~QNetworkRequest();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QNetworkRequest::QNetworkRequest()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_initialize_1native__Lio_qt_network_QNetworkRequest_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QNetworkRequest::QNetworkRequest()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QNetworkRequest_0, sizeof(QNetworkRequest), typeid(QNetworkRequest), false, &deleter_QNetworkRequest, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkRequest::QNetworkRequest(QNetworkRequest)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_initialize_1native__Lio_qt_network_QNetworkRequest_2Lio_qt_network_QNetworkRequest_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QNetworkRequest::QNetworkRequest(QNetworkRequest)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QNetworkRequest_1, sizeof(QNetworkRequest), typeid(QNetworkRequest), false, &deleter_QNetworkRequest, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkRequest::QNetworkRequest(QUrl)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_initialize_1native__Lio_qt_network_QNetworkRequest_2Lio_qt_core_QUrl_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject url0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QNetworkRequest::QNetworkRequest(QUrl)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = url0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QNetworkRequest_2, sizeof(QNetworkRequest), typeid(QNetworkRequest), false, &deleter_QNetworkRequest, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkRequest::attribute(QNetworkRequest::Attribute,QVariant)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_attribute_1native_1QNetworkRequest_1Attribute_1cref_1QVariant_1constfct__JILjava_lang_Object_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint code0,
 jobject defaultValue1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::attribute(QNetworkRequest::Attribute,QVariant)const", __qt_this)
        QNetworkRequest::Attribute __qt_code0 = qtjambi_cast<QNetworkRequest::Attribute>(__jni_env, code0);
        QVariant  __qt_defaultValue1 = qtjambi_cast<QVariant >(__jni_env, defaultValue1);
        QVariant __qt_return_value = __qt_this->attribute(QNetworkRequest::Attribute(__qt_code0), __qt_defaultValue1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkRequest::decompressedSafetyCheckThreshold()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_decompressedSafetyCheckThreshold_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::decompressedSafetyCheckThreshold()const", __qt_this)
        qint64 __qt_return_value = __qt_this->decompressedSafetyCheckThreshold();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkRequest::hasRawHeader(QByteArray)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_hasRawHeader_1native_1cref_1QByteArray_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID headerName0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::hasRawHeader(QByteArray)const", __qt_this)
        const QByteArray& __qt_headerName0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(headerName0);
        __java_return_value = __qt_this->hasRawHeader(__qt_headerName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkRequest::header(QNetworkRequest::KnownHeaders)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_header_1native_1QNetworkRequest_1KnownHeaders_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint header0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::header(QNetworkRequest::KnownHeaders)const", __qt_this)
        QNetworkRequest::KnownHeaders __qt_header0 = qtjambi_cast<QNetworkRequest::KnownHeaders>(__jni_env, header0);
        QVariant __qt_return_value = __qt_this->header(QNetworkRequest::KnownHeaders(__qt_header0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkRequest::http1Configuration()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_http1Configuration_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::http1Configuration()const", __qt_this)
        QHttp1Configuration __qt_return_value = __qt_this->http1Configuration();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkRequest::http2Configuration()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_http2Configuration_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::http2Configuration()const", __qt_this)
        QHttp2Configuration __qt_return_value = __qt_this->http2Configuration();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkRequest::maximumRedirectsAllowed()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_maximumRedirectsAllowed_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::maximumRedirectsAllowed()const", __qt_this)
        __java_return_value = __qt_this->maximumRedirectsAllowed();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkRequest::operator=(QNetworkRequest)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_assign_1native_1cref_1QNetworkRequest__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::operator=(QNetworkRequest)", __qt_this)
        const QNetworkRequest& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkRequest::operator==(QNetworkRequest)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_operator_1equal_1native_1cref_1QNetworkRequest_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::operator==(QNetworkRequest)const", __qt_this)
        const QNetworkRequest& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkRequest>(other0);
        __java_return_value = (*__qt_this) == __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkRequest::originatingObject()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_originatingObject_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::originatingObject()const", __qt_this)
        QObject* __qt_return_value = __qt_this->originatingObject();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkRequest::peerVerifyName()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_peerVerifyName_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::peerVerifyName()const", __qt_this)
        QString __qt_return_value = __qt_this->peerVerifyName();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkRequest::priority()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_priority_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::priority()const", __qt_this)
        QNetworkRequest::Priority __qt_return_value = __qt_this->priority();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkRequest::rawHeader(QByteArray)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_rawHeader_1native_1cref_1QByteArray_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID headerName0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::rawHeader(QByteArray)const", __qt_this)
        const QByteArray& __qt_headerName0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(headerName0);
        QByteArray __qt_return_value = __qt_this->rawHeader(__qt_headerName0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkRequest::rawHeaderList()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_rawHeaderList_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::rawHeaderList()const", __qt_this)
        QList<QByteArray> __qt_return_value = __qt_this->rawHeaderList();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkRequest::setAttribute(QNetworkRequest::Attribute,QVariant)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_setAttribute_1native_1QNetworkRequest_1Attribute_1cref_1QVariant__JILjava_lang_Object_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint code0,
 jobject value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::setAttribute(QNetworkRequest::Attribute,QVariant)", __qt_this)
        QNetworkRequest::Attribute __qt_code0 = qtjambi_cast<QNetworkRequest::Attribute>(__jni_env, code0);
        QVariant  __qt_value1 = qtjambi_cast<QVariant >(__jni_env, value1);
        __qt_this->setAttribute(QNetworkRequest::Attribute(__qt_code0), __qt_value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkRequest::setDecompressedSafetyCheckThreshold(qint64)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_setDecompressedSafetyCheckThreshold_1native_1qint64__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong threshold0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::setDecompressedSafetyCheckThreshold(qint64)", __qt_this)
        __qt_this->setDecompressedSafetyCheckThreshold(static_cast<qint64>(threshold0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkRequest::setHeader(QNetworkRequest::KnownHeaders,QVariant)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_setHeader_1native_1QNetworkRequest_1KnownHeaders_1cref_1QVariant__JILjava_lang_Object_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint header0,
 jobject value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::setHeader(QNetworkRequest::KnownHeaders,QVariant)", __qt_this)
        QNetworkRequest::KnownHeaders __qt_header0 = qtjambi_cast<QNetworkRequest::KnownHeaders>(__jni_env, header0);
        QVariant  __qt_value1 = qtjambi_cast<QVariant >(__jni_env, value1);
        __qt_this->setHeader(QNetworkRequest::KnownHeaders(__qt_header0), __qt_value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkRequest::setHttp1Configuration(QHttp1Configuration)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_setHttp1Configuration_1native_1cref_1QHttp1Configuration__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID configuration0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::setHttp1Configuration(QHttp1Configuration)", __qt_this)
        const QHttp1Configuration& __qt_configuration0 = QtJambiAPI::valueReferenceFromNativeId<QHttp1Configuration>(configuration0);
        __qt_this->setHttp1Configuration(__qt_configuration0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkRequest::setHttp2Configuration(QHttp2Configuration)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_setHttp2Configuration_1native_1cref_1QHttp2Configuration__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID configuration0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::setHttp2Configuration(QHttp2Configuration)", __qt_this)
        const QHttp2Configuration& __qt_configuration0 = QtJambiAPI::valueReferenceFromNativeId<QHttp2Configuration>(configuration0);
        __qt_this->setHttp2Configuration(__qt_configuration0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkRequest::setMaximumRedirectsAllowed(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_setMaximumRedirectsAllowed_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint maximumRedirectsAllowed0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::setMaximumRedirectsAllowed(int)", __qt_this)
        __qt_this->setMaximumRedirectsAllowed(static_cast<int>(maximumRedirectsAllowed0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkRequest::setOriginatingObject(QObject*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_setOriginatingObject_1native_1QObject_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID object0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::setOriginatingObject(QObject*)", __qt_this)
        QObject* __qt_object0 = QtJambiAPI::objectFromNativeId<QObject>(object0);
        __qt_this->setOriginatingObject(__qt_object0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkRequest::setPeerVerifyName(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_setPeerVerifyName_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring peerName0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::setPeerVerifyName(QString)", __qt_this)
        QString  __qt_peerName0 = qtjambi_cast<QString >(__jni_env, peerName0);
        __qt_this->setPeerVerifyName(__qt_peerName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkRequest::setPriority(QNetworkRequest::Priority)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_setPriority_1native_1QNetworkRequest_1Priority__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint priority0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::setPriority(QNetworkRequest::Priority)", __qt_this)
        QNetworkRequest::Priority __qt_priority0 = qtjambi_cast<QNetworkRequest::Priority>(__jni_env, priority0);
        __qt_this->setPriority(QNetworkRequest::Priority(__qt_priority0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkRequest::setRawHeader(QByteArray,QByteArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_setRawHeader_1native_1cref_1QByteArray_1cref_1QByteArray__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID headerName0,
 QtJambiNativeID value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::setRawHeader(QByteArray,QByteArray)", __qt_this)
        const QByteArray& __qt_headerName0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(headerName0);
        const QByteArray& __qt_value1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(value1);
        __qt_this->setRawHeader(__qt_headerName0, __qt_value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkRequest::setSslConfiguration(QSslConfiguration)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_setSslConfiguration_1native_1cref_1QSslConfiguration__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID configuration0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::setSslConfiguration(QSslConfiguration)", __qt_this)
        const QSslConfiguration& __qt_configuration0 = QtJambiAPI::valueReferenceFromNativeId<QSslConfiguration>(configuration0);
        __qt_this->setSslConfiguration(__qt_configuration0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkRequest::setTransferTimeout(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_setTransferTimeout_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint timeout0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::setTransferTimeout(int)", __qt_this)
        __qt_this->setTransferTimeout(static_cast<int>(timeout0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkRequest::setUrl(QUrl)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_setUrl_1native_1cref_1QUrl__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID url0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::setUrl(QUrl)", __qt_this)
        const QUrl& __qt_url0 = QtJambiAPI::valueReferenceFromNativeId<QUrl>(url0);
        __qt_this->setUrl(__qt_url0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkRequest::sslConfiguration()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_sslConfiguration_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::sslConfiguration()const", __qt_this)
        QSslConfiguration __qt_return_value = __qt_this->sslConfiguration();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkRequest::swap(QNetworkRequest&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_swap_1native_1ref_1QNetworkRequest__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::swap(QNetworkRequest&)", __qt_this)
        QNetworkRequest& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QNetworkRequest>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkRequest::transferTimeout()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_transferTimeout_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::transferTimeout()const", __qt_this)
        __java_return_value = __qt_this->transferTimeout();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkRequest::url()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_url_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkRequest::url()const", __qt_this)
        QUrl __qt_return_value = __qt_this->url();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkRequest_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QNetworkRequest *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QNetworkRequest(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QNetworkRequest>("QNetworkRequest", "io/qt/network/QNetworkRequest");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QNetworkRequest, {
        ConstructorInfo(&__qt_construct_QNetworkRequest_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QNetworkRequest_1, "Lio/qt/network/QNetworkRequest;")
       ,ConstructorInfo(&__qt_construct_QNetworkRequest_2, "Lio/qt/core/QUrl;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QNetworkRequest);
    registerMetaType<QNetworkRequest>("QNetworkRequest");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QNetworkRequest::Attribute>("QNetworkRequest::Attribute", "io/qt/network/QNetworkRequest$Attribute");
    registerEnumTypeInfo<QNetworkRequest::CacheLoadControl>("QNetworkRequest::CacheLoadControl", "io/qt/network/QNetworkRequest$CacheLoadControl");
    registerEnumTypeInfo<QNetworkRequest::KnownHeaders>("QNetworkRequest::KnownHeaders", "io/qt/network/QNetworkRequest$KnownHeaders");
    registerEnumTypeInfo<QNetworkRequest::LoadControl>("QNetworkRequest::LoadControl", "io/qt/network/QNetworkRequest$LoadControl");
    registerEnumTypeInfo<QNetworkRequest::Priority>("QNetworkRequest::Priority", "io/qt/network/QNetworkRequest$Priority");
    registerEnumTypeInfo<QNetworkRequest::RedirectPolicy>("QNetworkRequest::RedirectPolicy", "io/qt/network/QNetworkRequest$RedirectPolicy");
    registerEnumTypeInfo<QNetworkRequest::TransferTimeoutConstant>("QNetworkRequest::TransferTimeoutConstant", "io/qt/network/QNetworkRequest$TransferTimeoutConstant");
// END: enums and flags
}
