#include <QtCore/QtGlobal>
#if __has_include(<QtNetwork/qsslconfiguration.h>)
#include <QtNetwork/qsslconfiguration.h>
#endif
#include <QtCore/QList>
#include <QtCore/QMap>
#include <QtCore/QVariant>
#include <QtCore/QVector>
#include <QtCore/qbytearray.h>
#include <QtNetwork/qssl.h>
#if __has_include(<QtNetwork/qsslcertificate.h>)
#include <QtNetwork/qsslcertificate.h>
#endif
#if __has_include(<QtNetwork/qsslcipher.h>)
#include <QtNetwork/qsslcipher.h>
#endif
#if __has_include(<QtNetwork/qssldiffiehellmanparameters.h>)
#include <QtNetwork/qssldiffiehellmanparameters.h>
#endif
#if __has_include(<QtNetwork/qsslellipticcurve.h>)
#include <QtNetwork/qsslellipticcurve.h>
#endif
#if __has_include(<QtNetwork/qsslkey.h>)
#include <QtNetwork/qsslkey.h>
#endif
#include <QtNetwork/qsslsocket.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiNetwork/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

#if !defined(QT_NO_SSL)


void deleter_QSslConfiguration(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QSslConfiguration")
    QSslConfiguration *_ptr = reinterpret_cast<QSslConfiguration *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}


#endif // !defined(QT_NO_SSL)

// emitting (writeConstructors)
// new QSslConfiguration()
void __qt_construct_QSslConfiguration_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSslConfiguration()")
#if !defined(QT_NO_SSL)
    Q_UNUSED(__java_arguments)
    QSslConfiguration *__qt_this = new(__qtjambi_ptr) QSslConfiguration();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
}

// new QSslConfiguration(QSslConfiguration)
void __qt_construct_QSslConfiguration_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSslConfiguration(QSslConfiguration)")
#if !defined(QT_NO_SSL)
    jobject other0 = __java_arguments[0].l;
    const QSslConfiguration& __qt_other0 = qtjambi_cast<const QSslConfiguration& >(__jni_env, other0);
    QSslConfiguration *__qt_this = new(__qtjambi_ptr) QSslConfiguration(__qt_other0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
}

// destruct QSslConfiguration
void __qt_destruct_QSslConfiguration(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QSslConfiguration")

#if !defined(QT_NO_SSL)

    reinterpret_cast<QSslConfiguration*>(ptr)->~QSslConfiguration();

#else
    Q_UNUSED(ptr)

#endif // !defined(QT_NO_SSL)

}

// emitting  (functionsInTargetLang writeFinalFunction)
// QSslConfiguration::QSslConfiguration()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_initialize_1native__Lio_qt_network_QSslConfiguration_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSslConfiguration::QSslConfiguration()")
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QSslConfiguration_0, sizeof(QSslConfiguration), typeid(QSslConfiguration), false, &deleter_QSslConfiguration, nullptr);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::QSslConfiguration(QSslConfiguration)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_initialize_1native__Lio_qt_network_QSslConfiguration_2Lio_qt_network_QSslConfiguration_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSslConfiguration::QSslConfiguration(QSslConfiguration)")
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QSslConfiguration_1, sizeof(QSslConfiguration), typeid(QSslConfiguration), false, &deleter_QSslConfiguration, &arguments);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        Q_UNUSED(other0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::addCaCertificate(QSslCertificate)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_addCaCertificate_1native_1cref_1QSslCertificate__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID certificate0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::addCaCertificate(QSslCertificate)", __qt_this)
        const QSslCertificate& __qt_certificate0 = QtJambiAPI::valueReferenceFromNativeId<QSslCertificate>(certificate0);
        __qt_this->addCaCertificate(__qt_certificate0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(certificate0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::addCaCertificates(QList<QSslCertificate>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_addCaCertificates_1native_1cref_1QList__JLjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject certificates0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__qtjambi_scope)
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::addCaCertificates(QList<QSslCertificate>)", __qt_this)
        const QList<QSslCertificate>&  __qt_certificates0 = qtjambi_cast<const QList<QSslCertificate>& >(__jni_env, __qtjambi_scope, certificates0);
        __qt_this->addCaCertificates(__qt_certificates0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(certificates0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::addCaCertificates(QString,QSsl::EncodingFormat,QSslCertificate::PatternSyntax)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_addCaCertificates_1native_1cref_1QString_1QSsl_1EncodingFormat_1QSslCertificate_1PatternSyntax__JLjava_lang_String_2II)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring path0,
 jint format1,
 jint syntax2)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::addCaCertificates(QString,QSsl::EncodingFormat,QSslCertificate::PatternSyntax)", __qt_this)
        QString  __qt_path0 = qtjambi_cast<QString>(__jni_env, path0);
        QSsl::EncodingFormat __qt_format1 = qtjambi_cast<QSsl::EncodingFormat>(__jni_env, format1);
        QSslCertificate::PatternSyntax __qt_syntax2 = qtjambi_cast<QSslCertificate::PatternSyntax>(__jni_env, syntax2);
        __java_return_value = __qt_this->addCaCertificates(__qt_path0, QSsl::EncodingFormat(__qt_format1), QSslCertificate::PatternSyntax(__qt_syntax2));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(path0)
        Q_UNUSED(format1)
        Q_UNUSED(syntax2)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::allowedNextProtocols()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_allowedNextProtocols_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::allowedNextProtocols()const", __qt_this)
        QList<QByteArray> __qt_return_value = __qt_this->allowedNextProtocols();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::backendConfiguration()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_backendConfiguration_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::backendConfiguration()const", __qt_this)
        QMap<QByteArray, QVariant> __qt_return_value = __qt_this->backendConfiguration();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::caCertificates()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_caCertificates_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::caCertificates()const", __qt_this)
        QList<QSslCertificate> __qt_return_value = __qt_this->caCertificates();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::ciphers()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_ciphers_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::ciphers()const", __qt_this)
        QList<QSslCipher> __qt_return_value = __qt_this->ciphers();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::diffieHellmanParameters()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_diffieHellmanParameters_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::diffieHellmanParameters()const", __qt_this)
        QSslDiffieHellmanParameters __qt_return_value = __qt_this->diffieHellmanParameters();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::dtlsCookieVerificationEnabled()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_dtlsCookieVerificationEnabled_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(dtls) && !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::dtlsCookieVerificationEnabled()const", __qt_this)
        __java_return_value = __qt_this->dtlsCookieVerificationEnabled();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(dtls) && !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::ellipticCurves()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_ellipticCurves_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::ellipticCurves()const", __qt_this)
        QVector<QSslEllipticCurve> __qt_return_value = __qt_this->ellipticCurves();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::ephemeralServerKey()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_ephemeralServerKey_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::ephemeralServerKey()const", __qt_this)
        QSslKey __qt_return_value = __qt_this->ephemeralServerKey();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::isNull()const", __qt_this)
        __java_return_value = __qt_this->isNull();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::localCertificate()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_localCertificate_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::localCertificate()const", __qt_this)
        QSslCertificate __qt_return_value = __qt_this->localCertificate();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::localCertificateChain()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_localCertificateChain_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::localCertificateChain()const", __qt_this)
        QList<QSslCertificate> __qt_return_value = __qt_this->localCertificateChain();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::nextNegotiatedProtocol()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_nextNegotiatedProtocol_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::nextNegotiatedProtocol()const", __qt_this)
        QByteArray __qt_return_value = __qt_this->nextNegotiatedProtocol();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::nextProtocolNegotiationStatus()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_nextProtocolNegotiationStatus_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::nextProtocolNegotiationStatus()const", __qt_this)
        QSslConfiguration::NextProtocolNegotiationStatus __qt_return_value = __qt_this->nextProtocolNegotiationStatus();
        __java_return_value = __qt_return_value;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::ocspStaplingEnabled()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_ocspStaplingEnabled_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::ocspStaplingEnabled()const", __qt_this)
        __java_return_value = __qt_this->ocspStaplingEnabled();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::operator=(QSslConfiguration)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_assign_1native_1cref_1QSslConfiguration__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::operator=(QSslConfiguration)", __qt_this)
        const QSslConfiguration& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QSslConfiguration>(other0);
        (*__qt_this) = __qt_other0;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(other0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::operator==(QSslConfiguration)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_equals_1native_1cref_1QSslConfiguration_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::operator==(QSslConfiguration)const", __qt_this)
        const QSslConfiguration& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QSslConfiguration>(other0);
        __java_return_value = (*__qt_this) == __qt_other0;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(other0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::peerCertificate()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_peerCertificate_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::peerCertificate()const", __qt_this)
        QSslCertificate __qt_return_value = __qt_this->peerCertificate();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::peerCertificateChain()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_peerCertificateChain_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::peerCertificateChain()const", __qt_this)
        QList<QSslCertificate> __qt_return_value = __qt_this->peerCertificateChain();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::peerVerifyDepth()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_peerVerifyDepth_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::peerVerifyDepth()const", __qt_this)
        __java_return_value = __qt_this->peerVerifyDepth();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::peerVerifyMode()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_peerVerifyMode_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::peerVerifyMode()const", __qt_this)
        QSslSocket::PeerVerifyMode __qt_return_value = __qt_this->peerVerifyMode();
        __java_return_value = __qt_return_value;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::preSharedKeyIdentityHint()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_preSharedKeyIdentityHint_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::preSharedKeyIdentityHint()const", __qt_this)
        QByteArray __qt_return_value = __qt_this->preSharedKeyIdentityHint();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::privateKey()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_privateKey_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::privateKey()const", __qt_this)
        QSslKey __qt_return_value = __qt_this->privateKey();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::protocol()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_protocol_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::protocol()const", __qt_this)
        QSsl::SslProtocol __qt_return_value = __qt_this->protocol();
        __java_return_value = __qt_return_value;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::sessionCipher()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_sessionCipher_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::sessionCipher()const", __qt_this)
        QSslCipher __qt_return_value = __qt_this->sessionCipher();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::sessionProtocol()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_sessionProtocol_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::sessionProtocol()const", __qt_this)
        QSsl::SslProtocol __qt_return_value = __qt_this->sessionProtocol();
        __java_return_value = __qt_return_value;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::sessionTicket()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_sessionTicket_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::sessionTicket()const", __qt_this)
        QByteArray __qt_return_value = __qt_this->sessionTicket();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::sessionTicketLifeTimeHint()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_sessionTicketLifeTimeHint_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::sessionTicketLifeTimeHint()const", __qt_this)
        __java_return_value = __qt_this->sessionTicketLifeTimeHint();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::setAllowedNextProtocols(QList<QByteArray>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_setAllowedNextProtocols_1native_1QList__JLjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject protocols0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__qtjambi_scope)
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::setAllowedNextProtocols(QList<QByteArray>)", __qt_this)
        QList<QByteArray>  __qt_protocols0 = qtjambi_cast<QList<QByteArray> >(__jni_env, __qtjambi_scope, protocols0);
        __qt_this->setAllowedNextProtocols(__qt_protocols0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(protocols0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::setBackendConfiguration(QMap<QByteArray,QVariant>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_setBackendConfiguration_1native_1cref_1QMap__JLjava_util_Map_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject backendConfiguration0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__qtjambi_scope)
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::setBackendConfiguration(QMap<QByteArray,QVariant>)", __qt_this)
        const QMap<QByteArray, QVariant>&  __qt_backendConfiguration0 = qtjambi_cast<const QMap<QByteArray, QVariant>& >(__jni_env, __qtjambi_scope, backendConfiguration0);
        __qt_this->setBackendConfiguration(__qt_backendConfiguration0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(backendConfiguration0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::setBackendConfigurationOption(QByteArray,QVariant)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_setBackendConfigurationOption_1native_1cref_1QByteArray_1cref_1QVariant__JJLjava_lang_Object_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID name0,
 jobject value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::setBackendConfigurationOption(QByteArray,QVariant)", __qt_this)
        const QByteArray& __qt_name0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(name0);
        QVariant  __qt_value1 = qtjambi_cast<QVariant >(__jni_env, value1);
        __qt_this->setBackendConfigurationOption(__qt_name0, __qt_value1);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(name0)
        Q_UNUSED(value1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::setCaCertificates(QList<QSslCertificate>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_setCaCertificates_1native_1cref_1QList__JLjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject certificates0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__qtjambi_scope)
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::setCaCertificates(QList<QSslCertificate>)", __qt_this)
        const QList<QSslCertificate>&  __qt_certificates0 = qtjambi_cast<const QList<QSslCertificate>& >(__jni_env, __qtjambi_scope, certificates0);
        __qt_this->setCaCertificates(__qt_certificates0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(certificates0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::setCiphers(QList<QSslCipher>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_setCiphers_1native_1cref_1QList__JLjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject ciphers0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__qtjambi_scope)
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::setCiphers(QList<QSslCipher>)", __qt_this)
        const QList<QSslCipher>&  __qt_ciphers0 = qtjambi_cast<const QList<QSslCipher>& >(__jni_env, __qtjambi_scope, ciphers0);
        __qt_this->setCiphers(__qt_ciphers0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(ciphers0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::setDiffieHellmanParameters(QSslDiffieHellmanParameters)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_setDiffieHellmanParameters_1native_1cref_1QSslDiffieHellmanParameters__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID dhparams0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::setDiffieHellmanParameters(QSslDiffieHellmanParameters)", __qt_this)
        const QSslDiffieHellmanParameters& __qt_dhparams0 = QtJambiAPI::valueReferenceFromNativeId<QSslDiffieHellmanParameters>(dhparams0);
        __qt_this->setDiffieHellmanParameters(__qt_dhparams0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(dhparams0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::setDtlsCookieVerificationEnabled(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_setDtlsCookieVerificationEnabled_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean enable0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(dtls) && !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::setDtlsCookieVerificationEnabled(bool)", __qt_this)
        __qt_this->setDtlsCookieVerificationEnabled(static_cast<bool>(enable0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(enable0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(dtls) && !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::setEllipticCurves(QVector<QSslEllipticCurve>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_setEllipticCurves_1native_1cref_1QVector__JLjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject curves0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__qtjambi_scope)
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::setEllipticCurves(QVector<QSslEllipticCurve>)", __qt_this)
        const QVector<QSslEllipticCurve>&  __qt_curves0 = qtjambi_cast<const QVector<QSslEllipticCurve>& >(__jni_env, __qtjambi_scope, curves0);
        __qt_this->setEllipticCurves(__qt_curves0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(curves0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::setLocalCertificate(QSslCertificate)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_setLocalCertificate_1native_1cref_1QSslCertificate__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID certificate0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::setLocalCertificate(QSslCertificate)", __qt_this)
        const QSslCertificate& __qt_certificate0 = QtJambiAPI::valueReferenceFromNativeId<QSslCertificate>(certificate0);
        __qt_this->setLocalCertificate(__qt_certificate0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(certificate0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::setLocalCertificateChain(QList<QSslCertificate>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_setLocalCertificateChain_1native_1cref_1QList__JLjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject localChain0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__qtjambi_scope)
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::setLocalCertificateChain(QList<QSslCertificate>)", __qt_this)
        const QList<QSslCertificate>&  __qt_localChain0 = qtjambi_cast<const QList<QSslCertificate>& >(__jni_env, __qtjambi_scope, localChain0);
        __qt_this->setLocalCertificateChain(__qt_localChain0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(localChain0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::setOcspStaplingEnabled(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_setOcspStaplingEnabled_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean enable0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::setOcspStaplingEnabled(bool)", __qt_this)
        __qt_this->setOcspStaplingEnabled(static_cast<bool>(enable0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(enable0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::setPeerVerifyDepth(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_setPeerVerifyDepth_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint depth0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::setPeerVerifyDepth(int)", __qt_this)
        __qt_this->setPeerVerifyDepth(static_cast<int>(depth0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(depth0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::setPeerVerifyMode(QSslSocket::PeerVerifyMode)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_setPeerVerifyMode_1native_1QSslSocket_1PeerVerifyMode__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::setPeerVerifyMode(QSslSocket::PeerVerifyMode)", __qt_this)
        QSslSocket::PeerVerifyMode __qt_mode0 = qtjambi_cast<QSslSocket::PeerVerifyMode>(__jni_env, mode0);
        __qt_this->setPeerVerifyMode(QSslSocket::PeerVerifyMode(__qt_mode0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(mode0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::setPreSharedKeyIdentityHint(QByteArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_setPreSharedKeyIdentityHint_1native_1cref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID hint0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::setPreSharedKeyIdentityHint(QByteArray)", __qt_this)
        const QByteArray& __qt_hint0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(hint0);
        __qt_this->setPreSharedKeyIdentityHint(__qt_hint0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(hint0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::setPrivateKey(QSslKey)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_setPrivateKey_1native_1cref_1QSslKey__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID key0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::setPrivateKey(QSslKey)", __qt_this)
        const QSslKey& __qt_key0 = QtJambiAPI::valueReferenceFromNativeId<QSslKey>(key0);
        __qt_this->setPrivateKey(__qt_key0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(key0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::setProtocol(QSsl::SslProtocol)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_setProtocol_1native_1QSsl_1SslProtocol__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint protocol0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::setProtocol(QSsl::SslProtocol)", __qt_this)
        QSsl::SslProtocol __qt_protocol0 = qtjambi_cast<QSsl::SslProtocol>(__jni_env, protocol0);
        __qt_this->setProtocol(QSsl::SslProtocol(__qt_protocol0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(protocol0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::setSessionTicket(QByteArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_setSessionTicket_1native_1cref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID sessionTicket0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::setSessionTicket(QByteArray)", __qt_this)
        const QByteArray& __qt_sessionTicket0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(sessionTicket0);
        __qt_this->setSessionTicket(__qt_sessionTicket0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(sessionTicket0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::setSslOption(QSsl::SslOption,bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_setSslOption_1native_1QSsl_1SslOption_1bool__JIZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint option0,
 jboolean on1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::setSslOption(QSsl::SslOption,bool)", __qt_this)
        QSsl::SslOption __qt_option0 = qtjambi_cast<QSsl::SslOption>(__jni_env, option0);
        __qt_this->setSslOption(QSsl::SslOption(__qt_option0), static_cast<bool>(on1));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(option0)
        Q_UNUSED(on1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::swap(QSslConfiguration&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_swap_1native_1ref_1QSslConfiguration__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::swap(QSslConfiguration&)", __qt_this)
        QSslConfiguration& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QSslConfiguration>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(other0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::testSslOption(QSsl::SslOption)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_testSslOption_1native_1QSsl_1SslOption_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint option0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslConfiguration::testSslOption(QSsl::SslOption)const", __qt_this)
        QSsl::SslOption __qt_option0 = qtjambi_cast<QSsl::SslOption>(__jni_env, option0);
        __java_return_value = __qt_this->testSslOption(QSsl::SslOption(__qt_option0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(option0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::defaultConfiguration()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_defaultConfiguration__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSslConfiguration::defaultConfiguration()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslConfiguration __qt_return_value = QSslConfiguration::defaultConfiguration();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::defaultDtlsConfiguration()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_defaultDtlsConfiguration__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSslConfiguration::defaultDtlsConfiguration()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(dtls) && !defined(QT_NO_SSL)
        QSslConfiguration __qt_return_value = QSslConfiguration::defaultDtlsConfiguration();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(dtls) && !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::setDefaultConfiguration(QSslConfiguration)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_setDefaultConfiguration_1native_1cref_1QSslConfiguration__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID configuration0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSslConfiguration::setDefaultConfiguration(QSslConfiguration)")
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslConfiguration& __qt_configuration0 = QtJambiAPI::valueReferenceFromNativeId<QSslConfiguration>(configuration0);
        QSslConfiguration::setDefaultConfiguration(__qt_configuration0);
#else
        Q_UNUSED(configuration0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::setDefaultDtlsConfiguration(QSslConfiguration)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_setDefaultDtlsConfiguration_1native_1cref_1QSslConfiguration__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID configuration0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSslConfiguration::setDefaultDtlsConfiguration(QSslConfiguration)")
    QTJAMBI_TRY {
#if QT_CONFIG(dtls) && !defined(QT_NO_SSL)
        const QSslConfiguration& __qt_configuration0 = QtJambiAPI::valueReferenceFromNativeId<QSslConfiguration>(configuration0);
        QSslConfiguration::setDefaultDtlsConfiguration(__qt_configuration0);
#else
        Q_UNUSED(configuration0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(dtls) && !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslConfiguration::supportedCiphers()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_supportedCiphers__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSslConfiguration::supportedCiphers()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QList<QSslCipher> __qt_return_value = QSslConfiguration::supportedCiphers();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::supportedEllipticCurves()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_supportedEllipticCurves__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSslConfiguration::supportedEllipticCurves()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QVector<QSslEllipticCurve> __qt_return_value = QSslConfiguration::supportedEllipticCurves();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslConfiguration::systemCaCertificates()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_systemCaCertificates__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSslConfiguration::systemCaCertificates()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QList<QSslCertificate> __qt_return_value = QSslConfiguration::systemCaCertificates();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting Field accessors (writeFieldAccessors)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_ALPNProtocolHTTP2__)
(JNIEnv *__jni_env,
 jclass)
{
    jstring __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const char*  __qt_value = QSslConfiguration::ALPNProtocolHTTP2;
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_value);
#else
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif //!defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;
}

extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_NextProtocolHttp1_11__)
(JNIEnv *__jni_env,
 jclass)
{
    jstring __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const char*  __qt_value = QSslConfiguration::NextProtocolHttp1_1;
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_value);
#else
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif //!defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;
}

extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_NextProtocolSpdy3_10__)
(JNIEnv *__jni_env,
 jclass)
{
    jstring __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const char*  __qt_value = QSslConfiguration::NextProtocolSpdy3_0;
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_value);
#else
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif //!defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {

#if !defined(QT_NO_SSL)

        QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(hashValue);
#else
        Q_UNUSED(__this_nativeId)
#endif // !defined(QT_NO_SSL)

    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslConfiguration_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {

#if !defined(QT_NO_SSL)

        const QSslConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QSslConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);

#else
        Q_UNUSED(__this_nativeId)
#endif // !defined(QT_NO_SSL)

    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QSslConfiguration(){
    using namespace RegistryAPI;

#if !defined(QT_NO_SSL)

    const std::type_info& typeId = registerValueTypeInfo<QSslConfiguration>("QSslConfiguration", "io/qt/network/QSslConfiguration");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QSslConfiguration, {
        ConstructorInfo(&__qt_construct_QSslConfiguration_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QSslConfiguration_1, "Lio/qt/network/QSslConfiguration;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QSslConfiguration);
    registerMetaType<QSslConfiguration>("QSslConfiguration");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags

#if !defined(QT_NO_SSL)
    registerEnumTypeInfo<QSslConfiguration::NextProtocolNegotiationStatus>("QSslConfiguration::NextProtocolNegotiationStatus", "io/qt/network/QSslConfiguration$NextProtocolNegotiationStatus");
#endif //!defined(QT_NO_SSL)
// END: enums and flags

#endif //!defined(QT_NO_SSL)

}
