#ifndef QUDPSOCKET_SHELL_H
#define QUDPSOCKET_SHELL_H

#include <QtCore/QtGlobal>
#include <QtCore/qcompilerdetection.h>

QT_WARNING_DISABLE_DEPRECATED
QT_WARNING_DISABLE_GCC("-Wdeprecated-declarations")

#include <QtNetwork/qudpsocket.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtCore/qbindingstorage.h>
#include <QtCore/qbytearray.h>
#include <QtCore/qcoreevent.h>
#include <QtCore/qmetaobject.h>
#include <QtCore/qnamespace.h>
#include <QtCore/qobject.h>
#include <QtCore/qproperty.h>
#include <qtcore-config.h>
#if QT_CONFIG(regularexpression)
#include <QtCore/qregularexpression.h>
#endif //QT_CONFIG(regularexpression)
#include <QtCore/qthread.h>
#include <QtCore/qtimer.h>
#include <QtCore/qvariant.h>
#include <QtNetwork/qabstractsocket.h>
#include <QtNetwork/qauthenticator.h>
#include <QtNetwork/qhostaddress.h>
#include <QtNetwork/qnetworkdatagram.h>
#include <QtNetwork/qnetworkinterface.h>
#include <QtNetwork/qnetworkproxy.h>
#include "utils_p.h"
#include <QtJambi/RegistryAPI>


class QUdpSocket_shell : public QUdpSocket, public QtJambiShellInterface
{
public:
    QUdpSocket_shell(QObject* parent0 = nullptr);
    ~QUdpSocket_shell() override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    friend class QUdpSocket_mshell;
    friend class QUdpSocket_oshell;
};


class QUdpSocket_mshell : public QUdpSocket_shell
{
public:
    using QUdpSocket_shell::QUdpSocket_shell;
    static void operator delete(void * ptr) noexcept;
    const QMetaObject *metaObject() const override final;
    void *qt_metacast(const char *) override final;
    int qt_metacall(QMetaObject::Call, int, void **) override final;
};


class QUdpSocket_oshell : public QUdpSocket_mshell
{
public:
    using QUdpSocket_mshell::QUdpSocket_mshell;
    bool atEnd() const override;
    qint64 bytesAvailable() const override;
    qint64 bytesToWrite() const override;
    bool canReadLine() const override;
    void childEvent(QChildEvent* event0) override;
    void close() override;
    void connectNotify(const QMetaMethod& signal0) override;
    void connectToHost(const QString& hostName0, quint16 port1, QIODeviceBase::OpenMode mode2, QAbstractSocket::NetworkLayerProtocol protocol3) override;
    void customEvent(QEvent* event0) override;
    void disconnectFromHost() override;
    void disconnectNotify(const QMetaMethod& signal0) override;
    bool event(QEvent* event0) override;
    bool eventFilter(QObject* watched0, QEvent* event1) override;
    bool isSequential() const override;
    bool open(QIODeviceBase::OpenMode mode0) override;
    qint64 pos() const override;
    qint64 readData(char* data0, qint64 maxlen1) override;
    qint64 readLineData(char* data0, qint64 maxlen1) override;
    bool reset() override;
    void resume() override;
    bool seek(qint64 pos0) override;
    void setReadBufferSize(qint64 size0) override;
    bool setSocketDescriptor(qintptr socketDescriptor0, QAbstractSocket::SocketState state1, QIODeviceBase::OpenMode openMode2) override;
    qint64 size() const override;
    qint64 skipData(qint64 maxSize0) override;
    qintptr socketDescriptor() const override;
    void timerEvent(QTimerEvent* event0) override;
    bool waitForBytesWritten(int msecs0) override;
    bool waitForConnected(int msecs0) override;
    bool waitForDisconnected(int msecs0) override;
    bool waitForReadyRead(int msecs0) override;
    qint64 writeData(const char* data0, qint64 len1) override;
    static void operator delete(void * ptr) noexcept;
private:
    jmethodID __shell_javaMethod(int pos) const;
};

struct QUdpSocket_access : public QUdpSocket
{
};

#endif // QUDPSOCKET_SHELL_H
