#include <QtCore/QtGlobal>
#include <QtNetwork/qhostinfo.h>
#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtCore/qobject.h>
#include <QtNetwork/qhostaddress.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/JObjectWrapper>
#include <QtJambi/JavaAPI>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

// emitting (writeClassCodeInjections)
auto convertSlot(JNIEnv* _env, jobject _slot){
    JObjectWrapper slot(_env, _slot);
    return [slot](const QHostInfo& info){
                    if(JniEnvironment env{200}){
                        jobject _info = qtjambi_cast<jobject>(env, info);
                        Java::QtCore::QMetaObject$Slot1::invoke(env, slot.object(), _info);
                    }
                };
}

void deleter_QHostInfo(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QHostInfo")
    QHostInfo *_ptr = reinterpret_cast<QHostInfo *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QHostInfo(QHostInfo)
void __qt_construct_QHostInfo_cref_QHostInfo(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QHostInfo(QHostInfo)")
    jobject d0 = __java_arguments[0].l;
    const QHostInfo& __qt_d0 = qtjambi_cast<const QHostInfo& >(__jni_env, d0);
    QHostInfo *__qt_this = new(__qtjambi_ptr) QHostInfo(__qt_d0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QHostInfo::QHostInfo(QHostInfo)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostInfo_initialize_1native__Lio_qt_network_QHostInfo_2Lio_qt_network_QHostInfo_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject d0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QHostInfo::QHostInfo(QHostInfo)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = d0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QHostInfo_cref_QHostInfo, sizeof(QHostInfo), typeid(QHostInfo), false, &deleter_QHostInfo, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QHostInfo(int)
void __qt_construct_QHostInfo(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QHostInfo(int)")
    Q_UNUSED(__java_arguments)
    QHostInfo *__qt_this = new(__qtjambi_ptr) QHostInfo();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QHostInfo(int)
void __qt_construct_QHostInfo_int(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QHostInfo(int)")
    jint lookupId0 = __java_arguments[0].i;
    Q_UNUSED(lookupId0)
    QHostInfo *__qt_this = new(__qtjambi_ptr) QHostInfo(static_cast<int>(lookupId0));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QHostInfo::QHostInfo(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostInfo_initialize_1native__Lio_qt_network_QHostInfo_2I)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jint lookupId0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QHostInfo::QHostInfo(int)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.i = lookupId0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QHostInfo_int, sizeof(QHostInfo), typeid(QHostInfo), false, &deleter_QHostInfo, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QHostInfo
void __qt_destruct_QHostInfo(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QHostInfo")
    reinterpret_cast<QHostInfo*>(ptr)->~QHostInfo();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QHostInfo::addresses()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostInfo_addresses_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QHostInfo *__qt_this = QtJambiAPI::objectFromNativeId<QHostInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostInfo::addresses()const", __qt_this)
        QList<QHostAddress> __qt_return_value = __qt_this->addresses();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostInfo::error()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostInfo_error_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QHostInfo *__qt_this = QtJambiAPI::objectFromNativeId<QHostInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostInfo::error()const", __qt_this)
        QHostInfo::HostInfoError __qt_return_value = __qt_this->error();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostInfo::errorString()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostInfo_errorString_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QHostInfo *__qt_this = QtJambiAPI::objectFromNativeId<QHostInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostInfo::errorString()const", __qt_this)
        QString __qt_return_value = __qt_this->errorString();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostInfo::hostName()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostInfo_hostName_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QHostInfo *__qt_this = QtJambiAPI::objectFromNativeId<QHostInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostInfo::hostName()const", __qt_this)
        QString __qt_return_value = __qt_this->hostName();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostInfo::lookupId()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostInfo_lookupId_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QHostInfo *__qt_this = QtJambiAPI::objectFromNativeId<QHostInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostInfo::lookupId()const", __qt_this)
        __java_return_value = __qt_this->lookupId();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostInfo::operator=(QHostInfo)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostInfo_assign_1native_1cref_1QHostInfo__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID d0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QHostInfo *__qt_this = QtJambiAPI::objectFromNativeId<QHostInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostInfo::operator=(QHostInfo)", __qt_this)
        const QHostInfo& __qt_d0 = QtJambiAPI::objectReferenceFromNativeId<QHostInfo>(__jni_env, d0);
        (*__qt_this) = __qt_d0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QHostInfo::setAddresses(QList<QHostAddress>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostInfo_setAddresses_1native_1cref_1QList__JLjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject addresses0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QHostInfo *__qt_this = QtJambiAPI::objectFromNativeId<QHostInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostInfo::setAddresses(QList<QHostAddress>)", __qt_this)
        const QList<QHostAddress>&  __qt_addresses0 = qtjambi_cast<const QList<QHostAddress>& >(__jni_env, __qtjambi_scope, addresses0);
        __qt_this->setAddresses(__qt_addresses0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QHostInfo::setError(QHostInfo::HostInfoError)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostInfo_setError_1native_1QHostInfo_1HostInfoError__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint error0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QHostInfo *__qt_this = QtJambiAPI::objectFromNativeId<QHostInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostInfo::setError(QHostInfo::HostInfoError)", __qt_this)
        QHostInfo::HostInfoError __qt_error0 = qtjambi_cast<QHostInfo::HostInfoError>(__jni_env, error0);
        __qt_this->setError(QHostInfo::HostInfoError(__qt_error0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QHostInfo::setErrorString(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostInfo_setErrorString_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring errorString0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QHostInfo *__qt_this = QtJambiAPI::objectFromNativeId<QHostInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostInfo::setErrorString(QString)", __qt_this)
        QString  __qt_errorString0 = qtjambi_cast<QString>(__jni_env, errorString0);
        __qt_this->setErrorString(__qt_errorString0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QHostInfo::setHostName(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostInfo_setHostName_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring name0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QHostInfo *__qt_this = QtJambiAPI::objectFromNativeId<QHostInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostInfo::setHostName(QString)", __qt_this)
        QString  __qt_name0 = qtjambi_cast<QString>(__jni_env, name0);
        __qt_this->setHostName(__qt_name0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QHostInfo::setLookupId(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostInfo_setLookupId_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint id0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QHostInfo *__qt_this = QtJambiAPI::objectFromNativeId<QHostInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostInfo::setLookupId(int)", __qt_this)
        __qt_this->setLookupId(static_cast<int>(id0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QHostInfo::swap(QHostInfo&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostInfo_swap_1native_1ref_1QHostInfo__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QHostInfo *__qt_this = QtJambiAPI::objectFromNativeId<QHostInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QHostInfo::swap(QHostInfo&)", __qt_this)
        QHostInfo& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QHostInfo>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QHostInfo::abortHostLookup(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostInfo_abortHostLookup__I)
(JNIEnv *__jni_env,
 jclass,
 jint lookupId0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QHostInfo::abortHostLookup(int)")
    QTJAMBI_TRY {
        QHostInfo::abortHostLookup(static_cast<int>(lookupId0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QHostInfo::fromName(QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostInfo_fromName__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring name0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QHostInfo::fromName(QString)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_name0 = qtjambi_cast<QString>(__jni_env, name0);
        QHostInfo __qt_return_value = QHostInfo::fromName(__qt_name0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostInfo::localDomainName()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostInfo_localDomainName__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QHostInfo::localDomainName()")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString __qt_return_value = QHostInfo::localDomainName();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostInfo::localHostName()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostInfo_localHostName__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QHostInfo::localHostName()")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString __qt_return_value = QHostInfo::localHostName();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostInfo::lookupHost(QString,QObject*,const char*)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostInfo_lookupHost_1native_1cref_1QString_1QObject_1ptr_1const_1char_1ptr__Ljava_lang_String_2JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring name0,
 QtJambiNativeID receiver1,
 jstring member2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QHostInfo::lookupHost(QString,QObject*,const char*)")
    QtJambiScope __qtjambi_scope;
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_name0 = qtjambi_cast<QString>(__jni_env, name0);
        QObject* __qt_receiver1 = QtJambiAPI::objectFromNativeId<QObject>(receiver1);
        const char*  __qt_member2 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, member2);
        __java_return_value = QHostInfo::lookupHost(__qt_name0, __qt_receiver1, __qt_member2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QHostInfo::lookupHost<std::function<void(QHostInfo)>>(QString,const QtPrivate::ContextTypeForFunctor::ContextType<Functor>*,std::function<void(QHostInfo)>&&)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostInfo_lookupHost_1native_1cref_1QString_1const_1QtPrivate_1ContextTypeForFunctor_1ContextType_1Functor_1_1ptr_1rval_1QHostInfo_1Slot__Ljava_lang_String_2JLio_qt_core_QMetaObject_00024Slot1_2)
(JNIEnv *__jni_env,
 jclass,
 jstring name0,
 QtJambiNativeID receiver1,
 jobject func2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QHostInfo::lookupHost<std::function<void(QHostInfo)>>(QString,const QtPrivate::ContextTypeForFunctor::ContextType<Functor>*,std::function<void(QHostInfo)>&&)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_name0 = qtjambi_cast<QString>(__jni_env, name0);
        QObject* __qt_receiver1 = QtJambiAPI::objectFromNativeId<QObject>(receiver1);
        auto __qt_func2 = convertSlot(__jni_env, func2);
        __java_return_value = QHostInfo::lookupHost(__qt_name0, __qt_receiver1, std::move(__qt_func2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QHostInfo_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QHostInfo *__qt_this = QtJambiAPI::objectFromNativeId<QHostInfo>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QHostInfo(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QHostInfo>("QHostInfo", "io/qt/network/QHostInfo");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QHostInfo, {
        ConstructorInfo(&__qt_construct_QHostInfo_cref_QHostInfo, "Lio/qt/network/QHostInfo;")
       ,ConstructorInfo(&__qt_construct_QHostInfo, nullptr)
       ,ConstructorInfo(&__qt_construct_QHostInfo_int, "I")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QHostInfo);
    registerMetaType<QHostInfo>("QHostInfo");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QHostInfo::HostInfoError>("QHostInfo::HostInfoError", "io/qt/network/QHostInfo$HostInfoError");
// END: enums and flags
}
