#include <QtCore/QtGlobal>
#if __has_include(<QtNetwork/qsslkey.h>)
#include <QtNetwork/qsslkey.h>
#endif
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qiodevice.h>
#include <QtNetwork/qssl.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiNetwork/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

#if !defined(QT_NO_SSL)


void deleter_QSslKey(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QSslKey")
    QSslKey *_ptr = reinterpret_cast<QSslKey *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}


#endif // !defined(QT_NO_SSL)

// emitting (writeConstructors)
// new QSslKey()
void __qt_construct_QSslKey_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSslKey()")
#if !defined(QT_NO_SSL)
    Q_UNUSED(__java_arguments)
    QSslKey *__qt_this = new(__qtjambi_ptr) QSslKey();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
}

// new QSslKey(QByteArray,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)
void __qt_construct_QSslKey_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSslKey(QByteArray,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)")
#if !defined(QT_NO_SSL)
    jobject encoded0 = __java_arguments[0].l;
    const QByteArray& __qt_encoded0 = qtjambi_cast<const QByteArray& >(__jni_env, encoded0);
    jobject algorithm1 = __java_arguments[1].l;
    QSsl::KeyAlgorithm __qt_algorithm1 = qtjambi_cast<QSsl::KeyAlgorithm>(__jni_env, algorithm1);
    QSslKey *__qt_this = new(__qtjambi_ptr) QSslKey(__qt_encoded0, QSsl::KeyAlgorithm(__qt_algorithm1));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
}

// new QSslKey(QByteArray,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)
void __qt_construct_QSslKey_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSslKey(QByteArray,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)")
#if !defined(QT_NO_SSL)
    jobject encoded0 = __java_arguments[0].l;
    const QByteArray& __qt_encoded0 = qtjambi_cast<const QByteArray& >(__jni_env, encoded0);
    jobject algorithm1 = __java_arguments[1].l;
    QSsl::KeyAlgorithm __qt_algorithm1 = qtjambi_cast<QSsl::KeyAlgorithm>(__jni_env, algorithm1);
    jobject format2 = __java_arguments[2].l;
    QSsl::EncodingFormat __qt_format2 = qtjambi_cast<QSsl::EncodingFormat>(__jni_env, format2);
    QSslKey *__qt_this = new(__qtjambi_ptr) QSslKey(__qt_encoded0, QSsl::KeyAlgorithm(__qt_algorithm1), QSsl::EncodingFormat(__qt_format2));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
}

// new QSslKey(QByteArray,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)
void __qt_construct_QSslKey_3(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSslKey(QByteArray,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)")
#if !defined(QT_NO_SSL)
    jobject encoded0 = __java_arguments[0].l;
    const QByteArray& __qt_encoded0 = qtjambi_cast<const QByteArray& >(__jni_env, encoded0);
    jobject algorithm1 = __java_arguments[1].l;
    QSsl::KeyAlgorithm __qt_algorithm1 = qtjambi_cast<QSsl::KeyAlgorithm>(__jni_env, algorithm1);
    jobject format2 = __java_arguments[2].l;
    QSsl::EncodingFormat __qt_format2 = qtjambi_cast<QSsl::EncodingFormat>(__jni_env, format2);
    jobject type3 = __java_arguments[3].l;
    QSsl::KeyType __qt_type3 = qtjambi_cast<QSsl::KeyType>(__jni_env, type3);
    QSslKey *__qt_this = new(__qtjambi_ptr) QSslKey(__qt_encoded0, QSsl::KeyAlgorithm(__qt_algorithm1), QSsl::EncodingFormat(__qt_format2), QSsl::KeyType(__qt_type3));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
}

// new QSslKey(QByteArray,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)
void __qt_construct_QSslKey_4(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSslKey(QByteArray,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)")
#if !defined(QT_NO_SSL)
    jobject encoded0 = __java_arguments[0].l;
    const QByteArray& __qt_encoded0 = qtjambi_cast<const QByteArray& >(__jni_env, encoded0);
    jobject algorithm1 = __java_arguments[1].l;
    QSsl::KeyAlgorithm __qt_algorithm1 = qtjambi_cast<QSsl::KeyAlgorithm>(__jni_env, algorithm1);
    jobject format2 = __java_arguments[2].l;
    QSsl::EncodingFormat __qt_format2 = qtjambi_cast<QSsl::EncodingFormat>(__jni_env, format2);
    jobject type3 = __java_arguments[3].l;
    QSsl::KeyType __qt_type3 = qtjambi_cast<QSsl::KeyType>(__jni_env, type3);
    jobject passPhrase4 = __java_arguments[4].l;
    const QByteArray& __qt_passPhrase4 = qtjambi_cast<const QByteArray& >(__jni_env, passPhrase4);
    QSslKey *__qt_this = new(__qtjambi_ptr) QSslKey(__qt_encoded0, QSsl::KeyAlgorithm(__qt_algorithm1), QSsl::EncodingFormat(__qt_format2), QSsl::KeyType(__qt_type3), __qt_passPhrase4);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
}

// new QSslKey(QIODevice*,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)
void __qt_construct_QSslKey_5(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSslKey(QIODevice*,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)")
#if !defined(QT_NO_SSL)
    jobject device0 = __java_arguments[0].l;
    QIODevice* __qt_device0 = qtjambi_cast<QIODevice* >(__jni_env, device0);
    jobject algorithm1 = __java_arguments[1].l;
    QSsl::KeyAlgorithm __qt_algorithm1 = qtjambi_cast<QSsl::KeyAlgorithm>(__jni_env, algorithm1);
    QSslKey *__qt_this = new(__qtjambi_ptr) QSslKey(__qt_device0, QSsl::KeyAlgorithm(__qt_algorithm1));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
}

// new QSslKey(QIODevice*,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)
void __qt_construct_QSslKey_6(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSslKey(QIODevice*,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)")
#if !defined(QT_NO_SSL)
    jobject device0 = __java_arguments[0].l;
    QIODevice* __qt_device0 = qtjambi_cast<QIODevice* >(__jni_env, device0);
    jobject algorithm1 = __java_arguments[1].l;
    QSsl::KeyAlgorithm __qt_algorithm1 = qtjambi_cast<QSsl::KeyAlgorithm>(__jni_env, algorithm1);
    jobject format2 = __java_arguments[2].l;
    QSsl::EncodingFormat __qt_format2 = qtjambi_cast<QSsl::EncodingFormat>(__jni_env, format2);
    QSslKey *__qt_this = new(__qtjambi_ptr) QSslKey(__qt_device0, QSsl::KeyAlgorithm(__qt_algorithm1), QSsl::EncodingFormat(__qt_format2));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
}

// new QSslKey(QIODevice*,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)
void __qt_construct_QSslKey_7(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSslKey(QIODevice*,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)")
#if !defined(QT_NO_SSL)
    jobject device0 = __java_arguments[0].l;
    QIODevice* __qt_device0 = qtjambi_cast<QIODevice* >(__jni_env, device0);
    jobject algorithm1 = __java_arguments[1].l;
    QSsl::KeyAlgorithm __qt_algorithm1 = qtjambi_cast<QSsl::KeyAlgorithm>(__jni_env, algorithm1);
    jobject format2 = __java_arguments[2].l;
    QSsl::EncodingFormat __qt_format2 = qtjambi_cast<QSsl::EncodingFormat>(__jni_env, format2);
    jobject type3 = __java_arguments[3].l;
    QSsl::KeyType __qt_type3 = qtjambi_cast<QSsl::KeyType>(__jni_env, type3);
    QSslKey *__qt_this = new(__qtjambi_ptr) QSslKey(__qt_device0, QSsl::KeyAlgorithm(__qt_algorithm1), QSsl::EncodingFormat(__qt_format2), QSsl::KeyType(__qt_type3));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
}

// new QSslKey(QIODevice*,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)
void __qt_construct_QSslKey_8(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSslKey(QIODevice*,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)")
#if !defined(QT_NO_SSL)
    jobject device0 = __java_arguments[0].l;
    QIODevice* __qt_device0 = qtjambi_cast<QIODevice* >(__jni_env, device0);
    jobject algorithm1 = __java_arguments[1].l;
    QSsl::KeyAlgorithm __qt_algorithm1 = qtjambi_cast<QSsl::KeyAlgorithm>(__jni_env, algorithm1);
    jobject format2 = __java_arguments[2].l;
    QSsl::EncodingFormat __qt_format2 = qtjambi_cast<QSsl::EncodingFormat>(__jni_env, format2);
    jobject type3 = __java_arguments[3].l;
    QSsl::KeyType __qt_type3 = qtjambi_cast<QSsl::KeyType>(__jni_env, type3);
    jobject passPhrase4 = __java_arguments[4].l;
    const QByteArray& __qt_passPhrase4 = qtjambi_cast<const QByteArray& >(__jni_env, passPhrase4);
    QSslKey *__qt_this = new(__qtjambi_ptr) QSslKey(__qt_device0, QSsl::KeyAlgorithm(__qt_algorithm1), QSsl::EncodingFormat(__qt_format2), QSsl::KeyType(__qt_type3), __qt_passPhrase4);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
}

// new QSslKey(QSslKey)
void __qt_construct_QSslKey_9(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSslKey(QSslKey)")
#if !defined(QT_NO_SSL)
    jobject other0 = __java_arguments[0].l;
    const QSslKey& __qt_other0 = qtjambi_cast<const QSslKey& >(__jni_env, other0);
    QSslKey *__qt_this = new(__qtjambi_ptr) QSslKey(__qt_other0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
}

// new QSslKey(Qt::HANDLE,QSsl::KeyType)
void __qt_construct_QSslKey_10(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSslKey(Qt::HANDLE,QSsl::KeyType)")
#if !defined(QT_NO_SSL)
    jlong handle0 = __java_arguments[0].j;
    Qt::HANDLE __qt_handle0 = reinterpret_cast<Qt::HANDLE>(handle0);
    QSslKey *__qt_this = new(__qtjambi_ptr) QSslKey(Qt::HANDLE(__qt_handle0));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
}

// new QSslKey(Qt::HANDLE,QSsl::KeyType)
void __qt_construct_QSslKey_11(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSslKey(Qt::HANDLE,QSsl::KeyType)")
#if !defined(QT_NO_SSL)
    jlong handle0 = __java_arguments[0].j;
    Qt::HANDLE __qt_handle0 = reinterpret_cast<Qt::HANDLE>(handle0);
    jobject type1 = __java_arguments[1].l;
    QSsl::KeyType __qt_type1 = qtjambi_cast<QSsl::KeyType>(__jni_env, type1);
    QSslKey *__qt_this = new(__qtjambi_ptr) QSslKey(Qt::HANDLE(__qt_handle0), QSsl::KeyType(__qt_type1));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
}

// destruct QSslKey
void __qt_destruct_QSslKey(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QSslKey")

#if !defined(QT_NO_SSL)

    reinterpret_cast<QSslKey*>(ptr)->~QSslKey();

#else
    Q_UNUSED(ptr)

#endif // !defined(QT_NO_SSL)

}

// emitting  (functionsInTargetLang writeFinalFunction)
// QSslKey::QSslKey()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslKey_initialize_1native__Lio_qt_network_QSslKey_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSslKey::QSslKey()")
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QSslKey_0, sizeof(QSslKey), typeid(QSslKey), false, &deleter_QSslKey, nullptr);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslKey::QSslKey(QByteArray,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslKey_initialize_1native__Lio_qt_network_QSslKey_2Lio_qt_core_QByteArray_2Lio_qt_network_QSsl_00024KeyAlgorithm_2Lio_qt_network_QSsl_00024EncodingFormat_2Lio_qt_network_QSsl_00024KeyType_2Lio_qt_core_QByteArray_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject encoded0,
 jobject algorithm1,
 jobject format2,
 jobject type3,
 jobject passPhrase4)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSslKey::QSslKey(QByteArray,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)")
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        jvalue arguments[5];
        arguments[0].l = encoded0;
        arguments[1].l = algorithm1;
        arguments[2].l = format2;
        arguments[3].l = type3;
        arguments[4].l = passPhrase4;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QSslKey_4, sizeof(QSslKey), typeid(QSslKey), false, &deleter_QSslKey, arguments);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        Q_UNUSED(encoded0)
        Q_UNUSED(algorithm1)
        Q_UNUSED(format2)
        Q_UNUSED(type3)
        Q_UNUSED(passPhrase4)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslKey::QSslKey(QIODevice*,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslKey_initialize_1native__Lio_qt_network_QSslKey_2Lio_qt_core_QIODevice_2Lio_qt_network_QSsl_00024KeyAlgorithm_2Lio_qt_network_QSsl_00024EncodingFormat_2Lio_qt_network_QSsl_00024KeyType_2Lio_qt_core_QByteArray_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject device0,
 jobject algorithm1,
 jobject format2,
 jobject type3,
 jobject passPhrase4)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSslKey::QSslKey(QIODevice*,QSsl::KeyAlgorithm,QSsl::EncodingFormat,QSsl::KeyType,QByteArray)")
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        jvalue arguments[5];
        arguments[0].l = device0;
        arguments[1].l = algorithm1;
        arguments[2].l = format2;
        arguments[3].l = type3;
        arguments[4].l = passPhrase4;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QSslKey_8, sizeof(QSslKey), typeid(QSslKey), false, &deleter_QSslKey, arguments);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        Q_UNUSED(device0)
        Q_UNUSED(algorithm1)
        Q_UNUSED(format2)
        Q_UNUSED(type3)
        Q_UNUSED(passPhrase4)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslKey::QSslKey(QSslKey)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslKey_initialize_1native__Lio_qt_network_QSslKey_2Lio_qt_network_QSslKey_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSslKey::QSslKey(QSslKey)")
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QSslKey_9, sizeof(QSslKey), typeid(QSslKey), false, &deleter_QSslKey, &arguments);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        Q_UNUSED(other0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslKey::QSslKey(Qt::HANDLE,QSsl::KeyType)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslKey_initialize_1native__Lio_qt_network_QSslKey_2JLio_qt_network_QSsl_00024KeyType_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jlong handle0,
 jobject type1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSslKey::QSslKey(Qt::HANDLE,QSsl::KeyType)")
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        jvalue arguments[2];
        arguments[0].j = handle0;
        arguments[1].l = type1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QSslKey_11, sizeof(QSslKey), typeid(QSslKey), false, &deleter_QSslKey, arguments);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        Q_UNUSED(handle0)
        Q_UNUSED(type1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslKey::algorithm()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslKey_algorithm_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslKey *__qt_this = QtJambiAPI::objectFromNativeId<QSslKey>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslKey::algorithm()const", __qt_this)
        QSsl::KeyAlgorithm __qt_return_value = __qt_this->algorithm();
        __java_return_value = __qt_return_value;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslKey::clear()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslKey_clear_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslKey *__qt_this = QtJambiAPI::objectFromNativeId<QSslKey>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslKey::clear()", __qt_this)
        __qt_this->clear();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslKey::handle()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslKey_handle_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslKey *__qt_this = QtJambiAPI::objectFromNativeId<QSslKey>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslKey::handle()const", __qt_this)
        Qt::HANDLE __qt_return_value = __qt_this->handle();
        __java_return_value = jlong(__qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslKey::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslKey_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslKey *__qt_this = QtJambiAPI::objectFromNativeId<QSslKey>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslKey::isNull()const", __qt_this)
        __java_return_value = __qt_this->isNull();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslKey::length()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslKey_length_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslKey *__qt_this = QtJambiAPI::objectFromNativeId<QSslKey>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslKey::length()const", __qt_this)
        __java_return_value = __qt_this->length();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslKey::operator=(QSslKey)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslKey_assign_1native_1cref_1QSslKey__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslKey *__qt_this = QtJambiAPI::objectFromNativeId<QSslKey>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslKey::operator=(QSslKey)", __qt_this)
        const QSslKey& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QSslKey>(other0);
        (*__qt_this) = __qt_other0;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(other0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslKey::operator==(QSslKey)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslKey_equals_1native_1cref_1QSslKey_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID key0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslKey *__qt_this = QtJambiAPI::objectFromNativeId<QSslKey>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslKey::operator==(QSslKey)const", __qt_this)
        const QSslKey& __qt_key0 = QtJambiAPI::valueReferenceFromNativeId<QSslKey>(key0);
        __java_return_value = (*__qt_this) == __qt_key0;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(key0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslKey::swap(QSslKey&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslKey_swap_1native_1ref_1QSslKey__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        QSslKey *__qt_this = QtJambiAPI::objectFromNativeId<QSslKey>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslKey::swap(QSslKey&)", __qt_this)
        QSslKey& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QSslKey>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(other0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSslKey::toDer(QByteArray)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslKey_toDer_1native_1cref_1QByteArray_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID passPhrase0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslKey *__qt_this = QtJambiAPI::objectFromNativeId<QSslKey>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslKey::toDer(QByteArray)const", __qt_this)
        const QByteArray& __qt_passPhrase0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(passPhrase0);
        QByteArray __qt_return_value = __qt_this->toDer(__qt_passPhrase0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(passPhrase0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslKey::toPem(QByteArray)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslKey_toPem_1native_1cref_1QByteArray_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID passPhrase0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslKey *__qt_this = QtJambiAPI::objectFromNativeId<QSslKey>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslKey::toPem(QByteArray)const", __qt_this)
        const QByteArray& __qt_passPhrase0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(passPhrase0);
        QByteArray __qt_return_value = __qt_this->toPem(__qt_passPhrase0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(passPhrase0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSslKey::type()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslKey_type_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if !defined(QT_NO_SSL)
        const QSslKey *__qt_this = QtJambiAPI::objectFromNativeId<QSslKey>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSslKey::type()const", __qt_this)
        QSsl::KeyType __qt_return_value = __qt_this->type();
        __java_return_value = __qt_return_value;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // !defined(QT_NO_SSL)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslKey_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {

#if !defined(QT_NO_SSL)

        QSslKey *__qt_this = QtJambiAPI::objectFromNativeId<QSslKey>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
#else
        Q_UNUSED(__this_nativeId)
#endif // !defined(QT_NO_SSL)

    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslKey_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {

#if !defined(QT_NO_SSL)

        QSslKey *__qt_this = QtJambiAPI::objectFromNativeId<QSslKey>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);

#else
        Q_UNUSED(__this_nativeId)
#endif // !defined(QT_NO_SSL)

    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QSslKey_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {

#if !defined(QT_NO_SSL)

        const QSslKey *__qt_this = QtJambiAPI::objectFromNativeId<QSslKey>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);

#else
        Q_UNUSED(__this_nativeId)
#endif // !defined(QT_NO_SSL)

    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QSslKey(){
    using namespace RegistryAPI;

#if !defined(QT_NO_SSL)

    const std::type_info& typeId = registerValueTypeInfo<QSslKey>("QSslKey", "io/qt/network/QSslKey");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QSslKey, {
        ConstructorInfo(&__qt_construct_QSslKey_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QSslKey_1, "Lio/qt/core/QByteArray;Lio/qt/network/QSsl$KeyAlgorithm;")
       ,ConstructorInfo(&__qt_construct_QSslKey_2, "Lio/qt/core/QByteArray;Lio/qt/network/QSsl$KeyAlgorithm;Lio/qt/network/QSsl$EncodingFormat;")
       ,ConstructorInfo(&__qt_construct_QSslKey_3, "Lio/qt/core/QByteArray;Lio/qt/network/QSsl$KeyAlgorithm;Lio/qt/network/QSsl$EncodingFormat;Lio/qt/network/QSsl$KeyType;")
       ,ConstructorInfo(&__qt_construct_QSslKey_4, "Lio/qt/core/QByteArray;Lio/qt/network/QSsl$KeyAlgorithm;Lio/qt/network/QSsl$EncodingFormat;Lio/qt/network/QSsl$KeyType;Lio/qt/core/QByteArray;")
       ,ConstructorInfo(&__qt_construct_QSslKey_5, "Lio/qt/core/QIODevice;Lio/qt/network/QSsl$KeyAlgorithm;")
       ,ConstructorInfo(&__qt_construct_QSslKey_6, "Lio/qt/core/QIODevice;Lio/qt/network/QSsl$KeyAlgorithm;Lio/qt/network/QSsl$EncodingFormat;")
       ,ConstructorInfo(&__qt_construct_QSslKey_7, "Lio/qt/core/QIODevice;Lio/qt/network/QSsl$KeyAlgorithm;Lio/qt/network/QSsl$EncodingFormat;Lio/qt/network/QSsl$KeyType;")
       ,ConstructorInfo(&__qt_construct_QSslKey_8, "Lio/qt/core/QIODevice;Lio/qt/network/QSsl$KeyAlgorithm;Lio/qt/network/QSsl$EncodingFormat;Lio/qt/network/QSsl$KeyType;Lio/qt/core/QByteArray;")
       ,ConstructorInfo(&__qt_construct_QSslKey_9, "Lio/qt/network/QSslKey;")
       ,ConstructorInfo(&__qt_construct_QSslKey_10, "J")
       ,ConstructorInfo(&__qt_construct_QSslKey_11, "JLio/qt/network/QSsl$KeyType;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QSslKey);
    registerMetaType<QSslKey>("QSslKey");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags

#endif //!defined(QT_NO_SSL)

}
