#ifndef QSSLSOCKET_SHELL_H
#define QSSLSOCKET_SHELL_H

#include <QtCore/QtGlobal>
#include <QtCore/qcompilerdetection.h>

QT_WARNING_DISABLE_DEPRECATED
QT_WARNING_DISABLE_GCC("-Wdeprecated-declarations")

#if __has_include(<QtNetwork/qsslsocket.h>)
#include <QtNetwork/qsslsocket.h>
#endif
#include <QtJambi/QtJambiAPI>
#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtCore/qbindingstorage.h>
#include <QtCore/qbytearray.h>
#include <QtCore/qcoreevent.h>
#include <QtCore/qmetaobject.h>
#include <QtCore/qnamespace.h>
#include <QtCore/qobject.h>
#include <QtCore/qproperty.h>
#include <qtcore-config.h>
#if QT_CONFIG(regularexpression)
#include <QtCore/qregularexpression.h>
#endif //QT_CONFIG(regularexpression)
#include <QtCore/qthread.h>
#include <QtCore/qtimer.h>
#include <QtNetwork/qabstractsocket.h>
#include <QtNetwork/qauthenticator.h>
#include <QtNetwork/qhostaddress.h>
#include <QtNetwork/qnetworkproxy.h>
#include <qtnetwork-config.h>
#if QT_CONFIG(ssl)
#include <QtNetwork/qocspresponse.h>
#endif //QT_CONFIG(ssl)
#include <QtNetwork/qssl.h>
#if __has_include(<QtNetwork/qsslcertificate.h>)
#include <QtNetwork/qsslcertificate.h>
#endif
#if __has_include(<QtNetwork/qsslcipher.h>)
#include <QtNetwork/qsslcipher.h>
#endif
#if __has_include(<QtNetwork/qsslconfiguration.h>)
#include <QtNetwork/qsslconfiguration.h>
#endif
#if __has_include(<QtNetwork/qsslerror.h>)
#include <QtNetwork/qsslerror.h>
#endif
#if __has_include(<QtNetwork/qsslkey.h>)
#include <QtNetwork/qsslkey.h>
#endif
#if QT_CONFIG(ssl)
#if __has_include(<QtNetwork/qsslpresharedkeyauthenticator.h>)
#include <QtNetwork/qsslpresharedkeyauthenticator.h>
#endif
#endif //QT_CONFIG(ssl)
#include <QtJambi/RegistryAPI>


#if !defined(QT_NO_SSL)

class QSslSocket_shell : public QSslSocket, public QtJambiShellInterface
{
public:
    QSslSocket_shell(QObject* parent0 = nullptr);
    ~QSslSocket_shell() override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    friend class QSslSocket_mshell;
    friend class QSslSocket_oshell;
};


class QSslSocket_mshell : public QSslSocket_shell
{
public:
    using QSslSocket_shell::QSslSocket_shell;
    static void operator delete(void * ptr) noexcept;
    const QMetaObject *metaObject() const override final;
    void *qt_metacast(const char *) override final;
    int qt_metacall(QMetaObject::Call, int, void **) override final;
};


class QSslSocket_oshell : public QSslSocket_mshell
{
public:
    using QSslSocket_mshell::QSslSocket_mshell;
    bool atEnd() const override;
    qint64 bytesAvailable() const override;
    qint64 bytesToWrite() const override;
    bool canReadLine() const override;
    void childEvent(QChildEvent* event0) override;
    void close() override;
    void connectNotify(const QMetaMethod& signal0) override;
    void connectToHost(const QString& hostName0, quint16 port1, QIODeviceBase::OpenMode openMode2, QAbstractSocket::NetworkLayerProtocol protocol3) override;
    void customEvent(QEvent* event0) override;
    void disconnectFromHost() override;
    void disconnectNotify(const QMetaMethod& signal0) override;
    bool event(QEvent* event0) override;
    bool eventFilter(QObject* watched0, QEvent* event1) override;
    bool isSequential() const override;
    bool open(QIODeviceBase::OpenMode mode0) override;
    qint64 pos() const override;
    qint64 readData(char* data0, qint64 maxlen1) override;
    qint64 readLineData(char* data0, qint64 maxlen1) override;
    bool reset() override;
    void resume() override;
    bool seek(qint64 pos0) override;
    void setReadBufferSize(qint64 size0) override;
    bool setSocketDescriptor(qintptr socketDescriptor0, QAbstractSocket::SocketState state1, QIODeviceBase::OpenMode openMode2) override;
    void setSocketOption(QAbstractSocket::SocketOption option0, const QVariant& value1) override;
    qint64 size() const override;
    qint64 skipData(qint64 maxSize0) override;
    qintptr socketDescriptor() const override;
    QVariant socketOption(QAbstractSocket::SocketOption option0) override;
    void timerEvent(QTimerEvent* event0) override;
    bool waitForBytesWritten(int msecs0) override;
    bool waitForConnected(int msecs0) override;
    bool waitForDisconnected(int msecs0) override;
    bool waitForReadyRead(int msecs0) override;
    qint64 writeData(const char* data0, qint64 len1) override;
    static void operator delete(void * ptr) noexcept;
private:
    jmethodID __shell_javaMethod(int pos) const;
};

struct QSslSocket_access : public QSslSocket
{
    jboolean __qt_atEnd_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jlong __qt_bytesAvailable_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jlong __qt_bytesToWrite_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jboolean __qt_canReadLine_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    void __qt_close(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    void __qt_connectToHost_cref_QString_quint16_QIODeviceBase_OpenMode_QAbstractSocket_NetworkLayerProtocol(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring hostName0, jint port1, jint openMode2, jint protocol3);
    void __qt_disconnectFromHost(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jint __qt_readData_char_ptr_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobject data0);
    void __qt_resume(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    void __qt_setReadBufferSize_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jlong size0);
    jboolean __qt_setSocketDescriptor_qintptr_QAbstractSocket_SocketState_QIODeviceBase_OpenMode(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jlong socketDescriptor0, jint state1, jint openMode2);
    void __qt_setSocketOption_QAbstractSocket_SocketOption_cref_QVariant(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint option0, jobject value1);
    jlong __qt_skipData_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jlong maxSize0);
    jobject __qt_socketOption_QAbstractSocket_SocketOption(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint option0);
    jboolean __qt_waitForBytesWritten_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint msecs0);
    jboolean __qt_waitForConnected_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint msecs0);
    jboolean __qt_waitForDisconnected_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint msecs0);
    jboolean __qt_waitForReadyRead_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint msecs0);
    jint __qt_writeData_const_char_ptr_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobject data0);
};

#endif // !defined(QT_NO_SSL)
#endif // QSSLSOCKET_SHELL_H
