#include <QtCore/QtGlobal>
#include <QtNetwork/qnetworkcookie.h>
#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qdatetime.h>
#include <QtCore/qurl.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiNetwork/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QNetworkCookie(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QNetworkCookie")
    QNetworkCookie *_ptr = reinterpret_cast<QNetworkCookie *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QNetworkCookie(QByteArray,QByteArray)
void __qt_construct_QNetworkCookie(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QNetworkCookie(QByteArray,QByteArray)")
    Q_UNUSED(__java_arguments)
    QNetworkCookie *__qt_this = new(__qtjambi_ptr) QNetworkCookie();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// new QNetworkCookie(QByteArray,QByteArray)
void __qt_construct_QNetworkCookie_cref_QByteArray(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QNetworkCookie(QByteArray,QByteArray)")
    jobject name0 = __java_arguments[0].l;
    const QByteArray& __qt_name0 = qtjambi_cast<const QByteArray&>(__jni_env, name0);
    QNetworkCookie *__qt_this = new(__qtjambi_ptr) QNetworkCookie(__qt_name0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// new QNetworkCookie(QByteArray,QByteArray)
void __qt_construct_QNetworkCookie_cref_QByteArray_cref_QByteArray(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QNetworkCookie(QByteArray,QByteArray)")
    jobject name0 = __java_arguments[0].l;
    const QByteArray& __qt_name0 = qtjambi_cast<const QByteArray&>(__jni_env, name0);
    jobject value1 = __java_arguments[1].l;
    const QByteArray& __qt_value1 = qtjambi_cast<const QByteArray&>(__jni_env, value1);
    QNetworkCookie *__qt_this = new(__qtjambi_ptr) QNetworkCookie(__qt_name0, __qt_value1);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QNetworkCookie::QNetworkCookie(QByteArray,QByteArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_initialize_1native__Lio_qt_network_QNetworkCookie_2Lio_qt_core_QByteArray_2Lio_qt_core_QByteArray_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject name0,
 jobject value1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QNetworkCookie::QNetworkCookie(QByteArray,QByteArray)")
    QTJAMBI_TRY {
        jvalue arguments[2];
        arguments[0].l = name0;
        arguments[1].l = value1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QNetworkCookie_cref_QByteArray_cref_QByteArray, sizeof(QNetworkCookie), typeid(QNetworkCookie), 0, false, &deleter_QNetworkCookie, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QNetworkCookie(QNetworkCookie)
void __qt_construct_QNetworkCookie_cref_QNetworkCookie(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QNetworkCookie(QNetworkCookie)")
    jobject other0 = __java_arguments[0].l;
    const QNetworkCookie& __qt_other0 = qtjambi_cast<const QNetworkCookie&>(__jni_env, other0);
    QNetworkCookie *__qt_this = new(__qtjambi_ptr) QNetworkCookie(__qt_other0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QNetworkCookie::QNetworkCookie(QNetworkCookie)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_initialize_1native__Lio_qt_network_QNetworkCookie_2Lio_qt_network_QNetworkCookie_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QNetworkCookie::QNetworkCookie(QNetworkCookie)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QNetworkCookie_cref_QNetworkCookie, sizeof(QNetworkCookie), typeid(QNetworkCookie), 0, false, &deleter_QNetworkCookie, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QNetworkCookie
void __qt_destruct_QNetworkCookie(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QNetworkCookie")
    reinterpret_cast<QNetworkCookie*>(ptr)->~QNetworkCookie();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QNetworkCookie::domain()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_domain_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::domain()const", __this_nativeId)
        QString __qt_return_value = __qt_this->domain();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkCookie::expirationDate()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_expirationDate_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::expirationDate()const", __this_nativeId)
        QDateTime __qt_return_value = __qt_this->expirationDate();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkCookie::hasSameIdentifier(QNetworkCookie)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_hasSameIdentifier_1native_1cref_1QNetworkCookie_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::hasSameIdentifier(QNetworkCookie)const", __this_nativeId)
        const QNetworkCookie& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkCookie>(other0);
        __java_return_value = __qt_this->hasSameIdentifier(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkCookie::isHttpOnly()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_isHttpOnly_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::isHttpOnly()const", __this_nativeId)
        __java_return_value = __qt_this->isHttpOnly();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkCookie::isSecure()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_isSecure_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::isSecure()const", __this_nativeId)
        __java_return_value = __qt_this->isSecure();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkCookie::isSessionCookie()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_isSessionCookie_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::isSessionCookie()const", __this_nativeId)
        __java_return_value = __qt_this->isSessionCookie();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkCookie::name()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_name_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::name()const", __this_nativeId)
        QByteArray __qt_return_value = __qt_this->name();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkCookie::normalize(QUrl)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_normalize_1native_1cref_1QUrl__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID url0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::normalize(QUrl)", __this_nativeId)
        const QUrl& __qt_url0 = QtJambiAPI::valueReferenceFromNativeId<QUrl>(url0);
        __qt_this->normalize(__qt_url0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkCookie::operator=(QNetworkCookie)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_assign_1native_1cref_1QNetworkCookie__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::operator=(QNetworkCookie)", __this_nativeId)
        const QNetworkCookie& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkCookie>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkCookie::operator==(QNetworkCookie)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_equals_1native_1cref_1QNetworkCookie_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::operator==(QNetworkCookie)const", __this_nativeId)
        const QNetworkCookie& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QNetworkCookie>(other0);
        __java_return_value = (*__qt_this) == __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkCookie::path()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_path_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::path()const", __this_nativeId)
        QString __qt_return_value = __qt_this->path();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkCookie::sameSitePolicy()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_sameSitePolicy_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::sameSitePolicy()const", __this_nativeId)
        QNetworkCookie::SameSite __qt_return_value = __qt_this->sameSitePolicy();
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkCookie::setDomain(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_setDomain_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring domain0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::setDomain(QString)", __this_nativeId)
        QString  __qt_domain0 = qtjambi_cast<QString>(__jni_env, domain0);
        __qt_this->setDomain(__qt_domain0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkCookie::setExpirationDate(QDateTime)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_setExpirationDate_1native_1cref_1QDateTime__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID date0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::setExpirationDate(QDateTime)", __this_nativeId)
        const QDateTime& __qt_date0 = QtJambiAPI::valueReferenceFromNativeId<QDateTime>(date0);
        __qt_this->setExpirationDate(__qt_date0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkCookie::setHttpOnly(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_setHttpOnly_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean enable0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::setHttpOnly(bool)", __this_nativeId)
        __qt_this->setHttpOnly(static_cast<bool>(enable0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkCookie::setName(QByteArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_setName_1native_1cref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID cookieName0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::setName(QByteArray)", __this_nativeId)
        const QByteArray& __qt_cookieName0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(cookieName0);
        __qt_this->setName(__qt_cookieName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkCookie::setPath(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_setPath_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring path0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::setPath(QString)", __this_nativeId)
        QString  __qt_path0 = qtjambi_cast<QString>(__jni_env, path0);
        __qt_this->setPath(__qt_path0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkCookie::setSameSitePolicy(QNetworkCookie::SameSite)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_setSameSitePolicy_1native_1QNetworkCookie_1SameSite__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint sameSite0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::setSameSitePolicy(QNetworkCookie::SameSite)", __this_nativeId)
        QNetworkCookie::SameSite __qt_sameSite0 = qtjambi_cast<QNetworkCookie::SameSite>(__jni_env, sameSite0);
        __qt_this->setSameSitePolicy(QNetworkCookie::SameSite(__qt_sameSite0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkCookie::setSecure(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_setSecure_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean enable0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::setSecure(bool)", __this_nativeId)
        __qt_this->setSecure(static_cast<bool>(enable0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkCookie::setValue(QByteArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_setValue_1native_1cref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID value0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::setValue(QByteArray)", __this_nativeId)
        const QByteArray& __qt_value0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(value0);
        __qt_this->setValue(__qt_value0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkCookie::swap(QNetworkCookie&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_swap_1native_1ref_1QNetworkCookie__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::swap(QNetworkCookie&)", __this_nativeId)
        QNetworkCookie& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QNetworkCookie>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNetworkCookie::toRawForm(QNetworkCookie::RawForm)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_toRawForm_1native_1QNetworkCookie_1RawForm_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint form0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::toRawForm(QNetworkCookie::RawForm)const", __this_nativeId)
        QNetworkCookie::RawForm __qt_form0 = qtjambi_cast<QNetworkCookie::RawForm>(__jni_env, form0);
        QByteArray __qt_return_value = __qt_this->toRawForm(QNetworkCookie::RawForm(__qt_form0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkCookie::value()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_value_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNetworkCookie::value()const", __this_nativeId)
        QByteArray __qt_return_value = __qt_this->value();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNetworkCookie::parseCookies(QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_parseCookies_1native_1cref_1QByteArray__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID cookieString0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QNetworkCookie::parseCookies(QByteArray)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray& __qt_cookieString0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(cookieString0);
        QList<QNetworkCookie> __qt_return_value = QNetworkCookie::parseCookies(__qt_cookieString0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_network_QNetworkCookie_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QNetworkCookie *__qt_this = QtJambiAPI::objectFromNativeId<QNetworkCookie>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QNetworkCookie(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QNetworkCookie>("QNetworkCookie", "io/qt/network/QNetworkCookie");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, 0, &__qt_destruct_QNetworkCookie, {
        ConstructorInfo(&__qt_construct_QNetworkCookie, nullptr)
       ,ConstructorInfo(&__qt_construct_QNetworkCookie_cref_QByteArray, "Lio/qt/core/QByteArray;")
       ,ConstructorInfo(&__qt_construct_QNetworkCookie_cref_QByteArray_cref_QByteArray, "Lio/qt/core/QByteArray;Lio/qt/core/QByteArray;")
       ,ConstructorInfo(&__qt_construct_QNetworkCookie_cref_QNetworkCookie, "Lio/qt/network/QNetworkCookie;")
    });
// END: function table

    registerMetaObject(typeId, QNetworkCookie::staticMetaObject, false);
// END: signal table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QNetworkCookie);
    registerMetaType<QNetworkCookie>("QNetworkCookie");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QNetworkCookie::RawForm>("QNetworkCookie::RawForm", "io/qt/network/QNetworkCookie$RawForm");
    registerEnumTypeInfo<QNetworkCookie::SameSite>("QNetworkCookie::SameSite", "io/qt/network/QNetworkCookie$SameSite");
// END: enums and flags
}
