/*
 * Decompiled with CFR 0.152.
 */
package io.qt.multimedia;

import io.qt.multimedia.QAudioFormat;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public final class QAudioFrame {
    private final long positionToIndexFunction;

    public static AsByte dataAsAudioFrame(ByteBuffer buffer, QAudioFormat.ChannelConfig config) {
        return new QAudioFrame(config).new AsByte(buffer);
    }

    public static AsShort dataAsAudioFrame(ShortBuffer buffer, QAudioFormat.ChannelConfig config) {
        return new QAudioFrame(config).new AsShort(buffer);
    }

    public static AsInt dataAsAudioFrame(IntBuffer buffer, QAudioFormat.ChannelConfig config) {
        return new QAudioFrame(config).new AsInt(buffer);
    }

    public static AsFloat dataAsAudioFrame(FloatBuffer buffer, QAudioFormat.ChannelConfig config) {
        return new QAudioFrame(config).new AsFloat(buffer);
    }

    QAudioFrame(QAudioFormat.ChannelConfig config) {
        this.positionToIndexFunction = QAudioFrame.getPositionToIndex(config.value());
    }

    private static native int positionToIndex(int var0, long var1);

    private static native long getPositionToIndex(int var0);

    public final class AsByte {
        private final ByteBuffer channels;

        private AsByte(ByteBuffer channels) {
            this.channels = channels;
        }

        public int positionToIndex(QAudioFormat.AudioChannelPosition pos) {
            return QAudioFrame.positionToIndex(pos.value(), QAudioFrame.this.positionToIndexFunction);
        }

        public byte value(QAudioFormat.AudioChannelPosition pos) {
            int idx = this.positionToIndex(pos);
            if (idx < 0) {
                return -128;
            }
            return this.channels.get(idx);
        }

        public void setValue(QAudioFormat.AudioChannelPosition pos, byte val) {
            int idx = this.positionToIndex(pos);
            if (idx < 0) {
                return;
            }
            this.channels.put(idx, val);
        }

        public void clear() {
            this.channels.clear();
            for (int i = 0; i < this.channels.limit(); ++i) {
                this.channels.put(i, (byte)-128);
            }
        }
    }

    public final class AsShort {
        private final ShortBuffer channels;

        private AsShort(ShortBuffer channels) {
            this.channels = channels;
        }

        public int positionToIndex(QAudioFormat.AudioChannelPosition pos) {
            return QAudioFrame.positionToIndex(pos.value(), QAudioFrame.this.positionToIndexFunction);
        }

        public short value(QAudioFormat.AudioChannelPosition pos) {
            int idx = this.positionToIndex(pos);
            if (idx < 0) {
                return 0;
            }
            return this.channels.get(idx);
        }

        public void setValue(QAudioFormat.AudioChannelPosition pos, short val) {
            int idx = this.positionToIndex(pos);
            if (idx < 0) {
                return;
            }
            this.channels.put(idx, val);
        }

        public void clear() {
            this.channels.clear();
            for (int i = 0; i < this.channels.limit(); ++i) {
                this.channels.put(i, (short)0);
            }
        }
    }

    public final class AsInt {
        private final IntBuffer channels;

        private AsInt(IntBuffer channels) {
            this.channels = channels;
        }

        public int positionToIndex(QAudioFormat.AudioChannelPosition pos) {
            return QAudioFrame.positionToIndex(pos.value(), QAudioFrame.this.positionToIndexFunction);
        }

        public int value(QAudioFormat.AudioChannelPosition pos) {
            int idx = this.positionToIndex(pos);
            if (idx < 0) {
                return 0;
            }
            return this.channels.get(idx);
        }

        public void setValue(QAudioFormat.AudioChannelPosition pos, int val) {
            int idx = this.positionToIndex(pos);
            if (idx < 0) {
                return;
            }
            this.channels.put(idx, val);
        }

        public void clear() {
            this.channels.clear();
            for (int i = 0; i < this.channels.limit(); ++i) {
                this.channels.put(i, 0);
            }
        }
    }

    public final class AsFloat {
        private final FloatBuffer channels;

        private AsFloat(FloatBuffer channels) {
            this.channels = channels;
        }

        public int positionToIndex(QAudioFormat.AudioChannelPosition pos) {
            return QAudioFrame.positionToIndex(pos.value(), QAudioFrame.this.positionToIndexFunction);
        }

        public float value(QAudioFormat.AudioChannelPosition pos) {
            int idx = this.positionToIndex(pos);
            if (idx < 0) {
                return 0.0f;
            }
            return this.channels.get(idx);
        }

        public void setValue(QAudioFormat.AudioChannelPosition pos, float val) {
            int idx = this.positionToIndex(pos);
            if (idx < 0) {
                return;
            }
            this.channels.put(idx, val);
        }

        public void clear() {
            this.channels.clear();
            for (int i = 0; i < this.channels.limit(); ++i) {
                this.channels.put(i, 0.0f);
            }
        }
    }
}

