/*
 * Decompiled with CFR 0.152.
 */
package io.qt.multimedia;

import io.qt.NonNull;
import io.qt.Nullable;
import io.qt.QtObject;
import io.qt.QtUninvokable;
import io.qt.StrictNonNull;
import io.qt.core.QByteArray;
import io.qt.multimedia.QAudioFormat;
import io.qt.multimedia.QAudioFrame;
import io.qt.multimedia.QtJambi_LibraryUtilities;
import java.nio.ByteBuffer;
import java.util.Objects;

public class QAudioBuffer
extends QtObject
implements Cloneable {
    public QAudioBuffer() {
        super((QtObject.QPrivateConstructor)null);
        QAudioBuffer.initialize_native(this);
    }

    private static native void initialize_native(QAudioBuffer var0);

    public QAudioBuffer(@NonNull QAudioBuffer other) {
        super((QtObject.QPrivateConstructor)null);
        QAudioBuffer.initialize_native(this, other);
    }

    private static native void initialize_native(QAudioBuffer var0, QAudioBuffer var1);

    public QAudioBuffer(@NonNull QByteArray data, @NonNull QAudioFormat format, long startTime) {
        super((QtObject.QPrivateConstructor)null);
        QAudioBuffer.initialize_native(this, data, format, startTime);
    }

    private static native void initialize_native(QAudioBuffer var0, QByteArray var1, QAudioFormat var2, long var3);

    public QAudioBuffer(int numFrames, @NonNull QAudioFormat format, long startTime) {
        super((QtObject.QPrivateConstructor)null);
        QAudioBuffer.initialize_native(this, numFrames, format, startTime);
    }

    private static native void initialize_native(QAudioBuffer var0, int var1, QAudioFormat var2, long var3);

    @QtUninvokable
    public final long byteCount() {
        return this.byteCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native long byteCount_native_constfct(long var1);

    @QtUninvokable
    public final @Nullable ByteBuffer dataAsReadOnlyBuffer() {
        return this.dataAsReadOnlyBuffer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native ByteBuffer dataAsReadOnlyBuffer_native_constfct(long var1);

    @QtUninvokable
    public final @Nullable ByteBuffer dataAsBuffer() {
        return this.dataAsBuffer_native(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native ByteBuffer dataAsBuffer_native(long var1);

    @QtUninvokable
    public final byte @StrictNonNull [] dataAsArray() {
        return this.dataAsArray_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native byte[] dataAsArray_native_constfct(long var1);

    @QtUninvokable
    public final void detach() {
        this.detach_native(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native void detach_native(long var1);

    @QtUninvokable
    public final long duration() {
        return this.duration_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native long duration_native_constfct(long var1);

    @QtUninvokable
    public final @NonNull QAudioFormat format() {
        return this.format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native QAudioFormat format_native_constfct(long var1);

    @QtUninvokable
    public final long frameCount() {
        return this.frameCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native long frameCount_native_constfct(long var1);

    @QtUninvokable
    public final boolean isValid() {
        return this.isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native boolean isValid_native_constfct(long var1);

    @QtUninvokable
    public final void assign(@NonNull QAudioBuffer other) {
        this.assign_native_cref_QAudioBuffer(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)other));
    }

    @QtUninvokable
    private native void assign_native_cref_QAudioBuffer(long var1, long var3);

    @QtUninvokable
    public final long sampleCount() {
        return this.sampleCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native long sampleCount_native_constfct(long var1);

    @QtUninvokable
    public final long startTime() {
        return this.startTime_native_constfct(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    @QtUninvokable
    private native long startTime_native_constfct(long var1);

    @QtUninvokable
    public final void swap(@StrictNonNull QAudioBuffer other) {
        Objects.requireNonNull(other, "Argument 'other': null not expected.");
        this.swap_native_ref_QAudioBuffer(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this), QtJambi_LibraryUtilities.internal.checkedNativeId((QtObject)other));
    }

    @QtUninvokable
    private native void swap_native_ref_QAudioBuffer(long var1, long var3);

    protected QAudioBuffer(QtObject.QPrivateConstructor p) {
        super(p);
    }

    public final @NonNull QAudioFrame.AsByte dataAsU8M() {
        return QAudioFrame.dataAsAudioFrame(this.dataAsBuffer(), QAudioFormat.ChannelConfig.ChannelConfigMono);
    }

    public final @NonNull QAudioFrame.AsShort dataAsS16M() {
        return QAudioFrame.dataAsAudioFrame(this.dataAsBuffer().asShortBuffer(), QAudioFormat.ChannelConfig.ChannelConfigMono);
    }

    public final @NonNull QAudioFrame.AsInt dataAsS32M() {
        return QAudioFrame.dataAsAudioFrame(this.dataAsBuffer().asIntBuffer(), QAudioFormat.ChannelConfig.ChannelConfigMono);
    }

    public final @NonNull QAudioFrame.AsFloat dataAsF32M() {
        return QAudioFrame.dataAsAudioFrame(this.dataAsBuffer().asFloatBuffer(), QAudioFormat.ChannelConfig.ChannelConfigMono);
    }

    public final @NonNull QAudioFrame.AsByte dataAsU8S() {
        return QAudioFrame.dataAsAudioFrame(this.dataAsBuffer(), QAudioFormat.ChannelConfig.ChannelConfigStereo);
    }

    public final @NonNull QAudioFrame.AsShort dataAsS16S() {
        return QAudioFrame.dataAsAudioFrame(this.dataAsBuffer().asShortBuffer(), QAudioFormat.ChannelConfig.ChannelConfigStereo);
    }

    public final @NonNull QAudioFrame.AsInt dataAsS32S() {
        return QAudioFrame.dataAsAudioFrame(this.dataAsBuffer().asIntBuffer(), QAudioFormat.ChannelConfig.ChannelConfigStereo);
    }

    public final @NonNull QAudioFrame.AsFloat dataAsF32S() {
        return QAudioFrame.dataAsAudioFrame(this.dataAsBuffer().asFloatBuffer(), QAudioFormat.ChannelConfig.ChannelConfigStereo);
    }

    @QtUninvokable
    public QAudioBuffer clone() {
        return QAudioBuffer.clone_native(QtJambi_LibraryUtilities.internal.nativeId((QtObject)this));
    }

    private static native QAudioBuffer clone_native(long var0);

    public QAudioBuffer(@NonNull QByteArray data, @NonNull QAudioFormat format) {
        this(data, format, -1L);
    }

    public QAudioBuffer(byte @NonNull [] data, @NonNull QAudioFormat format) {
        this(data, format, -1L);
    }

    public QAudioBuffer(byte @NonNull [] data, @NonNull QAudioFormat format, long startTime) {
        this(new QByteArray(data), format, startTime);
    }

    public QAudioBuffer(int numFrames, @NonNull QAudioFormat format) {
        this(numFrames, format, -1L);
    }

    static {
        QtJambi_LibraryUtilities.initialize();
    }
}

