package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Enumerations for camera and video functionality</p>
 * <p>Java wrapper for Qt header file <code><a href="https://doc.qt.io/qt/qtvideo.html">QtVideo</a></code></p>
 */
public final class QtVideo
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private QtVideo() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace QtVideo."); }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qtvideo.html#Rotation-enum">QtVideo::Rotation</a></code></p>
     */
    public enum Rotation implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qtvideo.html#Rotation-enum">QtVideo::<wbr/>Rotation::<wbr/>None</a></code></p>
         */
        None(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qtvideo.html#Rotation-enum">QtVideo::<wbr/>Rotation::<wbr/>Clockwise90</a></code></p>
         */
        Clockwise90(90),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qtvideo.html#Rotation-enum">QtVideo::<wbr/>Rotation::<wbr/>Clockwise180</a></code></p>
         */
        Clockwise180(180),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qtvideo.html#Rotation-enum">QtVideo::<wbr/>Rotation::<wbr/>Clockwise270</a></code></p>
         */
        Clockwise270(270);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Rotation(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Rotation resolve(int value) {
            switch (value) {
            case 0: return None;
            case 90: return Clockwise90;
            case 180: return Clockwise180;
            case 270: return Clockwise270;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
}
