package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Contains enums used by the audio classes</p>
 * <p>Java wrapper for Qt header file <code><a href="https://doc.qt.io/qt/qtaudio.html">QtAudio</a></code></p>
 */
public final class QtAudio
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private QtAudio() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace QtAudio."); }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qtaudio.html#Error-enum">QtAudio::Error</a></code></p>
     */
    public enum Error implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qtaudio.html#Error-enum">QtAudio::<wbr/>NoError</a></code></p>
         */
        NoError(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qtaudio.html#Error-enum">QtAudio::<wbr/>OpenError</a></code></p>
         */
        OpenError(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qtaudio.html#Error-enum">QtAudio::<wbr/>IOError</a></code></p>
         */
        IOError(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qtaudio.html#Error-enum">QtAudio::<wbr/>UnderrunError</a></code></p>
         */
        UnderrunError(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qtaudio.html#Error-enum">QtAudio::<wbr/>FatalError</a></code></p>
         */
        FatalError(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Error resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return OpenError;
            case 2: return IOError;
            case 3: return UnderrunError;
            case 4: return FatalError;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qtaudio.html#State-enum">QtAudio::State</a></code></p>
     */
    public enum State implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qtaudio.html#State-enum">QtAudio::<wbr/>ActiveState</a></code></p>
         */
        ActiveState(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qtaudio.html#State-enum">QtAudio::<wbr/>SuspendedState</a></code></p>
         */
        SuspendedState(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qtaudio.html#State-enum">QtAudio::<wbr/>StoppedState</a></code></p>
         */
        StoppedState(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qtaudio.html#State-enum">QtAudio::<wbr/>IdleState</a></code></p>
         */
        IdleState(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private State(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull State resolve(int value) {
            switch (value) {
            case 0: return ActiveState;
            case 1: return SuspendedState;
            case 2: return StoppedState;
            case 3: return IdleState;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qtaudio.html#VolumeScale-enum">QtAudio::VolumeScale</a></code></p>
     */
    public enum VolumeScale implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qtaudio.html#VolumeScale-enum">QtAudio::<wbr/>LinearVolumeScale</a></code></p>
         */
        LinearVolumeScale(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qtaudio.html#VolumeScale-enum">QtAudio::<wbr/>CubicVolumeScale</a></code></p>
         */
        CubicVolumeScale(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qtaudio.html#VolumeScale-enum">QtAudio::<wbr/>LogarithmicVolumeScale</a></code></p>
         */
        LogarithmicVolumeScale(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qtaudio.html#VolumeScale-enum">QtAudio::<wbr/>DecibelVolumeScale</a></code></p>
         */
        DecibelVolumeScale(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private VolumeScale(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull VolumeScale resolve(int value) {
            switch (value) {
            case 0: return LinearVolumeScale;
            case 1: return CubicVolumeScale;
            case 2: return LogarithmicVolumeScale;
            case 3: return DecibelVolumeScale;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qtaudio.html#convertVolume">QtAudio::<wbr/>convertVolume(float,<wbr/>QtAudio::VolumeScale,<wbr/>QtAudio::VolumeScale)</a></code></p>
     */
    public static float convertVolume(float volume, io.qt.multimedia.QtAudio.@NonNull VolumeScale from, io.qt.multimedia.QtAudio.@NonNull VolumeScale to){
        return convertVolume_native_float_QtAudio_VolumeScale_QtAudio_VolumeScale(volume, from.value(), to.value());
    }
    
    private native static float convertVolume_native_float_QtAudio_VolumeScale_QtAudio_VolumeScale(float volume, int from, int to);
    
}
