package io.qt.multimedia;

import io.qt.*;


/**
 * <p>This class is used for capturing a window</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwindowcapture.html">QWindowCapture</a></code></p>
 */
public class QWindowCapture extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWindowCapture.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwindowcapture.html#Error-enum">QWindowCapture::Error</a></code></p>
     */
    public enum Error implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwindowcapture.html#Error-enum">QWindowCapture::<wbr/>NoError</a></code></p>
         */
        NoError(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwindowcapture.html#Error-enum">QWindowCapture::<wbr/>InternalError</a></code></p>
         */
        InternalError(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwindowcapture.html#Error-enum">QWindowCapture::<wbr/>CapturingNotSupported</a></code></p>
         */
        CapturingNotSupported(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwindowcapture.html#Error-enum">QWindowCapture::<wbr/>CaptureFailed</a></code></p>
         */
        CaptureFailed(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwindowcapture.html#Error-enum">QWindowCapture::<wbr/>NotFound</a></code></p>
         */
        NotFound(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Error resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return InternalError;
            case 2: return CapturingNotSupported;
            case 4: return CaptureFailed;
            case 5: return NotFound;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindowcapture.html#active-prop">QWindowCapture::<wbr/>activeChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="active")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> activeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindowcapture.html#errorChanged">QWindowCapture::<wbr/>errorChanged()</a></code></p>
     */
    @QtPropertyNotify(name="error")
    public final @NonNull Signal0 errorChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindowcapture.html#errorOccurred">QWindowCapture::<wbr/>errorOccurred(QWindowCapture::Error,<wbr/>QString)</a></code></p>
     */
    public final @NonNull Signal2<io.qt.multimedia.QWindowCapture.@NonNull Error, java.lang.@NonNull String> errorOccurred = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindowcapture.html#window-prop">QWindowCapture::<wbr/>windowChanged(QCapturableWindow)</a></code></p>
     */
    @QtPropertyNotify(name="window")
    public final @NonNull Signal1<io.qt.multimedia.@NonNull QCapturableWindow> windowChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindowcapture.html#QWindowCapture">QWindowCapture::<wbr/>QWindowCapture(QObject*)</a></code></p>
     */
    public QWindowCapture(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QWindowCapture instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code>QWindowCapture::<wbr/>captureSession()const</code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QMediaCaptureSession captureSession(){
        return captureSession_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QMediaCaptureSession captureSession_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindowcapture.html#error-prop">QWindowCapture::<wbr/>error()const</a></code></p>
     */
    @QtPropertyReader(name="error")
    @QtUninvokable
    public final io.qt.multimedia.QWindowCapture.@NonNull Error error(){
        return io.qt.multimedia.QWindowCapture.Error.resolve(error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int error_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindowcapture.html#errorString-prop">QWindowCapture::<wbr/>errorString()const</a></code></p>
     */
    @QtPropertyReader(name="errorString")
    @QtUninvokable
    public final java.lang.@NonNull String errorString(){
        return errorString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String errorString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindowcapture.html#active-prop">QWindowCapture::<wbr/>isActive()const</a></code></p>
     */
    @QtPropertyReader(name="active")
    @QtUninvokable
    public final boolean isActive(){
        return isActive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isActive_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindowcapture.html#active-prop">QWindowCapture::<wbr/>setActive(bool)</a></code></p>
     */
    @QtPropertyWriter(name="active")
    public final void setActive(boolean active){
        setActive_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), active);
    }
    
    private native void setActive_native_bool(long __this__nativeId, boolean active);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindowcapture.html#window-prop">QWindowCapture::<wbr/>setWindow(QCapturableWindow)</a></code></p>
     */
    @QtPropertyWriter(name="window")
    @QtUninvokable
    public final void setWindow(io.qt.multimedia.@NonNull QCapturableWindow window){
        setWindow_native_QCapturableWindow(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(window));
    }
    
    @QtUninvokable
    private native void setWindow_native_QCapturableWindow(long __this__nativeId, long window);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindowcapture.html#start">QWindowCapture::<wbr/>start()</a></code></p>
     */
    public final void start(){
        start_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void start_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindowcapture.html#stop">QWindowCapture::<wbr/>stop()</a></code></p>
     */
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stop_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindowcapture.html#window-prop">QWindowCapture::<wbr/>window()const</a></code></p>
     */
    @QtPropertyReader(name="window")
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QCapturableWindow window(){
        return window_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QCapturableWindow window_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwindowcapture.html#capturableWindows">QWindowCapture::<wbr/>capturableWindows()</a></code></p>
     */
    public native static io.qt.core.@NonNull QList<io.qt.multimedia.@NonNull QCapturableWindow> capturableWindows();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QWindowCapture(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QWindowCapture(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QWindowCapture instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QWindowCapture(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QWindowCapture() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #error()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QWindowCapture.@NonNull Error getError() {
        return error();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #errorString()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getErrorString() {
        return errorString();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isActive()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getActive() {
        return isActive();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #window()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QCapturableWindow getWindow() {
        return window();
    }
}
