package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Represents a generic sink for video data</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qvideosink.html">QVideoSink</a></code></p>
 */
public class QVideoSink extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcRhi = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QVideoSink.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideosink.html#subtitleText-prop">QVideoSink::<wbr/>subtitleTextChanged(QString)const</a></code></p>
     */
    @QtPropertyNotify(name="subtitleText")
    public final @NonNull Signal1<java.lang.@NonNull String> subtitleTextChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideosink.html#videoFrameChanged">QVideoSink::<wbr/>videoFrameChanged(QVideoFrame)const</a></code></p>
     * <p><b>Make sure to dispose frame object at the end of the slot!</b></p>
     */
    public final @NonNull Signal1<io.qt.multimedia.@NonNull QVideoFrame> videoFrameChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideosink.html#videoSize-prop">QVideoSink::<wbr/>videoSizeChanged()</a></code></p>
     */
    @QtPropertyNotify(name="videoSize")
    public final @NonNull Signal0 videoSizeChanged = new Signal0();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideosink.html#QVideoSink">QVideoSink::<wbr/>QVideoSink(QObject*)</a></code></p>
     */
    public QVideoSink(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QVideoSink instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideosink.html#rhi">QVideoSink::<wbr/>rhi()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.rhi.@Nullable QRhi rhi(){
        return rhi_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.rhi.QRhi rhi_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QVideoSink::<wbr/>setRhi(QRhi*)</code></p>
     */
    @QtUninvokable
    public final void setRhi(io.qt.gui.rhi.@Nullable QRhi rhi){
        setRhi_native_QRhi_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhi));
        __rcRhi = rhi;
    }
    
    @QtUninvokable
    private native void setRhi_native_QRhi_ptr(long __this__nativeId, long rhi);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideosink.html#setSubtitleText">QVideoSink::<wbr/>setSubtitleText(QString)</a></code></p>
     */
    @QtPropertyWriter(name="subtitleText")
    @QtUninvokable
    public final void setSubtitleText(java.lang.@NonNull String subtitle){
        setSubtitleText_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), subtitle);
    }
    
    @QtUninvokable
    private native void setSubtitleText_native_cref_QString(long __this__nativeId, java.lang.String subtitle);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideosink.html#setVideoFrame">QVideoSink::<wbr/>setVideoFrame(QVideoFrame)</a></code></p>
     */
    @QtUninvokable
    public final void setVideoFrame(io.qt.multimedia.@NonNull QVideoFrame frame){
        setVideoFrame_native_cref_QVideoFrame(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(frame));
    }
    
    @QtUninvokable
    private native void setVideoFrame_native_cref_QVideoFrame(long __this__nativeId, long frame);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideosink.html#subtitleText-prop">QVideoSink::<wbr/>subtitleText()const</a></code></p>
     */
    @QtPropertyReader(name="subtitleText")
    @QtUninvokable
    public final java.lang.@NonNull String subtitleText(){
        return subtitleText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String subtitleText_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideosink.html#videoFrame">QVideoSink::<wbr/>videoFrame()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QVideoFrame videoFrame(){
        return videoFrame_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QVideoFrame videoFrame_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideosink.html#videoSize-prop">QVideoSink::<wbr/>videoSize()const</a></code></p>
     */
    @QtPropertyReader(name="videoSize")
    @QtUninvokable
    public final io.qt.core.@NonNull QSize videoSize(){
        return videoSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSize videoSize_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QVideoSink(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QVideoSink(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QVideoSink instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QVideoSink(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QVideoSink() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded function for {@link #setVideoFrame(io.qt.multimedia.QVideoFrame)}.</p>
     */
    @QtUninvokable
    public final void setVideoFrame(io.qt.multimedia.@NonNull QVideoFrameFormat frame) {
        setVideoFrame(new io.qt.multimedia.QVideoFrame(frame));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #subtitleText()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getSubtitleText() {
        return subtitleText();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #videoSize()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QSize getVideoSize() {
        return videoSize();
    }
}
