package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Specifies the stream format of a video presentation surface</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qvideoframeformat.html">QVideoFrameFormat</a></code></p>
 */
public class QVideoFrameFormat extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#ColorRange-enum">QVideoFrameFormat::ColorRange</a></code></p>
     */
    public enum ColorRange implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#ColorRange-enum">QVideoFrameFormat::<wbr/>ColorRange_Unknown</a></code></p>
         */
        ColorRange_Unknown(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#ColorRange-enum">QVideoFrameFormat::<wbr/>ColorRange_Video</a></code></p>
         */
        ColorRange_Video(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#ColorRange-enum">QVideoFrameFormat::<wbr/>ColorRange_Full</a></code></p>
         */
        ColorRange_Full(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ColorRange(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ColorRange resolve(int value) {
            switch (value) {
            case 0: return ColorRange_Unknown;
            case 1: return ColorRange_Video;
            case 2: return ColorRange_Full;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#ColorSpace-enum">QVideoFrameFormat::ColorSpace</a></code></p>
     */
    public enum ColorSpace implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#ColorSpace-enum">QVideoFrameFormat::<wbr/>ColorSpace_Undefined</a></code></p>
         */
        ColorSpace_Undefined(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#ColorSpace-enum">QVideoFrameFormat::<wbr/>ColorSpace_BT601</a></code></p>
         */
        ColorSpace_BT601(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#ColorSpace-enum">QVideoFrameFormat::<wbr/>ColorSpace_BT709</a></code></p>
         */
        ColorSpace_BT709(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#ColorSpace-enum">QVideoFrameFormat::<wbr/>ColorSpace_AdobeRgb</a></code></p>
         */
        ColorSpace_AdobeRgb(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#ColorSpace-enum">QVideoFrameFormat::<wbr/>ColorSpace_BT2020</a></code></p>
         */
        ColorSpace_BT2020(6);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ColorSpace(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ColorSpace resolve(int value) {
            switch (value) {
            case 0: return ColorSpace_Undefined;
            case 1: return ColorSpace_BT601;
            case 2: return ColorSpace_BT709;
            case 5: return ColorSpace_AdobeRgb;
            case 6: return ColorSpace_BT2020;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#ColorTransfer-enum">QVideoFrameFormat::ColorTransfer</a></code></p>
     */
    public enum ColorTransfer implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#ColorTransfer-enum">QVideoFrameFormat::<wbr/>ColorTransfer_Unknown</a></code></p>
         */
        ColorTransfer_Unknown(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#ColorTransfer-enum">QVideoFrameFormat::<wbr/>ColorTransfer_BT709</a></code></p>
         */
        ColorTransfer_BT709(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#ColorTransfer-enum">QVideoFrameFormat::<wbr/>ColorTransfer_BT601</a></code></p>
         */
        ColorTransfer_BT601(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#ColorTransfer-enum">QVideoFrameFormat::<wbr/>ColorTransfer_Linear</a></code></p>
         */
        ColorTransfer_Linear(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#ColorTransfer-enum">QVideoFrameFormat::<wbr/>ColorTransfer_Gamma22</a></code></p>
         */
        ColorTransfer_Gamma22(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#ColorTransfer-enum">QVideoFrameFormat::<wbr/>ColorTransfer_Gamma28</a></code></p>
         */
        ColorTransfer_Gamma28(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#ColorTransfer-enum">QVideoFrameFormat::<wbr/>ColorTransfer_ST2084</a></code></p>
         */
        ColorTransfer_ST2084(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#ColorTransfer-enum">QVideoFrameFormat::<wbr/>ColorTransfer_STD_B67</a></code></p>
         */
        ColorTransfer_STD_B67(7);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ColorTransfer(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ColorTransfer resolve(int value) {
            switch (value) {
            case 0: return ColorTransfer_Unknown;
            case 1: return ColorTransfer_BT709;
            case 2: return ColorTransfer_BT601;
            case 3: return ColorTransfer_Linear;
            case 4: return ColorTransfer_Gamma22;
            case 5: return ColorTransfer_Gamma28;
            case 6: return ColorTransfer_ST2084;
            case 7: return ColorTransfer_STD_B67;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#Direction-enum">QVideoFrameFormat::Direction</a></code></p>
     */
    public enum Direction implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#Direction-enum">QVideoFrameFormat::<wbr/>TopToBottom</a></code></p>
         */
        TopToBottom(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#Direction-enum">QVideoFrameFormat::<wbr/>BottomToTop</a></code></p>
         */
        BottomToTop(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Direction(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Direction resolve(int value) {
            switch (value) {
            case 0: return TopToBottom;
            case 1: return BottomToTop;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::PixelFormat</a></code></p>
     */
    public enum PixelFormat implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_Invalid</a></code></p>
         */
        Format_Invalid(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_ARGB8888</a></code></p>
         */
        Format_ARGB8888(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_ARGB8888_Premultiplied</a></code></p>
         */
        Format_ARGB8888_Premultiplied(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_XRGB8888</a></code></p>
         */
        Format_XRGB8888(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_BGRA8888</a></code></p>
         */
        Format_BGRA8888(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_BGRA8888_Premultiplied</a></code></p>
         */
        Format_BGRA8888_Premultiplied(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_BGRX8888</a></code></p>
         */
        Format_BGRX8888(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_ABGR8888</a></code></p>
         */
        Format_ABGR8888(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_XBGR8888</a></code></p>
         */
        Format_XBGR8888(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_RGBA8888</a></code></p>
         */
        Format_RGBA8888(9),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_RGBX8888</a></code></p>
         */
        Format_RGBX8888(10),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_AYUV</a></code></p>
         */
        Format_AYUV(11),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_AYUV_Premultiplied</a></code></p>
         */
        Format_AYUV_Premultiplied(12),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_YUV420P</a></code></p>
         */
        Format_YUV420P(13),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_YUV422P</a></code></p>
         */
        Format_YUV422P(14),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_YV12</a></code></p>
         */
        Format_YV12(15),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_UYVY</a></code></p>
         */
        Format_UYVY(16),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_YUYV</a></code></p>
         */
        Format_YUYV(17),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_NV12</a></code></p>
         */
        Format_NV12(18),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_NV21</a></code></p>
         */
        Format_NV21(19),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_IMC1</a></code></p>
         */
        Format_IMC1(20),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_IMC2</a></code></p>
         */
        Format_IMC2(21),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_IMC3</a></code></p>
         */
        Format_IMC3(22),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_IMC4</a></code></p>
         */
        Format_IMC4(23),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_Y8</a></code></p>
         */
        Format_Y8(24),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_Y16</a></code></p>
         */
        Format_Y16(25),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_P010</a></code></p>
         */
        Format_P010(26),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_P016</a></code></p>
         */
        Format_P016(27),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_SamplerExternalOES</a></code></p>
         */
        Format_SamplerExternalOES(28),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_Jpeg</a></code></p>
         */
        Format_Jpeg(29),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_SamplerRect</a></code></p>
         */
        Format_SamplerRect(30),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#PixelFormat-enum">QVideoFrameFormat::<wbr/>Format_YUV420P10</a></code></p>
         */
        Format_YUV420P10(31);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PixelFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PixelFormat resolve(int value) {
            switch (value) {
            case 0: return Format_Invalid;
            case 1: return Format_ARGB8888;
            case 2: return Format_ARGB8888_Premultiplied;
            case 3: return Format_XRGB8888;
            case 4: return Format_BGRA8888;
            case 5: return Format_BGRA8888_Premultiplied;
            case 6: return Format_BGRX8888;
            case 7: return Format_ABGR8888;
            case 8: return Format_XBGR8888;
            case 9: return Format_RGBA8888;
            case 10: return Format_RGBX8888;
            case 11: return Format_AYUV;
            case 12: return Format_AYUV_Premultiplied;
            case 13: return Format_YUV420P;
            case 14: return Format_YUV422P;
            case 15: return Format_YV12;
            case 16: return Format_UYVY;
            case 17: return Format_YUYV;
            case 18: return Format_NV12;
            case 19: return Format_NV21;
            case 20: return Format_IMC1;
            case 21: return Format_IMC2;
            case 22: return Format_IMC3;
            case 23: return Format_IMC4;
            case 24: return Format_Y8;
            case 25: return Format_Y16;
            case 26: return Format_P010;
            case 27: return Format_P016;
            case 28: return Format_SamplerExternalOES;
            case 29: return Format_Jpeg;
            case 30: return Format_SamplerRect;
            case 31: return Format_YUV420P10;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code>QVideoFrameFormat::YCbCrColorSpace</code></p>
     */
    public enum YCbCrColorSpace implements QtEnumerator {
        /**
         * <p>Representing <code>QVideoFrameFormat::<wbr/>YCbCr_Undefined</code></p>
         */
        YCbCr_Undefined(0),
        /**
         * <p>Representing <code>QVideoFrameFormat::<wbr/>YCbCr_BT601</code></p>
         */
        YCbCr_BT601(1),
        /**
         * <p>Representing <code>QVideoFrameFormat::<wbr/>YCbCr_BT709</code></p>
         */
        YCbCr_BT709(2),
        /**
         * <p>Representing <code>QVideoFrameFormat::<wbr/>YCbCr_xvYCC601</code></p>
         */
        YCbCr_xvYCC601(3),
        /**
         * <p>Representing <code>QVideoFrameFormat::<wbr/>YCbCr_xvYCC709</code></p>
         */
        YCbCr_xvYCC709(4),
        /**
         * <p>Representing <code>QVideoFrameFormat::<wbr/>YCbCr_JPEG</code></p>
         */
        YCbCr_JPEG(5),
        /**
         * <p>Representing <code>QVideoFrameFormat::<wbr/>YCbCr_BT2020</code></p>
         */
        YCbCr_BT2020(6);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private YCbCrColorSpace(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull YCbCrColorSpace resolve(int value) {
            switch (value) {
            case 0: return YCbCr_Undefined;
            case 1: return YCbCr_BT601;
            case 2: return YCbCr_BT709;
            case 3: return YCbCr_xvYCC601;
            case 4: return YCbCr_xvYCC709;
            case 5: return YCbCr_JPEG;
            case 6: return YCbCr_BT2020;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#QVideoFrameFormat">QVideoFrameFormat::<wbr/>QVideoFrameFormat()</a></code></p>
     */
    public QVideoFrameFormat(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QVideoFrameFormat instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#QVideoFrameFormat-1">QVideoFrameFormat::<wbr/>QVideoFrameFormat(QSize,<wbr/>QVideoFrameFormat::PixelFormat)</a></code></p>
     */
    public QVideoFrameFormat(io.qt.core.@NonNull QSize size, io.qt.multimedia.QVideoFrameFormat.@NonNull PixelFormat pixelFormat){
        super((QPrivateConstructor)null);
        initialize_native(this, size, pixelFormat);
    }
    
    private native static void initialize_native(QVideoFrameFormat instance, io.qt.core.QSize size, io.qt.multimedia.QVideoFrameFormat.PixelFormat pixelFormat);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#QVideoFrameFormat-2">QVideoFrameFormat::<wbr/>QVideoFrameFormat(QVideoFrameFormat)</a></code></p>
     */
    public QVideoFrameFormat(io.qt.multimedia.@NonNull QVideoFrameFormat format){
        super((QPrivateConstructor)null);
        initialize_native(this, format);
    }
    
    private native static void initialize_native(QVideoFrameFormat instance, io.qt.multimedia.QVideoFrameFormat format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#colorRange">QVideoFrameFormat::<wbr/>colorRange()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.QVideoFrameFormat.@NonNull ColorRange colorRange(){
        return io.qt.multimedia.QVideoFrameFormat.ColorRange.resolve(colorRange_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int colorRange_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#colorSpace">QVideoFrameFormat::<wbr/>colorSpace()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.QVideoFrameFormat.@NonNull ColorSpace colorSpace(){
        return io.qt.multimedia.QVideoFrameFormat.ColorSpace.resolve(colorSpace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int colorSpace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#colorTransfer">QVideoFrameFormat::<wbr/>colorTransfer()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.QVideoFrameFormat.@NonNull ColorTransfer colorTransfer(){
        return io.qt.multimedia.QVideoFrameFormat.ColorTransfer.resolve(colorTransfer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int colorTransfer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QVideoFrameFormat::<wbr/>detach()</code></p>
     */
    @QtUninvokable
    public final void detach(){
        detach_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void detach_native(long __this__nativeId);
    
    /**
     * <p>See <code>QVideoFrameFormat::<wbr/>fragmentShaderFileName()const</code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String fragmentShaderFileName(){
        return fragmentShaderFileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String fragmentShaderFileName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#frameHeight">QVideoFrameFormat::<wbr/>frameHeight()const</a></code></p>
     */
    @QtUninvokable
    public final int frameHeight(){
        return frameHeight_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int frameHeight_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#frameRate">QVideoFrameFormat::<wbr/>frameRate()const</a></code></p>
     */
    @QtUninvokable
    public final double frameRate(){
        return frameRate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double frameRate_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#frameSize">QVideoFrameFormat::<wbr/>frameSize()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QSize frameSize(){
        return frameSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSize frameSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#frameWidth">QVideoFrameFormat::<wbr/>frameWidth()const</a></code></p>
     */
    @QtUninvokable
    public final int frameWidth(){
        return frameWidth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int frameWidth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#isMirrored">QVideoFrameFormat::<wbr/>isMirrored()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isMirrored(){
        return isMirrored_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isMirrored_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#isValid">QVideoFrameFormat::<wbr/>isValid()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QVideoFrameFormat::<wbr/>maxLuminance()const</code></p>
     */
    @QtUninvokable
    public final float maxLuminance(){
        return maxLuminance_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float maxLuminance_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#operator-eq-1">QVideoFrameFormat::<wbr/>operator=(QVideoFrameFormat)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.multimedia.@NonNull QVideoFrameFormat format){
        assign_native_cref_QVideoFrameFormat(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(format));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QVideoFrameFormat(long __this__nativeId, long format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#operator-eq-eq">QVideoFrameFormat::<wbr/>operator==(QVideoFrameFormat)const</a></code></p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.multimedia.@NonNull QVideoFrameFormat format){
        return equals_native_cref_QVideoFrameFormat_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(format));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QVideoFrameFormat_constfct(long __this__nativeId, long format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#pixelFormat">QVideoFrameFormat::<wbr/>pixelFormat()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.QVideoFrameFormat.@NonNull PixelFormat pixelFormat(){
        return io.qt.multimedia.QVideoFrameFormat.PixelFormat.resolve(pixelFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int pixelFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#planeCount">QVideoFrameFormat::<wbr/>planeCount()const</a></code></p>
     */
    @QtUninvokable
    public final int planeCount(){
        return planeCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int planeCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#scanLineDirection">QVideoFrameFormat::<wbr/>scanLineDirection()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.QVideoFrameFormat.@NonNull Direction scanLineDirection(){
        return io.qt.multimedia.QVideoFrameFormat.Direction.resolve(scanLineDirection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int scanLineDirection_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#setColorRange">QVideoFrameFormat::<wbr/>setColorRange(QVideoFrameFormat::ColorRange)</a></code></p>
     */
    @QtUninvokable
    public final void setColorRange(io.qt.multimedia.QVideoFrameFormat.@NonNull ColorRange range){
        setColorRange_native_QVideoFrameFormat_ColorRange(QtJambi_LibraryUtilities.internal.nativeId(this), range.value());
    }
    
    @QtUninvokable
    private native void setColorRange_native_QVideoFrameFormat_ColorRange(long __this__nativeId, int range);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#setColorSpace">QVideoFrameFormat::<wbr/>setColorSpace(QVideoFrameFormat::ColorSpace)</a></code></p>
     */
    @QtUninvokable
    public final void setColorSpace(io.qt.multimedia.QVideoFrameFormat.@NonNull ColorSpace colorSpace){
        setColorSpace_native_QVideoFrameFormat_ColorSpace(QtJambi_LibraryUtilities.internal.nativeId(this), colorSpace.value());
    }
    
    @QtUninvokable
    private native void setColorSpace_native_QVideoFrameFormat_ColorSpace(long __this__nativeId, int colorSpace);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#setColorTransfer">QVideoFrameFormat::<wbr/>setColorTransfer(QVideoFrameFormat::ColorTransfer)</a></code></p>
     */
    @QtUninvokable
    public final void setColorTransfer(io.qt.multimedia.QVideoFrameFormat.@NonNull ColorTransfer colorTransfer){
        setColorTransfer_native_QVideoFrameFormat_ColorTransfer(QtJambi_LibraryUtilities.internal.nativeId(this), colorTransfer.value());
    }
    
    @QtUninvokable
    private native void setColorTransfer_native_QVideoFrameFormat_ColorTransfer(long __this__nativeId, int colorTransfer);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#setFrameRate">QVideoFrameFormat::<wbr/>setFrameRate(qreal)</a></code></p>
     */
    @QtUninvokable
    public final void setFrameRate(double rate){
        setFrameRate_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), rate);
    }
    
    @QtUninvokable
    private native void setFrameRate_native_qreal(long __this__nativeId, double rate);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#setFrameSize">QVideoFrameFormat::<wbr/>setFrameSize(QSize)</a></code></p>
     */
    @QtUninvokable
    public final void setFrameSize(io.qt.core.@NonNull QSize size){
        setFrameSize_native_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @QtUninvokable
    private native void setFrameSize_native_cref_QSize(long __this__nativeId, long size);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#setFrameSize-1">QVideoFrameFormat::<wbr/>setFrameSize(int,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setFrameSize(int width, int height){
        setFrameSize_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), width, height);
    }
    
    @QtUninvokable
    private native void setFrameSize_native_int_int(long __this__nativeId, int width, int height);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#setMaxLuminance">QVideoFrameFormat::<wbr/>setMaxLuminance(float)</a></code></p>
     */
    @QtUninvokable
    public final void setMaxLuminance(float lum){
        setMaxLuminance_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), lum);
    }
    
    @QtUninvokable
    private native void setMaxLuminance_native_float(long __this__nativeId, float lum);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#setMirrored">QVideoFrameFormat::<wbr/>setMirrored(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setMirrored(boolean mirrored){
        setMirrored_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), mirrored);
    }
    
    @QtUninvokable
    private native void setMirrored_native_bool(long __this__nativeId, boolean mirrored);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#setScanLineDirection">QVideoFrameFormat::<wbr/>setScanLineDirection(QVideoFrameFormat::Direction)</a></code></p>
     */
    @QtUninvokable
    public final void setScanLineDirection(io.qt.multimedia.QVideoFrameFormat.@NonNull Direction direction){
        setScanLineDirection_native_QVideoFrameFormat_Direction(QtJambi_LibraryUtilities.internal.nativeId(this), direction.value());
    }
    
    @QtUninvokable
    private native void setScanLineDirection_native_QVideoFrameFormat_Direction(long __this__nativeId, int direction);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#setViewport">QVideoFrameFormat::<wbr/>setViewport(QRect)</a></code></p>
     */
    @QtUninvokable
    public final void setViewport(io.qt.core.@NonNull QRect viewport){
        setViewport_native_cref_QRect(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(viewport));
    }
    
    @QtUninvokable
    private native void setViewport_native_cref_QRect(long __this__nativeId, long viewport);
    
    /**
     * <p>See <code>QVideoFrameFormat::<wbr/>setYCbCrColorSpace(QVideoFrameFormat::YCbCrColorSpace)</code></p>
     */
    @QtUninvokable
    public final void setYCbCrColorSpace(io.qt.multimedia.QVideoFrameFormat.@NonNull YCbCrColorSpace colorSpace){
        setYCbCrColorSpace_native_QVideoFrameFormat_YCbCrColorSpace(QtJambi_LibraryUtilities.internal.nativeId(this), colorSpace.value());
    }
    
    @QtUninvokable
    private native void setYCbCrColorSpace_native_QVideoFrameFormat_YCbCrColorSpace(long __this__nativeId, int colorSpace);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#swap">QVideoFrameFormat::<wbr/>swap(QVideoFrameFormat&amp;)</a></code></p>
     */
    @QtUninvokable
    public final void swap(io.qt.multimedia.@StrictNonNull QVideoFrameFormat other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QVideoFrameFormat(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QVideoFrameFormat(long __this__nativeId, long other);
    
    /**
     * <p>See <code>QVideoFrameFormat::<wbr/>updateUniformData(QByteArray*,<wbr/>QVideoFrame,<wbr/>QMatrix4x4,<wbr/>float)const</code></p>
     */
    @QtUninvokable
    public final void updateUniformData(io.qt.core.@Nullable QByteArray dst, io.qt.multimedia.@NonNull QVideoFrame frame, io.qt.gui.@NonNull QMatrix4x4 transform, float opacity){
        updateUniformData_native_QByteArray_ptr_cref_QVideoFrame_cref_QMatrix4x4_float_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(dst), QtJambi_LibraryUtilities.internal.checkedNativeId(frame), QtJambi_LibraryUtilities.internal.checkedNativeId(transform), opacity);
    }
    
    @QtUninvokable
    private native void updateUniformData_native_QByteArray_ptr_cref_QVideoFrame_cref_QMatrix4x4_float_constfct(long __this__nativeId, long dst, long frame, long transform, float opacity);
    
    /**
     * <p>See <code>QVideoFrameFormat::<wbr/>vertexShaderFileName()const</code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String vertexShaderFileName(){
        return vertexShaderFileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String vertexShaderFileName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#viewport">QVideoFrameFormat::<wbr/>viewport()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QRect viewport(){
        return viewport_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRect viewport_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QVideoFrameFormat::<wbr/>yCbCrColorSpace()const</code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.QVideoFrameFormat.@NonNull YCbCrColorSpace yCbCrColorSpace(){
        return io.qt.multimedia.QVideoFrameFormat.YCbCrColorSpace.resolve(yCbCrColorSpace_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int yCbCrColorSpace_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#imageFormatFromPixelFormat">QVideoFrameFormat::<wbr/>imageFormatFromPixelFormat(QVideoFrameFormat::PixelFormat)</a></code></p>
     */
    public static io.qt.gui.QImage.@NonNull Format imageFormatFromPixelFormat(io.qt.multimedia.QVideoFrameFormat.@NonNull PixelFormat format){
        return io.qt.gui.QImage.Format.resolve(imageFormatFromPixelFormat_native_QVideoFrameFormat_PixelFormat(format.value()));
    }
    
    private native static int imageFormatFromPixelFormat_native_QVideoFrameFormat_PixelFormat(int format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#pixelFormatFromImageFormat">QVideoFrameFormat::<wbr/>pixelFormatFromImageFormat(QImage::Format)</a></code></p>
     */
    public static io.qt.multimedia.QVideoFrameFormat.@NonNull PixelFormat pixelFormatFromImageFormat(io.qt.gui.QImage.@NonNull Format format){
        return io.qt.multimedia.QVideoFrameFormat.PixelFormat.resolve(pixelFormatFromImageFormat_native_QImage_Format(format.value()));
    }
    
    private native static int pixelFormatFromImageFormat_native_QImage_Format(int format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#pixelFormatToString">QVideoFrameFormat::<wbr/>pixelFormatToString(QVideoFrameFormat::PixelFormat)</a></code></p>
     */
    public static java.lang.@NonNull String pixelFormatToString(io.qt.multimedia.QVideoFrameFormat.@NonNull PixelFormat pixelFormat){
        return pixelFormatToString_native_QVideoFrameFormat_PixelFormat(pixelFormat.value());
    }
    
    private native static java.lang.String pixelFormatToString_native_QVideoFrameFormat_PixelFormat(int pixelFormat);
    
    /**
     * <p>See <code>QVideoFrameFormat::<wbr/>NPixelFormats</code></p>
     */
    private native static int NPixelFormats();
    
    /**
     * <p>See <code>QVideoFrameFormat::<wbr/>NPixelFormats</code></p>
     */
    public static final int NPixelFormats = NPixelFormats();

    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QVideoFrameFormat(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#operator-eq-eq">QVideoFrameFormat::<wbr/>operator==(QVideoFrameFormat)const</a></code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.multimedia.QVideoFrameFormat) {
            return equals((io.qt.multimedia.QVideoFrameFormat) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QVideoFrameFormat)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);

    /**
     * <p>See <code>operator&lt;&lt;(QDebug,<wbr/>QVideoFrameFormat)</code></p>
     */
    @QtUninvokable
    @Override
    public @NonNull String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="https://doc.qt.io/qt/qvideoframeformat.html#QVideoFrameFormat-2">QVideoFrameFormat::<wbr/>QVideoFrameFormat(QVideoFrameFormat)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QVideoFrameFormat clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QVideoFrameFormat clone_native(long __this_nativeId);
    
    /**
     * <p>Overloaded function for {@link #updateUniformData(io.qt.core.QByteArray, io.qt.multimedia.QVideoFrame, io.qt.gui.QMatrix4x4, float)}.</p>
     */
    @QtUninvokable
    public final void updateUniformData(io.qt.core.@Nullable QByteArray dst, io.qt.multimedia.@NonNull QVideoFrameFormat frame, io.qt.gui.@NonNull QMatrix4x4 transform, float opacity) {
        updateUniformData(dst, new io.qt.multimedia.QVideoFrame(frame), transform, opacity);
    }
    
    /**
     * <p>Overloaded function for {@link #updateUniformData(io.qt.core.QByteArray, io.qt.multimedia.QVideoFrame, io.qt.gui.QMatrix4x4, float)}.</p>
     */
    @QtUninvokable
    public final void updateUniformData(io.qt.core.@Nullable QByteArray dst, io.qt.multimedia.@NonNull QVideoFrame frame, io.qt.gui.@NonNull QTransform transform, float opacity) {
        updateUniformData(dst, frame, new io.qt.gui.QMatrix4x4(transform), opacity);
    }
    
    /**
     * <p>Overloaded function for {@link #updateUniformData(io.qt.core.QByteArray, io.qt.multimedia.QVideoFrame, io.qt.gui.QMatrix4x4, float)}.</p>
     */
    @QtUninvokable
    public final void updateUniformData(io.qt.core.@Nullable QByteArray dst, io.qt.multimedia.@NonNull QVideoFrameFormat frame, io.qt.gui.@NonNull QTransform transform, float opacity) {
        updateUniformData(dst, new io.qt.multimedia.QVideoFrame(frame), new io.qt.gui.QMatrix4x4(transform), opacity);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #NPixelFormats()} instead.</p>
     */
    private static int getNPixelFormats() {
        return NPixelFormats();
    }
}
