package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Represents a frame of video data</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qvideoframe.html">QVideoFrame</a></code></p>
 */
public class QVideoFrame extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qvideoframe.html#HandleType-enum">QVideoFrame::HandleType</a></code></p>
     */
    public enum HandleType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframe.html#HandleType-enum">QVideoFrame::<wbr/>NoHandle</a></code></p>
         */
        NoHandle(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframe.html#HandleType-enum">QVideoFrame::<wbr/>RhiTextureHandle</a></code></p>
         */
        RhiTextureHandle(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private HandleType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull HandleType resolve(int value) {
            switch (value) {
            case 0: return NoHandle;
            case 1: return RhiTextureHandle;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qvideoframe.html#MapMode-enum">QVideoFrame::MapMode</a></code></p>
     */
    public enum MapMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframe.html#MapMode-enum">QVideoFrame::<wbr/>NotMapped</a></code></p>
         */
        NotMapped(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframe.html#MapMode-enum">QVideoFrame::<wbr/>ReadOnly</a></code></p>
         */
        ReadOnly(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframe.html#MapMode-enum">QVideoFrame::<wbr/>WriteOnly</a></code></p>
         */
        WriteOnly(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qvideoframe.html#MapMode-enum">QVideoFrame::<wbr/>ReadWrite</a></code></p>
         */
        ReadWrite(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private MapMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull MapMode resolve(int value) {
            switch (value) {
            case 0: return NotMapped;
            case 1: return ReadOnly;
            case 2: return WriteOnly;
            case 3: return ReadWrite;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code>QVideoFrame::RotationAngle</code></p>
     */
    public enum RotationAngle implements QtEnumerator {
        @Deprecated
        /**
         * <p>Representing <code>QVideoFrame::<wbr/>Rotation0</code></p>
         * @deprecated Use QtVideo::Rotation::None instead
         */
        Rotation0(0),
        @Deprecated
        /**
         * <p>Representing <code>QVideoFrame::<wbr/>Rotation90</code></p>
         * @deprecated Use QtVideo::Rotation::Clockwise90 instead
         */
        Rotation90(90),
        @Deprecated
        /**
         * <p>Representing <code>QVideoFrame::<wbr/>Rotation180</code></p>
         * @deprecated Use QtVideo::Rotation::Clockwise180 instead
         */
        Rotation180(180),
        @Deprecated
        /**
         * <p>Representing <code>QVideoFrame::<wbr/>Rotation270</code></p>
         * @deprecated Use QtVideo::Rotation::Clockwise270 instead
         */
        Rotation270(270);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RotationAngle(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull RotationAngle resolve(int value) {
            switch (value) {
            case 0: return Rotation0;
            case 90: return Rotation90;
            case 180: return Rotation180;
            case 270: return Rotation270;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Java wrapper for Qt class <code>QVideoFrame::PaintOptions</code></p>
     */
    public static class PaintOptions extends QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        /**
         * <p>Java wrapper for Qt enum <code>QVideoFrame::PaintOptions::PaintFlag</code></p>
         * 
         * @see PaintFlags
         */
        public enum PaintFlag implements QtFlagEnumerator {
            /**
             * <p>Representing <code>QVideoFrame::<wbr/>PaintOptions::<wbr/>DontDrawSubtitles</code></p>
             */
            DontDrawSubtitles(1);

            static {
                QtJambi_LibraryUtilities.initialize();
            }

            private PaintFlag(int value) {
                this.value = value;
            }

            /**
             * {@inheritDoc}
             */
            public int value() {
                return value;
            }

            /**
             * Create a QFlags of the enum entry.
             * @return QFlags
             */
            public @NonNull PaintFlags asFlags() {
                return new PaintFlags(value);
            }

            /**
             * Combines this entry with other enum entry.
             * @param e enum entry
             * @return new flag
             */
            public @NonNull PaintFlags combined(@NonNull PaintFlag e) {
                return asFlags().setFlag(e, true);
            }

            /**
             * Excludes other enum entry from a flag of this entry.
             * @param e enum entry
             * @return new flag
             */
            public @NonNull PaintFlags cleared(@NonNull PaintFlag e) {
                return asFlags().setFlag(e, false);
            }

            /**
             * Creates a new {@link PaintFlags} from the entries.
             * @param values entries
             * @return new flag
             */
            public static @NonNull PaintFlags flags(@Nullable PaintFlag @NonNull... values) {
                return new PaintFlags(values);
            }

            /**
             * Returns the corresponding enum entry for the given value.
             * @param value
             * @return enum entry
             */
            public static @NonNull PaintFlag resolve(int value) {
                switch (value) {
                case 1: return DontDrawSubtitles;
                default: throw new QNoSuchEnumValueException(value);
                }
            }


            private final int value;
        }
        
        /**
         * {@link QFlags} type for enum {@link PaintFlag}
         */
        public static final class PaintFlags extends QFlags<PaintFlag> implements Comparable<PaintFlags> {
            private static final long serialVersionUID = 0x6242deb0fcce5fd7L;
            static {
                QtJambi_LibraryUtilities.initialize();
            }

            /**
             * Creates a new PaintFlags where the flags in <code>args</code> are set.
             * @param args enum entries
             */
            public PaintFlags(@Nullable PaintFlag @NonNull... args){
                super(args);
            }

            /**
             * Creates a new PaintFlags with given <code>value</code>.
             * @param value
             */
            public PaintFlags(int value) {
                super(value);
            }

            /**
             * Combines this flags with enum entry.
             * @param e enum entry
             * @return new PaintFlags
             */
            @Override
            public final @NonNull PaintFlags combined(@StrictNonNull PaintFlag e){
                return new PaintFlags(value() | e.value());
            }

            /**
             * Sets the flag <code>e</code>
             * @param e enum entry
             * @return this
             */
            public final @NonNull PaintFlags setFlag(@Nullable PaintFlag e){
                return setFlag(e, true);
            }

            /**
             * Sets or clears the flag <code>flag</code>
             * @param e enum entry
             * @param on set (true) or clear (false)
             * @return this
             */
            public final @NonNull PaintFlags setFlag(@Nullable PaintFlag e, boolean on){
                if (on) {
                	setValue(value() | e.value());
                }else {
                	setValue(value() & ~e.value());
                }
                return this;
            }

            /**
             * Returns an array of flag objects represented by this PaintFlags.
             * @return array of enum entries
             */
            @Override
            public final @NonNull PaintFlag @NonNull[] flags(){
                return super.flags(PaintFlag.values());
            }

            /**
             * {@inheritDoc}
             */
            @Override
            public final @NonNull PaintFlags clone(){
                return new PaintFlags(value());
            }

            /**
             * {@inheritDoc}
             */
            @Override
            public final int compareTo(@StrictNonNull PaintFlags other){
                return Integer.compare(value(), other.value());
            }
        }
        
        
        /**
         * <p>See <code>QVideoFrame::PaintOptions::<wbr/>PaintOptions()</code></p>
         */
        public PaintOptions(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(PaintOptions instance);
        
        /**
         * <p>See <code>QVideoFrame::PaintOptions::<wbr/>PaintOptions(QVideoFrame::PaintOptions)</code></p>
         */
        public PaintOptions(io.qt.multimedia.QVideoFrame.@NonNull PaintOptions other){
            super((QPrivateConstructor)null);
            initialize_native(this, other);
        }
        
        private native static void initialize_native(PaintOptions instance, io.qt.multimedia.QVideoFrame.PaintOptions other);
        
        /**
         * <p>See <code>QVideoFrame::PaintOptions::<wbr/>PaintOptions{QColor,<wbr/>Qt::AspectRatioMode,<wbr/>QVideoFrame::PaintOptions::PaintFlags}</code></p>
         */
        public PaintOptions(io.qt.gui.@NonNull QColor backgroundColor, io.qt.core.Qt.@NonNull AspectRatioMode aspectRatioMode, io.qt.multimedia.QVideoFrame.PaintOptions.@NonNull PaintFlags paintFlags){
            super((QPrivateConstructor)null);
            initialize_native(this, backgroundColor, aspectRatioMode, paintFlags);
        }
        
        private native static void initialize_native(PaintOptions instance, io.qt.gui.QColor backgroundColor, io.qt.core.Qt.AspectRatioMode aspectRatioMode, io.qt.multimedia.QVideoFrame.PaintOptions.PaintFlags paintFlags);
        
        /**
         * <p>See <code>operator==(QVideoFrame::PaintOptions,<wbr/>QVideoFrame::PaintOptions)</code></p>
         */
        @QtUninvokable
        public final boolean equals(io.qt.multimedia.QVideoFrame.@NonNull PaintOptions value2){
            return equals_native_cref_QVideoFrame_PaintOptions(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(value2));
        }
        
        @QtUninvokable
        private native boolean equals_native_cref_QVideoFrame_PaintOptions(long __this__nativeId, long value2);
        
        /**
         * <p>See <code>QVideoFrame::PaintOptions::<wbr/>aspectRatioMode</code></p>
         */
        @QtUninvokable
        public final void setAspectRatioMode(io.qt.core.Qt.@NonNull AspectRatioMode aspectRatioMode){
            setAspectRatioMode_native_cref_Qt_AspectRatioMode(QtJambi_LibraryUtilities.internal.nativeId(this), aspectRatioMode.value());
        }
        
        @QtUninvokable
        private native void setAspectRatioMode_native_cref_Qt_AspectRatioMode(long __this__nativeId, int aspectRatioMode);
        
        /**
         * <p>See <code>QVideoFrame::PaintOptions::<wbr/>aspectRatioMode</code></p>
         */
        @QtUninvokable
        public final io.qt.core.Qt.@NonNull AspectRatioMode aspectRatioMode(){
            return io.qt.core.Qt.AspectRatioMode.resolve(aspectRatioMode_native(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        @QtUninvokable
        private native int aspectRatioMode_native(long __this__nativeId);
        
        /**
         * <p>See <code>QVideoFrame::PaintOptions::<wbr/>backgroundColor</code></p>
         */
        @QtUninvokable
        public final void setBackgroundColor(io.qt.gui.@NonNull QColor backgroundColor){
            setBackgroundColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(backgroundColor));
        }
        
        @QtUninvokable
        private native void setBackgroundColor_native_cref_QColor(long __this__nativeId, long backgroundColor);
        
        /**
         * <p>See <code>QVideoFrame::PaintOptions::<wbr/>backgroundColor</code></p>
         */
        @QtUninvokable
        public final io.qt.gui.@NonNull QColor backgroundColor(){
            return backgroundColor_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native io.qt.gui.QColor backgroundColor_native(long __this__nativeId);
        
        /**
         * <p>See <code>QVideoFrame::PaintOptions::<wbr/>paintFlags</code></p>
         */
        @QtUninvokable
        public final void setPaintFlags(io.qt.multimedia.QVideoFrame.PaintOptions.@NonNull PaintFlags paintFlags){
            setPaintFlags_native_cref_QVideoFrame_PaintOptions_PaintFlags(QtJambi_LibraryUtilities.internal.nativeId(this), paintFlags.value());
        }
        
        @QtUninvokable
        private native void setPaintFlags_native_cref_QVideoFrame_PaintOptions_PaintFlags(long __this__nativeId, int paintFlags);
        
        /**
         * <p>See <code>QVideoFrame::PaintOptions::<wbr/>paintFlags</code></p>
         */
        @QtUninvokable
        public final io.qt.multimedia.QVideoFrame.PaintOptions.@NonNull PaintFlags paintFlags(){
            return new io.qt.multimedia.QVideoFrame.PaintOptions.PaintFlags(paintFlags_native(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        @QtUninvokable
        private native int paintFlags_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected PaintOptions(QPrivateConstructor p) { super(p); } 
        

        /**
         * <p>See <code>operator==(QVideoFrame::PaintOptions,<wbr/>QVideoFrame::PaintOptions)</code></p>
         */
        @Override
        @QtUninvokable
        public boolean equals(Object other) {
            if (other instanceof io.qt.multimedia.QVideoFrame.PaintOptions) {
                return equals((io.qt.multimedia.QVideoFrame.PaintOptions) other);
            }

            return false;
        }


        /**
         * Returns the objects's hash code computed by <code>qHash(QVideoFrame::PaintOptions)</code>.
         */
        @QtUninvokable
        @Override
        public int hashCode() {
            return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native static int hashCode_native(long __this_nativeId);
        
        /**
         * <p>Creates and returns a copy of this object.</p>
        <p>See <code>QVideoFrame::PaintOptions::<wbr/>PaintOptions(QVideoFrame::PaintOptions)</code></p>
         */
        @QtUninvokable
        @Override
        public PaintOptions clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private static native PaintOptions clone_native(long __this_nativeId);
        
        /**
         * <p>Overloaded constructor for {@link #PaintOptions(io.qt.gui.QColor, io.qt.core.Qt.AspectRatioMode, io.qt.multimedia.QVideoFrame.PaintOptions.PaintFlags)}.</p>
         */
        public PaintOptions(io.qt.core.Qt.@NonNull GlobalColor backgroundColor, io.qt.core.Qt.@NonNull AspectRatioMode aspectRatioMode, io.qt.multimedia.QVideoFrame.PaintOptions.@NonNull PaintFlags paintFlags) {
            this(new io.qt.gui.QColor(backgroundColor), aspectRatioMode, paintFlags);
        }
        
        /**
         * <p>Overloaded constructor for {@link #PaintOptions(io.qt.gui.QColor, io.qt.core.Qt.AspectRatioMode, io.qt.multimedia.QVideoFrame.PaintOptions.PaintFlags)}.</p>
         */
        public PaintOptions(io.qt.gui.@NonNull QRgba64 backgroundColor, io.qt.core.Qt.@NonNull AspectRatioMode aspectRatioMode, io.qt.multimedia.QVideoFrame.PaintOptions.@NonNull PaintFlags paintFlags) {
            this(new io.qt.gui.QColor(backgroundColor), aspectRatioMode, paintFlags);
        }
        
        /**
         * <p>Overloaded constructor for {@link #PaintOptions(io.qt.gui.QColor, io.qt.core.Qt.AspectRatioMode, io.qt.multimedia.QVideoFrame.PaintOptions.PaintFlags)}.</p>
         */
        public PaintOptions(java.lang.@NonNull String backgroundColor, io.qt.core.Qt.@NonNull AspectRatioMode aspectRatioMode, io.qt.multimedia.QVideoFrame.PaintOptions.@NonNull PaintFlags paintFlags) {
            this(new io.qt.gui.QColor(backgroundColor), aspectRatioMode, paintFlags);
        }
        
        /**
         * <p>Overloaded constructor for {@link #PaintOptions(io.qt.gui.QColor, io.qt.core.Qt.AspectRatioMode, io.qt.multimedia.QVideoFrame.PaintOptions.PaintFlags)}.</p>
         */
        public PaintOptions(io.qt.gui.@NonNull QColor backgroundColor, io.qt.core.Qt.@NonNull AspectRatioMode aspectRatioMode, io.qt.multimedia.QVideoFrame.PaintOptions.@NonNull PaintFlag @NonNull... paintFlags) {
            this(backgroundColor, aspectRatioMode, new io.qt.multimedia.QVideoFrame.PaintOptions.PaintFlags(paintFlags));
        }
        
        /**
         * <p>Overloaded constructor for {@link #PaintOptions(io.qt.gui.QColor, io.qt.core.Qt.AspectRatioMode, io.qt.multimedia.QVideoFrame.PaintOptions.PaintFlags)}.</p>
         */
        public PaintOptions(io.qt.core.Qt.@NonNull GlobalColor backgroundColor, io.qt.core.Qt.@NonNull AspectRatioMode aspectRatioMode, io.qt.multimedia.QVideoFrame.PaintOptions.@NonNull PaintFlag @NonNull... paintFlags) {
            this(new io.qt.gui.QColor(backgroundColor), aspectRatioMode, new io.qt.multimedia.QVideoFrame.PaintOptions.PaintFlags(paintFlags));
        }
        
        /**
         * <p>Overloaded constructor for {@link #PaintOptions(io.qt.gui.QColor, io.qt.core.Qt.AspectRatioMode, io.qt.multimedia.QVideoFrame.PaintOptions.PaintFlags)}.</p>
         */
        public PaintOptions(io.qt.gui.@NonNull QRgba64 backgroundColor, io.qt.core.Qt.@NonNull AspectRatioMode aspectRatioMode, io.qt.multimedia.QVideoFrame.PaintOptions.@NonNull PaintFlag @NonNull... paintFlags) {
            this(new io.qt.gui.QColor(backgroundColor), aspectRatioMode, new io.qt.multimedia.QVideoFrame.PaintOptions.PaintFlags(paintFlags));
        }
        
        /**
         * <p>Overloaded constructor for {@link #PaintOptions(io.qt.gui.QColor, io.qt.core.Qt.AspectRatioMode, io.qt.multimedia.QVideoFrame.PaintOptions.PaintFlags)}.</p>
         */
        public PaintOptions(java.lang.@NonNull String backgroundColor, io.qt.core.Qt.@NonNull AspectRatioMode aspectRatioMode, io.qt.multimedia.QVideoFrame.PaintOptions.@NonNull PaintFlag @NonNull... paintFlags) {
            this(new io.qt.gui.QColor(backgroundColor), aspectRatioMode, new io.qt.multimedia.QVideoFrame.PaintOptions.PaintFlags(paintFlags));
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #aspectRatioMode()} instead.</p>
         */
        @QtUninvokable
        public final io.qt.core.Qt.@NonNull AspectRatioMode getAspectRatioMode() {
            return aspectRatioMode();
        }
        
        /**
         * <p>Overloaded function for {@link #setBackgroundColor(io.qt.gui.QColor)}.</p>
         */
        @QtUninvokable
        public final void setBackgroundColor(io.qt.core.Qt.@NonNull GlobalColor backgroundColor) {
            setBackgroundColor(new io.qt.gui.QColor(backgroundColor));
        }
        
        /**
         * <p>Overloaded function for {@link #setBackgroundColor(io.qt.gui.QColor)}.</p>
         */
        @QtUninvokable
        public final void setBackgroundColor(io.qt.gui.@NonNull QRgba64 backgroundColor) {
            setBackgroundColor(new io.qt.gui.QColor(backgroundColor));
        }
        
        /**
         * <p>Overloaded function for {@link #setBackgroundColor(io.qt.gui.QColor)}.</p>
         */
        @QtUninvokable
        public final void setBackgroundColor(java.lang.@NonNull String backgroundColor) {
            setBackgroundColor(new io.qt.gui.QColor(backgroundColor));
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #backgroundColor()} instead.</p>
         */
        @QtUninvokable
        public final io.qt.gui.@NonNull QColor getBackgroundColor() {
            return backgroundColor();
        }
        
        /**
         * <p>Overloaded function for {@link #setPaintFlags(io.qt.multimedia.QVideoFrame.PaintOptions.PaintFlags)}.</p>
         */
        @QtUninvokable
        public final void setPaintFlags(io.qt.multimedia.QVideoFrame.PaintOptions.@NonNull PaintFlag @NonNull... paintFlags) {
            setPaintFlags(new io.qt.multimedia.QVideoFrame.PaintOptions.PaintFlags(paintFlags));
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #paintFlags()} instead.</p>
         */
        @QtUninvokable
        public final io.qt.multimedia.QVideoFrame.PaintOptions.@NonNull PaintFlags getPaintFlags() {
            return paintFlags();
        }
    }

    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#QVideoFrame">QVideoFrame::<wbr/>QVideoFrame()</a></code></p>
     */
    public QVideoFrame(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QVideoFrame instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#QVideoFrame-2">QVideoFrame::<wbr/>QVideoFrame(QVideoFrame)</a></code></p>
     */
    public QVideoFrame(io.qt.multimedia.@NonNull QVideoFrame other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QVideoFrame instance, io.qt.multimedia.QVideoFrame other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#QVideoFrame-1">QVideoFrame::<wbr/>QVideoFrame(QVideoFrameFormat)</a></code></p>
     */
    public QVideoFrame(io.qt.multimedia.@NonNull QVideoFrameFormat format){
        super((QPrivateConstructor)null);
        initialize_native(this, format);
    }
    
    private native static void initialize_native(QVideoFrame instance, io.qt.multimedia.QVideoFrameFormat format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#bits">QVideoFrame::<wbr/>bits(int)</a></code></p>
     */
    @QtUninvokable
    public final java.nio.@Nullable ByteBuffer buffer(int plane){
        return buffer_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), plane);
    }
    
    @QtUninvokable
    private native java.nio.ByteBuffer buffer_native_int(long __this__nativeId, int plane);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#bits-1">QVideoFrame::<wbr/>bits(int)const</a></code></p>
     */
    @QtUninvokable
    public final byte @StrictNonNull[] bits(int plane){
        return bits_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), plane);
    }
    
    @QtUninvokable
    private native byte[] bits_native_int_constfct(long __this__nativeId, int plane);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#bytesPerLine">QVideoFrame::<wbr/>bytesPerLine(int)const</a></code></p>
     */
    @QtUninvokable
    public final int bytesPerLine(int plane){
        return bytesPerLine_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), plane);
    }
    
    @QtUninvokable
    private native int bytesPerLine_native_int_constfct(long __this__nativeId, int plane);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#endTime">QVideoFrame::<wbr/>endTime()const</a></code></p>
     */
    @QtUninvokable
    public final long endTime(){
        return endTime_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long endTime_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#handleType">QVideoFrame::<wbr/>handleType()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.QVideoFrame.@NonNull HandleType handleType(){
        return io.qt.multimedia.QVideoFrame.HandleType.resolve(handleType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int handleType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#height">QVideoFrame::<wbr/>height()const</a></code></p>
     */
    @QtUninvokable
    public final int height(){
        return height_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int height_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#isMapped">QVideoFrame::<wbr/>isMapped()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isMapped(){
        return isMapped_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isMapped_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#isReadable">QVideoFrame::<wbr/>isReadable()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isReadable(){
        return isReadable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isReadable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#isValid">QVideoFrame::<wbr/>isValid()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#isWritable">QVideoFrame::<wbr/>isWritable()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isWritable(){
        return isWritable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isWritable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#map">QVideoFrame::<wbr/>map(QVideoFrame::MapMode)</a></code></p>
     */
    @QtUninvokable
    public final boolean map(io.qt.multimedia.QVideoFrame.@NonNull MapMode mode){
        return map_native_QVideoFrame_MapMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @QtUninvokable
    private native boolean map_native_QVideoFrame_MapMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#mapMode">QVideoFrame::<wbr/>mapMode()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.QVideoFrame.@NonNull MapMode mapMode(){
        return io.qt.multimedia.QVideoFrame.MapMode.resolve(mapMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int mapMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#mappedBytes">QVideoFrame::<wbr/>mappedBytes(int)const</a></code></p>
     */
    @QtUninvokable
    public final int mappedBytes(int plane){
        return mappedBytes_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), plane);
    }
    
    @QtUninvokable
    private native int mappedBytes_native_int_constfct(long __this__nativeId, int plane);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#mirrored">QVideoFrame::<wbr/>mirrored()const</a></code></p>
     */
    @QtUninvokable
    public final boolean mirrored(){
        return mirrored_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean mirrored_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#operator-eq-1">QVideoFrame::<wbr/>operator=(QVideoFrame)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.multimedia.@NonNull QVideoFrame other){
        assign_native_cref_QVideoFrame(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QVideoFrame(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#operator-eq-eq">QVideoFrame::<wbr/>operator==(QVideoFrame)const</a></code></p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.multimedia.@NonNull QVideoFrame other){
        return equals_native_cref_QVideoFrame_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QVideoFrame_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#paint">QVideoFrame::<wbr/>paint(QPainter*,<wbr/>QRectF,<wbr/>QVideoFrame::PaintOptions)</a></code></p>
     */
    @QtUninvokable
    public final void paint(io.qt.gui.@Nullable QPainter painter, io.qt.core.@NonNull QRectF rect, io.qt.multimedia.QVideoFrame.@NonNull PaintOptions options){
        paint_native_QPainter_ptr_cref_QRectF_cref_QVideoFrame_PaintOptions(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(painter), QtJambi_LibraryUtilities.internal.checkedNativeId(rect), QtJambi_LibraryUtilities.internal.checkedNativeId(options));
    }
    
    @QtUninvokable
    private native void paint_native_QPainter_ptr_cref_QRectF_cref_QVideoFrame_PaintOptions(long __this__nativeId, long painter, long rect, long options);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#pixelFormat">QVideoFrame::<wbr/>pixelFormat()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.QVideoFrameFormat.@NonNull PixelFormat pixelFormat(){
        return io.qt.multimedia.QVideoFrameFormat.PixelFormat.resolve(pixelFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int pixelFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#planeCount">QVideoFrame::<wbr/>planeCount()const</a></code></p>
     */
    @QtUninvokable
    public final int planeCount(){
        return planeCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int planeCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#rotation">QVideoFrame::<wbr/>rotation()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.QtVideo.@NonNull Rotation rotation(){
        return io.qt.multimedia.QtVideo.Rotation.resolve(rotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int rotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QVideoFrame::<wbr/>rotationAngle()const</code></p>
     * 
     * @deprecated Use {@link io.qt.multimedia.QVideoFrame#rotation()} instead
     */
    @Deprecated
    @QtUninvokable
    public final io.qt.multimedia.QVideoFrame.@NonNull RotationAngle rotationAngle(){
        return io.qt.multimedia.QVideoFrame.RotationAngle.resolve(rotationAngle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @Deprecated
    @QtUninvokable
    private native int rotationAngle_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#setEndTime">QVideoFrame::<wbr/>setEndTime(qint64)</a></code></p>
     */
    @QtUninvokable
    public final void setEndTime(long time){
        setEndTime_native_qint64(QtJambi_LibraryUtilities.internal.nativeId(this), time);
    }
    
    @QtUninvokable
    private native void setEndTime_native_qint64(long __this__nativeId, long time);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#setMirrored">QVideoFrame::<wbr/>setMirrored(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setMirrored(boolean arg__1){
        setMirrored_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void setMirrored_native_bool(long __this__nativeId, boolean arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#setRotation">QVideoFrame::<wbr/>setRotation(QtVideo::Rotation)</a></code></p>
     */
    @QtUninvokable
    public final void setRotation(io.qt.multimedia.QtVideo.@NonNull Rotation angle){
        setRotation_native_QtVideo_Rotation(QtJambi_LibraryUtilities.internal.nativeId(this), angle.value());
    }
    
    @QtUninvokable
    private native void setRotation_native_QtVideo_Rotation(long __this__nativeId, int angle);
    
    /**
     * <p>See <code>QVideoFrame::<wbr/>setRotationAngle(QVideoFrame::RotationAngle)</code></p>
     * 
     * @deprecated Use {@link io.qt.multimedia.QVideoFrame#setRotation(io.qt.multimedia.QtVideo.Rotation)} instead
     */
    @Deprecated
    @QtUninvokable
    public final void setRotationAngle(io.qt.multimedia.QVideoFrame.@NonNull RotationAngle angle){
        setRotationAngle_native_QVideoFrame_RotationAngle(QtJambi_LibraryUtilities.internal.nativeId(this), angle.value());
    }
    
    @Deprecated
    @QtUninvokable
    private native void setRotationAngle_native_QVideoFrame_RotationAngle(long __this__nativeId, int angle);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#setStartTime">QVideoFrame::<wbr/>setStartTime(qint64)</a></code></p>
     */
    @QtUninvokable
    public final void setStartTime(long time){
        setStartTime_native_qint64(QtJambi_LibraryUtilities.internal.nativeId(this), time);
    }
    
    @QtUninvokable
    private native void setStartTime_native_qint64(long __this__nativeId, long time);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#setSubtitleText">QVideoFrame::<wbr/>setSubtitleText(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setSubtitleText(java.lang.@NonNull String text){
        setSubtitleText_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), text);
    }
    
    @QtUninvokable
    private native void setSubtitleText_native_cref_QString(long __this__nativeId, java.lang.String text);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#size">QVideoFrame::<wbr/>size()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QSize size(){
        return size_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSize size_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#startTime">QVideoFrame::<wbr/>startTime()const</a></code></p>
     */
    @QtUninvokable
    public final long startTime(){
        return startTime_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long startTime_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#subtitleText">QVideoFrame::<wbr/>subtitleText()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String subtitleText(){
        return subtitleText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String subtitleText_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#surfaceFormat">QVideoFrame::<wbr/>surfaceFormat()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QVideoFrameFormat surfaceFormat(){
        return surfaceFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QVideoFrameFormat surfaceFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#swap">QVideoFrame::<wbr/>swap(QVideoFrame&amp;)</a></code></p>
     */
    @QtUninvokable
    public final void swap(io.qt.multimedia.@StrictNonNull QVideoFrame other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QVideoFrame(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QVideoFrame(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#toImage">QVideoFrame::<wbr/>toImage()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QImage toImage(){
        return toImage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QImage toImage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#unmap">QVideoFrame::<wbr/>unmap()</a></code></p>
     */
    @QtUninvokable
    public final void unmap(){
        unmap_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void unmap_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#width">QVideoFrame::<wbr/>width()const</a></code></p>
     */
    @QtUninvokable
    public final int width(){
        return width_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int width_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QVideoFrame(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#operator-eq-eq">QVideoFrame::<wbr/>operator==(QVideoFrame)const</a></code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.multimedia.QVideoFrame) {
            return equals((io.qt.multimedia.QVideoFrame) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QVideoFrame)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);

    /**
     * <p>See <code>operator&lt;&lt;(QDebug,<wbr/>QVideoFrame)</code></p>
     */
    @QtUninvokable
    @Override
    public @NonNull String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="https://doc.qt.io/qt/qvideoframe.html#QVideoFrame-2">QVideoFrame::<wbr/>QVideoFrame(QVideoFrame)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QVideoFrame clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QVideoFrame clone_native(long __this_nativeId);
    
    /**
     * @deprecated Use {@link #assign(io.qt.multimedia.QVideoFrame)} instead.
     */
    @Deprecated
    @QtUninvokable
    public final void set(io.qt.multimedia.@NonNull QVideoFrame other) {
        assign(other);
    }
    
    /**
     * @deprecated Use {@link #assign(io.qt.multimedia.QVideoFrameFormat)} instead.
     */
    @Deprecated
    @QtUninvokable
    public final void set(io.qt.multimedia.@NonNull QVideoFrameFormat other) {
        assign(new io.qt.multimedia.QVideoFrame(other));
    }
    
    /**
     * <p>Overloaded function for {@link #assign(io.qt.multimedia.QVideoFrame)}.</p>
     */
    @QtUninvokable
    public final void assign(io.qt.multimedia.@NonNull QVideoFrameFormat other) {
        assign(new io.qt.multimedia.QVideoFrame(other));
    }
    
    /**
     * <p>Overloaded function for {@link #equals(io.qt.multimedia.QVideoFrame)}.</p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.multimedia.@NonNull QVideoFrameFormat other) {
        return equals(new io.qt.multimedia.QVideoFrame(other));
    }
    
    /**
     * <p>Overloaded function for {@link #paint(io.qt.gui.QPainter, io.qt.core.QRectF, io.qt.multimedia.QVideoFrame.PaintOptions)}.</p>
     */
    @QtUninvokable
    public final void paint(io.qt.gui.@Nullable QPainter painter, io.qt.core.@NonNull QRect rect, io.qt.multimedia.QVideoFrame.@NonNull PaintOptions options) {
        paint(painter, new io.qt.core.QRectF(rect), options);
    }
}
