package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Way to play low latency sound effects</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qsoundeffect.html">QSoundEffect</a></code></p>
 */
public class QSoundEffect extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSoundEffect.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qsoundeffect.html#Loop-enum">QSoundEffect::Loop</a></code></p>
     */
    public enum Loop implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsoundeffect.html#Loop-enum">QSoundEffect::<wbr/>Infinite</a></code></p>
         */
        Infinite(-2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Loop(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Loop resolve(int value) {
            switch (value) {
            case -2: return Infinite;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qsoundeffect.html#Status-enum">QSoundEffect::Status</a></code></p>
     */
    public enum Status implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsoundeffect.html#Status-enum">QSoundEffect::<wbr/>Null</a></code></p>
         */
        Null(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsoundeffect.html#Status-enum">QSoundEffect::<wbr/>Loading</a></code></p>
         */
        Loading(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsoundeffect.html#Status-enum">QSoundEffect::<wbr/>Ready</a></code></p>
         */
        Ready(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qsoundeffect.html#Status-enum">QSoundEffect::<wbr/>Error</a></code></p>
         */
        Error(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Status(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Status resolve(int value) {
            switch (value) {
            case 0: return Null;
            case 1: return Loading;
            case 2: return Ready;
            case 3: return Error;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#audioDevice-prop">QSoundEffect::<wbr/>audioDeviceChanged()</a></code></p>
     */
    @QtPropertyNotify(name="audioDevice")
    public final @NonNull Signal0 audioDeviceChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#loadedChanged">QSoundEffect::<wbr/>loadedChanged()</a></code></p>
     */
    public final @NonNull Signal0 loadedChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#loopCountChanged">QSoundEffect::<wbr/>loopCountChanged()</a></code></p>
     */
    @QtPropertyNotify(name="loops")
    public final @NonNull Signal0 loopCountChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#loopsRemainingChanged">QSoundEffect::<wbr/>loopsRemainingChanged()</a></code></p>
     */
    @QtPropertyNotify(name="loopsRemaining")
    public final @NonNull Signal0 loopsRemainingChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#mutedChanged">QSoundEffect::<wbr/>mutedChanged()</a></code></p>
     */
    @QtPropertyNotify(name="muted")
    public final @NonNull Signal0 mutedChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#playingChanged">QSoundEffect::<wbr/>playingChanged()</a></code></p>
     */
    @QtPropertyNotify(name="playing")
    public final @NonNull Signal0 playingChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#sourceChanged">QSoundEffect::<wbr/>sourceChanged()</a></code></p>
     */
    @QtPropertyNotify(name="source")
    public final @NonNull Signal0 sourceChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#statusChanged">QSoundEffect::<wbr/>statusChanged()</a></code></p>
     */
    @QtPropertyNotify(name="status")
    public final @NonNull Signal0 statusChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#volumeChanged">QSoundEffect::<wbr/>volumeChanged()</a></code></p>
     */
    @QtPropertyNotify(name="volume")
    public final @NonNull Signal0 volumeChanged = new Signal0();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#QSoundEffect-1">QSoundEffect::<wbr/>QSoundEffect(QAudioDevice,<wbr/>QObject*)</a></code></p>
     */
    public QSoundEffect(io.qt.multimedia.@NonNull QAudioDevice audioDevice, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, audioDevice, parent);
    }
    
    private native static void initialize_native(QSoundEffect instance, io.qt.multimedia.QAudioDevice audioDevice, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#QSoundEffect">QSoundEffect::<wbr/>QSoundEffect(QObject*)</a></code></p>
     */
    public QSoundEffect(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSoundEffect instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#audioDevice-prop">QSoundEffect::<wbr/>audioDevice()</a></code></p>
     */
    @QtPropertyReader(name="audioDevice")
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QAudioDevice audioDevice(){
        return audioDevice_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QAudioDevice audioDevice_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#isLoaded">QSoundEffect::<wbr/>isLoaded()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isLoaded(){
        return isLoaded_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isLoaded_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#isMuted">QSoundEffect::<wbr/>isMuted()const</a></code></p>
     */
    @QtPropertyReader(name="muted")
    @QtUninvokable
    public final boolean isMuted(){
        return isMuted_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isMuted_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#isPlaying">QSoundEffect::<wbr/>isPlaying()const</a></code></p>
     */
    @QtPropertyReader(name="playing")
    @QtUninvokable
    public final boolean isPlaying(){
        return isPlaying_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isPlaying_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#loopCount">QSoundEffect::<wbr/>loopCount()const</a></code></p>
     */
    @QtPropertyReader(name="loops")
    @QtUninvokable
    public final int loopCount(){
        return loopCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int loopCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#loopsRemaining-prop">QSoundEffect::<wbr/>loopsRemaining()const</a></code></p>
     */
    @QtPropertyReader(name="loopsRemaining")
    @QtUninvokable
    public final int loopsRemaining(){
        return loopsRemaining_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int loopsRemaining_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#play">QSoundEffect::<wbr/>play()</a></code></p>
     */
    public final void play(){
        play_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void play_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#audioDevice-prop">QSoundEffect::<wbr/>setAudioDevice(QAudioDevice)</a></code></p>
     */
    @QtPropertyWriter(name="audioDevice")
    @QtUninvokable
    public final void setAudioDevice(io.qt.multimedia.@NonNull QAudioDevice device){
        setAudioDevice_native_cref_QAudioDevice(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(device));
    }
    
    @QtUninvokable
    private native void setAudioDevice_native_cref_QAudioDevice(long __this__nativeId, long device);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#setLoopCount">QSoundEffect::<wbr/>setLoopCount(int)</a></code></p>
     */
    @QtPropertyWriter(name="loops")
    @QtUninvokable
    public final void setLoopCount(int loopCount){
        setLoopCount_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), loopCount);
    }
    
    @QtUninvokable
    private native void setLoopCount_native_int(long __this__nativeId, int loopCount);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#setMuted">QSoundEffect::<wbr/>setMuted(bool)</a></code></p>
     */
    @QtPropertyWriter(name="muted")
    @QtUninvokable
    public final void setMuted(boolean muted){
        setMuted_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), muted);
    }
    
    @QtUninvokable
    private native void setMuted_native_bool(long __this__nativeId, boolean muted);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#setSource">QSoundEffect::<wbr/>setSource(QUrl)</a></code></p>
     */
    @QtPropertyWriter(name="source")
    @QtUninvokable
    public final void setSource(io.qt.core.@NonNull QUrl url){
        setSource_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void setSource_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#setVolume">QSoundEffect::<wbr/>setVolume(float)</a></code></p>
     */
    @QtPropertyWriter(name="volume")
    @QtUninvokable
    public final void setVolume(float volume){
        setVolume_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), volume);
    }
    
    @QtUninvokable
    private native void setVolume_native_float(long __this__nativeId, float volume);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#source">QSoundEffect::<wbr/>source()const</a></code></p>
     */
    @QtPropertyReader(name="source")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl source(){
        return source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl source_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#status">QSoundEffect::<wbr/>status()const</a></code></p>
     */
    @QtPropertyReader(name="status")
    @QtUninvokable
    public final io.qt.multimedia.QSoundEffect.@NonNull Status status(){
        return io.qt.multimedia.QSoundEffect.Status.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#stop">QSoundEffect::<wbr/>stop()</a></code></p>
     */
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stop_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#volume">QSoundEffect::<wbr/>volume()const</a></code></p>
     */
    @QtPropertyReader(name="volume")
    @QtUninvokable
    public final float volume(){
        return volume_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float volume_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qsoundeffect.html#supportedMimeTypes">QSoundEffect::<wbr/>supportedMimeTypes()</a></code></p>
     */
    public native static io.qt.core.@NonNull QStringList supportedMimeTypes();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSoundEffect(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QSoundEffect(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QSoundEffect instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QSoundEffect(io.qt.multimedia.QAudioDevice, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSoundEffect(io.qt.multimedia.@NonNull QAudioDevice audioDevice) {
        this(audioDevice, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSoundEffect(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSoundEffect() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #audioDevice()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QAudioDevice getAudioDevice() {
        return audioDevice();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isMuted()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getMuted() {
        return isMuted();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isPlaying()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getPlaying() {
        return isPlaying();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #loopCount()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getLoops() {
        return loopCount();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #loopsRemaining()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getLoopsRemaining() {
        return loopsRemaining();
    }
    
    /**
     * <p>Overloaded function for {@link #setSource(io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final void setSource(java.lang.@NonNull String url) {
        setSource(new io.qt.core.QUrl(url));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #source()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getSource() {
        return source();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #status()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QSoundEffect.@NonNull Status getStatus() {
        return status();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #volume()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getVolume() {
        return volume();
    }
}
