package io.qt.multimedia;

import io.qt.*;


/**
 * <p>This class is used for capturing a screen</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qscreencapture.html">QScreenCapture</a></code></p>
 */
public class QScreenCapture extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcScreen = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QScreenCapture.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qscreencapture.html#Error-enum">QScreenCapture::Error</a></code></p>
     */
    public enum Error implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qscreencapture.html#Error-enum">QScreenCapture::<wbr/>NoError</a></code></p>
         */
        NoError(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qscreencapture.html#Error-enum">QScreenCapture::<wbr/>InternalError</a></code></p>
         */
        InternalError(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qscreencapture.html#Error-enum">QScreenCapture::<wbr/>CapturingNotSupported</a></code></p>
         */
        CapturingNotSupported(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qscreencapture.html#Error-enum">QScreenCapture::<wbr/>CaptureFailed</a></code></p>
         */
        CaptureFailed(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qscreencapture.html#Error-enum">QScreenCapture::<wbr/>NotFound</a></code></p>
         */
        NotFound(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Error resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return InternalError;
            case 2: return CapturingNotSupported;
            case 4: return CaptureFailed;
            case 5: return NotFound;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscreencapture.html#active-prop">QScreenCapture::<wbr/>activeChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="active")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> activeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscreencapture.html#errorChanged">QScreenCapture::<wbr/>errorChanged()</a></code></p>
     */
    @QtPropertyNotify(name="error")
    public final @NonNull Signal0 errorChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscreencapture.html#errorOccurred">QScreenCapture::<wbr/>errorOccurred(QScreenCapture::Error,<wbr/>QString)</a></code></p>
     */
    public final @NonNull Signal2<io.qt.multimedia.QScreenCapture.@NonNull Error, java.lang.@NonNull String> errorOccurred = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscreencapture.html#screen-prop">QScreenCapture::<wbr/>screenChanged(QScreen*)</a></code></p>
     */
    @QtPropertyNotify(name="screen")
    public final @NonNull Signal1<io.qt.gui.@Nullable QScreen> screenChanged = new Signal1<>();
    
    /**
     * <p>See <code>QScreenCapture::<wbr/>QScreenCapture(QObject*)</code></p>
     */
    public QScreenCapture(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QScreenCapture instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscreencapture.html#captureSession">QScreenCapture::<wbr/>captureSession()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QMediaCaptureSession captureSession(){
        return captureSession_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QMediaCaptureSession captureSession_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscreencapture.html#error-prop">QScreenCapture::<wbr/>error()const</a></code></p>
     */
    @QtPropertyReader(name="error")
    @QtUninvokable
    public final io.qt.multimedia.QScreenCapture.@NonNull Error error(){
        return io.qt.multimedia.QScreenCapture.Error.resolve(error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int error_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscreencapture.html#errorString-prop">QScreenCapture::<wbr/>errorString()const</a></code></p>
     */
    @QtPropertyReader(name="errorString")
    @QtUninvokable
    public final java.lang.@NonNull String errorString(){
        return errorString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String errorString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscreencapture.html#active-prop">QScreenCapture::<wbr/>isActive()const</a></code></p>
     */
    @QtPropertyReader(name="active")
    @QtUninvokable
    public final boolean isActive(){
        return isActive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isActive_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscreencapture.html#screen-prop">QScreenCapture::<wbr/>screen()const</a></code></p>
     */
    @QtPropertyReader(name="screen")
    @QtUninvokable
    public final io.qt.gui.@Nullable QScreen screen(){
        return screen_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QScreen screen_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscreencapture.html#active-prop">QScreenCapture::<wbr/>setActive(bool)</a></code></p>
     */
    @QtPropertyWriter(name="active")
    public final void setActive(boolean active){
        setActive_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), active);
    }
    
    private native void setActive_native_bool(long __this__nativeId, boolean active);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscreencapture.html#screen-prop">QScreenCapture::<wbr/>setScreen(QScreen*)</a></code></p>
     */
    @QtPropertyWriter(name="screen")
    @QtUninvokable
    public final void setScreen(io.qt.gui.@Nullable QScreen screen){
        setScreen_native_QScreen_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(screen));
        __rcScreen = screen;
    }
    
    @QtUninvokable
    private native void setScreen_native_QScreen_ptr(long __this__nativeId, long screen);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscreencapture.html#start">QScreenCapture::<wbr/>start()</a></code></p>
     */
    public final void start(){
        start_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void start_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qscreencapture.html#stop">QScreenCapture::<wbr/>stop()</a></code></p>
     */
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stop_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QScreenCapture(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QScreenCapture(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QScreenCapture instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QScreenCapture(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QScreenCapture() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #error()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QScreenCapture.@NonNull Error getError() {
        return error();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #errorString()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getErrorString() {
        return errorString();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isActive()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getActive() {
        return isActive();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #screen()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@Nullable QScreen getScreen() {
        return screen();
    }
}
