package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Represents a set of zero or more disjoint time intervals</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qmediatimerange.html">QMediaTimeRange</a></code></p>
 */
public class QMediaTimeRange extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>QMediaTimeRange::Interval class represents a time interval with integer precision</p>
     * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qmediatimerange-interval.html">QMediaTimeRange::Interval</a></code></p>
     */
    public static class Interval extends QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange-interval.html#Interval-1">QMediaTimeRange::Interval::<wbr/>Interval()</a></code></p>
         */
        public Interval(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(Interval instance);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange-interval.html#Interval-1">QMediaTimeRange::Interval::<wbr/>Interval(QMediaTimeRange::Interval)</a></code></p>
         */
        public Interval(io.qt.multimedia.QMediaTimeRange.@NonNull Interval other){
            super((QPrivateConstructor)null);
            initialize_native(this, other);
        }
        
        private native static void initialize_native(Interval instance, io.qt.multimedia.QMediaTimeRange.Interval other);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange-interval.html#Interval-1">QMediaTimeRange::Interval::<wbr/>Interval(qint64,<wbr/>qint64)</a></code></p>
         */
        public Interval(long start, long end){
            super((QPrivateConstructor)null);
            initialize_native(this, start, end);
        }
        
        private native static void initialize_native(Interval instance, long start, long end);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange-interval.html#contains">QMediaTimeRange::Interval::<wbr/>contains(qint64)const</a></code></p>
         */
        @QtUninvokable
        public final boolean contains(long time){
            return contains_native_qint64_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), time);
        }
        
        @QtUninvokable
        private native boolean contains_native_qint64_constfct(long __this__nativeId, long time);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange-interval.html#end">QMediaTimeRange::Interval::<wbr/>end()const</a></code></p>
         */
        @QtUninvokable
        public final long end(){
            return end_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native long end_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange-interval.html#isNormal">QMediaTimeRange::Interval::<wbr/>isNormal()const</a></code></p>
         */
        @QtUninvokable
        public final boolean isNormal(){
            return isNormal_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native boolean isNormal_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange-interval.html#normalized">QMediaTimeRange::Interval::<wbr/>normalized()const</a></code></p>
         */
        @QtUninvokable
        public final io.qt.multimedia.QMediaTimeRange.@NonNull Interval normalized(){
            return normalized_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native io.qt.multimedia.QMediaTimeRange.Interval normalized_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange-interval.html#operator-eq-eq">operator==(QMediaTimeRange::Interval,<wbr/>QMediaTimeRange::Interval)</a></code></p>
         */
        @QtUninvokable
        public final boolean equals(io.qt.multimedia.QMediaTimeRange.@NonNull Interval rhs){
            return equals_native_QMediaTimeRange_Interval(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
        }
        
        @QtUninvokable
        private native boolean equals_native_QMediaTimeRange_Interval(long __this__nativeId, long rhs);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange-interval.html#start">QMediaTimeRange::Interval::<wbr/>start()const</a></code></p>
         */
        @QtUninvokable
        public final long start(){
            return start_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native long start_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange-interval.html#translated">QMediaTimeRange::Interval::<wbr/>translated(qint64)const</a></code></p>
         */
        @QtUninvokable
        public final io.qt.multimedia.QMediaTimeRange.@NonNull Interval translated(long offset){
            return translated_native_qint64_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), offset);
        }
        
        @QtUninvokable
        private native io.qt.multimedia.QMediaTimeRange.Interval translated_native_qint64_constfct(long __this__nativeId, long offset);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected Interval(QPrivateConstructor p) { super(p); } 
        

        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange-interval.html#operator-eq-eq">operator==(QMediaTimeRange::Interval,<wbr/>QMediaTimeRange::Interval)</a></code></p>
         */
        @Override
        @QtUninvokable
        public boolean equals(Object other) {
            if (other instanceof io.qt.multimedia.QMediaTimeRange.Interval) {
                return equals((io.qt.multimedia.QMediaTimeRange.Interval) other);
            }

            return false;
        }


        /**
         * Returns the objects's hash code computed by <code>qHash(QMediaTimeRange::Interval)</code>.
         */
        @QtUninvokable
        @Override
        public int hashCode() {
            return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native static int hashCode_native(long __this_nativeId);

        /**
         * <p>See <code>operator&lt;&lt;(QDebug,<wbr/>QMediaTimeRange::Interval)</code></p>
         */
        @QtUninvokable
        @Override
        public @NonNull String toString() {
            return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private static native String toString_native(long __this_nativeId);
        
        /**
         * <p>Creates and returns a copy of this object.</p>
        <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange-interval.html#Interval-1">QMediaTimeRange::Interval::<wbr/>Interval(QMediaTimeRange::Interval)</a></code></p>
         */
        @QtUninvokable
        @Override
        public Interval clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private static native Interval clone_native(long __this_nativeId);
    }

    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#QMediaTimeRange">QMediaTimeRange::<wbr/>QMediaTimeRange()</a></code></p>
     */
    public QMediaTimeRange(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QMediaTimeRange instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#QMediaTimeRange-3">QMediaTimeRange::<wbr/>QMediaTimeRange(QMediaTimeRange)</a></code></p>
     */
    public QMediaTimeRange(io.qt.multimedia.@NonNull QMediaTimeRange range){
        super((QPrivateConstructor)null);
        initialize_native(this, range);
    }
    
    private native static void initialize_native(QMediaTimeRange instance, io.qt.multimedia.QMediaTimeRange range);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#QMediaTimeRange-2">QMediaTimeRange::<wbr/>QMediaTimeRange(QMediaTimeRange::Interval)</a></code></p>
     */
    public QMediaTimeRange(io.qt.multimedia.QMediaTimeRange.@NonNull Interval arg__1){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1);
    }
    
    private native static void initialize_native(QMediaTimeRange instance, io.qt.multimedia.QMediaTimeRange.Interval arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#QMediaTimeRange-1">QMediaTimeRange::<wbr/>QMediaTimeRange(qint64,<wbr/>qint64)</a></code></p>
     */
    public QMediaTimeRange(long start, long end){
        super((QPrivateConstructor)null);
        initialize_native(this, start, end);
    }
    
    private native static void initialize_native(QMediaTimeRange instance, long start, long end);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#addInterval">QMediaTimeRange::<wbr/>addInterval(QMediaTimeRange::Interval)</a></code></p>
     */
    @QtUninvokable
    public final void addInterval(io.qt.multimedia.QMediaTimeRange.@NonNull Interval interval){
        addInterval_native_cref_QMediaTimeRange_Interval(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(interval));
    }
    
    @QtUninvokable
    private native void addInterval_native_cref_QMediaTimeRange_Interval(long __this__nativeId, long interval);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#addInterval-1">QMediaTimeRange::<wbr/>addInterval(qint64,<wbr/>qint64)</a></code></p>
     */
    @QtUninvokable
    public final void addInterval(long start, long end){
        addInterval_native_qint64_qint64(QtJambi_LibraryUtilities.internal.nativeId(this), start, end);
    }
    
    @QtUninvokable
    private native void addInterval_native_qint64_qint64(long __this__nativeId, long start, long end);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#addTimeRange">QMediaTimeRange::<wbr/>addTimeRange(QMediaTimeRange)</a></code></p>
     */
    @QtUninvokable
    public final void addTimeRange(io.qt.multimedia.@NonNull QMediaTimeRange arg__1){
        addTimeRange_native_cref_QMediaTimeRange(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void addTimeRange_native_cref_QMediaTimeRange(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#clear">QMediaTimeRange::<wbr/>clear()</a></code></p>
     */
    @QtUninvokable
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#contains">QMediaTimeRange::<wbr/>contains(qint64)const</a></code></p>
     */
    @QtUninvokable
    public final boolean contains(long time){
        return contains_native_qint64_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), time);
    }
    
    @QtUninvokable
    private native boolean contains_native_qint64_constfct(long __this__nativeId, long time);
    
    /**
     * <p>See <code>QMediaTimeRange::<wbr/>detach()</code></p>
     */
    @QtUninvokable
    public final void detach(){
        detach_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void detach_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#earliestTime">QMediaTimeRange::<wbr/>earliestTime()const</a></code></p>
     */
    @QtUninvokable
    public final long earliestTime(){
        return earliestTime_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long earliestTime_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#intervals">QMediaTimeRange::<wbr/>intervals()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.multimedia.QMediaTimeRange.@NonNull Interval> intervals(){
        return intervals_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.multimedia.QMediaTimeRange.Interval> intervals_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#isContinuous">QMediaTimeRange::<wbr/>isContinuous()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isContinuous(){
        return isContinuous_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isContinuous_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#isEmpty">QMediaTimeRange::<wbr/>isEmpty()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isEmpty(){
        return isEmpty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isEmpty_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#latestTime">QMediaTimeRange::<wbr/>latestTime()const</a></code></p>
     */
    @QtUninvokable
    public final long latestTime(){
        return latestTime_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long latestTime_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#operator-2b">operator+(QMediaTimeRange,<wbr/>QMediaTimeRange)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QMediaTimeRange plus(io.qt.multimedia.@NonNull QMediaTimeRange r2){
        return plus_native_cref_QMediaTimeRange(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(r2));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QMediaTimeRange plus_native_cref_QMediaTimeRange(long __this__nativeId, long r2);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#operator-2b-eq">QMediaTimeRange::<wbr/>operator+=(QMediaTimeRange)</a></code></p>
     */
    @QtUninvokable
    public final @NonNull QMediaTimeRange add(io.qt.multimedia.@NonNull QMediaTimeRange arg__1){
        return add_native_cref_QMediaTimeRange(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native QMediaTimeRange add_native_cref_QMediaTimeRange(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#operator-2b-eq-1">QMediaTimeRange::<wbr/>operator+=(QMediaTimeRange::Interval)</a></code></p>
     */
    @QtUninvokable
    public final void plusAssign(io.qt.multimedia.QMediaTimeRange.@NonNull Interval arg__1){
        plusAssign_native_cref_QMediaTimeRange_Interval(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void plusAssign_native_cref_QMediaTimeRange_Interval(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#operator-">operator-(QMediaTimeRange,<wbr/>QMediaTimeRange)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QMediaTimeRange minus(io.qt.multimedia.@NonNull QMediaTimeRange r2){
        return minus_native_cref_QMediaTimeRange(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(r2));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QMediaTimeRange minus_native_cref_QMediaTimeRange(long __this__nativeId, long r2);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#operator--eq">QMediaTimeRange::<wbr/>operator-=(QMediaTimeRange)</a></code></p>
     */
    @QtUninvokable
    public final @NonNull QMediaTimeRange subtract(io.qt.multimedia.@NonNull QMediaTimeRange arg__1){
        return subtract_native_cref_QMediaTimeRange(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native QMediaTimeRange subtract_native_cref_QMediaTimeRange(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#operator--eq-1">QMediaTimeRange::<wbr/>operator-=(QMediaTimeRange::Interval)</a></code></p>
     */
    @QtUninvokable
    public final void minusAssign(io.qt.multimedia.QMediaTimeRange.@NonNull Interval arg__1){
        minusAssign_native_cref_QMediaTimeRange_Interval(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void minusAssign_native_cref_QMediaTimeRange_Interval(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#operator-eq">QMediaTimeRange::<wbr/>operator=(QMediaTimeRange)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.multimedia.@NonNull QMediaTimeRange arg__1){
        assign_native_cref_QMediaTimeRange(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QMediaTimeRange(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#operator-eq-2">QMediaTimeRange::<wbr/>operator=(QMediaTimeRange::Interval)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.multimedia.QMediaTimeRange.@NonNull Interval arg__1){
        assign_native_cref_QMediaTimeRange_Interval(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QMediaTimeRange_Interval(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#operator-eq-eq">operator==(QMediaTimeRange,<wbr/>QMediaTimeRange)</a></code></p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.multimedia.@NonNull QMediaTimeRange rhs){
        return equals_native_cref_QMediaTimeRange(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QMediaTimeRange(long __this__nativeId, long rhs);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#removeInterval">QMediaTimeRange::<wbr/>removeInterval(QMediaTimeRange::Interval)</a></code></p>
     */
    @QtUninvokable
    public final void removeInterval(io.qt.multimedia.QMediaTimeRange.@NonNull Interval interval){
        removeInterval_native_cref_QMediaTimeRange_Interval(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(interval));
    }
    
    @QtUninvokable
    private native void removeInterval_native_cref_QMediaTimeRange_Interval(long __this__nativeId, long interval);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#removeInterval-1">QMediaTimeRange::<wbr/>removeInterval(qint64,<wbr/>qint64)</a></code></p>
     */
    @QtUninvokable
    public final void removeInterval(long start, long end){
        removeInterval_native_qint64_qint64(QtJambi_LibraryUtilities.internal.nativeId(this), start, end);
    }
    
    @QtUninvokable
    private native void removeInterval_native_qint64_qint64(long __this__nativeId, long start, long end);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#removeTimeRange">QMediaTimeRange::<wbr/>removeTimeRange(QMediaTimeRange)</a></code></p>
     */
    @QtUninvokable
    public final void removeTimeRange(io.qt.multimedia.@NonNull QMediaTimeRange arg__1){
        removeTimeRange_native_cref_QMediaTimeRange(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void removeTimeRange_native_cref_QMediaTimeRange(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#swap">QMediaTimeRange::<wbr/>swap(QMediaTimeRange&amp;)</a></code></p>
     */
    @QtUninvokable
    public final void swap(io.qt.multimedia.@StrictNonNull QMediaTimeRange other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QMediaTimeRange(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QMediaTimeRange(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QMediaTimeRange(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#operator-eq-eq">operator==(QMediaTimeRange,<wbr/>QMediaTimeRange)</a></code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.multimedia.QMediaTimeRange) {
            return equals((io.qt.multimedia.QMediaTimeRange) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QMediaTimeRange)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);

    /**
     * <p>See <code>operator&lt;&lt;(QDebug,<wbr/>QMediaTimeRange)</code></p>
     */
    @QtUninvokable
    @Override
    public @NonNull String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="https://doc.qt.io/qt/qmediatimerange.html#QMediaTimeRange-3">QMediaTimeRange::<wbr/>QMediaTimeRange(QMediaTimeRange)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QMediaTimeRange clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QMediaTimeRange clone_native(long __this_nativeId);
}
