package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Used for encoding and recording a capture session</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qmediarecorder.html">QMediaRecorder</a></code></p>
 */
public class QMediaRecorder extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMediaRecorder.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qmediarecorder.html#EncodingMode-enum">QMediaRecorder::EncodingMode</a></code></p>
     */
    public enum EncodingMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediarecorder.html#EncodingMode-enum">QMediaRecorder::<wbr/>ConstantQualityEncoding</a></code></p>
         */
        ConstantQualityEncoding(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediarecorder.html#EncodingMode-enum">QMediaRecorder::<wbr/>ConstantBitRateEncoding</a></code></p>
         */
        ConstantBitRateEncoding(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediarecorder.html#EncodingMode-enum">QMediaRecorder::<wbr/>AverageBitRateEncoding</a></code></p>
         */
        AverageBitRateEncoding(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediarecorder.html#EncodingMode-enum">QMediaRecorder::<wbr/>TwoPassEncoding</a></code></p>
         */
        TwoPassEncoding(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private EncodingMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull EncodingMode resolve(int value) {
            switch (value) {
            case 0: return ConstantQualityEncoding;
            case 1: return ConstantBitRateEncoding;
            case 2: return AverageBitRateEncoding;
            case 3: return TwoPassEncoding;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qmediarecorder.html#Error-enum">QMediaRecorder::Error</a></code></p>
     */
    public enum Error implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediarecorder.html#Error-enum">QMediaRecorder::<wbr/>NoError</a></code></p>
         */
        NoError(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediarecorder.html#Error-enum">QMediaRecorder::<wbr/>ResourceError</a></code></p>
         */
        ResourceError(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediarecorder.html#Error-enum">QMediaRecorder::<wbr/>FormatError</a></code></p>
         */
        FormatError(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediarecorder.html#Error-enum">QMediaRecorder::<wbr/>OutOfSpaceError</a></code></p>
         */
        OutOfSpaceError(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediarecorder.html#Error-enum">QMediaRecorder::<wbr/>LocationNotWritable</a></code></p>
         */
        LocationNotWritable(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Error resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return ResourceError;
            case 2: return FormatError;
            case 3: return OutOfSpaceError;
            case 4: return LocationNotWritable;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qmediarecorder.html#Quality-enum">QMediaRecorder::Quality</a></code></p>
     */
    public enum Quality implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediarecorder.html#Quality-enum">QMediaRecorder::<wbr/>VeryLowQuality</a></code></p>
         */
        VeryLowQuality(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediarecorder.html#Quality-enum">QMediaRecorder::<wbr/>LowQuality</a></code></p>
         */
        LowQuality(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediarecorder.html#Quality-enum">QMediaRecorder::<wbr/>NormalQuality</a></code></p>
         */
        NormalQuality(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediarecorder.html#Quality-enum">QMediaRecorder::<wbr/>HighQuality</a></code></p>
         */
        HighQuality(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediarecorder.html#Quality-enum">QMediaRecorder::<wbr/>VeryHighQuality</a></code></p>
         */
        VeryHighQuality(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Quality(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Quality resolve(int value) {
            switch (value) {
            case 0: return VeryLowQuality;
            case 1: return LowQuality;
            case 2: return NormalQuality;
            case 3: return HighQuality;
            case 4: return VeryHighQuality;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qmediarecorder.html#RecorderState-enum">QMediaRecorder::RecorderState</a></code></p>
     */
    public enum RecorderState implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediarecorder.html#RecorderState-enum">QMediaRecorder::<wbr/>StoppedState</a></code></p>
         */
        StoppedState(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediarecorder.html#RecorderState-enum">QMediaRecorder::<wbr/>RecordingState</a></code></p>
         */
        RecordingState(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediarecorder.html#RecorderState-enum">QMediaRecorder::<wbr/>PausedState</a></code></p>
         */
        PausedState(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RecorderState(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull RecorderState resolve(int value) {
            switch (value) {
            case 0: return StoppedState;
            case 1: return RecordingState;
            case 2: return PausedState;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#actualLocationChanged">QMediaRecorder::<wbr/>actualLocationChanged(QUrl)</a></code></p>
     */
    @QtPropertyNotify(name="actualLocation")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> actualLocationChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#audioBitRateChanged">QMediaRecorder::<wbr/>audioBitRateChanged()</a></code></p>
     */
    @QtPropertyNotify(name="audioBitRate")
    public final @NonNull Signal0 audioBitRateChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#audioChannelCountChanged">QMediaRecorder::<wbr/>audioChannelCountChanged()</a></code></p>
     */
    @QtPropertyNotify(name="audioChannelCount")
    public final @NonNull Signal0 audioChannelCountChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#audioSampleRateChanged">QMediaRecorder::<wbr/>audioSampleRateChanged()</a></code></p>
     */
    @QtPropertyNotify(name="audioSampleRate")
    public final @NonNull Signal0 audioSampleRateChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#durationChanged">QMediaRecorder::<wbr/>durationChanged(qint64)</a></code></p>
     */
    @QtPropertyNotify(name="duration")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Long> durationChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#encoderSettingsChanged">QMediaRecorder::<wbr/>encoderSettingsChanged()</a></code></p>
     */
    public final @NonNull Signal0 encoderSettingsChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#encodingModeChanged">QMediaRecorder::<wbr/>encodingModeChanged()</a></code></p>
     */
    @QtPropertyNotify(name="encodingMode")
    public final @NonNull Signal0 encodingModeChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#errorChanged">QMediaRecorder::<wbr/>errorChanged()</a></code></p>
     */
    @QtPropertyNotify(name="error")
    public final @NonNull Signal0 errorChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#errorOccurred">QMediaRecorder::<wbr/>errorOccurred(QMediaRecorder::Error,<wbr/>QString)</a></code></p>
     */
    public final @NonNull Signal2<io.qt.multimedia.QMediaRecorder.@NonNull Error, java.lang.@NonNull String> errorOccurred = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#mediaFormat-prop">QMediaRecorder::<wbr/>mediaFormatChanged()</a></code></p>
     */
    @QtPropertyNotify(name="mediaFormat")
    public final @NonNull Signal0 mediaFormatChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#metaDataChanged">QMediaRecorder::<wbr/>metaDataChanged()</a></code></p>
     */
    @QtPropertyNotify(name="metaData")
    public final @NonNull Signal0 metaDataChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#qualityChanged">QMediaRecorder::<wbr/>qualityChanged()</a></code></p>
     */
    @QtPropertyNotify(name="quality")
    public final @NonNull Signal0 qualityChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#recorderStateChanged">QMediaRecorder::<wbr/>recorderStateChanged(QMediaRecorder::RecorderState)</a></code></p>
     */
    @QtPropertyNotify(name="recorderState")
    public final @NonNull Signal1<io.qt.multimedia.QMediaRecorder.@NonNull RecorderState> recorderStateChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#videoBitRateChanged">QMediaRecorder::<wbr/>videoBitRateChanged()</a></code></p>
     */
    @QtPropertyNotify(name="videoBitRate")
    public final @NonNull Signal0 videoBitRateChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#videoFrameRateChanged">QMediaRecorder::<wbr/>videoFrameRateChanged()</a></code></p>
     */
    @QtPropertyNotify(name="videoFrameRate")
    public final @NonNull Signal0 videoFrameRateChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#videoResolutionChanged">QMediaRecorder::<wbr/>videoResolutionChanged()</a></code></p>
     */
    @QtPropertyNotify(name="videoResolution")
    public final @NonNull Signal0 videoResolutionChanged = new Signal0();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#QMediaRecorder">QMediaRecorder::<wbr/>QMediaRecorder(QObject*)</a></code></p>
     */
    public QMediaRecorder(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QMediaRecorder instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#actualLocation-prop">QMediaRecorder::<wbr/>actualLocation()const</a></code></p>
     */
    @QtPropertyReader(name="actualLocation")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl actualLocation(){
        return actualLocation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl actualLocation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#addMetaData">QMediaRecorder::<wbr/>addMetaData(QMediaMetaData)</a></code></p>
     */
    @QtUninvokable
    public final void addMetaData(io.qt.multimedia.@NonNull QMediaMetaData metaData){
        addMetaData_native_cref_QMediaMetaData(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(metaData));
    }
    
    @QtUninvokable
    private native void addMetaData_native_cref_QMediaMetaData(long __this__nativeId, long metaData);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#audioBitRate">QMediaRecorder::<wbr/>audioBitRate()const</a></code></p>
     */
    @QtPropertyReader(name="audioBitRate")
    @QtUninvokable
    public final int audioBitRate(){
        return audioBitRate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int audioBitRate_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#audioChannelCount">QMediaRecorder::<wbr/>audioChannelCount()const</a></code></p>
     */
    @QtPropertyReader(name="audioChannelCount")
    @QtUninvokable
    public final int audioChannelCount(){
        return audioChannelCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int audioChannelCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#audioSampleRate">QMediaRecorder::<wbr/>audioSampleRate()const</a></code></p>
     */
    @QtPropertyReader(name="audioSampleRate")
    @QtUninvokable
    public final int audioSampleRate(){
        return audioSampleRate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int audioSampleRate_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#captureSession">QMediaRecorder::<wbr/>captureSession()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QMediaCaptureSession captureSession(){
        return captureSession_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QMediaCaptureSession captureSession_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#duration-prop">QMediaRecorder::<wbr/>duration()const</a></code></p>
     */
    @QtPropertyReader(name="duration")
    @QtUninvokable
    public final long duration(){
        return duration_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long duration_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#encodingMode">QMediaRecorder::<wbr/>encodingMode()const</a></code></p>
     */
    @QtPropertyReader(name="encodingMode")
    @QtUninvokable
    public final io.qt.multimedia.QMediaRecorder.@NonNull EncodingMode encodingMode(){
        return io.qt.multimedia.QMediaRecorder.EncodingMode.resolve(encodingMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int encodingMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#error-prop">QMediaRecorder::<wbr/>error()const</a></code></p>
     */
    @QtPropertyReader(name="error")
    @QtUninvokable
    public final io.qt.multimedia.QMediaRecorder.@NonNull Error error(){
        return io.qt.multimedia.QMediaRecorder.Error.resolve(error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int error_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#errorString-prop">QMediaRecorder::<wbr/>errorString()const</a></code></p>
     */
    @QtPropertyReader(name="errorString")
    @QtUninvokable
    public final java.lang.@NonNull String errorString(){
        return errorString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String errorString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#isAvailable">QMediaRecorder::<wbr/>isAvailable()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isAvailable(){
        return isAvailable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAvailable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#mediaFormat-prop">QMediaRecorder::<wbr/>mediaFormat()const</a></code></p>
     */
    @QtPropertyReader(name="mediaFormat")
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QMediaFormat mediaFormat(){
        return mediaFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QMediaFormat mediaFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#metaData-prop">QMediaRecorder::<wbr/>metaData()const</a></code></p>
     */
    @QtPropertyReader(name="metaData")
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QMediaMetaData metaData(){
        return metaData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QMediaMetaData metaData_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#outputLocation-prop">QMediaRecorder::<wbr/>outputLocation()const</a></code></p>
     */
    @QtPropertyReader(name="outputLocation")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl outputLocation(){
        return outputLocation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl outputLocation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#pause">QMediaRecorder::<wbr/>pause()</a></code></p>
     */
    public final void pause(){
        pause_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void pause_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#quality-prop">QMediaRecorder::<wbr/>quality()const</a></code></p>
     */
    @QtPropertyReader(name="quality")
    @QtUninvokable
    public final io.qt.multimedia.QMediaRecorder.@NonNull Quality quality(){
        return io.qt.multimedia.QMediaRecorder.Quality.resolve(quality_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int quality_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#record">QMediaRecorder::<wbr/>record()</a></code></p>
     */
    public final void record(){
        record_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void record_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#recorderState">QMediaRecorder::<wbr/>recorderState()const</a></code></p>
     */
    @QtPropertyReader(name="recorderState")
    @QtUninvokable
    public final io.qt.multimedia.QMediaRecorder.@NonNull RecorderState recorderState(){
        return io.qt.multimedia.QMediaRecorder.RecorderState.resolve(recorderState_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int recorderState_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#setAudioBitRate">QMediaRecorder::<wbr/>setAudioBitRate(int)</a></code></p>
     */
    @QtPropertyWriter(name="audioBitRate")
    @QtUninvokable
    public final void setAudioBitRate(int bitRate){
        setAudioBitRate_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), bitRate);
    }
    
    @QtUninvokable
    private native void setAudioBitRate_native_int(long __this__nativeId, int bitRate);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#setAudioChannelCount">QMediaRecorder::<wbr/>setAudioChannelCount(int)</a></code></p>
     */
    @QtPropertyWriter(name="audioChannelCount")
    @QtUninvokable
    public final void setAudioChannelCount(int channels){
        setAudioChannelCount_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), channels);
    }
    
    @QtUninvokable
    private native void setAudioChannelCount_native_int(long __this__nativeId, int channels);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#setAudioSampleRate">QMediaRecorder::<wbr/>setAudioSampleRate(int)</a></code></p>
     */
    @QtPropertyWriter(name="audioSampleRate")
    @QtUninvokable
    public final void setAudioSampleRate(int sampleRate){
        setAudioSampleRate_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), sampleRate);
    }
    
    @QtUninvokable
    private native void setAudioSampleRate_native_int(long __this__nativeId, int sampleRate);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#setEncodingMode">QMediaRecorder::<wbr/>setEncodingMode(QMediaRecorder::EncodingMode)</a></code></p>
     */
    @QtPropertyWriter(name="encodingMode")
    @QtUninvokable
    public final void setEncodingMode(io.qt.multimedia.QMediaRecorder.@NonNull EncodingMode arg__1){
        setEncodingMode_native_QMediaRecorder_EncodingMode(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @QtUninvokable
    private native void setEncodingMode_native_QMediaRecorder_EncodingMode(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#mediaFormat-prop">QMediaRecorder::<wbr/>setMediaFormat(QMediaFormat)</a></code></p>
     */
    @QtPropertyWriter(name="mediaFormat")
    @QtUninvokable
    public final void setMediaFormat(io.qt.multimedia.@NonNull QMediaFormat format){
        setMediaFormat_native_cref_QMediaFormat(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(format));
    }
    
    @QtUninvokable
    private native void setMediaFormat_native_cref_QMediaFormat(long __this__nativeId, long format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#setMetaData">QMediaRecorder::<wbr/>setMetaData(QMediaMetaData)</a></code></p>
     */
    @QtPropertyWriter(name="metaData")
    @QtUninvokable
    public final void setMetaData(io.qt.multimedia.@NonNull QMediaMetaData metaData){
        setMetaData_native_cref_QMediaMetaData(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(metaData));
    }
    
    @QtUninvokable
    private native void setMetaData_native_cref_QMediaMetaData(long __this__nativeId, long metaData);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#outputLocation-prop">QMediaRecorder::<wbr/>setOutputLocation(QUrl)</a></code></p>
     */
    @QtPropertyWriter(name="outputLocation")
    @QtUninvokable
    public final void setOutputLocation(io.qt.core.@NonNull QUrl location){
        setOutputLocation_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(location));
    }
    
    @QtUninvokable
    private native void setOutputLocation_native_cref_QUrl(long __this__nativeId, long location);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#quality-prop">QMediaRecorder::<wbr/>setQuality(QMediaRecorder::Quality)</a></code></p>
     */
    @QtPropertyWriter(name="quality")
    @QtUninvokable
    public final void setQuality(io.qt.multimedia.QMediaRecorder.@NonNull Quality quality){
        setQuality_native_QMediaRecorder_Quality(QtJambi_LibraryUtilities.internal.nativeId(this), quality.value());
    }
    
    @QtUninvokable
    private native void setQuality_native_QMediaRecorder_Quality(long __this__nativeId, int quality);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#setVideoBitRate">QMediaRecorder::<wbr/>setVideoBitRate(int)</a></code></p>
     */
    @QtPropertyWriter(name="videoBitRate")
    @QtUninvokable
    public final void setVideoBitRate(int bitRate){
        setVideoBitRate_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), bitRate);
    }
    
    @QtUninvokable
    private native void setVideoBitRate_native_int(long __this__nativeId, int bitRate);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#setVideoFrameRate">QMediaRecorder::<wbr/>setVideoFrameRate(qreal)</a></code></p>
     */
    @QtPropertyWriter(name="videoFrameRate")
    @QtUninvokable
    public final void setVideoFrameRate(double frameRate){
        setVideoFrameRate_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), frameRate);
    }
    
    @QtUninvokable
    private native void setVideoFrameRate_native_qreal(long __this__nativeId, double frameRate);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#setVideoResolution">QMediaRecorder::<wbr/>setVideoResolution(QSize)</a></code></p>
     */
    @QtPropertyWriter(name="videoResolution")
    @QtUninvokable
    public final void setVideoResolution(io.qt.core.@NonNull QSize arg__1){
        setVideoResolution_native_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void setVideoResolution_native_cref_QSize(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#setVideoResolution-1">QMediaRecorder::<wbr/>setVideoResolution(int,<wbr/>int)</a></code></p>
     */
    @QtPropertyWriter(name="videoResolution")
    @QtUninvokable
    public final void setVideoResolution(int width, int height){
        setVideoResolution_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), width, height);
    }
    
    @QtUninvokable
    private native void setVideoResolution_native_int_int(long __this__nativeId, int width, int height);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#stop">QMediaRecorder::<wbr/>stop()</a></code></p>
     */
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stop_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#videoBitRate">QMediaRecorder::<wbr/>videoBitRate()const</a></code></p>
     */
    @QtPropertyReader(name="videoBitRate")
    @QtUninvokable
    public final int videoBitRate(){
        return videoBitRate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int videoBitRate_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#videoFrameRate">QMediaRecorder::<wbr/>videoFrameRate()const</a></code></p>
     */
    @QtPropertyReader(name="videoFrameRate")
    @QtUninvokable
    public final double videoFrameRate(){
        return videoFrameRate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double videoFrameRate_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediarecorder.html#videoResolution">QMediaRecorder::<wbr/>videoResolution()const</a></code></p>
     */
    @QtPropertyReader(name="videoResolution")
    @QtUninvokable
    public final io.qt.core.@NonNull QSize videoResolution(){
        return videoResolution_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSize videoResolution_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QMediaRecorder(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QMediaRecorder(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QMediaRecorder instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QMediaRecorder(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QMediaRecorder() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #actualLocation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getActualLocation() {
        return actualLocation();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #audioBitRate()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getAudioBitRate() {
        return audioBitRate();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #audioChannelCount()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getAudioChannelCount() {
        return audioChannelCount();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #audioSampleRate()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getAudioSampleRate() {
        return audioSampleRate();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #duration()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final long getDuration() {
        return duration();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #encodingMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QMediaRecorder.@NonNull EncodingMode getEncodingMode() {
        return encodingMode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #error()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QMediaRecorder.@NonNull Error getError() {
        return error();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #errorString()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getErrorString() {
        return errorString();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #mediaFormat()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QMediaFormat getMediaFormat() {
        return mediaFormat();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #metaData()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QMediaMetaData getMetaData() {
        return metaData();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #outputLocation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getOutputLocation() {
        return outputLocation();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #quality()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QMediaRecorder.@NonNull Quality getQuality() {
        return quality();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #recorderState()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QMediaRecorder.@NonNull RecorderState getRecorderState() {
        return recorderState();
    }
    
    /**
     * <p>Overloaded function for {@link #setMediaFormat(io.qt.multimedia.QMediaFormat)}.</p>
     */
    @QtUninvokable
    public final void setMediaFormat(io.qt.multimedia.QMediaFormat.@NonNull FileFormat format) {
        setMediaFormat(new io.qt.multimedia.QMediaFormat(format));
    }
    
    /**
     * <p>Overloaded function for {@link #setOutputLocation(io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final void setOutputLocation(java.lang.@NonNull String location) {
        setOutputLocation(new io.qt.core.QUrl(location));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #videoBitRate()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getVideoBitRate() {
        return videoBitRate();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #videoFrameRate()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getVideoFrameRate() {
        return videoFrameRate();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #videoResolution()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QSize getVideoResolution() {
        return videoResolution();
    }
}
