package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Allows the playing of a media files</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qmediaplayer.html">QMediaPlayer</a></code></p>
 */
public class QMediaPlayer extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcAudioOutput = null;
    @QtPropertyMember(enabled=false)
    private Object __rcSourceDevice = null;
    @QtPropertyMember(enabled=false)
    private Object __rcVideoOutput = null;
    @QtPropertyMember(enabled=false)
    private Object __rcVideoSink = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMediaPlayer.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qmediaplayer.html#Error-enum">QMediaPlayer::Error</a></code></p>
     */
    public enum Error implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaplayer.html#Error-enum">QMediaPlayer::<wbr/>NoError</a></code></p>
         */
        NoError(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaplayer.html#Error-enum">QMediaPlayer::<wbr/>ResourceError</a></code></p>
         */
        ResourceError(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaplayer.html#Error-enum">QMediaPlayer::<wbr/>FormatError</a></code></p>
         */
        FormatError(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaplayer.html#Error-enum">QMediaPlayer::<wbr/>NetworkError</a></code></p>
         */
        NetworkError(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaplayer.html#Error-enum">QMediaPlayer::<wbr/>AccessDeniedError</a></code></p>
         */
        AccessDeniedError(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Error resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return ResourceError;
            case 2: return FormatError;
            case 3: return NetworkError;
            case 4: return AccessDeniedError;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qmediaplayer.html#Loops-enum">QMediaPlayer::Loops</a></code></p>
     */
    public enum Loops implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaplayer.html#Loops-enum">QMediaPlayer::<wbr/>Infinite</a></code></p>
         */
        Infinite(-1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaplayer.html#Loops-enum">QMediaPlayer::<wbr/>Once</a></code></p>
         */
        Once(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Loops(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Loops resolve(int value) {
            switch (value) {
            case -1: return Infinite;
            case 1: return Once;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qmediaplayer.html#MediaStatus-enum">QMediaPlayer::MediaStatus</a></code></p>
     */
    public enum MediaStatus implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaplayer.html#MediaStatus-enum">QMediaPlayer::<wbr/>NoMedia</a></code></p>
         */
        NoMedia(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaplayer.html#MediaStatus-enum">QMediaPlayer::<wbr/>LoadingMedia</a></code></p>
         */
        LoadingMedia(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaplayer.html#MediaStatus-enum">QMediaPlayer::<wbr/>LoadedMedia</a></code></p>
         */
        LoadedMedia(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaplayer.html#MediaStatus-enum">QMediaPlayer::<wbr/>StalledMedia</a></code></p>
         */
        StalledMedia(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaplayer.html#MediaStatus-enum">QMediaPlayer::<wbr/>BufferingMedia</a></code></p>
         */
        BufferingMedia(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaplayer.html#MediaStatus-enum">QMediaPlayer::<wbr/>BufferedMedia</a></code></p>
         */
        BufferedMedia(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaplayer.html#MediaStatus-enum">QMediaPlayer::<wbr/>EndOfMedia</a></code></p>
         */
        EndOfMedia(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaplayer.html#MediaStatus-enum">QMediaPlayer::<wbr/>InvalidMedia</a></code></p>
         */
        InvalidMedia(7);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private MediaStatus(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull MediaStatus resolve(int value) {
            switch (value) {
            case 0: return NoMedia;
            case 1: return LoadingMedia;
            case 2: return LoadedMedia;
            case 3: return StalledMedia;
            case 4: return BufferingMedia;
            case 5: return BufferedMedia;
            case 6: return EndOfMedia;
            case 7: return InvalidMedia;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qmediaplayer.html#PlaybackState-enum">QMediaPlayer::PlaybackState</a></code></p>
     */
    public enum PlaybackState implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaplayer.html#PlaybackState-enum">QMediaPlayer::<wbr/>StoppedState</a></code></p>
         */
        StoppedState(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaplayer.html#PlaybackState-enum">QMediaPlayer::<wbr/>PlayingState</a></code></p>
         */
        PlayingState(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaplayer.html#PlaybackState-enum">QMediaPlayer::<wbr/>PausedState</a></code></p>
         */
        PausedState(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PlaybackState(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PlaybackState resolve(int value) {
            switch (value) {
            case 0: return StoppedState;
            case 1: return PlayingState;
            case 2: return PausedState;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#activeTracksChanged">QMediaPlayer::<wbr/>activeTracksChanged()</a></code></p>
     */
    @QtPropertyNotify(name="activeAudioTrack")
    public final @NonNull Signal0 activeTracksChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#audioOutput-prop">QMediaPlayer::<wbr/>audioOutputChanged()</a></code></p>
     */
    @QtPropertyNotify(name="audioOutput")
    public final @NonNull Signal0 audioOutputChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#bufferProgressChanged">QMediaPlayer::<wbr/>bufferProgressChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="bufferProgress")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> bufferProgressChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#durationChanged">QMediaPlayer::<wbr/>durationChanged(qint64)</a></code></p>
     */
    @QtPropertyNotify(name="duration")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Long> durationChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#errorChanged">QMediaPlayer::<wbr/>errorChanged()</a></code></p>
     */
    @QtPropertyNotify(name="error")
    public final @NonNull Signal0 errorChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#errorOccurred">QMediaPlayer::<wbr/>errorOccurred(QMediaPlayer::Error,<wbr/>QString)</a></code></p>
     */
    public final @NonNull Signal2<io.qt.multimedia.QMediaPlayer.@NonNull Error, java.lang.@NonNull String> errorOccurred = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#hasAudioChanged">QMediaPlayer::<wbr/>hasAudioChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="hasAudio")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> hasAudioChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#hasVideoChanged">QMediaPlayer::<wbr/>hasVideoChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="hasVideo")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> hasVideoChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#loops-prop">QMediaPlayer::<wbr/>loopsChanged()</a></code></p>
     */
    @QtPropertyNotify(name="loops")
    public final @NonNull Signal0 loopsChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#mediaStatusChanged">QMediaPlayer::<wbr/>mediaStatusChanged(QMediaPlayer::MediaStatus)</a></code></p>
     */
    @QtPropertyNotify(name="mediaStatus")
    public final @NonNull Signal1<io.qt.multimedia.QMediaPlayer.@NonNull MediaStatus> mediaStatusChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#metaData-prop">QMediaPlayer::<wbr/>metaDataChanged()</a></code></p>
     */
    @QtPropertyNotify(name="metaData")
    public final @NonNull Signal0 metaDataChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#playbackRateChanged">QMediaPlayer::<wbr/>playbackRateChanged(qreal)</a></code></p>
     */
    @QtPropertyNotify(name="playbackRate")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Double> playbackRateChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#playbackState-prop">QMediaPlayer::<wbr/>playbackStateChanged(QMediaPlayer::PlaybackState)</a></code></p>
     */
    @QtPropertyNotify(name="playbackState")
    public final @NonNull Signal1<io.qt.multimedia.QMediaPlayer.@NonNull PlaybackState> playbackStateChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#playing-prop">QMediaPlayer::<wbr/>playingChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="playing")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> playingChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#positionChanged">QMediaPlayer::<wbr/>positionChanged(qint64)</a></code></p>
     */
    @QtPropertyNotify(name="position")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Long> positionChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#seekableChanged">QMediaPlayer::<wbr/>seekableChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="seekable")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> seekableChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#sourceChanged">QMediaPlayer::<wbr/>sourceChanged(QUrl)</a></code></p>
     */
    @QtPropertyNotify(name="source")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> sourceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#tracksChanged">QMediaPlayer::<wbr/>tracksChanged()</a></code></p>
     */
    @QtPropertyNotify(name="audioTracks")
    public final @NonNull Signal0 tracksChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#videoOutput-prop">QMediaPlayer::<wbr/>videoOutputChanged()</a></code></p>
     */
    @QtPropertyNotify(name="videoOutput")
    public final @NonNull Signal0 videoOutputChanged = new Signal0();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#QMediaPlayer">QMediaPlayer::<wbr/>QMediaPlayer(QObject*)</a></code></p>
     */
    public QMediaPlayer(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QMediaPlayer instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#activeAudioTrack-prop">QMediaPlayer::<wbr/>activeAudioTrack()const</a></code></p>
     */
    @QtPropertyReader(name="activeAudioTrack")
    @QtUninvokable
    public final int activeAudioTrack(){
        return activeAudioTrack_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int activeAudioTrack_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#activeSubtitleTrack-prop">QMediaPlayer::<wbr/>activeSubtitleTrack()const</a></code></p>
     */
    @QtPropertyReader(name="activeSubtitleTrack")
    @QtUninvokable
    public final int activeSubtitleTrack(){
        return activeSubtitleTrack_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int activeSubtitleTrack_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#activeVideoTrack-prop">QMediaPlayer::<wbr/>activeVideoTrack()const</a></code></p>
     */
    @QtPropertyReader(name="activeVideoTrack")
    @QtUninvokable
    public final int activeVideoTrack(){
        return activeVideoTrack_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int activeVideoTrack_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#audioOutput-prop">QMediaPlayer::<wbr/>audioOutput()const</a></code></p>
     */
    @QtPropertyReader(name="audioOutput")
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QAudioOutput audioOutput(){
        return audioOutput_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QAudioOutput audioOutput_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#audioTracks-prop">QMediaPlayer::<wbr/>audioTracks()const</a></code></p>
     */
    @QtPropertyReader(name="audioTracks")
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.multimedia.@NonNull QMediaMetaData> audioTracks(){
        return audioTracks_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.multimedia.QMediaMetaData> audioTracks_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#bufferProgress">QMediaPlayer::<wbr/>bufferProgress()const</a></code></p>
     */
    @QtPropertyReader(name="bufferProgress")
    @QtUninvokable
    public final float bufferProgress(){
        return bufferProgress_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float bufferProgress_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#bufferedTimeRange">QMediaPlayer::<wbr/>bufferedTimeRange()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QMediaTimeRange bufferedTimeRange(){
        return bufferedTimeRange_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QMediaTimeRange bufferedTimeRange_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#duration">QMediaPlayer::<wbr/>duration()const</a></code></p>
     */
    @QtPropertyReader(name="duration")
    @QtUninvokable
    public final long duration(){
        return duration_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long duration_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#error">QMediaPlayer::<wbr/>error()const</a></code></p>
     */
    @QtPropertyReader(name="error")
    @QtUninvokable
    public final io.qt.multimedia.QMediaPlayer.@NonNull Error error(){
        return io.qt.multimedia.QMediaPlayer.Error.resolve(error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int error_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#errorString-prop">QMediaPlayer::<wbr/>errorString()const</a></code></p>
     */
    @QtPropertyReader(name="errorString")
    @QtUninvokable
    public final java.lang.@NonNull String errorString(){
        return errorString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String errorString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#hasAudio-prop">QMediaPlayer::<wbr/>hasAudio()const</a></code></p>
     */
    @QtPropertyReader(name="hasAudio")
    @QtUninvokable
    public final boolean hasAudio(){
        return hasAudio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean hasAudio_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#hasVideo-prop">QMediaPlayer::<wbr/>hasVideo()const</a></code></p>
     */
    @QtPropertyReader(name="hasVideo")
    @QtUninvokable
    public final boolean hasVideo(){
        return hasVideo_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean hasVideo_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#isAvailable">QMediaPlayer::<wbr/>isAvailable()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isAvailable(){
        return isAvailable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAvailable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#playing-prop">QMediaPlayer::<wbr/>isPlaying()const</a></code></p>
     */
    @QtPropertyReader(name="playing")
    @QtUninvokable
    public final boolean isPlaying(){
        return isPlaying_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isPlaying_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#isSeekable">QMediaPlayer::<wbr/>isSeekable()const</a></code></p>
     */
    @QtPropertyReader(name="seekable")
    @QtUninvokable
    public final boolean isSeekable(){
        return isSeekable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isSeekable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#loops-prop">QMediaPlayer::<wbr/>loops()const</a></code></p>
     */
    @QtPropertyReader(name="loops")
    @QtUninvokable
    public final int loops(){
        return loops_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int loops_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#mediaStatus-prop">QMediaPlayer::<wbr/>mediaStatus()const</a></code></p>
     */
    @QtPropertyReader(name="mediaStatus")
    @QtUninvokable
    public final io.qt.multimedia.QMediaPlayer.@NonNull MediaStatus mediaStatus(){
        return io.qt.multimedia.QMediaPlayer.MediaStatus.resolve(mediaStatus_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int mediaStatus_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#metaData-prop">QMediaPlayer::<wbr/>metaData()const</a></code></p>
     */
    @QtPropertyReader(name="metaData")
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QMediaMetaData metaData(){
        return metaData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QMediaMetaData metaData_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#pause">QMediaPlayer::<wbr/>pause()</a></code></p>
     */
    public final void pause(){
        pause_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void pause_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#play">QMediaPlayer::<wbr/>play()</a></code></p>
     */
    public final void play(){
        play_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void play_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#playbackRate">QMediaPlayer::<wbr/>playbackRate()const</a></code></p>
     */
    @QtPropertyReader(name="playbackRate")
    @QtUninvokable
    public final double playbackRate(){
        return playbackRate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double playbackRate_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#playbackState-prop">QMediaPlayer::<wbr/>playbackState()const</a></code></p>
     */
    @QtPropertyReader(name="playbackState")
    @QtUninvokable
    public final io.qt.multimedia.QMediaPlayer.@NonNull PlaybackState playbackState(){
        return io.qt.multimedia.QMediaPlayer.PlaybackState.resolve(playbackState_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int playbackState_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#position">QMediaPlayer::<wbr/>position()const</a></code></p>
     */
    @QtPropertyReader(name="position")
    @QtUninvokable
    public final long position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long position_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#activeAudioTrack-prop">QMediaPlayer::<wbr/>setActiveAudioTrack(int)</a></code></p>
     */
    @QtPropertyWriter(name="activeAudioTrack")
    @QtUninvokable
    public final void setActiveAudioTrack(int index){
        setActiveAudioTrack_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void setActiveAudioTrack_native_int(long __this__nativeId, int index);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#activeSubtitleTrack-prop">QMediaPlayer::<wbr/>setActiveSubtitleTrack(int)</a></code></p>
     */
    @QtPropertyWriter(name="activeSubtitleTrack")
    @QtUninvokable
    public final void setActiveSubtitleTrack(int index){
        setActiveSubtitleTrack_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void setActiveSubtitleTrack_native_int(long __this__nativeId, int index);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#activeVideoTrack-prop">QMediaPlayer::<wbr/>setActiveVideoTrack(int)</a></code></p>
     */
    @QtPropertyWriter(name="activeVideoTrack")
    @QtUninvokable
    public final void setActiveVideoTrack(int index){
        setActiveVideoTrack_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void setActiveVideoTrack_native_int(long __this__nativeId, int index);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#audioOutput-prop">QMediaPlayer::<wbr/>setAudioOutput(QAudioOutput*)</a></code></p>
     */
    @QtPropertyWriter(name="audioOutput")
    @QtUninvokable
    public final void setAudioOutput(io.qt.multimedia.@Nullable QAudioOutput output){
        setAudioOutput_native_QAudioOutput_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(output));
        __rcAudioOutput = output;
    }
    
    @QtUninvokable
    private native void setAudioOutput_native_QAudioOutput_ptr(long __this__nativeId, long output);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#loops-prop">QMediaPlayer::<wbr/>setLoops(int)</a></code></p>
     */
    @QtPropertyWriter(name="loops")
    @QtUninvokable
    public final void setLoops(int loops){
        setLoops_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), loops);
    }
    
    @QtUninvokable
    private native void setLoops_native_int(long __this__nativeId, int loops);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#playbackRate-prop">QMediaPlayer::<wbr/>setPlaybackRate(qreal)</a></code></p>
     */
    @QtPropertyWriter(name="playbackRate")
    public final void setPlaybackRate(double rate){
        setPlaybackRate_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), rate);
    }
    
    private native void setPlaybackRate_native_qreal(long __this__nativeId, double rate);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#position-prop">QMediaPlayer::<wbr/>setPosition(qint64)</a></code></p>
     */
    @QtPropertyWriter(name="position")
    public final void setPosition(long position){
        setPosition_native_qint64(QtJambi_LibraryUtilities.internal.nativeId(this), position);
    }
    
    private native void setPosition_native_qint64(long __this__nativeId, long position);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#setSource">QMediaPlayer::<wbr/>setSource(QUrl)</a></code></p>
     */
    @QtPropertyWriter(name="source")
    public final void setSource(io.qt.core.@NonNull QUrl source){
        setSource_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    private native void setSource_native_cref_QUrl(long __this__nativeId, long source);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#setSourceDevice">QMediaPlayer::<wbr/>setSourceDevice(QIODevice*,<wbr/>QUrl)</a></code></p>
     */
    public final void setSourceDevice(io.qt.core.@Nullable QIODevice device, io.qt.core.@NonNull QUrl sourceUrl){
        setSourceDevice_native_QIODevice_ptr_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(device), QtJambi_LibraryUtilities.internal.checkedNativeId(sourceUrl));
        __rcSourceDevice = device;
    }
    
    private native void setSourceDevice_native_QIODevice_ptr_cref_QUrl(long __this__nativeId, long device, long sourceUrl);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#videoOutput-prop">QMediaPlayer::<wbr/>setVideoOutput(QObject*)</a></code></p>
     */
    @QtPropertyWriter(name="videoOutput")
    @QtUninvokable
    public final void setVideoOutput(io.qt.core.@Nullable QObject arg__1){
        setVideoOutput_native_QObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
        __rcVideoOutput = arg__1;
    }
    
    @QtUninvokable
    private native void setVideoOutput_native_QObject_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#setVideoSink">QMediaPlayer::<wbr/>setVideoSink(QVideoSink*)</a></code></p>
     */
    @QtUninvokable
    public final void setVideoSink(io.qt.multimedia.@Nullable QVideoSink sink){
        setVideoSink_native_QVideoSink_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sink));
        __rcVideoSink = sink;
    }
    
    @QtUninvokable
    private native void setVideoSink_native_QVideoSink_ptr(long __this__nativeId, long sink);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#source-prop">QMediaPlayer::<wbr/>source()const</a></code></p>
     */
    @QtPropertyReader(name="source")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl source(){
        return source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl source_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#sourceDevice">QMediaPlayer::<wbr/>sourceDevice()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@Nullable QIODevice sourceDevice(){
        return sourceDevice_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QIODevice sourceDevice_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#stop">QMediaPlayer::<wbr/>stop()</a></code></p>
     */
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stop_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#subtitleTracks-prop">QMediaPlayer::<wbr/>subtitleTracks()const</a></code></p>
     */
    @QtPropertyReader(name="subtitleTracks")
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.multimedia.@NonNull QMediaMetaData> subtitleTracks(){
        return subtitleTracks_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.multimedia.QMediaMetaData> subtitleTracks_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#videoOutput-prop">QMediaPlayer::<wbr/>videoOutput()const</a></code></p>
     */
    @QtPropertyReader(name="videoOutput")
    @QtUninvokable
    public final io.qt.core.@Nullable QObject videoOutput(){
        return videoOutput_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QObject videoOutput_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#videoSink">QMediaPlayer::<wbr/>videoSink()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QVideoSink videoSink(){
        return videoSink_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QVideoSink videoSink_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaplayer.html#videoTracks-prop">QMediaPlayer::<wbr/>videoTracks()const</a></code></p>
     */
    @QtPropertyReader(name="videoTracks")
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.multimedia.@NonNull QMediaMetaData> videoTracks(){
        return videoTracks_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.multimedia.QMediaMetaData> videoTracks_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QMediaPlayer(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QMediaPlayer(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QMediaPlayer instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QMediaPlayer(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QMediaPlayer() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #activeAudioTrack()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getActiveAudioTrack() {
        return activeAudioTrack();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #activeSubtitleTrack()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getActiveSubtitleTrack() {
        return activeSubtitleTrack();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #activeVideoTrack()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getActiveVideoTrack() {
        return activeVideoTrack();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #audioOutput()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QAudioOutput getAudioOutput() {
        return audioOutput();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #audioTracks()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.multimedia.@NonNull QMediaMetaData> getAudioTracks() {
        return audioTracks();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #bufferProgress()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getBufferProgress() {
        return bufferProgress();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #duration()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final long getDuration() {
        return duration();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #error()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QMediaPlayer.@NonNull Error getError() {
        return error();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #errorString()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getErrorString() {
        return errorString();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #hasAudio()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getHasAudio() {
        return hasAudio();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #hasVideo()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getHasVideo() {
        return hasVideo();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isPlaying()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getPlaying() {
        return isPlaying();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isSeekable()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getSeekable() {
        return isSeekable();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #loops()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getLoops() {
        return loops();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #mediaStatus()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QMediaPlayer.@NonNull MediaStatus getMediaStatus() {
        return mediaStatus();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #metaData()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QMediaMetaData getMetaData() {
        return metaData();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #playbackRate()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getPlaybackRate() {
        return playbackRate();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #playbackState()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QMediaPlayer.@NonNull PlaybackState getPlaybackState() {
        return playbackState();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #position()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final long getPosition() {
        return position();
    }
    
    /**
     * <p>Overloaded function for {@link #setSource(io.qt.core.QUrl)}.</p>
     */
    public final void setSource(java.lang.@NonNull String source) {
        setSource(new io.qt.core.QUrl(source));
    }
    
    /**
     * <p>Overloaded function for {@link #setSourceDevice(io.qt.core.QIODevice, io.qt.core.QUrl)}
     *  with <code>sourceUrl = new io.qt.core.QUrl()</code>.</p>
     */
    public final void setSourceDevice(io.qt.core.@Nullable QIODevice device) {
        setSourceDevice(device, new io.qt.core.QUrl());
    }
    
    /**
     * <p>Overloaded function for {@link #setSourceDevice(io.qt.core.QIODevice, io.qt.core.QUrl)}.</p>
     */
    public final void setSourceDevice(io.qt.core.@Nullable QIODevice device, java.lang.@NonNull String sourceUrl) {
        setSourceDevice(device, new io.qt.core.QUrl(sourceUrl));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #source()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getSource() {
        return source();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #subtitleTracks()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.multimedia.@NonNull QMediaMetaData> getSubtitleTracks() {
        return subtitleTracks();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #videoOutput()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@Nullable QObject getVideoOutput() {
        return videoOutput();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #videoTracks()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.multimedia.@NonNull QMediaMetaData> getVideoTracks() {
        return videoTracks();
    }
}
