package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Provides meta-data for media files</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qmediametadata.html">QMediaMetaData</a></code></p>
 */
public class QMediaMetaData extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMediaMetaData.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::Key</a></code></p>
     */
    public enum Key implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>Title</a></code></p>
         */
        Title(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>Author</a></code></p>
         */
        Author(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>Comment</a></code></p>
         */
        Comment(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>Description</a></code></p>
         */
        Description(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>Genre</a></code></p>
         */
        Genre(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>Date</a></code></p>
         */
        Date(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>Language</a></code></p>
         */
        Language(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>Publisher</a></code></p>
         */
        Publisher(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>Copyright</a></code></p>
         */
        Copyright(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>Url</a></code></p>
         */
        Url(9),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>Duration</a></code></p>
         */
        Duration(10),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>MediaType</a></code></p>
         */
        MediaType(11),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>FileFormat</a></code></p>
         */
        FileFormat(12),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>AudioBitRate</a></code></p>
         */
        AudioBitRate(13),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>AudioCodec</a></code></p>
         */
        AudioCodec(14),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>VideoBitRate</a></code></p>
         */
        VideoBitRate(15),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>VideoCodec</a></code></p>
         */
        VideoCodec(16),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>VideoFrameRate</a></code></p>
         */
        VideoFrameRate(17),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>AlbumTitle</a></code></p>
         */
        AlbumTitle(18),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>AlbumArtist</a></code></p>
         */
        AlbumArtist(19),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>ContributingArtist</a></code></p>
         */
        ContributingArtist(20),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>TrackNumber</a></code></p>
         */
        TrackNumber(21),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>Composer</a></code></p>
         */
        Composer(22),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>LeadPerformer</a></code></p>
         */
        LeadPerformer(23),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>ThumbnailImage</a></code></p>
         */
        ThumbnailImage(24),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>CoverArtImage</a></code></p>
         */
        CoverArtImage(25),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>Orientation</a></code></p>
         */
        Orientation(26),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediametadata.html#Key-enum">QMediaMetaData::<wbr/>Resolution</a></code></p>
         */
        Resolution(27);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Key(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Key resolve(int value) {
            switch (value) {
            case 0: return Title;
            case 1: return Author;
            case 2: return Comment;
            case 3: return Description;
            case 4: return Genre;
            case 5: return Date;
            case 6: return Language;
            case 7: return Publisher;
            case 8: return Copyright;
            case 9: return Url;
            case 10: return Duration;
            case 11: return MediaType;
            case 12: return FileFormat;
            case 13: return AudioBitRate;
            case 14: return AudioCodec;
            case 15: return VideoBitRate;
            case 16: return VideoCodec;
            case 17: return VideoFrameRate;
            case 18: return AlbumTitle;
            case 19: return AlbumArtist;
            case 20: return ContributingArtist;
            case 21: return TrackNumber;
            case 22: return Composer;
            case 23: return LeadPerformer;
            case 24: return ThumbnailImage;
            case 25: return CoverArtImage;
            case 26: return Orientation;
            case 27: return Resolution;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code>QMediaMetaData::<wbr/>QMediaMetaData()</code></p>
     */
    public QMediaMetaData(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QMediaMetaData instance);
    
    /**
     * <p>See <code>QMediaMetaData::<wbr/>QMediaMetaData(QMediaMetaData)</code></p>
     */
    public QMediaMetaData(io.qt.multimedia.@NonNull QMediaMetaData other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QMediaMetaData instance, io.qt.multimedia.QMediaMetaData other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediametadata.html#clear">QMediaMetaData::<wbr/>clear()</a></code></p>
     */
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediametadata.html#insert">QMediaMetaData::<wbr/>insert(QMediaMetaData::Key,<wbr/>QVariant)</a></code></p>
     */
    public final void insert(io.qt.multimedia.QMediaMetaData.@NonNull Key k, java.lang.Object value){
        insert_native_QMediaMetaData_Key_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), k.value(), value);
    }
    
    private native void insert_native_QMediaMetaData_Key_cref_QVariant(long __this__nativeId, int k, java.lang.Object value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediametadata.html#isEmpty">QMediaMetaData::<wbr/>isEmpty()const</a></code></p>
     */
    public final boolean isEmpty(){
        return isEmpty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native boolean isEmpty_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediametadata.html#keys">QMediaMetaData::<wbr/>keys()const</a></code></p>
     */
    public final io.qt.core.@NonNull QList<io.qt.multimedia.QMediaMetaData.@NonNull Key> keys(){
        return keys_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native io.qt.core.QList<io.qt.multimedia.QMediaMetaData.Key> keys_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediametadata.html#operator-eq-eq">operator==(QMediaMetaData,<wbr/>QMediaMetaData)</a></code></p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.multimedia.@NonNull QMediaMetaData b){
        return equals_native_cref_QMediaMetaData(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(b));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QMediaMetaData(long __this__nativeId, long b);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediametadata.html#operator-5b-5d">QMediaMetaData::<wbr/>operator[](QMediaMetaData::Key)</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object get(io.qt.multimedia.QMediaMetaData.@NonNull Key k){
        return get_native_QMediaMetaData_Key(QtJambi_LibraryUtilities.internal.nativeId(this), k.value());
    }
    
    @QtUninvokable
    private native java.lang.Object get_native_QMediaMetaData_Key(long __this__nativeId, int k);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediametadata.html#operator-5b-5d">QMediaMetaData::<wbr/>operator[](QMediaMetaData::Key)</a></code></p>
     */
    @QtUninvokable
    public final void set(io.qt.multimedia.QMediaMetaData.@NonNull Key k, java.lang.Object value){
        set_native_QMediaMetaData_Key_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), k.value(), value);
    }
    
    @QtUninvokable
    private native void set_native_QMediaMetaData_Key_cref_QVariant(long __this__nativeId, int k, java.lang.Object value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediametadata.html#remove">QMediaMetaData::<wbr/>remove(QMediaMetaData::Key)</a></code></p>
     */
    public final void remove(io.qt.multimedia.QMediaMetaData.@NonNull Key k){
        remove_native_QMediaMetaData_Key(QtJambi_LibraryUtilities.internal.nativeId(this), k.value());
    }
    
    private native void remove_native_QMediaMetaData_Key(long __this__nativeId, int k);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediametadata.html#stringValue">QMediaMetaData::<wbr/>stringValue(QMediaMetaData::Key)const</a></code></p>
     */
    public final java.lang.@NonNull String stringValue(io.qt.multimedia.QMediaMetaData.@NonNull Key k){
        return stringValue_native_QMediaMetaData_Key_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), k.value());
    }
    
    private native java.lang.String stringValue_native_QMediaMetaData_Key_constfct(long __this__nativeId, int k);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediametadata.html#value">QMediaMetaData::<wbr/>value(QMediaMetaData::Key)const</a></code></p>
     */
    public final java.lang.Object value(io.qt.multimedia.QMediaMetaData.@NonNull Key k){
        return value_native_QMediaMetaData_Key_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), k.value());
    }
    
    private native java.lang.Object value_native_QMediaMetaData_Key_constfct(long __this__nativeId, int k);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediametadata.html#keyType">QMediaMetaData::<wbr/>keyType(QMediaMetaData::Key)</a></code></p>
     */
    protected static io.qt.core.@NonNull QMetaType keyType(io.qt.multimedia.QMediaMetaData.@NonNull Key key){
        return keyType_native_QMediaMetaData_Key(key.value());
    }
    
    private native static io.qt.core.QMetaType keyType_native_QMediaMetaData_Key(int key);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediametadata.html#metaDataKeyToString">QMediaMetaData::<wbr/>metaDataKeyToString(QMediaMetaData::Key)</a></code></p>
     */
    public static java.lang.@NonNull String metaDataKeyToString(io.qt.multimedia.QMediaMetaData.@NonNull Key k){
        return metaDataKeyToString_native_QMediaMetaData_Key(k.value());
    }
    
    private native static java.lang.String metaDataKeyToString_native_QMediaMetaData_Key(int k);
    
    /**
     * <p>See <code>QMediaMetaData::<wbr/>NumMetaData</code></p>
     */
    private native static int NumMetaData();
    
    /**
     * <p>See <code>QMediaMetaData::<wbr/>NumMetaData</code></p>
     */
    public static final int NumMetaData = NumMetaData();

    /**
     * <p>The meta data</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qmediametadata.html#data-var">QMediaMetaData::<wbr/>data</a></code></p>
     */
    @QtUninvokable
    protected final void setData(java.util.@NonNull Map<? extends io.qt.multimedia.QMediaMetaData.@NonNull Key, ? extends java.lang.Object> data){
        setData_native_cref_QHash(QtJambi_LibraryUtilities.internal.nativeId(this), data);
    }
    
    @QtUninvokable
    private native void setData_native_cref_QHash(long __this__nativeId, java.util.Map<? extends io.qt.multimedia.QMediaMetaData.Key, ? extends java.lang.Object> data);
    
    /**
     * <p>The meta data</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qmediametadata.html#data-var">QMediaMetaData::<wbr/>data</a></code></p>
     */
    @QtUninvokable
    protected final io.qt.core.@NonNull QHash<io.qt.multimedia.QMediaMetaData.@NonNull Key, java.lang.Object> data(){
        return data_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QHash<io.qt.multimedia.QMediaMetaData.Key, java.lang.Object> data_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QMediaMetaData(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediametadata.html#operator-eq-eq">operator==(QMediaMetaData,<wbr/>QMediaMetaData)</a></code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.multimedia.QMediaMetaData) {
            return equals((io.qt.multimedia.QMediaMetaData) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QMediaMetaData)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return 0;
    }
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code>QMediaMetaData::<wbr/>QMediaMetaData(QMediaMetaData)</code></p>
     */
    @QtUninvokable
    @Override
    public QMediaMetaData clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QMediaMetaData clone_native(long __this_nativeId);
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #NumMetaData()} instead.</p>
     */
    private static int getNumMetaData() {
        return NumMetaData();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #data()} instead.</p>
     */
    @QtUninvokable
    protected final io.qt.core.@NonNull QHash<io.qt.multimedia.QMediaMetaData.@NonNull Key, java.lang.Object> getData() {
        return data();
    }
}
