package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Describes an encoding format for a multimedia file or stream</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qmediaformat.html">QMediaFormat</a></code></p>
 */
public class QMediaFormat extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMediaFormat.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qmediaformat.html#AudioCodec-enum">QMediaFormat::AudioCodec</a></code></p>
     */
    @QtRejectedEntries({"LastAudioCodec"})
    public enum AudioCodec implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#AudioCodec-enum">QMediaFormat::<wbr/>AudioCodec::<wbr/>Unspecified</a></code></p>
         */
        Unspecified(-1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#AudioCodec-enum">QMediaFormat::<wbr/>AudioCodec::<wbr/>MP3</a></code></p>
         */
        MP3(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#AudioCodec-enum">QMediaFormat::<wbr/>AudioCodec::<wbr/>AAC</a></code></p>
         */
        AAC(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#AudioCodec-enum">QMediaFormat::<wbr/>AudioCodec::<wbr/>AC3</a></code></p>
         */
        AC3(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#AudioCodec-enum">QMediaFormat::<wbr/>AudioCodec::<wbr/>EAC3</a></code></p>
         */
        EAC3(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#AudioCodec-enum">QMediaFormat::<wbr/>AudioCodec::<wbr/>FLAC</a></code></p>
         */
        FLAC(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#AudioCodec-enum">QMediaFormat::<wbr/>AudioCodec::<wbr/>DolbyTrueHD</a></code></p>
         */
        DolbyTrueHD(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#AudioCodec-enum">QMediaFormat::<wbr/>AudioCodec::<wbr/>Opus</a></code></p>
         */
        Opus(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#AudioCodec-enum">QMediaFormat::<wbr/>AudioCodec::<wbr/>Vorbis</a></code></p>
         */
        Vorbis(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#AudioCodec-enum">QMediaFormat::<wbr/>AudioCodec::<wbr/>Wave</a></code></p>
         */
        Wave(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#AudioCodec-enum">QMediaFormat::<wbr/>AudioCodec::<wbr/>WMA</a></code></p>
         */
        WMA(9),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#AudioCodec-enum">QMediaFormat::<wbr/>AudioCodec::<wbr/>ALAC</a></code></p>
         */
        ALAC(10),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#AudioCodec-enum">QMediaFormat::<wbr/>AudioCodec::<wbr/>LastAudioCodec</a></code></p>
         */
        LastAudioCodec(10);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private AudioCodec(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull AudioCodec resolve(int value) {
            switch (value) {
            case -1: return Unspecified;
            case 0: return MP3;
            case 1: return AAC;
            case 2: return AC3;
            case 3: return EAC3;
            case 4: return FLAC;
            case 5: return DolbyTrueHD;
            case 6: return Opus;
            case 7: return Vorbis;
            case 8: return Wave;
            case 9: return WMA;
            case 10: return ALAC;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qmediaformat.html#ConversionMode-enum">QMediaFormat::ConversionMode</a></code></p>
     */
    public enum ConversionMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#ConversionMode-enum">QMediaFormat::<wbr/>Encode</a></code></p>
         */
        Encode(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#ConversionMode-enum">QMediaFormat::<wbr/>Decode</a></code></p>
         */
        Decode(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ConversionMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ConversionMode resolve(int value) {
            switch (value) {
            case 0: return Encode;
            case 1: return Decode;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qmediaformat.html#FileFormat-enum">QMediaFormat::FileFormat</a></code></p>
     */
    @QtRejectedEntries({"LastFileFormat"})
    public enum FileFormat implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#FileFormat-enum">QMediaFormat::<wbr/>UnspecifiedFormat</a></code></p>
         */
        UnspecifiedFormat(-1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#FileFormat-enum">QMediaFormat::<wbr/>WMV</a></code></p>
         */
        WMV(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#FileFormat-enum">QMediaFormat::<wbr/>AVI</a></code></p>
         */
        AVI(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#FileFormat-enum">QMediaFormat::<wbr/>Matroska</a></code></p>
         */
        Matroska(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#FileFormat-enum">QMediaFormat::<wbr/>MPEG4</a></code></p>
         */
        MPEG4(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#FileFormat-enum">QMediaFormat::<wbr/>Ogg</a></code></p>
         */
        Ogg(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#FileFormat-enum">QMediaFormat::<wbr/>QuickTime</a></code></p>
         */
        QuickTime(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#FileFormat-enum">QMediaFormat::<wbr/>WebM</a></code></p>
         */
        WebM(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#FileFormat-enum">QMediaFormat::<wbr/>Mpeg4Audio</a></code></p>
         */
        Mpeg4Audio(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#FileFormat-enum">QMediaFormat::<wbr/>AAC</a></code></p>
         */
        AAC(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#FileFormat-enum">QMediaFormat::<wbr/>WMA</a></code></p>
         */
        WMA(9),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#FileFormat-enum">QMediaFormat::<wbr/>MP3</a></code></p>
         */
        MP3(10),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#FileFormat-enum">QMediaFormat::<wbr/>FLAC</a></code></p>
         */
        FLAC(11),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#FileFormat-enum">QMediaFormat::<wbr/>Wave</a></code></p>
         */
        Wave(12),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#FileFormat-enum">QMediaFormat::<wbr/>LastFileFormat</a></code></p>
         */
        LastFileFormat(12);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FileFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull FileFormat resolve(int value) {
            switch (value) {
            case -1: return UnspecifiedFormat;
            case 0: return WMV;
            case 1: return AVI;
            case 2: return Matroska;
            case 3: return MPEG4;
            case 4: return Ogg;
            case 5: return QuickTime;
            case 6: return WebM;
            case 7: return Mpeg4Audio;
            case 8: return AAC;
            case 9: return WMA;
            case 10: return MP3;
            case 11: return FLAC;
            case 12: return Wave;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qmediaformat.html#ResolveFlags-enum">QMediaFormat::ResolveFlags</a></code></p>
     */
    public enum ResolveFlags implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#ResolveFlags-enum">QMediaFormat::<wbr/>NoFlags</a></code></p>
         */
        NoFlags(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#ResolveFlags-enum">QMediaFormat::<wbr/>RequiresVideo</a></code></p>
         */
        RequiresVideo(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ResolveFlags(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ResolveFlags resolve(int value) {
            switch (value) {
            case 0: return NoFlags;
            case 1: return RequiresVideo;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qmediaformat.html#VideoCodec-enum">QMediaFormat::VideoCodec</a></code></p>
     */
    @QtRejectedEntries({"LastVideoCodec"})
    public enum VideoCodec implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#VideoCodec-enum">QMediaFormat::<wbr/>VideoCodec::<wbr/>Unspecified</a></code></p>
         */
        Unspecified(-1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#VideoCodec-enum">QMediaFormat::<wbr/>VideoCodec::<wbr/>MPEG1</a></code></p>
         */
        MPEG1(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#VideoCodec-enum">QMediaFormat::<wbr/>VideoCodec::<wbr/>MPEG2</a></code></p>
         */
        MPEG2(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#VideoCodec-enum">QMediaFormat::<wbr/>VideoCodec::<wbr/>MPEG4</a></code></p>
         */
        MPEG4(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#VideoCodec-enum">QMediaFormat::<wbr/>VideoCodec::<wbr/>H264</a></code></p>
         */
        H264(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#VideoCodec-enum">QMediaFormat::<wbr/>VideoCodec::<wbr/>H265</a></code></p>
         */
        H265(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#VideoCodec-enum">QMediaFormat::<wbr/>VideoCodec::<wbr/>VP8</a></code></p>
         */
        VP8(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#VideoCodec-enum">QMediaFormat::<wbr/>VideoCodec::<wbr/>VP9</a></code></p>
         */
        VP9(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#VideoCodec-enum">QMediaFormat::<wbr/>VideoCodec::<wbr/>AV1</a></code></p>
         */
        AV1(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#VideoCodec-enum">QMediaFormat::<wbr/>VideoCodec::<wbr/>Theora</a></code></p>
         */
        Theora(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#VideoCodec-enum">QMediaFormat::<wbr/>VideoCodec::<wbr/>WMV</a></code></p>
         */
        WMV(9),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#VideoCodec-enum">QMediaFormat::<wbr/>VideoCodec::<wbr/>MotionJPEG</a></code></p>
         */
        MotionJPEG(10),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qmediaformat.html#VideoCodec-enum">QMediaFormat::<wbr/>VideoCodec::<wbr/>LastVideoCodec</a></code></p>
         */
        LastVideoCodec(10);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private VideoCodec(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull VideoCodec resolve(int value) {
            switch (value) {
            case -1: return Unspecified;
            case 0: return MPEG1;
            case 1: return MPEG2;
            case 2: return MPEG4;
            case 3: return H264;
            case 4: return H265;
            case 5: return VP8;
            case 6: return VP9;
            case 7: return AV1;
            case 8: return Theora;
            case 9: return WMV;
            case 10: return MotionJPEG;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#QMediaFormat-1">QMediaFormat::<wbr/>QMediaFormat(QMediaFormat)</a></code></p>
     */
    public QMediaFormat(io.qt.multimedia.@NonNull QMediaFormat other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QMediaFormat instance, io.qt.multimedia.QMediaFormat other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#QMediaFormat">QMediaFormat::<wbr/>QMediaFormat(QMediaFormat::FileFormat)</a></code></p>
     */
    public QMediaFormat(io.qt.multimedia.QMediaFormat.@NonNull FileFormat format){
        super((QPrivateConstructor)null);
        initialize_native(this, format);
    }
    
    private native static void initialize_native(QMediaFormat instance, io.qt.multimedia.QMediaFormat.FileFormat format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#audioCodec">QMediaFormat::<wbr/>audioCodec()const</a></code></p>
     */
    @QtPropertyReader(name="audioCodec")
    @QtUninvokable
    public final io.qt.multimedia.QMediaFormat.@NonNull AudioCodec audioCodec(){
        return io.qt.multimedia.QMediaFormat.AudioCodec.resolve(audioCodec_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int audioCodec_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#fileFormat-prop">QMediaFormat::<wbr/>fileFormat()const</a></code></p>
     */
    @QtPropertyReader(name="fileFormat")
    @QtUninvokable
    public final io.qt.multimedia.QMediaFormat.@NonNull FileFormat fileFormat(){
        return io.qt.multimedia.QMediaFormat.FileFormat.resolve(fileFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int fileFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#isSupported">QMediaFormat::<wbr/>isSupported(QMediaFormat::ConversionMode)const</a></code></p>
     */
    public final boolean isSupported(io.qt.multimedia.QMediaFormat.@NonNull ConversionMode mode){
        return isSupported_native_QMediaFormat_ConversionMode_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    private native boolean isSupported_native_QMediaFormat_ConversionMode_constfct(long __this__nativeId, int mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#mimeType">QMediaFormat::<wbr/>mimeType()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QMimeType mimeType(){
        return mimeType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QMimeType mimeType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#operator-eq">QMediaFormat::<wbr/>operator=(QMediaFormat)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.multimedia.@NonNull QMediaFormat other){
        assign_native_cref_QMediaFormat(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QMediaFormat(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#operator-eq-eq">QMediaFormat::<wbr/>operator==(QMediaFormat)const</a></code></p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.multimedia.@NonNull QMediaFormat other){
        return equals_native_cref_QMediaFormat_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QMediaFormat_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#resolveForEncoding">QMediaFormat::<wbr/>resolveForEncoding(QMediaFormat::ResolveFlags)</a></code></p>
     */
    @QtUninvokable
    public final void resolveForEncoding(io.qt.multimedia.QMediaFormat.@NonNull ResolveFlags flags){
        resolveForEncoding_native_QMediaFormat_ResolveFlags(QtJambi_LibraryUtilities.internal.nativeId(this), flags.value());
    }
    
    @QtUninvokable
    private native void resolveForEncoding_native_QMediaFormat_ResolveFlags(long __this__nativeId, int flags);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#setAudioCodec">QMediaFormat::<wbr/>setAudioCodec(QMediaFormat::AudioCodec)</a></code></p>
     */
    @QtPropertyWriter(name="audioCodec")
    @QtUninvokable
    public final void setAudioCodec(io.qt.multimedia.QMediaFormat.@NonNull AudioCodec codec){
        setAudioCodec_native_QMediaFormat_AudioCodec(QtJambi_LibraryUtilities.internal.nativeId(this), codec.value());
    }
    
    @QtUninvokable
    private native void setAudioCodec_native_QMediaFormat_AudioCodec(long __this__nativeId, int codec);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#fileFormat-prop">QMediaFormat::<wbr/>setFileFormat(QMediaFormat::FileFormat)</a></code></p>
     */
    @QtPropertyWriter(name="fileFormat")
    @QtUninvokable
    public final void setFileFormat(io.qt.multimedia.QMediaFormat.@NonNull FileFormat f){
        setFileFormat_native_QMediaFormat_FileFormat(QtJambi_LibraryUtilities.internal.nativeId(this), f.value());
    }
    
    @QtUninvokable
    private native void setFileFormat_native_QMediaFormat_FileFormat(long __this__nativeId, int f);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#setVideoCodec">QMediaFormat::<wbr/>setVideoCodec(QMediaFormat::VideoCodec)</a></code></p>
     */
    @QtPropertyWriter(name="videoCodec")
    @QtUninvokable
    public final void setVideoCodec(io.qt.multimedia.QMediaFormat.@NonNull VideoCodec codec){
        setVideoCodec_native_QMediaFormat_VideoCodec(QtJambi_LibraryUtilities.internal.nativeId(this), codec.value());
    }
    
    @QtUninvokable
    private native void setVideoCodec_native_QMediaFormat_VideoCodec(long __this__nativeId, int codec);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#supportedAudioCodecs">QMediaFormat::<wbr/>supportedAudioCodecs(QMediaFormat::ConversionMode)</a></code></p>
     */
    public final io.qt.core.@NonNull QList<io.qt.multimedia.QMediaFormat.@NonNull AudioCodec> supportedAudioCodecs(io.qt.multimedia.QMediaFormat.@NonNull ConversionMode m){
        return supportedAudioCodecs_native_QMediaFormat_ConversionMode(QtJambi_LibraryUtilities.internal.nativeId(this), m.value());
    }
    
    private native io.qt.core.QList<io.qt.multimedia.QMediaFormat.AudioCodec> supportedAudioCodecs_native_QMediaFormat_ConversionMode(long __this__nativeId, int m);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#supportedFileFormats">QMediaFormat::<wbr/>supportedFileFormats(QMediaFormat::ConversionMode)</a></code></p>
     */
    public final io.qt.core.@NonNull QList<io.qt.multimedia.QMediaFormat.@NonNull FileFormat> supportedFileFormats(io.qt.multimedia.QMediaFormat.@NonNull ConversionMode m){
        return supportedFileFormats_native_QMediaFormat_ConversionMode(QtJambi_LibraryUtilities.internal.nativeId(this), m.value());
    }
    
    private native io.qt.core.QList<io.qt.multimedia.QMediaFormat.FileFormat> supportedFileFormats_native_QMediaFormat_ConversionMode(long __this__nativeId, int m);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#supportedVideoCodecs">QMediaFormat::<wbr/>supportedVideoCodecs(QMediaFormat::ConversionMode)</a></code></p>
     */
    public final io.qt.core.@NonNull QList<io.qt.multimedia.QMediaFormat.@NonNull VideoCodec> supportedVideoCodecs(io.qt.multimedia.QMediaFormat.@NonNull ConversionMode m){
        return supportedVideoCodecs_native_QMediaFormat_ConversionMode(QtJambi_LibraryUtilities.internal.nativeId(this), m.value());
    }
    
    private native io.qt.core.QList<io.qt.multimedia.QMediaFormat.VideoCodec> supportedVideoCodecs_native_QMediaFormat_ConversionMode(long __this__nativeId, int m);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#swap">QMediaFormat::<wbr/>swap(QMediaFormat&amp;)</a></code></p>
     */
    @QtUninvokable
    public final void swap(io.qt.multimedia.@StrictNonNull QMediaFormat other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QMediaFormat(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QMediaFormat(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#videoCodec">QMediaFormat::<wbr/>videoCodec()const</a></code></p>
     */
    @QtPropertyReader(name="videoCodec")
    @QtUninvokable
    public final io.qt.multimedia.QMediaFormat.@NonNull VideoCodec videoCodec(){
        return io.qt.multimedia.QMediaFormat.VideoCodec.resolve(videoCodec_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int videoCodec_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#audioCodecDescription">QMediaFormat::<wbr/>audioCodecDescription(QMediaFormat::AudioCodec)</a></code></p>
     */
    public static java.lang.@NonNull String audioCodecDescription(io.qt.multimedia.QMediaFormat.@NonNull AudioCodec codec){
        return audioCodecDescription_native_QMediaFormat_AudioCodec(codec.value());
    }
    
    private native static java.lang.String audioCodecDescription_native_QMediaFormat_AudioCodec(int codec);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#audioCodecName">QMediaFormat::<wbr/>audioCodecName(QMediaFormat::AudioCodec)</a></code></p>
     */
    public static java.lang.@NonNull String audioCodecName(io.qt.multimedia.QMediaFormat.@NonNull AudioCodec codec){
        return audioCodecName_native_QMediaFormat_AudioCodec(codec.value());
    }
    
    private native static java.lang.String audioCodecName_native_QMediaFormat_AudioCodec(int codec);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#fileFormatDescription">QMediaFormat::<wbr/>fileFormatDescription(QMediaFormat::FileFormat)</a></code></p>
     */
    public static java.lang.@NonNull String fileFormatDescription(io.qt.multimedia.QMediaFormat.@NonNull FileFormat fileFormat){
        return fileFormatDescription_native_QMediaFormat_FileFormat(fileFormat.value());
    }
    
    private native static java.lang.String fileFormatDescription_native_QMediaFormat_FileFormat(int fileFormat);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#fileFormatName">QMediaFormat::<wbr/>fileFormatName(QMediaFormat::FileFormat)</a></code></p>
     */
    public static java.lang.@NonNull String fileFormatName(io.qt.multimedia.QMediaFormat.@NonNull FileFormat fileFormat){
        return fileFormatName_native_QMediaFormat_FileFormat(fileFormat.value());
    }
    
    private native static java.lang.String fileFormatName_native_QMediaFormat_FileFormat(int fileFormat);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#videoCodecDescription">QMediaFormat::<wbr/>videoCodecDescription(QMediaFormat::VideoCodec)</a></code></p>
     */
    public static java.lang.@NonNull String videoCodecDescription(io.qt.multimedia.QMediaFormat.@NonNull VideoCodec codec){
        return videoCodecDescription_native_QMediaFormat_VideoCodec(codec.value());
    }
    
    private native static java.lang.String videoCodecDescription_native_QMediaFormat_VideoCodec(int codec);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#videoCodecName">QMediaFormat::<wbr/>videoCodecName(QMediaFormat::VideoCodec)</a></code></p>
     */
    public static java.lang.@NonNull String videoCodecName(io.qt.multimedia.QMediaFormat.@NonNull VideoCodec codec){
        return videoCodecName_native_QMediaFormat_VideoCodec(codec.value());
    }
    
    private native static java.lang.String videoCodecName_native_QMediaFormat_VideoCodec(int codec);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QMediaFormat(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#operator-eq-eq">QMediaFormat::<wbr/>operator==(QMediaFormat)const</a></code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.multimedia.QMediaFormat) {
            return equals((io.qt.multimedia.QMediaFormat) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QMediaFormat)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="https://doc.qt.io/qt/qmediaformat.html#QMediaFormat-1">QMediaFormat::<wbr/>QMediaFormat(QMediaFormat)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QMediaFormat clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QMediaFormat clone_native(long __this_nativeId);
    
    /**
     * <p>Overloaded constructor for {@link #QMediaFormat(io.qt.multimedia.QMediaFormat.FileFormat)}
     *  with <code>format = io.qt.multimedia.QMediaFormat.FileFormat.UnspecifiedFormat</code>.</p>
     */
    public QMediaFormat() {
        this(io.qt.multimedia.QMediaFormat.FileFormat.UnspecifiedFormat);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #audioCodec()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QMediaFormat.@NonNull AudioCodec getAudioCodec() {
        return audioCodec();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #fileFormat()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QMediaFormat.@NonNull FileFormat getFileFormat() {
        return fileFormat();
    }
    
    /**
     * <p>Overloaded function for {@link #assign(io.qt.multimedia.QMediaFormat)}.</p>
     */
    @QtUninvokable
    public final void assign(io.qt.multimedia.QMediaFormat.@NonNull FileFormat other) {
        assign(new io.qt.multimedia.QMediaFormat(other));
    }
    
    /**
     * <p>Overloaded function for {@link #equals(io.qt.multimedia.QMediaFormat)}.</p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.multimedia.QMediaFormat.@NonNull FileFormat other) {
        return equals(new io.qt.multimedia.QMediaFormat(other));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #videoCodec()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QMediaFormat.@NonNull VideoCodec getVideoCodec() {
        return videoCodec();
    }
}
