package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Information about available multimedia input and output devices</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qmediadevices.html">QMediaDevices</a></code></p>
 */
public class QMediaDevices extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMediaDevices.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediadevices.html#audioInputsChanged">QMediaDevices::<wbr/>audioInputsChanged()</a></code></p>
     */
    @QtPropertyNotify(name="audioInputs")
    public final @NonNull Signal0 audioInputsChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediadevices.html#audioOutputsChanged">QMediaDevices::<wbr/>audioOutputsChanged()</a></code></p>
     */
    @QtPropertyNotify(name="audioOutputs")
    public final @NonNull Signal0 audioOutputsChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediadevices.html#videoInputsChanged">QMediaDevices::<wbr/>videoInputsChanged()</a></code></p>
     */
    @QtPropertyNotify(name="videoInputs")
    public final @NonNull Signal0 videoInputsChanged = new Signal0();
    
    /**
     * <p>See <code>QMediaDevices::<wbr/>QMediaDevices(QObject*)</code></p>
     */
    public QMediaDevices(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QMediaDevices instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qobject.html#connectNotify">QObject::<wbr/>connectNotify(QMetaMethod)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void connectNotify(io.qt.core.@NonNull QMetaMethod signal){
        connectNotify_native_cref_QMetaMethod(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(signal));
    }
    
    @QtUninvokable
    private native void connectNotify_native_cref_QMetaMethod(long __this__nativeId, long signal);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediadevices.html#audioInputs-prop">QMediaDevices::<wbr/>audioInputs()</a></code></p>
     */
    @QtPropertyReader(name="audioInputs")
    public native static io.qt.core.@NonNull QList<io.qt.multimedia.@NonNull QAudioDevice> audioInputs();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediadevices.html#audioOutputs-prop">QMediaDevices::<wbr/>audioOutputs()</a></code></p>
     */
    @QtPropertyReader(name="audioOutputs")
    public native static io.qt.core.@NonNull QList<io.qt.multimedia.@NonNull QAudioDevice> audioOutputs();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediadevices.html#defaultAudioInput-prop">QMediaDevices::<wbr/>defaultAudioInput()</a></code></p>
     */
    @QtPropertyReader(name="defaultAudioInput")
    public native static io.qt.multimedia.@NonNull QAudioDevice defaultAudioInput();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediadevices.html#defaultAudioOutput-prop">QMediaDevices::<wbr/>defaultAudioOutput()</a></code></p>
     */
    @QtPropertyReader(name="defaultAudioOutput")
    public native static io.qt.multimedia.@NonNull QAudioDevice defaultAudioOutput();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediadevices.html#defaultVideoInput-prop">QMediaDevices::<wbr/>defaultVideoInput()</a></code></p>
     */
    @QtPropertyReader(name="defaultVideoInput")
    public native static io.qt.multimedia.@NonNull QCameraDevice defaultVideoInput();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediadevices.html#videoInputs-prop">QMediaDevices::<wbr/>videoInputs()</a></code></p>
     */
    @QtPropertyReader(name="videoInputs")
    public native static io.qt.core.@NonNull QList<io.qt.multimedia.@NonNull QCameraDevice> videoInputs();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QMediaDevices(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QMediaDevices(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QMediaDevices instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QMediaDevices(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QMediaDevices() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #audioInputs()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static io.qt.core.@NonNull QList<io.qt.multimedia.@NonNull QAudioDevice> getAudioInputs() {
        return audioInputs();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #audioOutputs()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static io.qt.core.@NonNull QList<io.qt.multimedia.@NonNull QAudioDevice> getAudioOutputs() {
        return audioOutputs();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #defaultAudioInput()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static io.qt.multimedia.@NonNull QAudioDevice getDefaultAudioInput() {
        return defaultAudioInput();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #defaultAudioOutput()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static io.qt.multimedia.@NonNull QAudioDevice getDefaultAudioOutput() {
        return defaultAudioOutput();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #defaultVideoInput()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static io.qt.multimedia.@NonNull QCameraDevice getDefaultVideoInput() {
        return defaultVideoInput();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #videoInputs()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public static io.qt.core.@NonNull QList<io.qt.multimedia.@NonNull QCameraDevice> getVideoInputs() {
        return videoInputs();
    }
}
