package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Allows capturing of audio and video content</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qmediacapturesession.html">QMediaCaptureSession</a></code></p>
 */
public class QMediaCaptureSession extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcAudioInput = null;
    @QtPropertyMember(enabled=false)
    private Object __rcAudioOutput = null;
    @QtPropertyMember(enabled=false)
    private Object __rcCamera = null;
    @QtPropertyMember(enabled=false)
    private Object __rcImageCapture = null;
    @QtPropertyMember(enabled=false)
    private Object __rcRecorder = null;
    @QtPropertyMember(enabled=false)
    private Object __rcScreenCapture = null;
    @QtPropertyMember(enabled=false)
    private Object __rcVideoOutput = null;
    @QtPropertyMember(enabled=false)
    private Object __rcVideoSink = null;
    @QtPropertyMember(enabled=false)
    private Object __rcWindowCapture = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMediaCaptureSession.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#audioInput-prop">QMediaCaptureSession::<wbr/>audioInputChanged()</a></code></p>
     */
    @QtPropertyNotify(name="audioInput")
    public final @NonNull Signal0 audioInputChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#audioOutput-prop">QMediaCaptureSession::<wbr/>audioOutputChanged()</a></code></p>
     */
    @QtPropertyNotify(name="audioOutput")
    public final @NonNull Signal0 audioOutputChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#camera-prop">QMediaCaptureSession::<wbr/>cameraChanged()</a></code></p>
     */
    @QtPropertyNotify(name="camera")
    public final @NonNull Signal0 cameraChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#imageCapture-prop">QMediaCaptureSession::<wbr/>imageCaptureChanged()</a></code></p>
     */
    @QtPropertyNotify(name="imageCapture")
    public final @NonNull Signal0 imageCaptureChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#recorder-prop">QMediaCaptureSession::<wbr/>recorderChanged()</a></code></p>
     */
    @QtPropertyNotify(name="recorder")
    public final @NonNull Signal0 recorderChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#screenCapture-prop">QMediaCaptureSession::<wbr/>screenCaptureChanged()</a></code></p>
     */
    @QtPropertyNotify(name="screenCapture")
    public final @NonNull Signal0 screenCaptureChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#videoOutput-prop">QMediaCaptureSession::<wbr/>videoOutputChanged()</a></code></p>
     */
    @QtPropertyNotify(name="videoOutput")
    public final @NonNull Signal0 videoOutputChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#windowCapture-prop">QMediaCaptureSession::<wbr/>windowCaptureChanged()</a></code></p>
     */
    @QtPropertyNotify(name="windowCapture")
    public final @NonNull Signal0 windowCaptureChanged = new Signal0();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#QMediaCaptureSession">QMediaCaptureSession::<wbr/>QMediaCaptureSession(QObject*)</a></code></p>
     */
    public QMediaCaptureSession(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QMediaCaptureSession instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#audioInput-prop">QMediaCaptureSession::<wbr/>audioInput()const</a></code></p>
     */
    @QtPropertyReader(name="audioInput")
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QAudioInput audioInput(){
        return audioInput_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QAudioInput audioInput_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#audioOutput-prop">QMediaCaptureSession::<wbr/>audioOutput()const</a></code></p>
     */
    @QtPropertyReader(name="audioOutput")
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QAudioOutput audioOutput(){
        return audioOutput_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QAudioOutput audioOutput_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#camera-prop">QMediaCaptureSession::<wbr/>camera()const</a></code></p>
     */
    @QtPropertyReader(name="camera")
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QCamera camera(){
        return camera_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QCamera camera_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#imageCapture-prop">QMediaCaptureSession::<wbr/>imageCapture()</a></code></p>
     */
    @QtPropertyReader(name="imageCapture")
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QImageCapture imageCapture(){
        return imageCapture_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QImageCapture imageCapture_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#recorder-prop">QMediaCaptureSession::<wbr/>recorder()</a></code></p>
     */
    @QtPropertyReader(name="recorder")
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QMediaRecorder recorder(){
        return recorder_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QMediaRecorder recorder_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#screenCapture-prop">QMediaCaptureSession::<wbr/>screenCapture()</a></code></p>
     */
    @QtPropertyReader(name="screenCapture")
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QScreenCapture screenCapture(){
        return screenCapture_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QScreenCapture screenCapture_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#setAudioInput">QMediaCaptureSession::<wbr/>setAudioInput(QAudioInput*)</a></code></p>
     */
    @QtPropertyWriter(name="audioInput")
    @QtUninvokable
    public final void setAudioInput(io.qt.multimedia.@Nullable QAudioInput input){
        setAudioInput_native_QAudioInput_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(input));
        __rcAudioInput = input;
    }
    
    @QtUninvokable
    private native void setAudioInput_native_QAudioInput_ptr(long __this__nativeId, long input);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#setAudioOutput">QMediaCaptureSession::<wbr/>setAudioOutput(QAudioOutput*)</a></code></p>
     */
    @QtPropertyWriter(name="audioOutput")
    @QtUninvokable
    public final void setAudioOutput(io.qt.multimedia.@Nullable QAudioOutput output){
        setAudioOutput_native_QAudioOutput_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(output));
        __rcAudioOutput = output;
    }
    
    @QtUninvokable
    private native void setAudioOutput_native_QAudioOutput_ptr(long __this__nativeId, long output);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#camera-prop">QMediaCaptureSession::<wbr/>setCamera(QCamera*)</a></code></p>
     */
    @QtPropertyWriter(name="camera")
    @QtUninvokable
    public final void setCamera(io.qt.multimedia.@Nullable QCamera camera){
        setCamera_native_QCamera_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(camera));
        __rcCamera = camera;
    }
    
    @QtUninvokable
    private native void setCamera_native_QCamera_ptr(long __this__nativeId, long camera);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#imageCapture-prop">QMediaCaptureSession::<wbr/>setImageCapture(QImageCapture*)</a></code></p>
     */
    @QtPropertyWriter(name="imageCapture")
    @QtUninvokable
    public final void setImageCapture(io.qt.multimedia.@Nullable QImageCapture imageCapture){
        setImageCapture_native_QImageCapture_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(imageCapture));
        __rcImageCapture = imageCapture;
    }
    
    @QtUninvokable
    private native void setImageCapture_native_QImageCapture_ptr(long __this__nativeId, long imageCapture);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#recorder-prop">QMediaCaptureSession::<wbr/>setRecorder(QMediaRecorder*)</a></code></p>
     */
    @QtPropertyWriter(name="recorder")
    @QtUninvokable
    public final void setRecorder(io.qt.multimedia.@Nullable QMediaRecorder recorder){
        setRecorder_native_QMediaRecorder_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(recorder));
        __rcRecorder = recorder;
    }
    
    @QtUninvokable
    private native void setRecorder_native_QMediaRecorder_ptr(long __this__nativeId, long recorder);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#screenCapture-prop">QMediaCaptureSession::<wbr/>setScreenCapture(QScreenCapture*)</a></code></p>
     */
    @QtPropertyWriter(name="screenCapture")
    @QtUninvokable
    public final void setScreenCapture(io.qt.multimedia.@Nullable QScreenCapture screenCapture){
        setScreenCapture_native_QScreenCapture_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(screenCapture));
        __rcScreenCapture = screenCapture;
    }
    
    @QtUninvokable
    private native void setScreenCapture_native_QScreenCapture_ptr(long __this__nativeId, long screenCapture);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#setVideoOutput">QMediaCaptureSession::<wbr/>setVideoOutput(QObject*)</a></code></p>
     */
    @QtPropertyWriter(name="videoOutput")
    @QtUninvokable
    public final void setVideoOutput(io.qt.core.@Nullable QObject output){
        setVideoOutput_native_QObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(output));
        __rcVideoOutput = output;
    }
    
    @QtUninvokable
    private native void setVideoOutput_native_QObject_ptr(long __this__nativeId, long output);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#setVideoSink">QMediaCaptureSession::<wbr/>setVideoSink(QVideoSink*)</a></code></p>
     */
    @QtUninvokable
    public final void setVideoSink(io.qt.multimedia.@Nullable QVideoSink sink){
        setVideoSink_native_QVideoSink_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sink));
        __rcVideoSink = sink;
    }
    
    @QtUninvokable
    private native void setVideoSink_native_QVideoSink_ptr(long __this__nativeId, long sink);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#windowCapture-prop">QMediaCaptureSession::<wbr/>setWindowCapture(QWindowCapture*)</a></code></p>
     */
    @QtPropertyWriter(name="windowCapture")
    @QtUninvokable
    public final void setWindowCapture(io.qt.multimedia.@Nullable QWindowCapture windowCapture){
        setWindowCapture_native_QWindowCapture_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(windowCapture));
        __rcWindowCapture = windowCapture;
    }
    
    @QtUninvokable
    private native void setWindowCapture_native_QWindowCapture_ptr(long __this__nativeId, long windowCapture);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#videoOutput-prop">QMediaCaptureSession::<wbr/>videoOutput()const</a></code></p>
     */
    @QtPropertyReader(name="videoOutput")
    @QtUninvokable
    public final io.qt.core.@Nullable QObject videoOutput(){
        return videoOutput_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QObject videoOutput_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#videoSink">QMediaCaptureSession::<wbr/>videoSink()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QVideoSink videoSink(){
        return videoSink_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QVideoSink videoSink_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qmediacapturesession.html#windowCapture-prop">QMediaCaptureSession::<wbr/>windowCapture()</a></code></p>
     */
    @QtPropertyReader(name="windowCapture")
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QWindowCapture windowCapture(){
        return windowCapture_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QWindowCapture windowCapture_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QMediaCaptureSession(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QMediaCaptureSession(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QMediaCaptureSession instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QMediaCaptureSession(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QMediaCaptureSession() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #audioInput()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QAudioInput getAudioInput() {
        return audioInput();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #audioOutput()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QAudioOutput getAudioOutput() {
        return audioOutput();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #camera()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QCamera getCamera() {
        return camera();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #imageCapture()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QImageCapture getImageCapture() {
        return imageCapture();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #recorder()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QMediaRecorder getRecorder() {
        return recorder();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #screenCapture()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QScreenCapture getScreenCapture() {
        return screenCapture();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #videoOutput()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@Nullable QObject getVideoOutput() {
        return videoOutput();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #windowCapture()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QWindowCapture getWindowCapture() {
        return windowCapture();
    }
}
