package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Used for the recording of media content</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qimagecapture.html">QImageCapture</a></code></p>
 */
public class QImageCapture extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QImageCapture.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qimagecapture.html#Error-enum">QImageCapture::Error</a></code></p>
     */
    public enum Error implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qimagecapture.html#Error-enum">QImageCapture::<wbr/>NoError</a></code></p>
         */
        NoError(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qimagecapture.html#Error-enum">QImageCapture::<wbr/>NotReadyError</a></code></p>
         */
        NotReadyError(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qimagecapture.html#Error-enum">QImageCapture::<wbr/>ResourceError</a></code></p>
         */
        ResourceError(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qimagecapture.html#Error-enum">QImageCapture::<wbr/>OutOfSpaceError</a></code></p>
         */
        OutOfSpaceError(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qimagecapture.html#Error-enum">QImageCapture::<wbr/>NotSupportedFeatureError</a></code></p>
         */
        NotSupportedFeatureError(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qimagecapture.html#Error-enum">QImageCapture::<wbr/>FormatError</a></code></p>
         */
        FormatError(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Error resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return NotReadyError;
            case 2: return ResourceError;
            case 3: return OutOfSpaceError;
            case 4: return NotSupportedFeatureError;
            case 5: return FormatError;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qimagecapture.html#FileFormat-enum">QImageCapture::FileFormat</a></code></p>
     */
    @QtRejectedEntries({"LastFileFormat"})
    public enum FileFormat implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qimagecapture.html#FileFormat-enum">QImageCapture::<wbr/>UnspecifiedFormat</a></code></p>
         */
        UnspecifiedFormat(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qimagecapture.html#FileFormat-enum">QImageCapture::<wbr/>JPEG</a></code></p>
         */
        JPEG(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qimagecapture.html#FileFormat-enum">QImageCapture::<wbr/>PNG</a></code></p>
         */
        PNG(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qimagecapture.html#FileFormat-enum">QImageCapture::<wbr/>WebP</a></code></p>
         */
        WebP(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qimagecapture.html#FileFormat-enum">QImageCapture::<wbr/>Tiff</a></code></p>
         */
        Tiff(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qimagecapture.html#FileFormat-enum">QImageCapture::<wbr/>LastFileFormat</a></code></p>
         */
        LastFileFormat(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FileFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull FileFormat resolve(int value) {
            switch (value) {
            case 0: return UnspecifiedFormat;
            case 1: return JPEG;
            case 2: return PNG;
            case 3: return WebP;
            case 4: return Tiff;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qimagecapture.html#Quality-enum">QImageCapture::Quality</a></code></p>
     */
    public enum Quality implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qimagecapture.html#Quality-enum">QImageCapture::<wbr/>VeryLowQuality</a></code></p>
         */
        VeryLowQuality(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qimagecapture.html#Quality-enum">QImageCapture::<wbr/>LowQuality</a></code></p>
         */
        LowQuality(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qimagecapture.html#Quality-enum">QImageCapture::<wbr/>NormalQuality</a></code></p>
         */
        NormalQuality(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qimagecapture.html#Quality-enum">QImageCapture::<wbr/>HighQuality</a></code></p>
         */
        HighQuality(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qimagecapture.html#Quality-enum">QImageCapture::<wbr/>VeryHighQuality</a></code></p>
         */
        VeryHighQuality(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Quality(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Quality resolve(int value) {
            switch (value) {
            case 0: return VeryLowQuality;
            case 1: return LowQuality;
            case 2: return NormalQuality;
            case 3: return HighQuality;
            case 4: return VeryHighQuality;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#errorChanged">QImageCapture::<wbr/>errorChanged()</a></code></p>
     */
    @QtPropertyNotify(name="error")
    public final @NonNull Signal0 errorChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#errorOccurred">QImageCapture::<wbr/>errorOccurred(int,<wbr/>QImageCapture::Error,<wbr/>QString)</a></code></p>
     */
    public final @NonNull Signal3<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.multimedia.QImageCapture.@NonNull Error, java.lang.@NonNull String> errorOccurred = new Signal3<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#fileFormat-prop">QImageCapture::<wbr/>fileFormatChanged()</a></code></p>
     */
    @QtPropertyNotify(name="fileFormat")
    public final @NonNull Signal0 fileFormatChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#imageAvailable">QImageCapture::<wbr/>imageAvailable(int,<wbr/>QVideoFrame)</a></code></p>
     * <p><b>Make sure to dispose frame object at the end of the slot!</b></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.multimedia.@NonNull QVideoFrame> imageAvailable = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#imageCaptured">QImageCapture::<wbr/>imageCaptured(int,<wbr/>QImage)</a></code></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.gui.@NonNull QImage> imageCaptured = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#imageExposed">QImageCapture::<wbr/>imageExposed(int)</a></code></p>
     */
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> imageExposed = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#imageMetadataAvailable">QImageCapture::<wbr/>imageMetadataAvailable(int,<wbr/>QMediaMetaData)</a></code></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.multimedia.@NonNull QMediaMetaData> imageMetadataAvailable = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#imageSaved">QImageCapture::<wbr/>imageSaved(int,<wbr/>QString)</a></code></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@NonNull String> imageSaved = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#metaData-prop">QImageCapture::<wbr/>metaDataChanged()</a></code></p>
     */
    @QtPropertyNotify(name="metaData")
    public final @NonNull Signal0 metaDataChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#quality-prop">QImageCapture::<wbr/>qualityChanged()</a></code></p>
     */
    @QtPropertyNotify(name="quality")
    public final @NonNull Signal0 qualityChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#readyForCaptureChanged">QImageCapture::<wbr/>readyForCaptureChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="readyForCapture")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> readyForCaptureChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#resolutionChanged">QImageCapture::<wbr/>resolutionChanged()</a></code></p>
     */
    public final @NonNull Signal0 resolutionChanged = new Signal0();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#QImageCapture">QImageCapture::<wbr/>QImageCapture(QObject*)</a></code></p>
     */
    public QImageCapture(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QImageCapture instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#addMetaData">QImageCapture::<wbr/>addMetaData(QMediaMetaData)</a></code></p>
     */
    @QtUninvokable
    public final void addMetaData(io.qt.multimedia.@NonNull QMediaMetaData metaData){
        addMetaData_native_cref_QMediaMetaData(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(metaData));
    }
    
    @QtUninvokable
    private native void addMetaData_native_cref_QMediaMetaData(long __this__nativeId, long metaData);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#capture">QImageCapture::<wbr/>capture()</a></code></p>
     */
    public final int capture(){
        return capture_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native int capture_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#captureSession">QImageCapture::<wbr/>captureSession()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QMediaCaptureSession captureSession(){
        return captureSession_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QMediaCaptureSession captureSession_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#captureToFile">QImageCapture::<wbr/>captureToFile(QString)</a></code></p>
     */
    public final int captureToFile(java.lang.@NonNull String location){
        return captureToFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), location);
    }
    
    private native int captureToFile_native_cref_QString(long __this__nativeId, java.lang.String location);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#error-prop">QImageCapture::<wbr/>error()const</a></code></p>
     */
    @QtPropertyReader(name="error")
    @QtUninvokable
    public final io.qt.multimedia.QImageCapture.@NonNull Error error(){
        return io.qt.multimedia.QImageCapture.Error.resolve(error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int error_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#errorString-prop">QImageCapture::<wbr/>errorString()const</a></code></p>
     */
    @QtPropertyReader(name="errorString")
    @QtUninvokable
    public final java.lang.@NonNull String errorString(){
        return errorString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String errorString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#fileFormat-prop">QImageCapture::<wbr/>fileFormat()const</a></code></p>
     */
    @QtPropertyReader(name="fileFormat")
    @QtUninvokable
    public final io.qt.multimedia.QImageCapture.@NonNull FileFormat fileFormat(){
        return io.qt.multimedia.QImageCapture.FileFormat.resolve(fileFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int fileFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#isAvailable">QImageCapture::<wbr/>isAvailable()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isAvailable(){
        return isAvailable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAvailable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#readyForCapture-prop">QImageCapture::<wbr/>isReadyForCapture()const</a></code></p>
     */
    @QtPropertyReader(name="readyForCapture")
    @QtUninvokable
    public final boolean isReadyForCapture(){
        return isReadyForCapture_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isReadyForCapture_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#metaData-prop">QImageCapture::<wbr/>metaData()const</a></code></p>
     */
    @QtPropertyReader(name="metaData")
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QMediaMetaData metaData(){
        return metaData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QMediaMetaData metaData_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#quality-prop">QImageCapture::<wbr/>quality()const</a></code></p>
     */
    @QtPropertyReader(name="quality")
    @QtUninvokable
    public final io.qt.multimedia.QImageCapture.@NonNull Quality quality(){
        return io.qt.multimedia.QImageCapture.Quality.resolve(quality_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int quality_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#resolution">QImageCapture::<wbr/>resolution()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QSize resolution(){
        return resolution_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSize resolution_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#setFileFormat">QImageCapture::<wbr/>setFileFormat(QImageCapture::FileFormat)</a></code></p>
     */
    @QtUninvokable
    public final void setFileFormat(io.qt.multimedia.QImageCapture.@NonNull FileFormat format){
        setFileFormat_native_QImageCapture_FileFormat(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    @QtUninvokable
    private native void setFileFormat_native_QImageCapture_FileFormat(long __this__nativeId, int format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#setMetaData">QImageCapture::<wbr/>setMetaData(QMediaMetaData)</a></code></p>
     */
    @QtPropertyWriter(name="metaData")
    @QtUninvokable
    public final void setMetaData(io.qt.multimedia.@NonNull QMediaMetaData metaData){
        setMetaData_native_cref_QMediaMetaData(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(metaData));
    }
    
    @QtUninvokable
    private native void setMetaData_native_cref_QMediaMetaData(long __this__nativeId, long metaData);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#setQuality">QImageCapture::<wbr/>setQuality(QImageCapture::Quality)</a></code></p>
     */
    @QtUninvokable
    public final void setQuality(io.qt.multimedia.QImageCapture.@NonNull Quality quality){
        setQuality_native_QImageCapture_Quality(QtJambi_LibraryUtilities.internal.nativeId(this), quality.value());
    }
    
    @QtUninvokable
    private native void setQuality_native_QImageCapture_Quality(long __this__nativeId, int quality);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#setResolution">QImageCapture::<wbr/>setResolution(QSize)</a></code></p>
     */
    @QtUninvokable
    public final void setResolution(io.qt.core.@NonNull QSize arg__1){
        setResolution_native_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void setResolution_native_cref_QSize(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#setResolution-1">QImageCapture::<wbr/>setResolution(int,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setResolution(int width, int height){
        setResolution_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), width, height);
    }
    
    @QtUninvokable
    private native void setResolution_native_int_int(long __this__nativeId, int width, int height);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#fileFormatDescription">QImageCapture::<wbr/>fileFormatDescription(QImageCapture::FileFormat)</a></code></p>
     */
    public static java.lang.@NonNull String fileFormatDescription(io.qt.multimedia.QImageCapture.@NonNull FileFormat c){
        return fileFormatDescription_native_QImageCapture_FileFormat(c.value());
    }
    
    private native static java.lang.String fileFormatDescription_native_QImageCapture_FileFormat(int c);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#fileFormatName">QImageCapture::<wbr/>fileFormatName(QImageCapture::FileFormat)</a></code></p>
     */
    public static java.lang.@NonNull String fileFormatName(io.qt.multimedia.QImageCapture.@NonNull FileFormat c){
        return fileFormatName_native_QImageCapture_FileFormat(c.value());
    }
    
    private native static java.lang.String fileFormatName_native_QImageCapture_FileFormat(int c);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qimagecapture.html#supportedFormats">QImageCapture::<wbr/>supportedFormats()</a></code></p>
     */
    public native static io.qt.core.@NonNull QList<io.qt.multimedia.QImageCapture.@NonNull FileFormat> supportedFormats();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QImageCapture(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QImageCapture(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QImageCapture instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QImageCapture(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QImageCapture() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded function for {@link #captureToFile(java.lang.String)}
     *  with <code>location = (String)null</code>.</p>
     */
    public final int captureToFile() {
        return captureToFile((String)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #error()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QImageCapture.@NonNull Error getError() {
        return error();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #errorString()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getErrorString() {
        return errorString();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #fileFormat()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QImageCapture.@NonNull FileFormat getFileFormat() {
        return fileFormat();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isReadyForCapture()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getReadyForCapture() {
        return isReadyForCapture();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #metaData()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QMediaMetaData getMetaData() {
        return metaData();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #quality()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QImageCapture.@NonNull Quality getQuality() {
        return quality();
    }
}
