package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Describes a video format supported by a camera device</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qcameraformat.html">QCameraFormat</a></code></p>
 */
public class QCameraFormat extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QCameraFormat.class);
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameraformat.html#QCameraFormat">QCameraFormat::<wbr/>QCameraFormat()</a></code></p>
     */
    public QCameraFormat(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QCameraFormat instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameraformat.html#QCameraFormat-1">QCameraFormat::<wbr/>QCameraFormat(QCameraFormat)</a></code></p>
     */
    public QCameraFormat(io.qt.multimedia.@NonNull QCameraFormat other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QCameraFormat instance, io.qt.multimedia.QCameraFormat other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameraformat.html#isNull">QCameraFormat::<wbr/>isNull()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameraformat.html#maxFrameRate-prop">QCameraFormat::<wbr/>maxFrameRate()const</a></code></p>
     */
    @QtPropertyReader(name="maxFrameRate")
    @QtPropertyConstant
    @QtUninvokable
    public final float maxFrameRate(){
        return maxFrameRate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float maxFrameRate_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameraformat.html#minFrameRate-prop">QCameraFormat::<wbr/>minFrameRate()const</a></code></p>
     */
    @QtPropertyReader(name="minFrameRate")
    @QtPropertyConstant
    @QtUninvokable
    public final float minFrameRate(){
        return minFrameRate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float minFrameRate_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameraformat.html#operator-eq">QCameraFormat::<wbr/>operator=(QCameraFormat)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.multimedia.@NonNull QCameraFormat other){
        assign_native_cref_QCameraFormat(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QCameraFormat(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameraformat.html#operator-eq-eq">QCameraFormat::<wbr/>operator==(QCameraFormat)const</a></code></p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.multimedia.@NonNull QCameraFormat other){
        return equals_native_cref_QCameraFormat_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QCameraFormat_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameraformat.html#pixelFormat-prop">QCameraFormat::<wbr/>pixelFormat()const</a></code></p>
     */
    @QtPropertyReader(name="pixelFormat")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.multimedia.QVideoFrameFormat.@NonNull PixelFormat pixelFormat(){
        return io.qt.multimedia.QVideoFrameFormat.PixelFormat.resolve(pixelFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int pixelFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameraformat.html#resolution-prop">QCameraFormat::<wbr/>resolution()const</a></code></p>
     */
    @QtPropertyReader(name="resolution")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QSize resolution(){
        return resolution_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSize resolution_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QCameraFormat(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameraformat.html#operator-eq-eq">QCameraFormat::<wbr/>operator==(QCameraFormat)const</a></code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.multimedia.QCameraFormat) {
            return equals((io.qt.multimedia.QCameraFormat) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QCameraFormat)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="https://doc.qt.io/qt/qcameraformat.html#QCameraFormat-1">QCameraFormat::<wbr/>QCameraFormat(QCameraFormat)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QCameraFormat clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QCameraFormat clone_native(long __this_nativeId);
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #maxFrameRate()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMaxFrameRate() {
        return maxFrameRate();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #minFrameRate()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMinFrameRate() {
        return minFrameRate();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #pixelFormat()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QVideoFrameFormat.@NonNull PixelFormat getPixelFormat() {
        return pixelFormat();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #resolution()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QSize getResolution() {
        return resolution();
    }
}
