package io.qt.multimedia;

import io.qt.*;


/**
 * <p>General information about camera devices</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qcameradevice.html">QCameraDevice</a></code></p>
 */
public class QCameraDevice extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QCameraDevice.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qcameradevice.html#Position-enum">QCameraDevice::Position</a></code></p>
     */
    public enum Position implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcameradevice.html#Position-enum">QCameraDevice::<wbr/>UnspecifiedPosition</a></code></p>
         */
        UnspecifiedPosition(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcameradevice.html#Position-enum">QCameraDevice::<wbr/>BackFace</a></code></p>
         */
        BackFace(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcameradevice.html#Position-enum">QCameraDevice::<wbr/>FrontFace</a></code></p>
         */
        FrontFace(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Position(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Position resolve(int value) {
            switch (value) {
            case 0: return UnspecifiedPosition;
            case 1: return BackFace;
            case 2: return FrontFace;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameradevice.html#QCameraDevice">QCameraDevice::<wbr/>QCameraDevice()</a></code></p>
     */
    public QCameraDevice(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QCameraDevice instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameradevice.html#QCameraDevice-1">QCameraDevice::<wbr/>QCameraDevice(QCameraDevice)</a></code></p>
     */
    public QCameraDevice(io.qt.multimedia.@NonNull QCameraDevice other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QCameraDevice instance, io.qt.multimedia.QCameraDevice other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameradevice.html#correctionAngle-prop">QCameraDevice::<wbr/>correctionAngle()const</a></code></p>
     */
    @QtPropertyReader(name="correctionAngle")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.multimedia.QtVideo.@NonNull Rotation correctionAngle(){
        return io.qt.multimedia.QtVideo.Rotation.resolve(correctionAngle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int correctionAngle_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameradevice.html#description-prop">QCameraDevice::<wbr/>description()const</a></code></p>
     */
    @QtPropertyReader(name="description")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String description(){
        return description_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String description_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameradevice.html#id-prop">QCameraDevice::<wbr/>id()const</a></code></p>
     */
    @QtPropertyReader(name="id")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray id(){
        return id_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray id_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameradevice.html#isDefault-prop">QCameraDevice::<wbr/>isDefault()const</a></code></p>
     */
    @QtPropertyReader(name="isDefault")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean isDefault(){
        return isDefault_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isDefault_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameradevice.html#isNull">QCameraDevice::<wbr/>isNull()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameradevice.html#operator-eq">QCameraDevice::<wbr/>operator=(QCameraDevice)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.multimedia.@NonNull QCameraDevice other){
        assign_native_cref_QCameraDevice(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QCameraDevice(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameradevice.html#operator-eq-eq">QCameraDevice::<wbr/>operator==(QCameraDevice)const</a></code></p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.multimedia.@NonNull QCameraDevice other){
        return equals_native_cref_QCameraDevice_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QCameraDevice_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameradevice.html#photoResolutions">QCameraDevice::<wbr/>photoResolutions()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.core.@NonNull QSize> photoResolutions(){
        return photoResolutions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.core.QSize> photoResolutions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameradevice.html#position-prop">QCameraDevice::<wbr/>position()const</a></code></p>
     */
    @QtPropertyReader(name="position")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.multimedia.QCameraDevice.@NonNull Position position(){
        return io.qt.multimedia.QCameraDevice.Position.resolve(position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int position_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameradevice.html#videoFormats-prop">QCameraDevice::<wbr/>videoFormats()const</a></code></p>
     */
    @QtPropertyReader(name="videoFormats")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.multimedia.@NonNull QCameraFormat> videoFormats(){
        return videoFormats_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.multimedia.QCameraFormat> videoFormats_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QCameraDevice(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcameradevice.html#operator-eq-eq">QCameraDevice::<wbr/>operator==(QCameraDevice)const</a></code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.multimedia.QCameraDevice) {
            return equals((io.qt.multimedia.QCameraDevice) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QCameraDevice)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);

    /**
     * <p>See <code>operator&lt;&lt;(QDebug,<wbr/>QCameraDevice)</code></p>
     */
    @QtUninvokable
    @Override
    public @NonNull String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="https://doc.qt.io/qt/qcameradevice.html#QCameraDevice-1">QCameraDevice::<wbr/>QCameraDevice(QCameraDevice)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QCameraDevice clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QCameraDevice clone_native(long __this_nativeId);
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #correctionAngle()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QtVideo.@NonNull Rotation getCorrectionAngle() {
        return correctionAngle();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #description()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getDescription() {
        return description();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #id()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getId() {
        return id();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #position()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QCameraDevice.@NonNull Position getPosition() {
        return position();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #videoFormats()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.multimedia.@NonNull QCameraFormat> getVideoFormats() {
        return videoFormats();
    }
}
