package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Interface for system camera devices</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qcamera.html">QCamera</a></code></p>
 */
public class QCamera extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QCamera.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qcamera.html#Error-enum">QCamera::Error</a></code></p>
     */
    public enum Error implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#Error-enum">QCamera::<wbr/>NoError</a></code></p>
         */
        NoError(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#Error-enum">QCamera::<wbr/>CameraError</a></code></p>
         */
        CameraError(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Error resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return CameraError;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qcamera.html#ExposureMode-enum">QCamera::ExposureMode</a></code></p>
     */
    public enum ExposureMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#ExposureMode-enum">QCamera::<wbr/>ExposureAuto</a></code></p>
         */
        ExposureAuto(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#ExposureMode-enum">QCamera::<wbr/>ExposureManual</a></code></p>
         */
        ExposureManual(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#ExposureMode-enum">QCamera::<wbr/>ExposurePortrait</a></code></p>
         */
        ExposurePortrait(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#ExposureMode-enum">QCamera::<wbr/>ExposureNight</a></code></p>
         */
        ExposureNight(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#ExposureMode-enum">QCamera::<wbr/>ExposureSports</a></code></p>
         */
        ExposureSports(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#ExposureMode-enum">QCamera::<wbr/>ExposureSnow</a></code></p>
         */
        ExposureSnow(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#ExposureMode-enum">QCamera::<wbr/>ExposureBeach</a></code></p>
         */
        ExposureBeach(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#ExposureMode-enum">QCamera::<wbr/>ExposureAction</a></code></p>
         */
        ExposureAction(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#ExposureMode-enum">QCamera::<wbr/>ExposureLandscape</a></code></p>
         */
        ExposureLandscape(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#ExposureMode-enum">QCamera::<wbr/>ExposureNightPortrait</a></code></p>
         */
        ExposureNightPortrait(9),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#ExposureMode-enum">QCamera::<wbr/>ExposureTheatre</a></code></p>
         */
        ExposureTheatre(10),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#ExposureMode-enum">QCamera::<wbr/>ExposureSunset</a></code></p>
         */
        ExposureSunset(11),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#ExposureMode-enum">QCamera::<wbr/>ExposureSteadyPhoto</a></code></p>
         */
        ExposureSteadyPhoto(12),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#ExposureMode-enum">QCamera::<wbr/>ExposureFireworks</a></code></p>
         */
        ExposureFireworks(13),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#ExposureMode-enum">QCamera::<wbr/>ExposureParty</a></code></p>
         */
        ExposureParty(14),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#ExposureMode-enum">QCamera::<wbr/>ExposureCandlelight</a></code></p>
         */
        ExposureCandlelight(15),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#ExposureMode-enum">QCamera::<wbr/>ExposureBarcode</a></code></p>
         */
        ExposureBarcode(16);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ExposureMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ExposureMode resolve(int value) {
            switch (value) {
            case 0: return ExposureAuto;
            case 1: return ExposureManual;
            case 2: return ExposurePortrait;
            case 3: return ExposureNight;
            case 4: return ExposureSports;
            case 5: return ExposureSnow;
            case 6: return ExposureBeach;
            case 7: return ExposureAction;
            case 8: return ExposureLandscape;
            case 9: return ExposureNightPortrait;
            case 10: return ExposureTheatre;
            case 11: return ExposureSunset;
            case 12: return ExposureSteadyPhoto;
            case 13: return ExposureFireworks;
            case 14: return ExposureParty;
            case 15: return ExposureCandlelight;
            case 16: return ExposureBarcode;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qcamera.html#Feature-enum">QCamera::Feature</a></code></p>
     * 
     * @see Features
     */
    public enum Feature implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#Feature-enum">QCamera::<wbr/>Feature::<wbr/>ColorTemperature</a></code></p>
         */
        ColorTemperature(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#Feature-enum">QCamera::<wbr/>Feature::<wbr/>ExposureCompensation</a></code></p>
         */
        ExposureCompensation(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#Feature-enum">QCamera::<wbr/>Feature::<wbr/>IsoSensitivity</a></code></p>
         */
        IsoSensitivity(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#Feature-enum">QCamera::<wbr/>Feature::<wbr/>ManualExposureTime</a></code></p>
         */
        ManualExposureTime(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#Feature-enum">QCamera::<wbr/>Feature::<wbr/>CustomFocusPoint</a></code></p>
         */
        CustomFocusPoint(16),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#Feature-enum">QCamera::<wbr/>Feature::<wbr/>FocusDistance</a></code></p>
         */
        FocusDistance(32);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Feature(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull Features asFlags() {
            return new Features(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull Features combined(@NonNull Feature e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull Features cleared(@NonNull Feature e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link Features} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull Features flags(@Nullable Feature @NonNull... values) {
            return new Features(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Feature resolve(int value) {
            switch (value) {
            case 1: return ColorTemperature;
            case 2: return ExposureCompensation;
            case 4: return IsoSensitivity;
            case 8: return ManualExposureTime;
            case 16: return CustomFocusPoint;
            case 32: return FocusDistance;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link Feature}
     */
    public static final class Features extends QFlags<Feature> implements Comparable<Features> {
        private static final long serialVersionUID = 0x169fb62bf9f4d5d0L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new Features where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public Features(@Nullable Feature @NonNull... args){
            super(args);
        }

        /**
         * Creates a new Features with given <code>value</code>.
         * @param value
         */
        public Features(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new Features
         */
        @Override
        public final @NonNull Features combined(@StrictNonNull Feature e){
            return new Features(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull Features setFlag(@Nullable Feature e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull Features setFlag(@Nullable Feature e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this Features.
         * @return array of enum entries
         */
        @Override
        public final @NonNull Feature @NonNull[] flags(){
            return super.flags(Feature.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull Features clone(){
            return new Features(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull Features other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qcamera.html#FlashMode-enum">QCamera::FlashMode</a></code></p>
     */
    public enum FlashMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#FlashMode-enum">QCamera::<wbr/>FlashOff</a></code></p>
         */
        FlashOff(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#FlashMode-enum">QCamera::<wbr/>FlashOn</a></code></p>
         */
        FlashOn(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#FlashMode-enum">QCamera::<wbr/>FlashAuto</a></code></p>
         */
        FlashAuto(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FlashMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull FlashMode resolve(int value) {
            switch (value) {
            case 0: return FlashOff;
            case 1: return FlashOn;
            case 2: return FlashAuto;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qcamera.html#FocusMode-enum">QCamera::FocusMode</a></code></p>
     */
    public enum FocusMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#FocusMode-enum">QCamera::<wbr/>FocusModeAuto</a></code></p>
         */
        FocusModeAuto(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#FocusMode-enum">QCamera::<wbr/>FocusModeAutoNear</a></code></p>
         */
        FocusModeAutoNear(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#FocusMode-enum">QCamera::<wbr/>FocusModeAutoFar</a></code></p>
         */
        FocusModeAutoFar(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#FocusMode-enum">QCamera::<wbr/>FocusModeHyperfocal</a></code></p>
         */
        FocusModeHyperfocal(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#FocusMode-enum">QCamera::<wbr/>FocusModeInfinity</a></code></p>
         */
        FocusModeInfinity(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#FocusMode-enum">QCamera::<wbr/>FocusModeManual</a></code></p>
         */
        FocusModeManual(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FocusMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull FocusMode resolve(int value) {
            switch (value) {
            case 0: return FocusModeAuto;
            case 1: return FocusModeAutoNear;
            case 2: return FocusModeAutoFar;
            case 3: return FocusModeHyperfocal;
            case 4: return FocusModeInfinity;
            case 5: return FocusModeManual;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qcamera.html#TorchMode-enum">QCamera::TorchMode</a></code></p>
     */
    public enum TorchMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#TorchMode-enum">QCamera::<wbr/>TorchOff</a></code></p>
         */
        TorchOff(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#TorchMode-enum">QCamera::<wbr/>TorchOn</a></code></p>
         */
        TorchOn(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#TorchMode-enum">QCamera::<wbr/>TorchAuto</a></code></p>
         */
        TorchAuto(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private TorchMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull TorchMode resolve(int value) {
            switch (value) {
            case 0: return TorchOff;
            case 1: return TorchOn;
            case 2: return TorchAuto;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qcamera.html#WhiteBalanceMode-enum">QCamera::WhiteBalanceMode</a></code></p>
     */
    public enum WhiteBalanceMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#WhiteBalanceMode-enum">QCamera::<wbr/>WhiteBalanceAuto</a></code></p>
         */
        WhiteBalanceAuto(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#WhiteBalanceMode-enum">QCamera::<wbr/>WhiteBalanceManual</a></code></p>
         */
        WhiteBalanceManual(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#WhiteBalanceMode-enum">QCamera::<wbr/>WhiteBalanceSunlight</a></code></p>
         */
        WhiteBalanceSunlight(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#WhiteBalanceMode-enum">QCamera::<wbr/>WhiteBalanceCloudy</a></code></p>
         */
        WhiteBalanceCloudy(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#WhiteBalanceMode-enum">QCamera::<wbr/>WhiteBalanceShade</a></code></p>
         */
        WhiteBalanceShade(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#WhiteBalanceMode-enum">QCamera::<wbr/>WhiteBalanceTungsten</a></code></p>
         */
        WhiteBalanceTungsten(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#WhiteBalanceMode-enum">QCamera::<wbr/>WhiteBalanceFluorescent</a></code></p>
         */
        WhiteBalanceFluorescent(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#WhiteBalanceMode-enum">QCamera::<wbr/>WhiteBalanceFlash</a></code></p>
         */
        WhiteBalanceFlash(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qcamera.html#WhiteBalanceMode-enum">QCamera::<wbr/>WhiteBalanceSunset</a></code></p>
         */
        WhiteBalanceSunset(8);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private WhiteBalanceMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull WhiteBalanceMode resolve(int value) {
            switch (value) {
            case 0: return WhiteBalanceAuto;
            case 1: return WhiteBalanceManual;
            case 2: return WhiteBalanceSunlight;
            case 3: return WhiteBalanceCloudy;
            case 4: return WhiteBalanceShade;
            case 5: return WhiteBalanceTungsten;
            case 6: return WhiteBalanceFluorescent;
            case 7: return WhiteBalanceFlash;
            case 8: return WhiteBalanceSunset;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#active-prop">QCamera::<wbr/>activeChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="active")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> activeChanged = new Signal1<>();

    /**
     * <p>See <code>QCamera::<wbr/>brightnessChanged()</code></p>
     */
    public final @NonNull Signal0 brightnessChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#cameraDevice-prop">QCamera::<wbr/>cameraDeviceChanged()</a></code></p>
     */
    @QtPropertyNotify(name="cameraDevice")
    public final @NonNull Signal0 cameraDeviceChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#cameraFormat-prop">QCamera::<wbr/>cameraFormatChanged()</a></code></p>
     */
    @QtPropertyNotify(name="cameraFormat")
    public final @NonNull Signal0 cameraFormatChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#colorTemperature-prop">QCamera::<wbr/>colorTemperatureChanged()const</a></code></p>
     */
    @QtPropertyNotify(name="colorTemperature")
    public final @NonNull Signal0 colorTemperatureChanged = new Signal0();

    /**
     * <p>See <code>QCamera::<wbr/>contrastChanged()</code></p>
     */
    public final @NonNull Signal0 contrastChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#customFocusPoint-prop">QCamera::<wbr/>customFocusPointChanged()</a></code></p>
     */
    @QtPropertyNotify(name="customFocusPoint")
    public final @NonNull Signal0 customFocusPointChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#errorChanged">QCamera::<wbr/>errorChanged()</a></code></p>
     */
    @QtPropertyNotify(name="error")
    public final @NonNull Signal0 errorChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#errorOccurred">QCamera::<wbr/>errorOccurred(QCamera::Error,<wbr/>QString)</a></code></p>
     */
    public final @NonNull Signal2<io.qt.multimedia.QCamera.@NonNull Error, java.lang.@NonNull String> errorOccurred = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#exposureCompensationChanged">QCamera::<wbr/>exposureCompensationChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="exposureCompensation")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> exposureCompensationChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#exposureMode-prop">QCamera::<wbr/>exposureModeChanged()</a></code></p>
     */
    @QtPropertyNotify(name="exposureMode")
    public final @NonNull Signal0 exposureModeChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#exposureTimeChanged">QCamera::<wbr/>exposureTimeChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="exposureTime")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> exposureTimeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#flashMode-prop">QCamera::<wbr/>flashModeChanged()</a></code></p>
     */
    @QtPropertyNotify(name="flashMode")
    public final @NonNull Signal0 flashModeChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#flashReady">QCamera::<wbr/>flashReady(bool)</a></code></p>
     */
    @QtPropertyNotify(name="flashReady")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> flashReady = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#focusDistance-prop">QCamera::<wbr/>focusDistanceChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="focusDistance")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> focusDistanceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#focusModeChanged">QCamera::<wbr/>focusModeChanged()</a></code></p>
     */
    public final @NonNull Signal0 focusModeChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#focusPoint-prop">QCamera::<wbr/>focusPointChanged()</a></code></p>
     */
    @QtPropertyNotify(name="focusPoint")
    public final @NonNull Signal0 focusPointChanged = new Signal0();

    /**
     * <p>See <code>QCamera::<wbr/>hueChanged()</code></p>
     */
    public final @NonNull Signal0 hueChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#isoSensitivityChanged">QCamera::<wbr/>isoSensitivityChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="isoSensitivity")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> isoSensitivityChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#manualExposureTime-prop">QCamera::<wbr/>manualExposureTimeChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="manualExposureTime")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> manualExposureTimeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#manualIsoSensitivity-prop">QCamera::<wbr/>manualIsoSensitivityChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="manualIsoSensitivity")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> manualIsoSensitivityChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#maximumZoomFactor-prop">QCamera::<wbr/>maximumZoomFactorChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="maximumZoomFactor")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> maximumZoomFactorChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#minimumZoomFactor-prop">QCamera::<wbr/>minimumZoomFactorChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="minimumZoomFactor")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> minimumZoomFactorChanged = new Signal1<>();

    /**
     * <p>See <code>QCamera::<wbr/>saturationChanged()</code></p>
     */
    public final @NonNull Signal0 saturationChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#supportedFeatures-prop">QCamera::<wbr/>supportedFeaturesChanged()</a></code></p>
     */
    @QtPropertyNotify(name="supportedFeatures")
    public final @NonNull Signal0 supportedFeaturesChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#torchMode-prop">QCamera::<wbr/>torchModeChanged()</a></code></p>
     */
    @QtPropertyNotify(name="torchMode")
    public final @NonNull Signal0 torchModeChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#whiteBalanceMode-prop">QCamera::<wbr/>whiteBalanceModeChanged()const</a></code></p>
     */
    @QtPropertyNotify(name="whiteBalanceMode")
    public final @NonNull Signal0 whiteBalanceModeChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#zoomFactor-prop">QCamera::<wbr/>zoomFactorChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="zoomFactor")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> zoomFactorChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#QCamera-1">QCamera::<wbr/>QCamera(QCameraDevice,<wbr/>QObject*)</a></code></p>
     */
    public QCamera(io.qt.multimedia.@NonNull QCameraDevice cameraDevice, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, cameraDevice, parent);
    }
    
    private native static void initialize_native(QCamera instance, io.qt.multimedia.QCameraDevice cameraDevice, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#QCamera-2">QCamera::<wbr/>QCamera(QCameraDevice::Position,<wbr/>QObject*)</a></code></p>
     */
    public QCamera(io.qt.multimedia.QCameraDevice.@NonNull Position position, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, position, parent);
    }
    
    private native static void initialize_native(QCamera instance, io.qt.multimedia.QCameraDevice.Position position, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#QCamera">QCamera::<wbr/>QCamera(QObject*)</a></code></p>
     */
    public QCamera(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QCamera instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#cameraDevice-prop">QCamera::<wbr/>cameraDevice()const</a></code></p>
     */
    @QtPropertyReader(name="cameraDevice")
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QCameraDevice cameraDevice(){
        return cameraDevice_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QCameraDevice cameraDevice_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#cameraFormat-prop">QCamera::<wbr/>cameraFormat()const</a></code></p>
     */
    @QtPropertyReader(name="cameraFormat")
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QCameraFormat cameraFormat(){
        return cameraFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QCameraFormat cameraFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#captureSession">QCamera::<wbr/>captureSession()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.@Nullable QMediaCaptureSession captureSession(){
        return captureSession_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QMediaCaptureSession captureSession_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#colorTemperature-prop">QCamera::<wbr/>colorTemperature()const</a></code></p>
     */
    @QtPropertyReader(name="colorTemperature")
    @QtUninvokable
    public final int colorTemperature(){
        return colorTemperature_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int colorTemperature_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#customFocusPoint-prop">QCamera::<wbr/>customFocusPoint()const</a></code></p>
     */
    @QtPropertyReader(name="customFocusPoint")
    @QtUninvokable
    public final io.qt.core.@NonNull QPointF customFocusPoint(){
        return customFocusPoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPointF customFocusPoint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#error-prop">QCamera::<wbr/>error()const</a></code></p>
     */
    @QtPropertyReader(name="error")
    @QtUninvokable
    public final io.qt.multimedia.QCamera.@NonNull Error error(){
        return io.qt.multimedia.QCamera.Error.resolve(error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int error_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#errorString-prop">QCamera::<wbr/>errorString()const</a></code></p>
     */
    @QtPropertyReader(name="errorString")
    @QtUninvokable
    public final java.lang.@NonNull String errorString(){
        return errorString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String errorString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#exposureCompensation-prop">QCamera::<wbr/>exposureCompensation()const</a></code></p>
     */
    @QtPropertyReader(name="exposureCompensation")
    @QtUninvokable
    public final float exposureCompensation(){
        return exposureCompensation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float exposureCompensation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#exposureMode-prop">QCamera::<wbr/>exposureMode()const</a></code></p>
     */
    @QtPropertyReader(name="exposureMode")
    @QtUninvokable
    public final io.qt.multimedia.QCamera.@NonNull ExposureMode exposureMode(){
        return io.qt.multimedia.QCamera.ExposureMode.resolve(exposureMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int exposureMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#exposureTime">QCamera::<wbr/>exposureTime()const</a></code></p>
     */
    @QtPropertyReader(name="exposureTime")
    @QtUninvokable
    public final float exposureTime(){
        return exposureTime_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float exposureTime_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#flashMode-prop">QCamera::<wbr/>flashMode()const</a></code></p>
     */
    @QtPropertyReader(name="flashMode")
    @QtUninvokable
    public final io.qt.multimedia.QCamera.@NonNull FlashMode flashMode(){
        return io.qt.multimedia.QCamera.FlashMode.resolve(flashMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int flashMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#focusDistance-prop">QCamera::<wbr/>focusDistance()const</a></code></p>
     */
    @QtPropertyReader(name="focusDistance")
    @QtUninvokable
    public final float focusDistance(){
        return focusDistance_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float focusDistance_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#focusMode-prop">QCamera::<wbr/>focusMode()const</a></code></p>
     */
    @QtPropertyReader(name="focusMode")
    @QtUninvokable
    public final io.qt.multimedia.QCamera.@NonNull FocusMode focusMode(){
        return io.qt.multimedia.QCamera.FocusMode.resolve(focusMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int focusMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#focusPoint-prop">QCamera::<wbr/>focusPoint()const</a></code></p>
     */
    @QtPropertyReader(name="focusPoint")
    @QtUninvokable
    public final io.qt.core.@NonNull QPointF focusPoint(){
        return focusPoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPointF focusPoint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#isActive">QCamera::<wbr/>isActive()const</a></code></p>
     */
    @QtPropertyReader(name="active")
    @QtUninvokable
    public final boolean isActive(){
        return isActive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isActive_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#isAvailable">QCamera::<wbr/>isAvailable()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isAvailable(){
        return isAvailable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAvailable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#isExposureModeSupported">QCamera::<wbr/>isExposureModeSupported(QCamera::ExposureMode)const</a></code></p>
     */
    public final boolean isExposureModeSupported(io.qt.multimedia.QCamera.@NonNull ExposureMode mode){
        return isExposureModeSupported_native_QCamera_ExposureMode_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    private native boolean isExposureModeSupported_native_QCamera_ExposureMode_constfct(long __this__nativeId, int mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#isFlashModeSupported">QCamera::<wbr/>isFlashModeSupported(QCamera::FlashMode)const</a></code></p>
     */
    public final boolean isFlashModeSupported(io.qt.multimedia.QCamera.@NonNull FlashMode mode){
        return isFlashModeSupported_native_QCamera_FlashMode_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    private native boolean isFlashModeSupported_native_QCamera_FlashMode_constfct(long __this__nativeId, int mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#isFlashReady">QCamera::<wbr/>isFlashReady()const</a></code></p>
     */
    @QtPropertyReader(name="flashReady")
    public final boolean isFlashReady(){
        return isFlashReady_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native boolean isFlashReady_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#isFocusModeSupported">QCamera::<wbr/>isFocusModeSupported(QCamera::FocusMode)const</a></code></p>
     */
    public final boolean isFocusModeSupported(io.qt.multimedia.QCamera.@NonNull FocusMode mode){
        return isFocusModeSupported_native_QCamera_FocusMode_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    private native boolean isFocusModeSupported_native_QCamera_FocusMode_constfct(long __this__nativeId, int mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#isTorchModeSupported">QCamera::<wbr/>isTorchModeSupported(QCamera::TorchMode)const</a></code></p>
     */
    public final boolean isTorchModeSupported(io.qt.multimedia.QCamera.@NonNull TorchMode mode){
        return isTorchModeSupported_native_QCamera_TorchMode_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    private native boolean isTorchModeSupported_native_QCamera_TorchMode_constfct(long __this__nativeId, int mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#isWhiteBalanceModeSupported">QCamera::<wbr/>isWhiteBalanceModeSupported(QCamera::WhiteBalanceMode)const</a></code></p>
     */
    public final boolean isWhiteBalanceModeSupported(io.qt.multimedia.QCamera.@NonNull WhiteBalanceMode mode){
        return isWhiteBalanceModeSupported_native_QCamera_WhiteBalanceMode_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    private native boolean isWhiteBalanceModeSupported_native_QCamera_WhiteBalanceMode_constfct(long __this__nativeId, int mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#isoSensitivity-prop">QCamera::<wbr/>isoSensitivity()const</a></code></p>
     */
    @QtPropertyReader(name="isoSensitivity")
    @QtUninvokable
    public final int isoSensitivity(){
        return isoSensitivity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int isoSensitivity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#manualExposureTime">QCamera::<wbr/>manualExposureTime()const</a></code></p>
     */
    @QtPropertyReader(name="manualExposureTime")
    @QtUninvokable
    public final float manualExposureTime(){
        return manualExposureTime_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float manualExposureTime_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#manualIsoSensitivity-prop">QCamera::<wbr/>manualIsoSensitivity()const</a></code></p>
     */
    @QtPropertyReader(name="manualIsoSensitivity")
    @QtUninvokable
    public final int manualIsoSensitivity(){
        return manualIsoSensitivity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int manualIsoSensitivity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#maximumExposureTime">QCamera::<wbr/>maximumExposureTime()const</a></code></p>
     */
    @QtUninvokable
    public final float maximumExposureTime(){
        return maximumExposureTime_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float maximumExposureTime_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#maximumIsoSensitivity">QCamera::<wbr/>maximumIsoSensitivity()const</a></code></p>
     */
    @QtUninvokable
    public final int maximumIsoSensitivity(){
        return maximumIsoSensitivity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maximumIsoSensitivity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#maximumZoomFactor-prop">QCamera::<wbr/>maximumZoomFactor()const</a></code></p>
     */
    @QtPropertyReader(name="maximumZoomFactor")
    @QtUninvokable
    public final float maximumZoomFactor(){
        return maximumZoomFactor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float maximumZoomFactor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#minimumExposureTime">QCamera::<wbr/>minimumExposureTime()const</a></code></p>
     */
    @QtUninvokable
    public final float minimumExposureTime(){
        return minimumExposureTime_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float minimumExposureTime_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#minimumIsoSensitivity">QCamera::<wbr/>minimumIsoSensitivity()const</a></code></p>
     */
    @QtUninvokable
    public final int minimumIsoSensitivity(){
        return minimumIsoSensitivity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int minimumIsoSensitivity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#minimumZoomFactor-prop">QCamera::<wbr/>minimumZoomFactor()const</a></code></p>
     */
    @QtPropertyReader(name="minimumZoomFactor")
    @QtUninvokable
    public final float minimumZoomFactor(){
        return minimumZoomFactor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float minimumZoomFactor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#setActive">QCamera::<wbr/>setActive(bool)</a></code></p>
     */
    @QtPropertyWriter(name="active")
    public final void setActive(boolean active){
        setActive_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), active);
    }
    
    private native void setActive_native_bool(long __this__nativeId, boolean active);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#setAutoExposureTime">QCamera::<wbr/>setAutoExposureTime()</a></code></p>
     */
    public final void setAutoExposureTime(){
        setAutoExposureTime_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void setAutoExposureTime_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#setAutoIsoSensitivity">QCamera::<wbr/>setAutoIsoSensitivity()</a></code></p>
     */
    public final void setAutoIsoSensitivity(){
        setAutoIsoSensitivity_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void setAutoIsoSensitivity_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#setCameraDevice">QCamera::<wbr/>setCameraDevice(QCameraDevice)</a></code></p>
     */
    @QtPropertyWriter(name="cameraDevice")
    @QtUninvokable
    public final void setCameraDevice(io.qt.multimedia.@NonNull QCameraDevice cameraDevice){
        setCameraDevice_native_cref_QCameraDevice(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(cameraDevice));
    }
    
    @QtUninvokable
    private native void setCameraDevice_native_cref_QCameraDevice(long __this__nativeId, long cameraDevice);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#setCameraFormat">QCamera::<wbr/>setCameraFormat(QCameraFormat)</a></code></p>
     */
    @QtPropertyWriter(name="cameraFormat")
    @QtUninvokable
    public final void setCameraFormat(io.qt.multimedia.@NonNull QCameraFormat format){
        setCameraFormat_native_cref_QCameraFormat(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(format));
    }
    
    @QtUninvokable
    private native void setCameraFormat_native_cref_QCameraFormat(long __this__nativeId, long format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#setColorTemperature">QCamera::<wbr/>setColorTemperature(int)</a></code></p>
     */
    @QtPropertyWriter(name="colorTemperature")
    public final void setColorTemperature(int colorTemperature){
        setColorTemperature_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), colorTemperature);
    }
    
    private native void setColorTemperature_native_int(long __this__nativeId, int colorTemperature);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#customFocusPoint-prop">QCamera::<wbr/>setCustomFocusPoint(QPointF)</a></code></p>
     */
    @QtPropertyWriter(name="customFocusPoint")
    @QtUninvokable
    public final void setCustomFocusPoint(io.qt.core.@NonNull QPointF point){
        setCustomFocusPoint_native_cref_QPointF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @QtUninvokable
    private native void setCustomFocusPoint_native_cref_QPointF(long __this__nativeId, long point);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#exposureCompensation-prop">QCamera::<wbr/>setExposureCompensation(float)</a></code></p>
     */
    @QtPropertyWriter(name="exposureCompensation")
    public final void setExposureCompensation(float ev){
        setExposureCompensation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), ev);
    }
    
    private native void setExposureCompensation_native_float(long __this__nativeId, float ev);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#exposureMode-prop">QCamera::<wbr/>setExposureMode(QCamera::ExposureMode)</a></code></p>
     */
    @QtPropertyWriter(name="exposureMode")
    public final void setExposureMode(io.qt.multimedia.QCamera.@NonNull ExposureMode mode){
        setExposureMode_native_QCamera_ExposureMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    private native void setExposureMode_native_QCamera_ExposureMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#flashMode-prop">QCamera::<wbr/>setFlashMode(QCamera::FlashMode)</a></code></p>
     */
    @QtPropertyWriter(name="flashMode")
    public final void setFlashMode(io.qt.multimedia.QCamera.@NonNull FlashMode mode){
        setFlashMode_native_QCamera_FlashMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    private native void setFlashMode_native_QCamera_FlashMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#focusDistance-prop">QCamera::<wbr/>setFocusDistance(float)</a></code></p>
     */
    @QtPropertyWriter(name="focusDistance")
    @QtUninvokable
    public final void setFocusDistance(float d){
        setFocusDistance_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), d);
    }
    
    @QtUninvokable
    private native void setFocusDistance_native_float(long __this__nativeId, float d);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#focusMode-prop">QCamera::<wbr/>setFocusMode(QCamera::FocusMode)</a></code></p>
     */
    @QtPropertyWriter(name="focusMode")
    @QtUninvokable
    public final void setFocusMode(io.qt.multimedia.QCamera.@NonNull FocusMode mode){
        setFocusMode_native_QCamera_FocusMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @QtUninvokable
    private native void setFocusMode_native_QCamera_FocusMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#manualExposureTime-prop">QCamera::<wbr/>setManualExposureTime(float)</a></code></p>
     */
    @QtPropertyWriter(name="manualExposureTime")
    public final void setManualExposureTime(float seconds){
        setManualExposureTime_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), seconds);
    }
    
    private native void setManualExposureTime_native_float(long __this__nativeId, float seconds);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#manualIsoSensitivity-prop">QCamera::<wbr/>setManualIsoSensitivity(int)</a></code></p>
     */
    @QtPropertyWriter(name="manualIsoSensitivity")
    public final void setManualIsoSensitivity(int iso){
        setManualIsoSensitivity_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), iso);
    }
    
    private native void setManualIsoSensitivity_native_int(long __this__nativeId, int iso);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#torchMode-prop">QCamera::<wbr/>setTorchMode(QCamera::TorchMode)</a></code></p>
     */
    @QtPropertyWriter(name="torchMode")
    public final void setTorchMode(io.qt.multimedia.QCamera.@NonNull TorchMode mode){
        setTorchMode_native_QCamera_TorchMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    private native void setTorchMode_native_QCamera_TorchMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#setWhiteBalanceMode">QCamera::<wbr/>setWhiteBalanceMode(QCamera::WhiteBalanceMode)</a></code></p>
     */
    @QtPropertyWriter(name="whiteBalanceMode")
    public final void setWhiteBalanceMode(io.qt.multimedia.QCamera.@NonNull WhiteBalanceMode mode){
        setWhiteBalanceMode_native_QCamera_WhiteBalanceMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    private native void setWhiteBalanceMode_native_QCamera_WhiteBalanceMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#setZoomFactor">QCamera::<wbr/>setZoomFactor(float)</a></code></p>
     */
    @QtPropertyWriter(name="zoomFactor")
    @QtUninvokable
    public final void setZoomFactor(float factor){
        setZoomFactor_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), factor);
    }
    
    @QtUninvokable
    private native void setZoomFactor_native_float(long __this__nativeId, float factor);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#start">QCamera::<wbr/>start()</a></code></p>
     */
    public final void start(){
        start_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void start_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#stop">QCamera::<wbr/>stop()</a></code></p>
     */
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stop_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#supportedFeatures-prop">QCamera::<wbr/>supportedFeatures()const</a></code></p>
     */
    @QtPropertyReader(name="supportedFeatures")
    @QtUninvokable
    public final io.qt.multimedia.QCamera.@NonNull Features supportedFeatures(){
        return new io.qt.multimedia.QCamera.Features(supportedFeatures_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int supportedFeatures_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#torchMode-prop">QCamera::<wbr/>torchMode()const</a></code></p>
     */
    @QtPropertyReader(name="torchMode")
    @QtUninvokable
    public final io.qt.multimedia.QCamera.@NonNull TorchMode torchMode(){
        return io.qt.multimedia.QCamera.TorchMode.resolve(torchMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int torchMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#whiteBalanceMode-prop">QCamera::<wbr/>whiteBalanceMode()const</a></code></p>
     */
    @QtPropertyReader(name="whiteBalanceMode")
    @QtUninvokable
    public final io.qt.multimedia.QCamera.@NonNull WhiteBalanceMode whiteBalanceMode(){
        return io.qt.multimedia.QCamera.WhiteBalanceMode.resolve(whiteBalanceMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int whiteBalanceMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#zoomFactor-prop">QCamera::<wbr/>zoomFactor()const</a></code></p>
     */
    @QtPropertyReader(name="zoomFactor")
    @QtUninvokable
    public final float zoomFactor(){
        return zoomFactor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float zoomFactor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qcamera.html#zoomTo">QCamera::<wbr/>zoomTo(float,<wbr/>float)</a></code></p>
     */
    public final void zoomTo(float zoom, float rate){
        zoomTo_native_float_float(QtJambi_LibraryUtilities.internal.nativeId(this), zoom, rate);
    }
    
    private native void zoomTo_native_float_float(long __this__nativeId, float zoom, float rate);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QCamera(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QCamera(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QCamera instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QCamera(io.qt.multimedia.QCameraDevice, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QCamera(io.qt.multimedia.@NonNull QCameraDevice cameraDevice) {
        this(cameraDevice, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QCamera(io.qt.multimedia.QCameraDevice.Position, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QCamera(io.qt.multimedia.QCameraDevice.@NonNull Position position) {
        this(position, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QCamera(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QCamera() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #cameraDevice()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QCameraDevice getCameraDevice() {
        return cameraDevice();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #cameraFormat()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QCameraFormat getCameraFormat() {
        return cameraFormat();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #colorTemperature()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getColorTemperature() {
        return colorTemperature();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #customFocusPoint()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QPointF getCustomFocusPoint() {
        return customFocusPoint();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #error()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QCamera.@NonNull Error getError() {
        return error();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #errorString()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getErrorString() {
        return errorString();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #exposureCompensation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getExposureCompensation() {
        return exposureCompensation();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #exposureMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QCamera.@NonNull ExposureMode getExposureMode() {
        return exposureMode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #exposureTime()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getExposureTime() {
        return exposureTime();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #flashMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QCamera.@NonNull FlashMode getFlashMode() {
        return flashMode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #focusDistance()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getFocusDistance() {
        return focusDistance();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #focusMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QCamera.@NonNull FocusMode getFocusMode() {
        return focusMode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #focusPoint()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QPointF getFocusPoint() {
        return focusPoint();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isActive()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getActive() {
        return isActive();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isFlashReady()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    public final boolean getFlashReady() {
        return isFlashReady();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isoSensitivity()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getIsoSensitivity() {
        return isoSensitivity();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #manualExposureTime()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getManualExposureTime() {
        return manualExposureTime();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #manualIsoSensitivity()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getManualIsoSensitivity() {
        return manualIsoSensitivity();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #maximumZoomFactor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMaximumZoomFactor() {
        return maximumZoomFactor();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #minimumZoomFactor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMinimumZoomFactor() {
        return minimumZoomFactor();
    }
    
    /**
     * <p>Overloaded function for {@link #setCustomFocusPoint(io.qt.core.QPointF)}.</p>
     */
    @QtUninvokable
    public final void setCustomFocusPoint(io.qt.core.@NonNull QPoint point) {
        setCustomFocusPoint(new io.qt.core.QPointF(point));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #supportedFeatures()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QCamera.@NonNull Features getSupportedFeatures() {
        return supportedFeatures();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #torchMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QCamera.@NonNull TorchMode getTorchMode() {
        return torchMode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #whiteBalanceMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QCamera.@NonNull WhiteBalanceMode getWhiteBalanceMode() {
        return whiteBalanceMode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #zoomFactor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getZoomFactor() {
        return zoomFactor();
    }
}
