package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Interface for receiving audio data from an audio input device</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qaudiosource.html">QAudioSource</a></code></p>
 */
public class QAudioSource extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAudioSource.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosource.html#stateChanged">QAudioSource::<wbr/>stateChanged(QtAudio::State)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.multimedia.QtAudio.@NonNull State> stateChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosource.html#QAudioSource-1">QAudioSource::<wbr/>QAudioSource(QAudioDevice,<wbr/>QAudioFormat,<wbr/>QObject*)</a></code></p>
     */
    public QAudioSource(io.qt.multimedia.@NonNull QAudioDevice audioDeviceInfo, io.qt.multimedia.@NonNull QAudioFormat format, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, audioDeviceInfo, format, parent);
    }
    
    private native static void initialize_native(QAudioSource instance, io.qt.multimedia.QAudioDevice audioDeviceInfo, io.qt.multimedia.QAudioFormat format, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosource.html#QAudioSource">QAudioSource::<wbr/>QAudioSource(QAudioFormat,<wbr/>QObject*)</a></code></p>
     */
    public QAudioSource(io.qt.multimedia.@NonNull QAudioFormat format, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, format, parent);
    }
    
    private native static void initialize_native(QAudioSource instance, io.qt.multimedia.QAudioFormat format, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosource.html#bufferSize">QAudioSource::<wbr/>bufferSize()const</a></code></p>
     */
    @QtUninvokable
    public final long bufferSize(){
        return bufferSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long bufferSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosource.html#bytesAvailable">QAudioSource::<wbr/>bytesAvailable()const</a></code></p>
     */
    @QtUninvokable
    public final long bytesAvailable(){
        return bytesAvailable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long bytesAvailable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosource.html#elapsedUSecs">QAudioSource::<wbr/>elapsedUSecs()const</a></code></p>
     */
    @QtUninvokable
    public final long elapsedUSecs(){
        return elapsedUSecs_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long elapsedUSecs_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosource.html#error">QAudioSource::<wbr/>error(Qt::Disambiguated_t)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.QtAudio.@NonNull Error error(){
        return io.qt.multimedia.QtAudio.Error.resolve(error_native_Qt_Disambiguated_t_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int error_native_Qt_Disambiguated_t_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosource.html#format">QAudioSource::<wbr/>format()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QAudioFormat format(){
        return format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QAudioFormat format_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosource.html#isNull">QAudioSource::<wbr/>isNull()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosource.html#processedUSecs">QAudioSource::<wbr/>processedUSecs()const</a></code></p>
     */
    @QtUninvokable
    public final long processedUSecs(){
        return processedUSecs_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long processedUSecs_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosource.html#reset">QAudioSource::<wbr/>reset()</a></code></p>
     */
    @QtUninvokable
    public final void reset(){
        reset_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void reset_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosource.html#resume">QAudioSource::<wbr/>resume()</a></code></p>
     */
    @QtUninvokable
    public final void resume(){
        resume_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void resume_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosource.html#setBufferSize">QAudioSource::<wbr/>setBufferSize(qsizetype)</a></code></p>
     */
    @QtUninvokable
    public final void setBufferSize(long bytes){
        setBufferSize_native_qsizetype(QtJambi_LibraryUtilities.internal.nativeId(this), bytes);
    }
    
    @QtUninvokable
    private native void setBufferSize_native_qsizetype(long __this__nativeId, long bytes);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosource.html#setVolume">QAudioSource::<wbr/>setVolume(qreal)</a></code></p>
     */
    @QtUninvokable
    public final void setVolume(double volume){
        setVolume_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), volume);
    }
    
    @QtUninvokable
    private native void setVolume_native_qreal(long __this__nativeId, double volume);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosource.html#start-1">QAudioSource::<wbr/>start()</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@Nullable QIODevice start(){
        return start_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QIODevice start_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosource.html#start">QAudioSource::<wbr/>start(QIODevice*)</a></code></p>
     */
    @QtUninvokable
    public final void start(io.qt.core.@Nullable QIODevice device){
        start_native_QIODevice_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(device));
    }
    
    @QtUninvokable
    private native void start_native_QIODevice_ptr(long __this__nativeId, long device);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosource.html#state">QAudioSource::<wbr/>state(Qt::Disambiguated_t)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.QtAudio.@NonNull State state(){
        return io.qt.multimedia.QtAudio.State.resolve(state_native_Qt_Disambiguated_t_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int state_native_Qt_Disambiguated_t_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosource.html#stop">QAudioSource::<wbr/>stop()</a></code></p>
     */
    @QtUninvokable
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void stop_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosource.html#suspend">QAudioSource::<wbr/>suspend()</a></code></p>
     */
    @QtUninvokable
    public final void suspend(){
        suspend_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void suspend_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosource.html#volume">QAudioSource::<wbr/>volume()const</a></code></p>
     */
    @QtUninvokable
    public final double volume(){
        return volume_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double volume_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAudioSource(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QAudioSource(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAudioSource instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAudioSource(io.qt.multimedia.QAudioDevice, io.qt.multimedia.QAudioFormat, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAudioSource(io.qt.multimedia.@NonNull QAudioDevice audioDeviceInfo, io.qt.multimedia.@NonNull QAudioFormat format) {
        this(audioDeviceInfo, format, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAudioSource(io.qt.multimedia.QAudioDevice, io.qt.multimedia.QAudioFormat, io.qt.core.QObject)}</p>
     * <p>with: </p><ul>
     * <li><code>format = new io.qt.multimedia.QAudioFormat()</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QAudioSource(io.qt.multimedia.@NonNull QAudioDevice audioDeviceInfo) {
        this(audioDeviceInfo, new io.qt.multimedia.QAudioFormat(), (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAudioSource(io.qt.multimedia.QAudioFormat, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAudioSource(io.qt.multimedia.@NonNull QAudioFormat format) {
        this(format, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAudioSource(io.qt.multimedia.QAudioFormat, io.qt.core.QObject)}</p>
     * <p>with: </p><ul>
     * <li><code>format = new io.qt.multimedia.QAudioFormat()</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QAudioSource() {
        this(new io.qt.multimedia.QAudioFormat(), (io.qt.core.QObject)null);
    }
}
