package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Interface for sending audio data to an audio output device</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qaudiosink.html">QAudioSink</a></code></p>
 */
public class QAudioSink extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAudioSink.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosink.html#stateChanged">QAudioSink::<wbr/>stateChanged(QtAudio::State)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.multimedia.QtAudio.@NonNull State> stateChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosink.html#QAudioSink-1">QAudioSink::<wbr/>QAudioSink(QAudioDevice,<wbr/>QAudioFormat,<wbr/>QObject*)</a></code></p>
     */
    public QAudioSink(io.qt.multimedia.@NonNull QAudioDevice audioDeviceInfo, io.qt.multimedia.@NonNull QAudioFormat format, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, audioDeviceInfo, format, parent);
    }
    
    private native static void initialize_native(QAudioSink instance, io.qt.multimedia.QAudioDevice audioDeviceInfo, io.qt.multimedia.QAudioFormat format, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosink.html#QAudioSink">QAudioSink::<wbr/>QAudioSink(QAudioFormat,<wbr/>QObject*)</a></code></p>
     */
    public QAudioSink(io.qt.multimedia.@NonNull QAudioFormat format, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, format, parent);
    }
    
    private native static void initialize_native(QAudioSink instance, io.qt.multimedia.QAudioFormat format, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosink.html#bufferSize">QAudioSink::<wbr/>bufferSize()const</a></code></p>
     */
    @QtUninvokable
    public final long bufferSize(){
        return bufferSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long bufferSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosink.html#bytesFree">QAudioSink::<wbr/>bytesFree()const</a></code></p>
     */
    @QtUninvokable
    public final long bytesFree(){
        return bytesFree_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long bytesFree_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosink.html#elapsedUSecs">QAudioSink::<wbr/>elapsedUSecs()const</a></code></p>
     */
    @QtUninvokable
    public final long elapsedUSecs(){
        return elapsedUSecs_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long elapsedUSecs_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosink.html#error">QAudioSink::<wbr/>error(Qt::Disambiguated_t)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.QtAudio.@NonNull Error error(){
        return io.qt.multimedia.QtAudio.Error.resolve(error_native_Qt_Disambiguated_t_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int error_native_Qt_Disambiguated_t_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosink.html#format">QAudioSink::<wbr/>format()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QAudioFormat format(){
        return format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QAudioFormat format_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosink.html#isNull">QAudioSink::<wbr/>isNull()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosink.html#processedUSecs">QAudioSink::<wbr/>processedUSecs()const</a></code></p>
     */
    @QtUninvokable
    public final long processedUSecs(){
        return processedUSecs_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long processedUSecs_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosink.html#reset">QAudioSink::<wbr/>reset()</a></code></p>
     */
    @QtUninvokable
    public final void reset(){
        reset_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void reset_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosink.html#resume">QAudioSink::<wbr/>resume()</a></code></p>
     */
    @QtUninvokable
    public final void resume(){
        resume_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void resume_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosink.html#setBufferSize">QAudioSink::<wbr/>setBufferSize(qsizetype)</a></code></p>
     */
    @QtUninvokable
    public final void setBufferSize(long bytes){
        setBufferSize_native_qsizetype(QtJambi_LibraryUtilities.internal.nativeId(this), bytes);
    }
    
    @QtUninvokable
    private native void setBufferSize_native_qsizetype(long __this__nativeId, long bytes);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosink.html#setVolume">QAudioSink::<wbr/>setVolume(qreal)</a></code></p>
     */
    @QtUninvokable
    public final void setVolume(double arg__1){
        setVolume_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void setVolume_native_qreal(long __this__nativeId, double arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosink.html#start-1">QAudioSink::<wbr/>start()</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@Nullable QIODevice start(){
        return start_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QIODevice start_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosink.html#start">QAudioSink::<wbr/>start(QIODevice*)</a></code></p>
     */
    @QtUninvokable
    public final void start(io.qt.core.@Nullable QIODevice device){
        start_native_QIODevice_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(device));
    }
    
    @QtUninvokable
    private native void start_native_QIODevice_ptr(long __this__nativeId, long device);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosink.html#state">QAudioSink::<wbr/>state(Qt::Disambiguated_t)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.QtAudio.@NonNull State state(){
        return io.qt.multimedia.QtAudio.State.resolve(state_native_Qt_Disambiguated_t_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int state_native_Qt_Disambiguated_t_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosink.html#stop">QAudioSink::<wbr/>stop()</a></code></p>
     */
    @QtUninvokable
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void stop_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosink.html#suspend">QAudioSink::<wbr/>suspend()</a></code></p>
     */
    @QtUninvokable
    public final void suspend(){
        suspend_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void suspend_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiosink.html#volume">QAudioSink::<wbr/>volume()const</a></code></p>
     */
    @QtUninvokable
    public final double volume(){
        return volume_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double volume_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAudioSink(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QAudioSink(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAudioSink instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAudioSink(io.qt.multimedia.QAudioDevice, io.qt.multimedia.QAudioFormat, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAudioSink(io.qt.multimedia.@NonNull QAudioDevice audioDeviceInfo, io.qt.multimedia.@NonNull QAudioFormat format) {
        this(audioDeviceInfo, format, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAudioSink(io.qt.multimedia.QAudioDevice, io.qt.multimedia.QAudioFormat, io.qt.core.QObject)}</p>
     * <p>with: </p><ul>
     * <li><code>format = new io.qt.multimedia.QAudioFormat()</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QAudioSink(io.qt.multimedia.@NonNull QAudioDevice audioDeviceInfo) {
        this(audioDeviceInfo, new io.qt.multimedia.QAudioFormat(), (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAudioSink(io.qt.multimedia.QAudioFormat, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAudioSink(io.qt.multimedia.@NonNull QAudioFormat format) {
        this(format, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAudioSink(io.qt.multimedia.QAudioFormat, io.qt.core.QObject)}</p>
     * <p>with: </p><ul>
     * <li><code>format = new io.qt.multimedia.QAudioFormat()</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QAudioSink() {
        this(new io.qt.multimedia.QAudioFormat(), (io.qt.core.QObject)null);
    }
}
