package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Represents an output channel for audio</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qaudiooutput.html">QAudioOutput</a></code></p>
 */
public class QAudioOutput extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAudioOutput.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiooutput.html#device-prop">QAudioOutput::<wbr/>deviceChanged()</a></code></p>
     */
    @QtPropertyNotify(name="device")
    public final @NonNull Signal0 deviceChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiooutput.html#muted-prop">QAudioOutput::<wbr/>mutedChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="muted")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> mutedChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiooutput.html#volume-prop">QAudioOutput::<wbr/>volumeChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="volume")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> volumeChanged = new Signal1<>();
    
    /**
     * <p>See <code>QAudioOutput::<wbr/>QAudioOutput(QAudioDevice,<wbr/>QObject*)</code></p>
     */
    public QAudioOutput(io.qt.multimedia.@NonNull QAudioDevice device, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, device, parent);
    }
    
    private native static void initialize_native(QAudioOutput instance, io.qt.multimedia.QAudioDevice device, io.qt.core.QObject parent);
    
    /**
     * <p>See <code>QAudioOutput::<wbr/>QAudioOutput(QObject*)</code></p>
     */
    public QAudioOutput(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAudioOutput instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiooutput.html#device-prop">QAudioOutput::<wbr/>device()const</a></code></p>
     */
    @QtPropertyReader(name="device")
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QAudioDevice device(){
        return device_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QAudioDevice device_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiooutput.html#muted-prop">QAudioOutput::<wbr/>isMuted()const</a></code></p>
     */
    @QtPropertyReader(name="muted")
    @QtUninvokable
    public final boolean isMuted(){
        return isMuted_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isMuted_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiooutput.html#device-prop">QAudioOutput::<wbr/>setDevice(QAudioDevice)</a></code></p>
     */
    @QtPropertyWriter(name="device")
    public final void setDevice(io.qt.multimedia.@NonNull QAudioDevice device){
        setDevice_native_cref_QAudioDevice(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(device));
    }
    
    private native void setDevice_native_cref_QAudioDevice(long __this__nativeId, long device);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiooutput.html#muted-prop">QAudioOutput::<wbr/>setMuted(bool)</a></code></p>
     */
    @QtPropertyWriter(name="muted")
    public final void setMuted(boolean muted){
        setMuted_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), muted);
    }
    
    private native void setMuted_native_bool(long __this__nativeId, boolean muted);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiooutput.html#volume-prop">QAudioOutput::<wbr/>setVolume(float)</a></code></p>
     */
    @QtPropertyWriter(name="volume")
    public final void setVolume(float volume){
        setVolume_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), volume);
    }
    
    private native void setVolume_native_float(long __this__nativeId, float volume);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiooutput.html#volume-prop">QAudioOutput::<wbr/>volume()const</a></code></p>
     */
    @QtPropertyReader(name="volume")
    @QtUninvokable
    public final float volume(){
        return volume_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float volume_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAudioOutput(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QAudioOutput(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAudioOutput instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAudioOutput(io.qt.multimedia.QAudioDevice, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAudioOutput(io.qt.multimedia.@NonNull QAudioDevice device) {
        this(device, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAudioOutput(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAudioOutput() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #device()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QAudioDevice getDevice() {
        return device();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isMuted()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getMuted() {
        return isMuted();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #volume()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getVolume() {
        return volume();
    }
}
