package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Stores audio stream parameter information</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qaudioformat.html">QAudioFormat</a></code></p>
 */
public class QAudioFormat extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::AudioChannelPosition</a></code></p>
     */
    public enum AudioChannelPosition implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>UnknownPosition</a></code></p>
         */
        UnknownPosition(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>FrontLeft</a></code></p>
         */
        FrontLeft(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>FrontRight</a></code></p>
         */
        FrontRight(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>FrontCenter</a></code></p>
         */
        FrontCenter(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>LFE</a></code></p>
         */
        LFE(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>BackLeft</a></code></p>
         */
        BackLeft(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>BackRight</a></code></p>
         */
        BackRight(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>FrontLeftOfCenter</a></code></p>
         */
        FrontLeftOfCenter(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>FrontRightOfCenter</a></code></p>
         */
        FrontRightOfCenter(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>BackCenter</a></code></p>
         */
        BackCenter(9),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>SideLeft</a></code></p>
         */
        SideLeft(10),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>SideRight</a></code></p>
         */
        SideRight(11),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>TopCenter</a></code></p>
         */
        TopCenter(12),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>TopFrontLeft</a></code></p>
         */
        TopFrontLeft(13),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>TopFrontCenter</a></code></p>
         */
        TopFrontCenter(14),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>TopFrontRight</a></code></p>
         */
        TopFrontRight(15),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>TopBackLeft</a></code></p>
         */
        TopBackLeft(16),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>TopBackCenter</a></code></p>
         */
        TopBackCenter(17),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>TopBackRight</a></code></p>
         */
        TopBackRight(18),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>LFE2</a></code></p>
         */
        LFE2(19),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>TopSideLeft</a></code></p>
         */
        TopSideLeft(20),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>TopSideRight</a></code></p>
         */
        TopSideRight(21),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>BottomFrontCenter</a></code></p>
         */
        BottomFrontCenter(22),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>BottomFrontLeft</a></code></p>
         */
        BottomFrontLeft(23),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#AudioChannelPosition-enum">QAudioFormat::<wbr/>BottomFrontRight</a></code></p>
         */
        BottomFrontRight(24);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private AudioChannelPosition(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull AudioChannelPosition resolve(int value) {
            switch (value) {
            case 0: return UnknownPosition;
            case 1: return FrontLeft;
            case 2: return FrontRight;
            case 3: return FrontCenter;
            case 4: return LFE;
            case 5: return BackLeft;
            case 6: return BackRight;
            case 7: return FrontLeftOfCenter;
            case 8: return FrontRightOfCenter;
            case 9: return BackCenter;
            case 10: return SideLeft;
            case 11: return SideRight;
            case 12: return TopCenter;
            case 13: return TopFrontLeft;
            case 14: return TopFrontCenter;
            case 15: return TopFrontRight;
            case 16: return TopBackLeft;
            case 17: return TopBackCenter;
            case 18: return TopBackRight;
            case 19: return LFE2;
            case 20: return TopSideLeft;
            case 21: return TopSideRight;
            case 22: return BottomFrontCenter;
            case 23: return BottomFrontLeft;
            case 24: return BottomFrontRight;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qaudioformat.html#ChannelConfig-enum">QAudioFormat::ChannelConfig</a></code></p>
     */
    @QtExtensibleEnum
    public enum ChannelConfig implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#ChannelConfig-enum">QAudioFormat::<wbr/>ChannelConfigUnknown</a></code></p>
         */
        ChannelConfigUnknown(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#ChannelConfig-enum">QAudioFormat::<wbr/>ChannelConfigMono</a></code></p>
         */
        ChannelConfigMono(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#ChannelConfig-enum">QAudioFormat::<wbr/>ChannelConfigStereo</a></code></p>
         */
        ChannelConfigStereo(value_ChannelConfigStereo()),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#ChannelConfig-enum">QAudioFormat::<wbr/>ChannelConfig2Dot1</a></code></p>
         */
        ChannelConfig2Dot1(value_ChannelConfig2Dot1()),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#ChannelConfig-enum">QAudioFormat::<wbr/>ChannelConfig3Dot0</a></code></p>
         */
        ChannelConfig3Dot0(value_ChannelConfig3Dot0()),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#ChannelConfig-enum">QAudioFormat::<wbr/>ChannelConfig3Dot1</a></code></p>
         */
        ChannelConfig3Dot1(value_ChannelConfig3Dot1()),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#ChannelConfig-enum">QAudioFormat::<wbr/>ChannelConfigSurround5Dot0</a></code></p>
         */
        ChannelConfigSurround5Dot0(value_ChannelConfigSurround5Dot0()),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#ChannelConfig-enum">QAudioFormat::<wbr/>ChannelConfigSurround5Dot1</a></code></p>
         */
        ChannelConfigSurround5Dot1(value_ChannelConfigSurround5Dot1()),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#ChannelConfig-enum">QAudioFormat::<wbr/>ChannelConfigSurround7Dot0</a></code></p>
         */
        ChannelConfigSurround7Dot0(value_ChannelConfigSurround7Dot0()),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#ChannelConfig-enum">QAudioFormat::<wbr/>ChannelConfigSurround7Dot1</a></code></p>
         */
        ChannelConfigSurround7Dot1(value_ChannelConfigSurround7Dot1());

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ChannelConfig(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         * @throws QNoSuchEnumValueException if value not existent in the enum
         */
        public static @NonNull ChannelConfig resolve(int value) {
            if(value==0){
                return ChannelConfigUnknown;
            }else if(value==3){
                return ChannelConfigMono;
            }else if(value==ChannelConfigStereo.value){
                return ChannelConfigStereo;
            }else if(value==ChannelConfig2Dot1.value){
                return ChannelConfig2Dot1;
            }else if(value==ChannelConfig3Dot0.value){
                return ChannelConfig3Dot0;
            }else if(value==ChannelConfig3Dot1.value){
                return ChannelConfig3Dot1;
            }else if(value==ChannelConfigSurround5Dot0.value){
                return ChannelConfigSurround5Dot0;
            }else if(value==ChannelConfigSurround5Dot1.value){
                return ChannelConfigSurround5Dot1;
            }else if(value==ChannelConfigSurround7Dot0.value){
                return ChannelConfigSurround7Dot0;
            }else if(value==ChannelConfigSurround7Dot1.value){
                return ChannelConfigSurround7Dot1;
            } else {
                return QtJambi_LibraryUtilities.internal.resolveEnum(ChannelConfig.class, value, null);
            }
        }

        /**
         * Returns the corresponding enum entry for the given value and name.
         * @param value
         * @param name
         * @return enum entry
         * @throws QNoSuchEnumValueException if value not existent in the enum or name does not match.
         */
        public static @NonNull ChannelConfig resolve(int value, @Nullable String name) {
            if(name==null || name.isEmpty())
                return resolve(value);
            else
                return QtJambi_LibraryUtilities.internal.resolveEnum(ChannelConfig.class, value, name);
        }

        private static native int value_ChannelConfigStereo();
        private static native int value_ChannelConfig2Dot1();
        private static native int value_ChannelConfig3Dot0();
        private static native int value_ChannelConfig3Dot1();
        private static native int value_ChannelConfigSurround5Dot0();
        private static native int value_ChannelConfigSurround5Dot1();
        private static native int value_ChannelConfigSurround7Dot0();
        private static native int value_ChannelConfigSurround7Dot1();

        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qaudioformat.html#SampleFormat-enum">QAudioFormat::SampleFormat</a></code></p>
     */
    public enum SampleFormat implements QtShortEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#SampleFormat-enum">QAudioFormat::<wbr/>Unknown</a></code></p>
         */
        Unknown((short)0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#SampleFormat-enum">QAudioFormat::<wbr/>UInt8</a></code></p>
         */
        UInt8((short)1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#SampleFormat-enum">QAudioFormat::<wbr/>Int16</a></code></p>
         */
        Int16((short)2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#SampleFormat-enum">QAudioFormat::<wbr/>Int32</a></code></p>
         */
        Int32((short)3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#SampleFormat-enum">QAudioFormat::<wbr/>Float</a></code></p>
         */
        Float((short)4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudioformat.html#SampleFormat-enum">QAudioFormat::<wbr/>NSampleFormats</a></code></p>
         */
        NSampleFormats((short)5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private SampleFormat(short value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public short value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull SampleFormat resolve(short value) {
            switch (value) {
            case 0: return Unknown;
            case 1: return UInt8;
            case 2: return Int16;
            case 3: return Int32;
            case 4: return Float;
            case 5: return NSampleFormats;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final short value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#QAudioFormat">QAudioFormat::<wbr/>QAudioFormat()</a></code></p>
     */
    public QAudioFormat(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QAudioFormat instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#QAudioFormat-1">QAudioFormat::<wbr/>QAudioFormat(QAudioFormat)</a></code></p>
     */
    public QAudioFormat(io.qt.multimedia.@NonNull QAudioFormat other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QAudioFormat instance, io.qt.multimedia.QAudioFormat other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#bytesForDuration">QAudioFormat::<wbr/>bytesForDuration(qint64)const</a></code></p>
     */
    @QtUninvokable
    public final int bytesForDuration(long microseconds){
        return bytesForDuration_native_qint64_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), microseconds);
    }
    
    @QtUninvokable
    private native int bytesForDuration_native_qint64_constfct(long __this__nativeId, long microseconds);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#bytesForFrames">QAudioFormat::<wbr/>bytesForFrames(qint32)const</a></code></p>
     */
    @QtUninvokable
    public final int bytesForFrames(int frameCount){
        return bytesForFrames_native_qint32_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), frameCount);
    }
    
    @QtUninvokable
    private native int bytesForFrames_native_qint32_constfct(long __this__nativeId, int frameCount);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#bytesPerFrame">QAudioFormat::<wbr/>bytesPerFrame()const</a></code></p>
     */
    @QtUninvokable
    public final int bytesPerFrame(){
        return bytesPerFrame_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int bytesPerFrame_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#bytesPerSample">QAudioFormat::<wbr/>bytesPerSample()const</a></code></p>
     */
    @QtUninvokable
    public final int bytesPerSample(){
        return bytesPerSample_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int bytesPerSample_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#channelConfig-1">QAudioFormat::<wbr/>channelConfig()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.QAudioFormat.@NonNull ChannelConfig channelConfig(){
        return io.qt.multimedia.QAudioFormat.ChannelConfig.resolve(channelConfig_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int channelConfig_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#channelCount">QAudioFormat::<wbr/>channelCount()const</a></code></p>
     */
    @QtUninvokable
    public final int channelCount(){
        return channelCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int channelCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#channelOffset">QAudioFormat::<wbr/>channelOffset(QAudioFormat::AudioChannelPosition)const</a></code></p>
     */
    @QtUninvokable
    public final int channelOffset(io.qt.multimedia.QAudioFormat.@NonNull AudioChannelPosition channel){
        return channelOffset_native_QAudioFormat_AudioChannelPosition_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), channel.value());
    }
    
    @QtUninvokable
    private native int channelOffset_native_QAudioFormat_AudioChannelPosition_constfct(long __this__nativeId, int channel);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#durationForBytes">QAudioFormat::<wbr/>durationForBytes(qint32)const</a></code></p>
     */
    @QtUninvokable
    public final long durationForBytes(int byteCount){
        return durationForBytes_native_qint32_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), byteCount);
    }
    
    @QtUninvokable
    private native long durationForBytes_native_qint32_constfct(long __this__nativeId, int byteCount);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#durationForFrames">QAudioFormat::<wbr/>durationForFrames(qint32)const</a></code></p>
     */
    @QtUninvokable
    public final long durationForFrames(int frameCount){
        return durationForFrames_native_qint32_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), frameCount);
    }
    
    @QtUninvokable
    private native long durationForFrames_native_qint32_constfct(long __this__nativeId, int frameCount);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#framesForBytes">QAudioFormat::<wbr/>framesForBytes(qint32)const</a></code></p>
     */
    @QtUninvokable
    public final int framesForBytes(int byteCount){
        return framesForBytes_native_qint32_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), byteCount);
    }
    
    @QtUninvokable
    private native int framesForBytes_native_qint32_constfct(long __this__nativeId, int byteCount);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#framesForDuration">QAudioFormat::<wbr/>framesForDuration(qint64)const</a></code></p>
     */
    @QtUninvokable
    public final int framesForDuration(long microseconds){
        return framesForDuration_native_qint64_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), microseconds);
    }
    
    @QtUninvokable
    private native int framesForDuration_native_qint64_constfct(long __this__nativeId, long microseconds);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#isValid">QAudioFormat::<wbr/>isValid()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#normalizedSampleValue">QAudioFormat::<wbr/>normalizedSampleValue(const void*)const</a></code></p>
     */
    @QtUninvokable
    public final float normalizedSampleValue(java.nio.@Nullable Buffer sample){
        return normalizedSampleValue_native_const_void_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), sample);
    }
    
    @QtUninvokable
    private native float normalizedSampleValue_native_const_void_ptr_constfct(long __this__nativeId, java.nio.Buffer sample);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#operator-eq-eq">operator==(QAudioFormat,<wbr/>QAudioFormat)</a></code></p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.multimedia.@NonNull QAudioFormat b){
        return equals_native_cref_QAudioFormat(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(b));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QAudioFormat(long __this__nativeId, long b);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#sampleFormat">QAudioFormat::<wbr/>sampleFormat()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.QAudioFormat.@NonNull SampleFormat sampleFormat(){
        return io.qt.multimedia.QAudioFormat.SampleFormat.resolve(sampleFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native short sampleFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#sampleRate">QAudioFormat::<wbr/>sampleRate()const</a></code></p>
     */
    @QtUninvokable
    public final int sampleRate(){
        return sampleRate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int sampleRate_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#setChannelConfig">QAudioFormat::<wbr/>setChannelConfig(QAudioFormat::ChannelConfig)</a></code></p>
     */
    @QtUninvokable
    public final void setChannelConfig(io.qt.multimedia.QAudioFormat.@NonNull ChannelConfig config){
        setChannelConfig_native_QAudioFormat_ChannelConfig(QtJambi_LibraryUtilities.internal.nativeId(this), config.value());
    }
    
    @QtUninvokable
    private native void setChannelConfig_native_QAudioFormat_ChannelConfig(long __this__nativeId, int config);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#setChannelCount">QAudioFormat::<wbr/>setChannelCount(int)</a></code></p>
     */
    @QtUninvokable
    public final void setChannelCount(int channelCount){
        setChannelCount_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), channelCount);
    }
    
    @QtUninvokable
    private native void setChannelCount_native_int(long __this__nativeId, int channelCount);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#setSampleFormat">QAudioFormat::<wbr/>setSampleFormat(QAudioFormat::SampleFormat)</a></code></p>
     */
    @QtUninvokable
    public final void setSampleFormat(io.qt.multimedia.QAudioFormat.@NonNull SampleFormat f){
        setSampleFormat_native_QAudioFormat_SampleFormat(QtJambi_LibraryUtilities.internal.nativeId(this), f.value());
    }
    
    @QtUninvokable
    private native void setSampleFormat_native_QAudioFormat_SampleFormat(long __this__nativeId, short f);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#setSampleRate">QAudioFormat::<wbr/>setSampleRate(int)</a></code></p>
     */
    @QtUninvokable
    public final void setSampleRate(int sampleRate){
        setSampleRate_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), sampleRate);
    }
    
    @QtUninvokable
    private native void setSampleRate_native_int(long __this__nativeId, int sampleRate);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#defaultChannelConfigForChannelCount">QAudioFormat::<wbr/>defaultChannelConfigForChannelCount(int)</a></code></p>
     */
    public static io.qt.multimedia.QAudioFormat.@NonNull ChannelConfig defaultChannelConfigForChannelCount(int channelCount){
        return io.qt.multimedia.QAudioFormat.ChannelConfig.resolve(defaultChannelConfigForChannelCount_native_int(channelCount));
    }
    
    private native static int defaultChannelConfigForChannelCount_native_int(int channelCount);
    
    /**
     * <p>See <code>QAudioFormat::<wbr/>NChannelPositions</code></p>
     */
    private native static int NChannelPositions();
    
    /**
     * <p>See <code>QAudioFormat::<wbr/>NChannelPositions</code></p>
     */
    public static final int NChannelPositions = NChannelPositions();

    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAudioFormat(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#operator-eq-eq">operator==(QAudioFormat,<wbr/>QAudioFormat)</a></code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.multimedia.QAudioFormat) {
            return equals((io.qt.multimedia.QAudioFormat) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QAudioFormat)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    public static @NonNull ChannelConfig channelConfig(@NonNull AudioChannelPosition @NonNull... channels) {
        int value = 0;
        for (AudioChannelPosition channel : channels) {
            value |= (0x01 << channel.value());
        }
        return ChannelConfig.resolve(value);
    }

    /**
     * <p>See <code>operator&lt;&lt;(QDebug,<wbr/>QAudioFormat)</code></p>
     */
    @QtUninvokable
    @Override
    public @NonNull String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="https://doc.qt.io/qt/qaudioformat.html#QAudioFormat-1">QAudioFormat::<wbr/>QAudioFormat(QAudioFormat)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QAudioFormat clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QAudioFormat clone_native(long __this_nativeId);
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #NChannelPositions()} instead.</p>
     */
    private static int getNChannelPositions() {
        return NChannelPositions();
    }
}
