package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Information about audio devices and their functionality</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qaudiodevice.html">QAudioDevice</a></code></p>
 */
public class QAudioDevice extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAudioDevice.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qaudiodevice.html#Mode-enum">QAudioDevice::Mode</a></code></p>
     */
    public enum Mode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudiodevice.html#Mode-enum">QAudioDevice::<wbr/>Null</a></code></p>
         */
        Null(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudiodevice.html#Mode-enum">QAudioDevice::<wbr/>Input</a></code></p>
         */
        Input(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qaudiodevice.html#Mode-enum">QAudioDevice::<wbr/>Output</a></code></p>
         */
        Output(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Mode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Mode resolve(int value) {
            switch (value) {
            case 0: return Null;
            case 1: return Input;
            case 2: return Output;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiodevice.html#QAudioDevice">QAudioDevice::<wbr/>QAudioDevice()</a></code></p>
     */
    public QAudioDevice(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QAudioDevice instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiodevice.html#QAudioDevice-1">QAudioDevice::<wbr/>QAudioDevice(QAudioDevice)</a></code></p>
     */
    public QAudioDevice(io.qt.multimedia.@NonNull QAudioDevice other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QAudioDevice instance, io.qt.multimedia.QAudioDevice other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiodevice.html#channelConfiguration">QAudioDevice::<wbr/>channelConfiguration()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.QAudioFormat.@NonNull ChannelConfig channelConfiguration(){
        return io.qt.multimedia.QAudioFormat.ChannelConfig.resolve(channelConfiguration_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int channelConfiguration_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiodevice.html#description-prop">QAudioDevice::<wbr/>description()const</a></code></p>
     */
    @QtPropertyReader(name="description")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String description(){
        return description_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String description_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiodevice.html#id-prop">QAudioDevice::<wbr/>id()const</a></code></p>
     */
    @QtPropertyReader(name="id")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray id(){
        return id_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray id_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiodevice.html#isDefault-prop">QAudioDevice::<wbr/>isDefault()const</a></code></p>
     */
    @QtPropertyReader(name="isDefault")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean isDefault(){
        return isDefault_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isDefault_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiodevice.html#isFormatSupported">QAudioDevice::<wbr/>isFormatSupported(QAudioFormat)const</a></code></p>
     */
    @QtUninvokable
    public final boolean isFormatSupported(io.qt.multimedia.@NonNull QAudioFormat format){
        return isFormatSupported_native_cref_QAudioFormat_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(format));
    }
    
    @QtUninvokable
    private native boolean isFormatSupported_native_cref_QAudioFormat_constfct(long __this__nativeId, long format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiodevice.html#isNull">QAudioDevice::<wbr/>isNull()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiodevice.html#maximumChannelCount">QAudioDevice::<wbr/>maximumChannelCount()const</a></code></p>
     */
    @QtUninvokable
    public final int maximumChannelCount(){
        return maximumChannelCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maximumChannelCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiodevice.html#maximumSampleRate">QAudioDevice::<wbr/>maximumSampleRate()const</a></code></p>
     */
    @QtUninvokable
    public final int maximumSampleRate(){
        return maximumSampleRate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maximumSampleRate_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiodevice.html#minimumChannelCount">QAudioDevice::<wbr/>minimumChannelCount()const</a></code></p>
     */
    @QtUninvokable
    public final int minimumChannelCount(){
        return minimumChannelCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int minimumChannelCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiodevice.html#minimumSampleRate">QAudioDevice::<wbr/>minimumSampleRate()const</a></code></p>
     */
    @QtUninvokable
    public final int minimumSampleRate(){
        return minimumSampleRate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int minimumSampleRate_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiodevice.html#mode-prop">QAudioDevice::<wbr/>mode()const</a></code></p>
     */
    @QtPropertyReader(name="mode")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.multimedia.QAudioDevice.@NonNull Mode mode(){
        return io.qt.multimedia.QAudioDevice.Mode.resolve(mode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int mode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiodevice.html#operator-eq-1">QAudioDevice::<wbr/>operator=(QAudioDevice)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.multimedia.@NonNull QAudioDevice other){
        assign_native_cref_QAudioDevice(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QAudioDevice(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiodevice.html#operator-eq-eq">QAudioDevice::<wbr/>operator==(QAudioDevice)const</a></code></p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.multimedia.@NonNull QAudioDevice other){
        return equals_native_cref_QAudioDevice_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QAudioDevice_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiodevice.html#preferredFormat">QAudioDevice::<wbr/>preferredFormat()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QAudioFormat preferredFormat(){
        return preferredFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QAudioFormat preferredFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiodevice.html#supportedSampleFormats">QAudioDevice::<wbr/>supportedSampleFormats()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.multimedia.QAudioFormat.@NonNull SampleFormat> supportedSampleFormats(){
        return supportedSampleFormats_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.multimedia.QAudioFormat.SampleFormat> supportedSampleFormats_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiodevice.html#swap">QAudioDevice::<wbr/>swap(QAudioDevice&amp;)</a></code></p>
     */
    @QtUninvokable
    public final void swap(io.qt.multimedia.@StrictNonNull QAudioDevice other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QAudioDevice(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QAudioDevice(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAudioDevice(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiodevice.html#operator-eq-eq">QAudioDevice::<wbr/>operator==(QAudioDevice)const</a></code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.multimedia.QAudioDevice) {
            return equals((io.qt.multimedia.QAudioDevice) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QAudioDevice)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="https://doc.qt.io/qt/qaudiodevice.html#QAudioDevice-1">QAudioDevice::<wbr/>QAudioDevice(QAudioDevice)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QAudioDevice clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QAudioDevice clone_native(long __this_nativeId);
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #description()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getDescription() {
        return description();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #id()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getId() {
        return id();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #mode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.multimedia.QAudioDevice.@NonNull Mode getMode() {
        return mode();
    }
}
