package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Java wrapper for Qt class <code>QAudioDecoder</code></p>
 */
public class QAudioDecoder extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAudioDecoder.class);
    
    /**
     * <p>Java wrapper for Qt enum <code>QAudioDecoder::Error</code></p>
     */
    public enum Error implements QtEnumerator {
        /**
         * <p>Representing <code>QAudioDecoder::<wbr/>NoError</code></p>
         */
        NoError(0),
        /**
         * <p>Representing <code>QAudioDecoder::<wbr/>ResourceError</code></p>
         */
        ResourceError(1),
        /**
         * <p>Representing <code>QAudioDecoder::<wbr/>FormatError</code></p>
         */
        FormatError(2),
        /**
         * <p>Representing <code>QAudioDecoder::<wbr/>AccessDeniedError</code></p>
         */
        AccessDeniedError(3),
        /**
         * <p>Representing <code>QAudioDecoder::<wbr/>NotSupportedError</code></p>
         */
        NotSupportedError(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Error resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return ResourceError;
            case 2: return FormatError;
            case 3: return AccessDeniedError;
            case 4: return NotSupportedError;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code>QAudioDecoder::<wbr/>bufferAvailableChanged(bool)</code></p>
     */
    @QtPropertyNotify(name="bufferAvailable")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> bufferAvailableChanged = new Signal1<>();

    /**
     * <p>See <code>QAudioDecoder::<wbr/>bufferReady()</code></p>
     */
    public final @NonNull Signal0 bufferReady = new Signal0();

    /**
     * <p>See <code>QAudioDecoder::<wbr/>durationChanged(qint64)</code></p>
     */
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Long> durationChanged = new Signal1<>();

    /**
     * <p>See <code>QAudioDecoder::<wbr/>error(QAudioDecoder::Error)</code></p>
     */
    public final @NonNull Signal1<io.qt.multimedia.QAudioDecoder.@NonNull Error> error = new Signal1<>();

    /**
     * <p>See <code>QAudioDecoder::<wbr/>finished()</code></p>
     */
    public final @NonNull Signal0 finished = new Signal0();

    /**
     * <p>See <code>QAudioDecoder::<wbr/>formatChanged(QAudioFormat)</code></p>
     */
    public final @NonNull Signal1<io.qt.multimedia.@NonNull QAudioFormat> formatChanged = new Signal1<>();

    /**
     * <p>See <code>QAudioDecoder::<wbr/>isDecodingChanged(bool)</code></p>
     */
    @QtPropertyNotify(name="isDecoding")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> isDecodingChanged = new Signal1<>();

    /**
     * <p>See <code>QAudioDecoder::<wbr/>positionChanged(qint64)</code></p>
     */
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Long> positionChanged = new Signal1<>();

    /**
     * <p>See <code>QAudioDecoder::<wbr/>sourceChanged()</code></p>
     */
    @QtPropertyNotify(name="source")
    public final @NonNull Signal0 sourceChanged = new Signal0();
    
    /**
     * <p>See <code>QAudioDecoder::<wbr/>QAudioDecoder(QObject*)</code></p>
     */
    public QAudioDecoder(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAudioDecoder instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code>QAudioDecoder::<wbr/>audioFormat()const</code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QAudioFormat audioFormat(){
        return audioFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QAudioFormat audioFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QAudioDecoder::<wbr/>bufferAvailable()const</code></p>
     */
    @QtPropertyReader(name="bufferAvailable")
    @QtUninvokable
    public final boolean bufferAvailable(){
        return bufferAvailable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean bufferAvailable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QAudioDecoder::<wbr/>duration()const</code></p>
     */
    @QtUninvokable
    public final long duration(){
        return duration_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long duration_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QAudioDecoder::<wbr/>error()const</code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.QAudioDecoder.@NonNull Error error(){
        return io.qt.multimedia.QAudioDecoder.Error.resolve(error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int error_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QAudioDecoder::<wbr/>errorString()const</code></p>
     */
    @QtPropertyReader(name="error")
    @QtUninvokable
    public final java.lang.@NonNull String errorString(){
        return errorString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String errorString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QAudioDecoder::<wbr/>isDecoding()const</code></p>
     */
    @QtPropertyReader(name="isDecoding")
    @QtUninvokable
    public final boolean isDecoding(){
        return isDecoding_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isDecoding_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QAudioDecoder::<wbr/>isSupported()const</code></p>
     */
    @QtUninvokable
    public final boolean isSupported(){
        return isSupported_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isSupported_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QAudioDecoder::<wbr/>position()const</code></p>
     */
    @QtUninvokable
    public final long position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long position_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QAudioDecoder::<wbr/>read()const</code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QAudioBuffer read(){
        return read_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QAudioBuffer read_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QAudioDecoder::<wbr/>setAudioFormat(QAudioFormat)</code></p>
     */
    @QtUninvokable
    public final void setAudioFormat(io.qt.multimedia.@NonNull QAudioFormat format){
        setAudioFormat_native_cref_QAudioFormat(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(format));
    }
    
    @QtUninvokable
    private native void setAudioFormat_native_cref_QAudioFormat(long __this__nativeId, long format);
    
    /**
     * <p>See <code>QAudioDecoder::<wbr/>setSource(QUrl)</code></p>
     */
    @QtPropertyWriter(name="source")
    @QtUninvokable
    public final void setSource(io.qt.core.@NonNull QUrl fileName){
        setSource_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(fileName));
    }
    
    @QtUninvokable
    private native void setSource_native_cref_QUrl(long __this__nativeId, long fileName);
    
    /**
     * <p>See <code>QAudioDecoder::<wbr/>setSourceDevice(QIODevice*)</code></p>
     */
    @QtUninvokable
    public final void setSourceDevice(io.qt.core.@Nullable QIODevice device){
        setSourceDevice_native_QIODevice_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(device));
    }
    
    @QtUninvokable
    private native void setSourceDevice_native_QIODevice_ptr(long __this__nativeId, long device);
    
    /**
     * <p>See <code>QAudioDecoder::<wbr/>source()const</code></p>
     */
    @QtPropertyReader(name="source")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl source(){
        return source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl source_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QAudioDecoder::<wbr/>sourceDevice()const</code></p>
     */
    @QtUninvokable
    public final io.qt.core.@Nullable QIODevice sourceDevice(){
        return sourceDevice_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QIODevice sourceDevice_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QAudioDecoder::<wbr/>start()</code></p>
     */
    public final void start(){
        start_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void start_native(long __this__nativeId);
    
    /**
     * <p>See <code>QAudioDecoder::<wbr/>stop()</code></p>
     */
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stop_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAudioDecoder(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QAudioDecoder(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAudioDecoder instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAudioDecoder(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAudioDecoder() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #bufferAvailable()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getBufferAvailable() {
        return bufferAvailable();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #errorString()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getError() {
        return errorString();
    }
    
    /**
     * <p>Overloaded function for {@link #setSource(io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final void setSource(java.lang.@NonNull String fileName) {
        setSource(new io.qt.core.QUrl(fileName));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #source()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getSource() {
        return source();
    }
}
