package io.qt.multimedia;

import io.qt.*;


/**
 * <p>Represents a collection of audio samples with a specific format and sample rate</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qaudiobuffer.html">QAudioBuffer</a></code></p>
 */
public class QAudioBuffer extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiobuffer.html#QAudioBuffer">QAudioBuffer::<wbr/>QAudioBuffer()</a></code></p>
     */
    public QAudioBuffer(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QAudioBuffer instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiobuffer.html#QAudioBuffer-1">QAudioBuffer::<wbr/>QAudioBuffer(QAudioBuffer)</a></code></p>
     */
    public QAudioBuffer(io.qt.multimedia.@NonNull QAudioBuffer other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QAudioBuffer instance, io.qt.multimedia.QAudioBuffer other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiobuffer.html#QAudioBuffer-2">QAudioBuffer::<wbr/>QAudioBuffer(QByteArray,<wbr/>QAudioFormat,<wbr/>qint64)</a></code></p>
     */
    public QAudioBuffer(io.qt.core.@NonNull QByteArray data, io.qt.multimedia.@NonNull QAudioFormat format, long startTime){
        super((QPrivateConstructor)null);
        initialize_native(this, data, format, startTime);
    }
    
    private native static void initialize_native(QAudioBuffer instance, io.qt.core.QByteArray data, io.qt.multimedia.QAudioFormat format, long startTime);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiobuffer.html#QAudioBuffer-3">QAudioBuffer::<wbr/>QAudioBuffer(int,<wbr/>QAudioFormat,<wbr/>qint64)</a></code></p>
     */
    public QAudioBuffer(int numFrames, io.qt.multimedia.@NonNull QAudioFormat format, long startTime){
        super((QPrivateConstructor)null);
        initialize_native(this, numFrames, format, startTime);
    }
    
    private native static void initialize_native(QAudioBuffer instance, int numFrames, io.qt.multimedia.QAudioFormat format, long startTime);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiobuffer.html#byteCount">QAudioBuffer::<wbr/>byteCount()const</a></code></p>
     */
    @QtUninvokable
    public final long byteCount(){
        return byteCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long byteCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiobuffer.html#constData">QAudioBuffer::<wbr/>constData&lt;T&gt;()const</a></code></p>
     */
    @QtUninvokable
    public final java.nio.@Nullable ByteBuffer dataAsReadOnlyBuffer(){
        return dataAsReadOnlyBuffer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.nio.ByteBuffer dataAsReadOnlyBuffer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiobuffer.html#data-1">QAudioBuffer::<wbr/>data&lt;T&gt;()</a></code></p>
     */
    @QtUninvokable
    public final java.nio.@Nullable ByteBuffer dataAsBuffer(){
        return dataAsBuffer_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.nio.ByteBuffer dataAsBuffer_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiobuffer.html#data">QAudioBuffer::<wbr/>data&lt;T&gt;()const</a></code></p>
     */
    @QtUninvokable
    public final byte @StrictNonNull[] dataAsArray(){
        return dataAsArray_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native byte[] dataAsArray_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiobuffer.html#detach">QAudioBuffer::<wbr/>detach()</a></code></p>
     */
    @QtUninvokable
    public final void detach(){
        detach_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void detach_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiobuffer.html#duration">QAudioBuffer::<wbr/>duration()const</a></code></p>
     */
    @QtUninvokable
    public final long duration(){
        return duration_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long duration_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiobuffer.html#format">QAudioBuffer::<wbr/>format()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.multimedia.@NonNull QAudioFormat format(){
        return format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.multimedia.QAudioFormat format_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiobuffer.html#frameCount">QAudioBuffer::<wbr/>frameCount()const</a></code></p>
     */
    @QtUninvokable
    public final long frameCount(){
        return frameCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long frameCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiobuffer.html#isValid">QAudioBuffer::<wbr/>isValid()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiobuffer.html#operator-eq">QAudioBuffer::<wbr/>operator=(QAudioBuffer)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.multimedia.@NonNull QAudioBuffer other){
        assign_native_cref_QAudioBuffer(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QAudioBuffer(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiobuffer.html#sampleCount">QAudioBuffer::<wbr/>sampleCount()const</a></code></p>
     */
    @QtUninvokable
    public final long sampleCount(){
        return sampleCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long sampleCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiobuffer.html#startTime">QAudioBuffer::<wbr/>startTime()const</a></code></p>
     */
    @QtUninvokable
    public final long startTime(){
        return startTime_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long startTime_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qaudiobuffer.html#swap">QAudioBuffer::<wbr/>swap(QAudioBuffer&amp;)</a></code></p>
     */
    @QtUninvokable
    public final void swap(io.qt.multimedia.@StrictNonNull QAudioBuffer other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QAudioBuffer(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QAudioBuffer(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAudioBuffer(QPrivateConstructor p) { super(p); } 
    
    public final @NonNull QAudioFrame.AsByte dataAsU8M(){
        return QAudioFrame.dataAsAudioFrame(dataAsBuffer(), QAudioFormat.ChannelConfig.ChannelConfigMono);
    }
    
    public final @NonNull QAudioFrame.AsShort dataAsS16M(){
        return QAudioFrame.dataAsAudioFrame(dataAsBuffer().asShortBuffer(), QAudioFormat.ChannelConfig.ChannelConfigMono);
    }
    
    public final @NonNull QAudioFrame.AsInt dataAsS32M(){
        return QAudioFrame.dataAsAudioFrame(dataAsBuffer().asIntBuffer(), QAudioFormat.ChannelConfig.ChannelConfigMono);
    }
    
    public final @NonNull QAudioFrame.AsFloat dataAsF32M(){
        return QAudioFrame.dataAsAudioFrame(dataAsBuffer().asFloatBuffer(), QAudioFormat.ChannelConfig.ChannelConfigMono);
    }
    
    public final @NonNull QAudioFrame.AsByte dataAsU8S(){
        return QAudioFrame.dataAsAudioFrame(dataAsBuffer(), QAudioFormat.ChannelConfig.ChannelConfigStereo);
    }
    
    public final @NonNull QAudioFrame.AsShort dataAsS16S(){
        return QAudioFrame.dataAsAudioFrame(dataAsBuffer().asShortBuffer(), QAudioFormat.ChannelConfig.ChannelConfigStereo);
    }
    
    public final @NonNull QAudioFrame.AsInt dataAsS32S(){
        return QAudioFrame.dataAsAudioFrame(dataAsBuffer().asIntBuffer(), QAudioFormat.ChannelConfig.ChannelConfigStereo);
    }
    
    public final @NonNull QAudioFrame.AsFloat dataAsF32S(){
        return QAudioFrame.dataAsAudioFrame(dataAsBuffer().asFloatBuffer(), QAudioFormat.ChannelConfig.ChannelConfigStereo);
    }
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="https://doc.qt.io/qt/qaudiobuffer.html#QAudioBuffer-1">QAudioBuffer::<wbr/>QAudioBuffer(QAudioBuffer)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QAudioBuffer clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QAudioBuffer clone_native(long __this_nativeId);
    
    /**
     * <p>Overloaded constructor for {@link #QAudioBuffer(io.qt.core.QByteArray, io.qt.multimedia.QAudioFormat, long)}
     *  with <code>startTime = -1</code>.</p>
     */
    public QAudioBuffer(io.qt.core.@NonNull QByteArray data, io.qt.multimedia.@NonNull QAudioFormat format) {
        this(data, format, (long)-1);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAudioBuffer(byte[], io.qt.multimedia.QAudioFormat, long)}
     *  with <code>startTime = -1</code>.</p>
     */
    public QAudioBuffer(byte @NonNull[] data, io.qt.multimedia.@NonNull QAudioFormat format) {
        this(data, format, (long)-1);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAudioBuffer(io.qt.core.QByteArray, io.qt.multimedia.QAudioFormat, long)}.</p>
     */
    public QAudioBuffer(byte @NonNull[] data, io.qt.multimedia.@NonNull QAudioFormat format, long startTime) {
        this(new io.qt.core.QByteArray(data), format, startTime);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAudioBuffer(int, io.qt.multimedia.QAudioFormat, long)}
     *  with <code>startTime = -1</code>.</p>
     */
    public QAudioBuffer(int numFrames, io.qt.multimedia.@NonNull QAudioFormat format) {
        this(numFrames, format, (long)-1);
    }
}
