#ifndef QWAVEDECODER_SHELL_H
#define QWAVEDECODER_SHELL_H

#include <QtCore/QtGlobal>
#include <QtCore/qcompilerdetection.h>

QT_WARNING_DISABLE_DEPRECATED
QT_WARNING_DISABLE_GCC("-Wdeprecated-declarations")

#include <QtMultimedia/qwavedecoder.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtCore/qbindingstorage.h>
#include <QtCore/qbytearray.h>
#include <QtCore/qcoreevent.h>
#include <QtCore/qiodevice.h>
#include <QtCore/qmetaobject.h>
#include <QtCore/qnamespace.h>
#include <QtCore/qobject.h>
#include <QtCore/qproperty.h>
#include <qtcore-config.h>
#if QT_CONFIG(regularexpression)
#include <QtCore/qregularexpression.h>
#endif //QT_CONFIG(regularexpression)
#include <QtCore/qthread.h>
#include <QtCore/qtimer.h>
#include <QtCore/qvariant.h>
#include <QtMultimedia/qaudioformat.h>
#include <QtJambi/RegistryAPI>


class QWaveDecoder_shell : public QWaveDecoder, public QtJambiShellInterface
{
public:
    QWaveDecoder_shell(QIODevice* device0, const QAudioFormat& format1, QObject* parent2 = nullptr);
    QWaveDecoder_shell(QIODevice* device0, QObject* parent1 = nullptr);
    ~QWaveDecoder_shell() override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    friend class QWaveDecoder_mshell;
    friend class QWaveDecoder_oshell;
};


class QWaveDecoder_mshell : public QWaveDecoder_shell
{
public:
    using QWaveDecoder_shell::QWaveDecoder_shell;
    static void operator delete(void * ptr) noexcept;
    const QMetaObject *metaObject() const override final;
    void *qt_metacast(const char *) override final;
    int qt_metacall(QMetaObject::Call, int, void **) override final;
};


class QWaveDecoder_oshell : public QWaveDecoder_mshell
{
public:
    using QWaveDecoder_mshell::QWaveDecoder_mshell;
    bool atEnd() const override;
    qint64 bytesAvailable() const override;
    qint64 bytesToWrite() const override;
    bool canReadLine() const override;
    void childEvent(QChildEvent* event0) override;
    void close() override;
    void connectNotify(const QMetaMethod& signal0) override;
    void customEvent(QEvent* event0) override;
    void disconnectNotify(const QMetaMethod& signal0) override;
    bool event(QEvent* event0) override;
    bool eventFilter(QObject* watched0, QEvent* event1) override;
    bool isSequential() const override;
    bool open(QIODeviceBase::OpenMode mode0) override;
    qint64 pos() const override;
    qint64 readLineData(char* data0, qint64 maxlen1) override;
    bool reset() override;
    bool seek(qint64 pos0) override;
    qint64 size() const override;
    qint64 skipData(qint64 maxSize0) override;
    void timerEvent(QTimerEvent* event0) override;
    bool waitForBytesWritten(int msecs0) override;
    bool waitForReadyRead(int msecs0) override;
    static void operator delete(void * ptr) noexcept;
private:
    jmethodID __shell_javaMethod(int pos) const;
};

struct QWaveDecoder_access : public QWaveDecoder
{
    jlong __qt_bytesAvailable_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    void __qt_close(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jboolean __qt_isSequential_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jboolean __qt_open_QIODeviceBase_OpenMode(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint mode0);
    jlong __qt_pos_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jboolean __qt_seek_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jlong pos0);
    jlong __qt_size_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
};

#endif // QWAVEDECODER_SHELL_H
