#include <QtCore/QtGlobal>
#include <QtMultimedia/qmediatimerange.h>
#include <QtCore/QList>
#include <QtCore/QVariant>

#include <QtJambi/QtJambiAPI>
#include <QtJambiMultimedia/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QMediaTimeRange(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QMediaTimeRange")
    QMediaTimeRange *_ptr = reinterpret_cast<QMediaTimeRange *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QMediaTimeRange()
void __qt_construct_QMediaTimeRange(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMediaTimeRange()")
    Q_UNUSED(__java_arguments)
    QMediaTimeRange *__qt_this = new(__qtjambi_ptr) QMediaTimeRange();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// QMediaTimeRange::QMediaTimeRange()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_initialize_1native__Lio_qt_multimedia_QMediaTimeRange_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMediaTimeRange::QMediaTimeRange()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QMediaTimeRange, sizeof(QMediaTimeRange), typeid(QMediaTimeRange), 0, false, &deleter_QMediaTimeRange, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QMediaTimeRange(QMediaTimeRange)
void __qt_construct_QMediaTimeRange_cref_QMediaTimeRange(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMediaTimeRange(QMediaTimeRange)")
    jobject range0 = __java_arguments[0].l;
    const QMediaTimeRange& __qt_range0 = qtjambi_cast<const QMediaTimeRange&>(__jni_env, range0);
    QMediaTimeRange *__qt_this = new(__qtjambi_ptr) QMediaTimeRange(__qt_range0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QMediaTimeRange::QMediaTimeRange(QMediaTimeRange)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_initialize_1native__Lio_qt_multimedia_QMediaTimeRange_2Lio_qt_multimedia_QMediaTimeRange_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject range0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMediaTimeRange::QMediaTimeRange(QMediaTimeRange)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = range0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QMediaTimeRange_cref_QMediaTimeRange, sizeof(QMediaTimeRange), typeid(QMediaTimeRange), 0, false, &deleter_QMediaTimeRange, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QMediaTimeRange(QMediaTimeRange::Interval)
void __qt_construct_QMediaTimeRange_cref_QMediaTimeRange_Interval(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMediaTimeRange(QMediaTimeRange::Interval)")
    jobject arg__1 = __java_arguments[0].l;
    const QMediaTimeRange::Interval& __qt_arg__1 = qtjambi_cast<const QMediaTimeRange::Interval&>(__jni_env, arg__1);
    QMediaTimeRange *__qt_this = new(__qtjambi_ptr) QMediaTimeRange(__qt_arg__1);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QMediaTimeRange::QMediaTimeRange(QMediaTimeRange::Interval)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_initialize_1native__Lio_qt_multimedia_QMediaTimeRange_2Lio_qt_multimedia_QMediaTimeRange_00024Interval_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject arg__1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMediaTimeRange::QMediaTimeRange(QMediaTimeRange::Interval)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = arg__1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QMediaTimeRange_cref_QMediaTimeRange_Interval, sizeof(QMediaTimeRange), typeid(QMediaTimeRange), 0, false, &deleter_QMediaTimeRange, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QMediaTimeRange(qint64,qint64)
void __qt_construct_QMediaTimeRange_qint64_qint64(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMediaTimeRange(qint64,qint64)")
    jlong start0 = __java_arguments[0].j;
    Q_UNUSED(start0)
    jlong end1 = __java_arguments[1].j;
    Q_UNUSED(end1)
    QMediaTimeRange *__qt_this = new(__qtjambi_ptr) QMediaTimeRange(static_cast<qint64>(start0), static_cast<qint64>(end1));
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// QMediaTimeRange::QMediaTimeRange(qint64,qint64)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_initialize_1native__Lio_qt_multimedia_QMediaTimeRange_2JJ)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jlong start0,
 jlong end1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMediaTimeRange::QMediaTimeRange(qint64,qint64)")
    QTJAMBI_TRY {
        jvalue arguments[2];
        arguments[0].j = start0;
        arguments[1].j = end1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QMediaTimeRange_qint64_qint64, sizeof(QMediaTimeRange), typeid(QMediaTimeRange), 0, false, &deleter_QMediaTimeRange, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QMediaTimeRange
void __qt_destruct_QMediaTimeRange(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QMediaTimeRange")
    reinterpret_cast<QMediaTimeRange*>(ptr)->~QMediaTimeRange();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QMediaTimeRange::addInterval(QMediaTimeRange::Interval)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_addInterval_1native_1cref_1QMediaTimeRange_1Interval__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID interval0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::addInterval(QMediaTimeRange::Interval)", __this_nativeId)
        const QMediaTimeRange::Interval& __qt_interval0 = QtJambiAPI::valueReferenceFromNativeId<QMediaTimeRange::Interval>(interval0);
        __qt_this->addInterval(__qt_interval0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMediaTimeRange::addInterval(qint64,qint64)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_addInterval_1native_1qint64_1qint64__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong start0,
 jlong end1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::addInterval(qint64,qint64)", __this_nativeId)
        __qt_this->addInterval(static_cast<qint64>(start0), static_cast<qint64>(end1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMediaTimeRange::addTimeRange(QMediaTimeRange)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_addTimeRange_1native_1cref_1QMediaTimeRange__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::addTimeRange(QMediaTimeRange)", __this_nativeId)
        const QMediaTimeRange& __qt_arg__1 = QtJambiAPI::valueReferenceFromNativeId<QMediaTimeRange>(arg__1);
        __qt_this->addTimeRange(__qt_arg__1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMediaTimeRange::clear()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_clear_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::clear()", __this_nativeId)
        __qt_this->clear();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMediaTimeRange::contains(qint64)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_contains_1native_1qint64_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong time0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::contains(qint64)const", __this_nativeId)
        __java_return_value = __qt_this->contains(static_cast<qint64>(time0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaTimeRange::detach()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_detach_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::detach()", __this_nativeId)
        __qt_this->detach();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMediaTimeRange::earliestTime()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_earliestTime_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::earliestTime()const", __this_nativeId)
        qint64 __qt_return_value = __qt_this->earliestTime();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaTimeRange::intervals()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_intervals_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::intervals()const", __this_nativeId)
        QList<QMediaTimeRange::Interval> __qt_return_value = __qt_this->intervals();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaTimeRange::isContinuous()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_isContinuous_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::isContinuous()const", __this_nativeId)
        __java_return_value = __qt_this->isContinuous();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaTimeRange::isEmpty()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_isEmpty_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::isEmpty()const", __this_nativeId)
        __java_return_value = __qt_this->isEmpty();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaTimeRange::latestTime()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_latestTime_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::latestTime()const", __this_nativeId)
        qint64 __qt_return_value = __qt_this->latestTime();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaTimeRange::operator+(QMediaTimeRange,QMediaTimeRange)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_plus_1native_1cref_1QMediaTimeRange__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID r21)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::operator+(QMediaTimeRange,QMediaTimeRange)", __this_nativeId)
        const QMediaTimeRange& __qt_r21 = QtJambiAPI::valueReferenceFromNativeId<QMediaTimeRange>(r21);
        QMediaTimeRange __qt_return_value = (*__qt_this) + __qt_r21;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaTimeRange::operator+=(QMediaTimeRange)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_add_1native_1cref_1QMediaTimeRange__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::operator+=(QMediaTimeRange)", __this_nativeId)
        const QMediaTimeRange& __qt_arg__1 = QtJambiAPI::valueReferenceFromNativeId<QMediaTimeRange>(arg__1);
        (*__qt_this) += __qt_arg__1;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaTimeRange::operator+=(QMediaTimeRange::Interval)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_plusAssign_1native_1cref_1QMediaTimeRange_1Interval__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::operator+=(QMediaTimeRange::Interval)", __this_nativeId)
        const QMediaTimeRange::Interval& __qt_arg__1 = QtJambiAPI::valueReferenceFromNativeId<QMediaTimeRange::Interval>(arg__1);
        (*__qt_this) += __qt_arg__1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMediaTimeRange::operator-(QMediaTimeRange,QMediaTimeRange)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_minus_1native_1cref_1QMediaTimeRange__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID r21)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::operator-(QMediaTimeRange,QMediaTimeRange)", __this_nativeId)
        const QMediaTimeRange& __qt_r21 = QtJambiAPI::valueReferenceFromNativeId<QMediaTimeRange>(r21);
        QMediaTimeRange __qt_return_value = (*__qt_this) - __qt_r21;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaTimeRange::operator-=(QMediaTimeRange)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_subtract_1native_1cref_1QMediaTimeRange__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::operator-=(QMediaTimeRange)", __this_nativeId)
        const QMediaTimeRange& __qt_arg__1 = QtJambiAPI::valueReferenceFromNativeId<QMediaTimeRange>(arg__1);
        (*__qt_this) -= __qt_arg__1;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaTimeRange::operator-=(QMediaTimeRange::Interval)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_minusAssign_1native_1cref_1QMediaTimeRange_1Interval__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::operator-=(QMediaTimeRange::Interval)", __this_nativeId)
        const QMediaTimeRange::Interval& __qt_arg__1 = QtJambiAPI::valueReferenceFromNativeId<QMediaTimeRange::Interval>(arg__1);
        (*__qt_this) -= __qt_arg__1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMediaTimeRange::operator=(QMediaTimeRange)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_assign_1native_1cref_1QMediaTimeRange__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::operator=(QMediaTimeRange)", __this_nativeId)
        const QMediaTimeRange& __qt_arg__1 = QtJambiAPI::valueReferenceFromNativeId<QMediaTimeRange>(arg__1);
        (*__qt_this) = __qt_arg__1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMediaTimeRange::operator=(QMediaTimeRange::Interval)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_assign_1native_1cref_1QMediaTimeRange_1Interval__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::operator=(QMediaTimeRange::Interval)", __this_nativeId)
        const QMediaTimeRange::Interval& __qt_arg__1 = QtJambiAPI::valueReferenceFromNativeId<QMediaTimeRange::Interval>(arg__1);
        (*__qt_this) = __qt_arg__1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMediaTimeRange::operator==(QMediaTimeRange,QMediaTimeRange)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_equals_1native_1cref_1QMediaTimeRange__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rhs1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::operator==(QMediaTimeRange,QMediaTimeRange)", __this_nativeId)
        const QMediaTimeRange& __qt_rhs1 = QtJambiAPI::valueReferenceFromNativeId<QMediaTimeRange>(rhs1);
        __java_return_value = (*__qt_this) == __qt_rhs1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMediaTimeRange::removeInterval(QMediaTimeRange::Interval)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_removeInterval_1native_1cref_1QMediaTimeRange_1Interval__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID interval0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::removeInterval(QMediaTimeRange::Interval)", __this_nativeId)
        const QMediaTimeRange::Interval& __qt_interval0 = QtJambiAPI::valueReferenceFromNativeId<QMediaTimeRange::Interval>(interval0);
        __qt_this->removeInterval(__qt_interval0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMediaTimeRange::removeInterval(qint64,qint64)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_removeInterval_1native_1qint64_1qint64__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong start0,
 jlong end1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::removeInterval(qint64,qint64)", __this_nativeId)
        __qt_this->removeInterval(static_cast<qint64>(start0), static_cast<qint64>(end1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMediaTimeRange::removeTimeRange(QMediaTimeRange)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_removeTimeRange_1native_1cref_1QMediaTimeRange__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::removeTimeRange(QMediaTimeRange)", __this_nativeId)
        const QMediaTimeRange& __qt_arg__1 = QtJambiAPI::valueReferenceFromNativeId<QMediaTimeRange>(arg__1);
        __qt_this->removeTimeRange(__qt_arg__1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMediaTimeRange::swap(QMediaTimeRange&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_swap_1native_1ref_1QMediaTimeRange__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMediaTimeRange::swap(QMediaTimeRange&)", __this_nativeId)
        QMediaTimeRange& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QMediaTimeRange>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_multimedia_QMediaTimeRange_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QMediaTimeRange *__qt_this = QtJambiAPI::objectFromNativeId<QMediaTimeRange>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QMediaTimeRange(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QMediaTimeRange>("QMediaTimeRange", "io/qt/multimedia/QMediaTimeRange");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, 0, &__qt_destruct_QMediaTimeRange, {
        ConstructorInfo(&__qt_construct_QMediaTimeRange, nullptr)
       ,ConstructorInfo(&__qt_construct_QMediaTimeRange_cref_QMediaTimeRange, "Lio/qt/multimedia/QMediaTimeRange;")
       ,ConstructorInfo(&__qt_construct_QMediaTimeRange_cref_QMediaTimeRange_Interval, "Lio/qt/multimedia/QMediaTimeRange$Interval;")
       ,ConstructorInfo(&__qt_construct_QMediaTimeRange_qint64_qint64, "JJ")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QMediaTimeRange);
    registerMetaType<QMediaTimeRange>("QMediaTimeRange");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
